/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.se.xslt;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.petals.component.framework.AbstractComponent;
import org.ow2.petals.component.framework.api.configuration.ConfigurationExtensions;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.jbidescriptor.generated.Jbi;
import org.ow2.petals.component.framework.jbidescriptor.generated.Provides;
import org.ow2.petals.component.framework.su.AbstractServiceUnitManager;
import org.ow2.petals.component.framework.su.ServiceUnitDataHandler;
import org.ow2.petals.component.framework.util.StringHelper;
import org.ow2.petals.se.xslt.XsltSe;
import org.ow2.petals.se.xslt.model.XslParameterBean;
import org.ow2.petals.se.xslt.model.XsltConfiguration;
import org.ow2.petals.se.xslt.model.XsltConfigurationHandler;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XsltSuManager
extends AbstractServiceUnitManager {
    private static final String CONFIG_XSL_PATH = "stylesheet";
    private static final String CONFIG_TRANSFORMER_FACTORY_CLASS_NAME = "transformer-factory";
    private static final String CONFIG_TRANSFORMER_POOL_SIZE_MIN = "transformer-pool-size-min";
    private static final int DEFAULT_TRANSFORMER_POOL_SIZE_MIN = 1;
    private static final String CONFIG_TRANSFORMER_POOL_SIZE_MAX = "transformer-pool-size-max";
    private static final int DEFAULT_TRANSFORMER_POOL_SIZE_MAX = 1;
    private static final String CONFIG_OUTPUT_ATTACHMENT_NAME = "output-attachment-name";
    private static final String DEFAULT_OUTPUT_ATTACHMENT_NAME = "petals-se-xslt.out";
    private static final String CONFIG_XSL_PARAMETERS = "xsl-parameters";
    private static final String CONFIG_XSL_PARAMETER = "xsl-parameter";
    private final Map<String, XsltConfigurationHandler> suNameToXsltConfigurationHandler = new ConcurrentHashMap<String, XsltConfigurationHandler>();

    public XsltSuManager(AbstractComponent component) {
        super(component);
    }

    protected void doDeploy(String serviceUnitName, String suRootPath, Jbi jbiDescriptor) throws PEtALSCDKException {
        if (jbiDescriptor.getServices().getConsumes().size() != 0) {
            throw new PEtALSCDKException("'Consumes' sections are not supported by this component.");
        }
        List providesList = jbiDescriptor.getServices().getProvides();
        if (providesList == null || providesList.size() != 1) {
            throw new PEtALSCDKException("Only one 'Provides' section is allowed by this component.");
        }
        Provides provides = (Provides)providesList.get(0);
        ServiceUnitDataHandler suDatahandler = this.getSUDataHandlerForService(provides);
        ConfigurationExtensions extensions = suDatahandler.getConfigurationExtensions((Object)provides);
        String xslPath = extensions.get((Object)CONFIG_XSL_PATH);
        if (xslPath != null) {
            xslPath = xslPath.trim();
        }
        if (StringHelper.isNullOrEmpty((String)xslPath)) {
            throw new PEtALSCDKException("The 'stylesheet' parameter is not defined or is empty.");
        }
        String transformerFactoryClassName = extensions.get((Object)CONFIG_TRANSFORMER_FACTORY_CLASS_NAME);
        if (StringHelper.isNullOrEmpty((String)transformerFactoryClassName) && this.logger != null && this.logger.isLoggable(Level.FINE)) {
            transformerFactoryClassName = null;
            String msg = serviceUnitName + ": the '" + CONFIG_TRANSFORMER_FACTORY_CLASS_NAME + "' parameter is not defined or is empty. The system transformer factory is used.";
            this.logger.fine(msg);
        }
        int transformerPoolSizeMin = XsltSuManager.getIntParameterValue(this.logger, serviceUnitName, extensions, CONFIG_TRANSFORMER_POOL_SIZE_MIN, 1);
        int transformerPoolSizeMax = XsltSuManager.getIntParameterValue(this.logger, serviceUnitName, extensions, CONFIG_TRANSFORMER_POOL_SIZE_MAX, 1);
        String outputAttachmentName = extensions.get((Object)CONFIG_OUTPUT_ATTACHMENT_NAME);
        if (outputAttachmentName != null) {
            outputAttachmentName = outputAttachmentName.trim();
        }
        if (StringHelper.isNullOrEmpty((String)outputAttachmentName) && this.logger != null && this.logger.isLoggable(Level.FINE)) {
            outputAttachmentName = DEFAULT_OUTPUT_ATTACHMENT_NAME;
            String msg = serviceUnitName + ": the '" + CONFIG_OUTPUT_ATTACHMENT_NAME + "' parameter is not defined or is empty.";
            this.logger.fine(msg);
        }
        HashMap<String, XslParameterBean> xslParamNameToXslParamBean = new HashMap<String, XslParameterBean>();
        for (Element elt : provides.getAny()) {
            if (!elt.getNodeName().endsWith(CONFIG_XSL_PARAMETERS)) continue;
            NodeList children = elt.getElementsByTagNameNS("*", CONFIG_XSL_PARAMETER);
            if (this.logger != null && this.logger.isLoggable(Level.FINER)) {
                String msg = serviceUnitName + ": " + children.getLength();
                String suffix = children.getLength() < 2 ? " XSL parameter was found." : " XSL parameters were found.";
                this.logger.finer(msg + suffix);
            }
            for (int i = 0; i < children.getLength(); ++i) {
                Element child = (Element)children.item(i);
                String name = child.getAttribute("name");
                boolean overridable = Boolean.valueOf(child.getAttribute("overridable"));
                String value = null;
                if (child.getTextContent() != null) {
                    value = child.getTextContent().trim();
                }
                if (StringHelper.isNullOrEmpty((String)name) || StringHelper.isNullOrEmpty((String)value)) continue;
                XslParameterBean xslParamBean = new XslParameterBean(name, value, overridable);
                xslParamNameToXslParamBean.put(name, xslParamBean);
                if (this.logger == null || !this.logger.isLoggable(Level.FINER)) continue;
                String msg = serviceUnitName + ": a XSL parameter was found (" + name + " = " + value + ").";
                this.logger.finer(msg);
            }
        }
        XsltConfiguration config = new XsltConfiguration(xslPath, transformerFactoryClassName, transformerPoolSizeMin, transformerPoolSizeMax, suRootPath, outputAttachmentName, provides.getEndpointName(), serviceUnitName, xslParamNameToXslParamBean);
        XsltConfigurationHandler handler = new XsltConfigurationHandler(config, this.logger);
        ((XsltSe)this.component).registerXsltConfigurationHandler(config.getEndpointName(), handler);
        this.suNameToXsltConfigurationHandler.put(serviceUnitName, handler);
    }

    private static final int getIntParameterValue(Logger logger, String serviceUnitName, ConfigurationExtensions extensions, String parameterName, int defaultValue) {
        int value;
        String valueStr = extensions.get((Object)parameterName);
        if (!StringHelper.isNullOrEmpty((String)valueStr)) {
            try {
                value = Integer.parseInt(valueStr);
            }
            catch (NumberFormatException e) {
                value = defaultValue;
                String msg = serviceUnitName + ": the '" + parameterName + "' parameter is not an integer. The default value '" + defaultValue + "' is used";
                logger.warning(msg);
            }
        } else {
            value = defaultValue;
        }
        return value;
    }

    protected void doStart(String serviceUnitName) throws PEtALSCDKException {
        XsltConfigurationHandler handler = this.suNameToXsltConfigurationHandler.get(serviceUnitName);
        if (handler == null) {
            throw new PEtALSCDKException("No configuration handler was found for the service-unit " + serviceUnitName + " (start).");
        }
        handler.start(this.logger);
    }

    protected void doStop(String serviceUnitName) throws PEtALSCDKException {
        XsltConfigurationHandler handler = this.suNameToXsltConfigurationHandler.get(serviceUnitName);
        if (handler == null) {
            throw new PEtALSCDKException("No configuration handler was found for the service-unit " + serviceUnitName + " (stop).");
        }
        handler.stop();
    }

    protected void doUndeploy(String serviceUnitName) throws PEtALSCDKException {
        XsltConfigurationHandler handler = this.suNameToXsltConfigurationHandler.remove(serviceUnitName);
        ((XsltSe)this.component).removeXsltConfigurationHandler(handler.getEndpointName());
    }
}

