/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.se.xslt.model;

import com.ebmwebsourcing.easycommons.pooling.GenericResourcePool;
import com.ebmwebsourcing.easycommons.pooling.api.PoolPolicy;
import com.ebmwebsourcing.easycommons.pooling.api.PoolPolicyBehaviorException;
import com.ebmwebsourcing.easycommons.pooling.api.ResourceHandler;
import com.ebmwebsourcing.easycommons.pooling.api.UnstableStateException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.messaging.MessagingException;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.util.ClassLoaderUtil;
import org.ow2.petals.se.xslt.model.XslParameterBean;
import org.ow2.petals.se.xslt.model.XsltConfiguration;
import org.ow2.petals.se.xslt.model.XsltTransformerResourceHandler;
import org.ow2.petals.se.xslt.utils.LogErrorListener;
import org.ow2.petals.se.xslt.utils.ServiceUnitURIResolver;

public class XsltConfigurationHandler {
    private final XsltConfiguration xsltConfiguration;
    private final ServiceUnitURIResolver uriResolver;
    private final LogErrorListener logErrorListener;
    private ClassLoader classLoader;
    private final Object lock = new Object();
    private GenericResourcePool<Transformer> suTransformerResourcePool;

    public XsltConfigurationHandler(XsltConfiguration xsltConfiguration, Logger logger) {
        this.xsltConfiguration = xsltConfiguration;
        this.logErrorListener = new LogErrorListener(logger, xsltConfiguration.getServiceUnitName());
        this.uriResolver = new ServiceUnitURIResolver(xsltConfiguration.getSuInstallRoot(), logger, xsltConfiguration.getServiceUnitName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(Logger logger) throws PEtALSCDKException {
        Object object = this.lock;
        synchronized (object) {
            String suRoot = this.xsltConfiguration.getSuInstallRoot();
            String logPrefix = this.xsltConfiguration.getServiceUnitName();
            InputStream xslStream = null;
            try {
                URLClassLoader tempClassLoader;
                boolean clazzProvided = false;
                block14: for (File file : new File(suRoot).listFiles()) {
                    if (!file.getName().toLowerCase().endsWith(".jar")) continue;
                    JarFile jar = new JarFile(file);
                    Enumeration<JarEntry> entryEnum = jar.entries();
                    while (entryEnum.hasMoreElements()) {
                        JarEntry jarEntry = entryEnum.nextElement();
                        if (!jarEntry.getName().toLowerCase().endsWith(".class")) continue;
                        clazzProvided = true;
                        break block14;
                    }
                }
                if ((xslStream = ((ClassLoader)(tempClassLoader = ClassLoaderUtil.createClassLoader((String)suRoot, (ClassLoader)this.getClass().getClassLoader()))).getResourceAsStream(this.xsltConfiguration.getXslPath())) == null) {
                    File xslStyleSheet = new File(suRoot, this.xsltConfiguration.getXslPath());
                    xslStream = new FileInputStream(xslStyleSheet);
                }
                StreamSource source = new StreamSource(xslStream);
                String transformerFactoryClassName = this.xsltConfiguration.getTransformerFactoryClassName();
                TransformerFactory transformerFactory = XsltConfigurationHandler.createTransformerFactory(logPrefix, transformerFactoryClassName);
                transformerFactory.setURIResolver(this.uriResolver);
                transformerFactory.setErrorListener(this.logErrorListener);
                if (clazzProvided) {
                    this.classLoader = tempClassLoader;
                    Thread.currentThread().setContextClassLoader(this.classLoader);
                } else {
                    tempClassLoader = null;
                }
                Templates template = transformerFactory.newTemplates(source);
                XsltTransformerResourceHandler transformerResourceHandler = new XsltTransformerResourceHandler(template, this.uriResolver, this.logErrorListener, this.xsltConfiguration);
                int transformerPoolSizeMin = this.xsltConfiguration.getTransformerPoolSizeMin();
                int transformerPoolSizeMax = this.xsltConfiguration.getTransformerPoolSizeMax();
                this.suTransformerResourcePool = new GenericResourcePool((ResourceHandler)transformerResourceHandler, transformerPoolSizeMin, transformerPoolSizeMax, PoolPolicy.WAIT);
                if (this.classLoader != null) {
                    Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest(logPrefix + ": the XSL style sheet was stored with a custom class loader.");
                    }
                }
            }
            catch (IOException e) {
                throw new PEtALSCDKException(logPrefix + ": failed to retrieve the XSL resources.", (Throwable)e);
            }
            catch (TransformerConfigurationException e) {
                throw new PEtALSCDKException(logPrefix + ": failed to create the pool of transformer.", (Throwable)e);
            }
            catch (UnstableStateException e) {
                throw new PEtALSCDKException(logPrefix + ": failed to create the pool of transformer.", (Throwable)e);
            }
            finally {
                block23: {
                    if (xslStream != null) {
                        try {
                            xslStream.close();
                        }
                        catch (IOException e) {
                            if (!logger.isLoggable(Level.FINE)) break block23;
                            logger.fine(logPrefix + ": the XSL input stream could not be closed.");
                        }
                    }
                }
            }
        }
    }

    static final TransformerFactory createTransformerFactory(String logPrefix, String transformerFactoryClassName) throws PEtALSCDKException {
        TransformerFactory transformerFactory;
        if (transformerFactoryClassName == null) {
            transformerFactory = TransformerFactory.newInstance();
        } else {
            try {
                Class<?> transformerFactoryClass = Class.forName(transformerFactoryClassName);
                Object transformerFactoryObj = transformerFactoryClass.newInstance();
                if (!(transformerFactoryObj instanceof TransformerFactory)) {
                    throw new PEtALSCDKException(logPrefix + ": failed to create the pool of transformer. The class defined as transformer factory does not implement TransformerFactory");
                }
                transformerFactory = (TransformerFactory)transformerFactoryObj;
            }
            catch (ClassNotFoundException e) {
                throw new PEtALSCDKException(logPrefix + ": failed to create the pool of transformer.", (Throwable)e);
            }
            catch (InstantiationException e) {
                throw new PEtALSCDKException(logPrefix + ": failed to create the pool of transformer.", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new PEtALSCDKException(logPrefix + ": failed to create the pool of transformer.", (Throwable)e);
            }
        }
        return transformerFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            this.classLoader = null;
        }
    }

    public String getEndpointName() {
        return this.xsltConfiguration.getEndpointName();
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public String getOutputAttachmentName() {
        return this.xsltConfiguration.getOutputAttachmentName();
    }

    public Transformer takeTransformer(Exchange exchange, Logger logger) throws TransformerException, UnstableStateException, PoolPolicyBehaviorException {
        Transformer transformer;
        block4: {
            transformer = (Transformer)this.suTransformerResourcePool.take();
            String logHint = "Exchange " + exchange.getExchangeId();
            try {
                Map<String, XslParameterBean> suXslParameters = this.xsltConfiguration.getParamNameToParamBean();
                for (String propertyName : exchange.getInMessagePropertyNames()) {
                    XslParameterBean suXslParamBean = suXslParameters.get(propertyName);
                    if (suXslParamBean != null && !suXslParamBean.isOverridable()) {
                        throw new TransformerException(logHint + ": the XSL parameter " + propertyName + " was already set by the configuration and cannot be overridden.");
                    }
                    Object value = exchange.getInMessageProperty(propertyName);
                    transformer.setParameter(propertyName, value);
                }
            }
            catch (MessagingException e) {
                if (!logger.isLoggable(Level.WARNING)) break block4;
                String msg = logHint + ": IN message properties could not be read and passed as parameters to the transformer.";
                logger.warning(msg);
            }
        }
        return transformer;
    }

    public void releaseTransformer(Transformer transformer) throws UnstableStateException {
        this.suTransformerResourcePool.release((Object)transformer);
    }
}

