/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.se.xslt.model;

import com.ebmwebsourcing.easycommons.pooling.api.ResourceHandler;
import java.util.Map;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.URIResolver;
import org.ow2.petals.se.xslt.model.XslParameterBean;
import org.ow2.petals.se.xslt.model.XsltConfiguration;

public class XsltTransformerResourceHandler
implements ResourceHandler<Transformer> {
    private Templates template;
    private URIResolver uriResolver;
    private ErrorListener logErrorListener;
    private XsltConfiguration xsltConfiguration;

    public XsltTransformerResourceHandler(Templates template, URIResolver uriResolver, ErrorListener logErrorListener, XsltConfiguration xsltConfiguration) {
        this.template = template;
        this.uriResolver = uriResolver;
        this.logErrorListener = logErrorListener;
        this.xsltConfiguration = xsltConfiguration;
    }

    public void activateResource(Transformer transformer) throws Exception {
    }

    public Transformer createResource() throws Exception {
        Transformer transformer = this.template.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setURIResolver(this.uriResolver);
        transformer.setErrorListener(this.logErrorListener);
        Map<String, XslParameterBean> suXslParameters = this.xsltConfiguration.getParamNameToParamBean();
        for (XslParameterBean paramBean : suXslParameters.values()) {
            transformer.setParameter(paramBean.getName(), paramBean.getValue());
        }
        return transformer;
    }

    public void destroyResource(Transformer transformer) throws Exception {
        transformer.clearParameters();
        transformer.reset();
    }

    public void passivateResource(Transformer transformer) throws Exception {
    }
}

