/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.se.xslt.utils;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;

public class LogErrorListener
implements ErrorListener {
    private final Logger logger;
    private final String logPrefix;

    public LogErrorListener(Logger logger, String suName) {
        this.logger = logger;
        this.logPrefix = suName + ": ";
    }

    @Override
    public void error(TransformerException e) throws TransformerException {
        int line = -1;
        SourceLocator locator = e.getLocator();
        if (locator != null) {
            line = locator.getLineNumber();
        }
        String msg = "an error was found. " + e.getMessage() + " (line: " + (line == -1 ? "unresolved" : Integer.valueOf(line)) + ").";
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine(this.logPrefix + msg);
        }
        throw e;
    }

    @Override
    public void fatalError(TransformerException e) throws TransformerException {
        int line = -1;
        SourceLocator locator = e.getLocator();
        if (locator != null) {
            line = locator.getLineNumber();
        }
        String msg = "a fatal error was found. " + e.getMessage() + " (line: " + (line == -1 ? "unresolved" : Integer.valueOf(line)) + ").";
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine(this.logPrefix + msg);
        }
        throw e;
    }

    @Override
    public void warning(TransformerException e) throws TransformerException {
        int line = -1;
        SourceLocator locator = e.getLocator();
        if (locator != null) {
            line = locator.getLineNumber();
        }
        String msg = "a warning was found. " + e.getMessage() + " (line: " + (line == -1 ? "unresolved" : Integer.valueOf(line)) + ").";
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine(this.logPrefix + msg);
        }
        throw e;
    }
}

