/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.se.xslt;

import com.ebmwebsourcing.easycommons.logger.Level;
import com.ebmwebsourcing.easycommons.pooling.PoolException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Logger;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.MessagingException;
import javax.mail.util.ByteArrayDataSource;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import org.ow2.petals.component.framework.api.Message;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.listener.AbstractJBIListener;
import org.ow2.petals.component.framework.util.SourceUtil;
import org.ow2.petals.se.xslt.XsltSe;
import org.ow2.petals.se.xslt.model.XsltConfigurationHandler;

public class XsltJBIListener
extends AbstractJBIListener {
    private static final String OPERATION_TRANSFORM = "transform";
    private static final String OPERATION_TRANSFORM_TO_MTOM_ATTACHMENT = "transformToMtomAttachment";
    public static final String MTOM_TNS = "http://www.w3.org/2004/08/xop/include";
    private String logHint;

    public boolean onJBIMessage(Exchange exchange) {
        if (exchange.isActiveStatus()) {
            Throwable finalException;
            Logger logger;
            block14: {
                logger = this.getLogger();
                this.logHint = "Exchange " + exchange.getExchangeId();
                if (logger.isLoggable(Level.INFO)) {
                    logger.info(this.logHint + " was received and is started to be processed.");
                }
                finalException = null;
                try {
                    String errorMsg = XsltJBIListener.validateExchange(exchange);
                    if (errorMsg != null) {
                        if (!exchange.isInOnlyPattern()) {
                            this.setFault(exchange, errorMsg, null);
                        } else {
                            finalException = new IllegalArgumentException(errorMsg);
                        }
                        break block14;
                    }
                    try {
                        this.processExchange(exchange);
                        if (logger.isLoggable(Level.INFO)) {
                            logger.log(Level.INFO, this.logHint + " was successfully processed.");
                        }
                    }
                    catch (Throwable t) {
                        this.setFault(exchange, null, t);
                    }
                }
                catch (PEtALSCDKException e) {
                    finalException = e;
                }
                catch (MessagingException e) {
                    finalException = e;
                }
            }
            if (finalException != null) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info(this.logHint + " encountered a problem. " + finalException.getMessage());
                }
                if (exchange.isActiveStatus()) {
                    exchange.setError((Exception)finalException);
                }
            }
        }
        return true;
    }

    private static final String validateExchange(Exchange exchange) {
        String errorMsg = null;
        QName operation = exchange.getOperation();
        if (operation == null) {
            errorMsg = "The JBI operation must be set by the consumer of the service.";
        } else if (OPERATION_TRANSFORM.equalsIgnoreCase(operation.getLocalPart())) {
            if (!Message.MEPConstants.IN_OUT_PATTERN.equals(exchange.getPattern())) {
                errorMsg = "The operation '" + operation + "' must use the pattern '" + Message.MEPConstants.IN_OUT_PATTERN + "'.";
            }
        } else if (OPERATION_TRANSFORM_TO_MTOM_ATTACHMENT.equalsIgnoreCase(operation.getLocalPart())) {
            if (!Message.MEPConstants.IN_OUT_PATTERN.equals(exchange.getPattern())) {
                errorMsg = "The operation '" + operation + "' must use the pattern '" + Message.MEPConstants.IN_OUT_PATTERN + "'.";
            }
        } else {
            errorMsg = "The operation '" + operation + "' is not supported by this component.";
        }
        return errorMsg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processExchange(Exchange exchange) throws MessagingException, TransformerException, IOException {
        XsltConfigurationHandler handler;
        Logger log = this.getLogger();
        if (log.isLoggable(Level.INFO)) {
            log.info(this.logHint + ": the request was validated, the transformation is about to start.");
        }
        if ((handler = ((XsltSe)this.component).getXsltConfigurationHandler(exchange.getEndpointName())) == null) {
            String msg = this.logHint + " encountered a problem. No handler was found for this end-point.";
            throw new TransformerException(msg);
        }
        Source inputSource = exchange.getInMessageContentAsSource();
        if (log.isLoggable(Level.FINEST)) {
            try {
                String inputMsg = SourceUtil.createString((Source)inputSource, (boolean)true);
                log.finest(this.logHint + ": the message to transform is\n" + inputMsg);
            }
            catch (PEtALSCDKException e) {
                log.finest(this.logHint + ": the message to transform could not be displayed, an error occurred.");
            }
        }
        ClassLoader customClassLoader = handler.getClassLoader();
        try {
            if (customClassLoader != null) {
                Thread.currentThread().setContextClassLoader(customClassLoader);
            }
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            StreamResult outputResult = new StreamResult(outputStream);
            Transformer transformer = null;
            try {
                transformer = handler.takeTransformer(exchange, log);
                transformer.transform(inputSource, outputResult);
            }
            catch (PoolException e) {
                throw new TransformerException("Impossible to take a transformer from to pool", e);
            }
            finally {
                if (transformer != null) {
                    handler.releaseTransformer(transformer);
                }
            }
            String opName = exchange.getOperation().getLocalPart();
            if (OPERATION_TRANSFORM.equalsIgnoreCase(opName)) {
                exchange.setOutMessageContent((InputStream)new ByteArrayInputStream(outputStream.toByteArray()));
            } else if (OPERATION_TRANSFORM_TO_MTOM_ATTACHMENT.equalsIgnoreCase(opName)) {
                ByteArrayInputStream input = new ByteArrayInputStream(outputStream.toByteArray());
                ByteArrayDataSource datasource = new ByteArrayDataSource((InputStream)input, "application/octet-stream");
                DataHandler attachmentHandler = new DataHandler((DataSource)datasource);
                String attachmentName = handler.getOutputAttachmentName();
                exchange.setOutMessageAttachment(attachmentName, attachmentHandler);
                StringBuilder sb = new StringBuilder();
                sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
                sb.append("<attachedTransformResponse ");
                sb.append("xmlns=\"" + exchange.getOperation().getNamespaceURI() + "\" ");
                sb.append("xmlns:xop=\"http://www.w3.org/2004/08/xop/include\">\n");
                sb.append("\t<fileContent>\n");
                sb.append("\t\t<xop:include href=\"cid:" + attachmentName + "\" />\n");
                sb.append("\t</fileContent>\n");
                sb.append("</attachedTransformResponse>");
                exchange.setOutMessageContent((InputStream)new ByteArrayInputStream(sb.toString().getBytes("UTF-8")));
            }
        }
        finally {
            if (customClassLoader != null) {
                Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            }
        }
    }

    private void setFault(Exchange exchange, String faultMessage, Throwable e) throws PEtALSCDKException, MessagingException {
        String errorMsg = faultMessage != null ? faultMessage : (e != null && e.getMessage() != null ? e.getMessage() : "An error occurred in the XSLT SE.");
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        sb.append("<xsltFault ");
        sb.append("xmlns=\"" + exchange.getOperation().getNamespaceURI() + "\">\n");
        sb.append("\t<message>" + errorMsg + "</message>\n");
        if (e != null) {
            StringWriter sWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(sWriter));
            sb.append("\t<details>\n" + sWriter.getBuffer().toString() + "\n\t</details>\n");
        }
        sb.append("</xsltFault>");
        Source source = SourceUtil.createSource((String)sb.toString(), (String)"UTF-8");
        Fault fault = exchange.createFault();
        fault.setContent(source);
        exchange.setFault(fault);
    }
}

