/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.se.xslt.model;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.ow2.petals.se.xslt.model.XslParameterBean;

public class XsltConfiguration {
    private static AtomicInteger idCounter = new AtomicInteger();
    private final int id;
    private final String xslPath;
    private final String transformerFactoryClassName;
    private final int transformerPoolSizeMin;
    private final int transformerPoolSizeMax;
    private final String suInstallRoot;
    private final String outputAttachmentName;
    private final String endpointName;
    private final String serviceUnitName;
    private final Map<String, XslParameterBean> paramNameToParamBean = new HashMap<String, XslParameterBean>();

    public XsltConfiguration(String xslPath, String transformerFactoryClassName, int transformerPoolSizeMin, int transformerPoolSizeMax, String suInstallRoot, String outputAttachmentName, String endpointName, String serviceUnitName, Map<String, XslParameterBean> paramNameToParamBean) {
        this.id = idCounter.getAndIncrement();
        this.xslPath = xslPath;
        this.transformerFactoryClassName = transformerFactoryClassName;
        this.transformerPoolSizeMin = transformerPoolSizeMin;
        this.transformerPoolSizeMax = transformerPoolSizeMax;
        this.suInstallRoot = suInstallRoot;
        this.endpointName = endpointName;
        this.serviceUnitName = serviceUnitName;
        this.outputAttachmentName = outputAttachmentName;
        this.paramNameToParamBean.putAll(paramNameToParamBean);
    }

    public String getXslPath() {
        return this.xslPath;
    }

    public String getTransformerFactoryClassName() {
        return this.transformerFactoryClassName;
    }

    public int getTransformerPoolSizeMin() {
        return this.transformerPoolSizeMin;
    }

    public int getTransformerPoolSizeMax() {
        return this.transformerPoolSizeMax;
    }

    public String getSuInstallRoot() {
        return this.suInstallRoot;
    }

    public String getOutputAttachmentName() {
        return this.outputAttachmentName;
    }

    public String getEndpointName() {
        return this.endpointName;
    }

    public String getServiceUnitName() {
        return this.serviceUnitName;
    }

    public Map<String, XslParameterBean> getParamNameToParamBean() {
        return this.paramNameToParamBean;
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof XsltConfiguration && ((XsltConfiguration)obj).id == this.id;
    }

    public int hashCode() {
        return this.id;
    }
}

