/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.se.xslt.model;

import com.ebmwebsourcing.easycommons.pooling.GenericResourcePool;
import com.ebmwebsourcing.easycommons.pooling.PoolPolicy;
import com.ebmwebsourcing.easycommons.pooling.ResourceHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.messaging.MessagingException;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.util.ClassLoaderUtil;
import org.ow2.petals.se.xslt.model.XslParameterBean;
import org.ow2.petals.se.xslt.model.XsltConfiguration;
import org.ow2.petals.se.xslt.model.XsltTransformerResourceHandler;
import org.ow2.petals.se.xslt.utils.LogErrorListener;
import org.ow2.petals.se.xslt.utils.ServiceUnitURIResolver;

public class XsltConfigurationHandler {
    private final XsltConfiguration xsltConfiguration;
    private final ServiceUnitURIResolver uriResolver;
    private final LogErrorListener logErrorListener;
    private ClassLoader classLoader;
    private final Object lock = new Object();
    private GenericResourcePool<Transformer> suTransformerResourcePool;

    public XsltConfigurationHandler(XsltConfiguration xsltConfiguration, Logger logger) {
        this.xsltConfiguration = xsltConfiguration;
        this.logErrorListener = new LogErrorListener(logger, xsltConfiguration.getServiceUnitName());
        this.uriResolver = new ServiceUnitURIResolver(xsltConfiguration.getSuInstallRoot(), logger, xsltConfiguration.getServiceUnitName());
    }

    public void check(Logger logger) throws PEtALSCDKException {
        this.createTemplate(logger, true);
    }

    public void start(Logger logger) throws PEtALSCDKException {
        Templates template = this.createTemplate(logger, false);
        XsltTransformerResourceHandler transformerResourceHandler = new XsltTransformerResourceHandler(template, this.uriResolver, this.logErrorListener, this.xsltConfiguration);
        int transformerPoolSizeMin = this.xsltConfiguration.getTransformerPoolSizeMin();
        int transformerPoolSizeMax = this.xsltConfiguration.getTransformerPoolSizeMax();
        this.suTransformerResourcePool = new GenericResourcePool((ResourceHandler)transformerResourceHandler, transformerPoolSizeMin, transformerPoolSizeMax, PoolPolicy.WAIT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Templates createTemplate(Logger logger, boolean logEnabled) throws PEtALSCDKException {
        Templates template = null;
        Object object = this.lock;
        synchronized (object) {
            String suRoot = this.xsltConfiguration.getSuInstallRoot();
            String logPrefix = this.xsltConfiguration.getServiceUnitName();
            InputStream xslStream = null;
            try {
                URLClassLoader tempClassLoader;
                boolean clazzProvided = false;
                block13: for (File file : new File(suRoot).listFiles()) {
                    if (!file.getName().toLowerCase().endsWith(".jar")) continue;
                    JarFile jar = new JarFile(file);
                    Enumeration<JarEntry> entryEnum = jar.entries();
                    while (entryEnum.hasMoreElements()) {
                        JarEntry jarEntry = entryEnum.nextElement();
                        if (!jarEntry.getName().toLowerCase().endsWith(".class")) continue;
                        clazzProvided = true;
                        break block13;
                    }
                }
                if ((xslStream = ((ClassLoader)(tempClassLoader = ClassLoaderUtil.createClassLoader((String)suRoot, (ClassLoader)this.getClass().getClassLoader()))).getResourceAsStream(this.xsltConfiguration.getXslPath())) == null) {
                    File xslStyleSheet = new File(suRoot, this.xsltConfiguration.getXslPath());
                    xslStream = new FileInputStream(xslStyleSheet);
                }
                StreamSource source = new StreamSource(xslStream);
                String transformerFactoryClassName = this.xsltConfiguration.getTransformerFactoryClassName();
                TransformerFactory transformerFactory = XsltConfigurationHandler.createTransformerFactory(logger, logPrefix, transformerFactoryClassName, logEnabled);
                transformerFactory.setURIResolver(this.uriResolver);
                transformerFactory.setErrorListener(this.logErrorListener);
                if (clazzProvided) {
                    this.classLoader = tempClassLoader;
                    Thread.currentThread().setContextClassLoader(this.classLoader);
                } else {
                    tempClassLoader = null;
                }
                template = transformerFactory.newTemplates(source);
                if (this.classLoader != null) {
                    Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest(logPrefix + ": the XSL style sheet was stored with a custom class loader.");
                    }
                }
            }
            catch (IOException e) {
                throw new PEtALSCDKException(logPrefix + ": failed to retrieve the XSL resources.", (Throwable)e);
            }
            catch (TransformerConfigurationException e) {
                throw new PEtALSCDKException(logPrefix + ": failed to create the pool of transformer.", (Throwable)e);
            }
            finally {
                block22: {
                    if (xslStream != null) {
                        try {
                            xslStream.close();
                        }
                        catch (IOException e) {
                            if (!logger.isLoggable(Level.FINE)) break block22;
                            logger.fine(logPrefix + ": the XSL input stream could not be closed.");
                        }
                    }
                }
            }
        }
        return template;
    }

    static final TransformerFactory createTransformerFactory(Logger logger, String logPrefix, String transformerFactoryClassName, boolean logEnabled) throws PEtALSCDKException {
        TransformerFactory transformerFactory;
        block10: {
            if (transformerFactoryClassName == null) {
                transformerFactory = TransformerFactory.newInstance();
                if (logger.isLoggable(Level.CONFIG)) {
                    logger.log(Level.CONFIG, "Transformer used: " + transformerFactory.getClass().getName() + " provided by the component");
                }
            } else {
                try {
                    Class<?> transformerFactoryClass;
                    Object transformerFactoryObj;
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.log(Level.FINEST, "Trying to load the specific XSLT engine factory class " + transformerFactoryClassName + " in the following classloader\n" + Thread.currentThread().getContextClassLoader());
                    }
                    if ((transformerFactoryObj = (transformerFactoryClass = Class.forName(transformerFactoryClassName)).newInstance()) instanceof TransformerFactory) {
                        transformerFactory = (TransformerFactory)transformerFactoryObj;
                        if (logger.isLoggable(Level.CONFIG)) {
                            logger.log(Level.CONFIG, "Transformer used: " + transformerFactory.getClass().getName() + " provided by the SL");
                        }
                        break block10;
                    }
                    throw new PEtALSCDKException(logPrefix + ": failed to create the pool of transformer. The class defined as XSLT engine factory does not implement TransformerFactory");
                }
                catch (ClassNotFoundException e) {
                    throw new PEtALSCDKException(logPrefix + ": failed to create the pool of transformer.", (Throwable)e);
                }
                catch (InstantiationException e) {
                    throw new PEtALSCDKException(logPrefix + ": failed to create the pool of transformer.", (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    throw new PEtALSCDKException(logPrefix + ": failed to create the pool of transformer.", (Throwable)e);
                }
            }
        }
        return transformerFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            this.classLoader = null;
        }
    }

    public String getEndpointName() {
        return this.xsltConfiguration.getEndpointName();
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public String getOutputAttachmentName() {
        return this.xsltConfiguration.getOutputAttachmentName();
    }

    public Transformer takeTransformer(Exchange exchange, Logger logger) throws TransformerException {
        Transformer transformer;
        block4: {
            transformer = (Transformer)this.suTransformerResourcePool.take();
            String logHint = "Exchange " + exchange.getExchangeId();
            try {
                Map<String, XslParameterBean> suXslParameters = this.xsltConfiguration.getParamNameToParamBean();
                for (String propertyName : exchange.getInMessagePropertyNames()) {
                    XslParameterBean suXslParamBean = suXslParameters.get(propertyName);
                    if (suXslParamBean != null && !suXslParamBean.isOverridable()) {
                        throw new TransformerException(logHint + ": the XSL parameter " + propertyName + " was already set by the configuration and cannot be overridden.");
                    }
                    Object value = exchange.getInMessageProperty(propertyName);
                    transformer.setParameter(propertyName, value);
                }
            }
            catch (MessagingException e) {
                if (!logger.isLoggable(Level.WARNING)) break block4;
                String msg = logHint + ": IN message properties could not be read and passed as parameters to the transformer.";
                logger.warning(msg);
            }
        }
        return transformer;
    }

    public void releaseTransformer(Transformer transformer) {
        this.suTransformerResourcePool.release((Object)transformer);
    }
}

