/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import org.ow2.petals.component.framework.DefaultBootstrap;
import org.ow2.petals.component.framework.jbidescriptor.generated.Component;
import org.ow2.petals.component.framework.jbidescriptor.generated.Runtimepositivestrictint;

public class ExtensionMBean
implements DynamicMBean {
    public static final String PROCESSOR_MAX_POOL_SIZE_ATTR_NAME = "processorMaxPoolSize";
    public static final String PROCESSOR_POOL_SIZE_ATTR_NAME = "processorPoolSize";
    private final List<AttributeSetterGetter> attributeSetterGetterList = new ArrayList<AttributeSetterGetter>();
    private static final Hashtable<String, Class<?>> primitiveClasses;
    private final DefaultBootstrap bootstrap;

    public ExtensionMBean(DefaultBootstrap bootstrap) {
        primitiveClasses.put(Boolean.TYPE.toString(), Boolean.TYPE);
        primitiveClasses.put(Character.TYPE.toString(), Character.TYPE);
        primitiveClasses.put(Byte.TYPE.toString(), Byte.TYPE);
        primitiveClasses.put(Short.TYPE.toString(), Short.TYPE);
        primitiveClasses.put(Integer.TYPE.toString(), Integer.TYPE);
        primitiveClasses.put(Long.TYPE.toString(), Long.TYPE);
        primitiveClasses.put(Float.TYPE.toString(), Float.TYPE);
        primitiveClasses.put(Double.TYPE.toString(), Double.TYPE);
        this.bootstrap = bootstrap;
    }

    @Override
    public synchronized Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        Object attributeObject = null;
        try {
            Field field = Component.class.getDeclaredField(attribute);
            field.setAccessible(true);
            Object settableObject = field.get(this.bootstrap.getJbiComponentConfiguration().getComponent());
            if (settableObject != null) {
                String methodName = "getValue";
                if (field.getType().getSimpleName().endsWith("boolean")) {
                    methodName = "isValue";
                }
                Method method = settableObject.getClass().getMethod(methodName, new Class[0]);
                attributeObject = method.invoke(settableObject, new Object[0]);
            }
        }
        catch (SecurityException e) {
            throw new AttributeNotFoundException("Attribute '" + attribute + "' is not reachable");
        }
        catch (NoSuchFieldException e) {
            boolean isFound = false;
            try {
                for (AttributeSetterGetter attributeSetterGetter : this.attributeSetterGetterList) {
                    if (!attributeSetterGetter.attributeName.equals(attribute)) continue;
                    attributeObject = attributeSetterGetter.getter.invoke((Object)this.bootstrap, new Object[0]);
                    isFound = true;
                    break;
                }
            }
            catch (IllegalArgumentException e1) {
                throw new ReflectionException(e, e.getMessage());
            }
            catch (IllegalAccessException e1) {
                throw new ReflectionException(e, e.getMessage());
            }
            catch (InvocationTargetException e1) {
                throw new ReflectionException(e, e.getMessage());
            }
            if (!isFound) {
                throw new AttributeNotFoundException("Attribute '" + attribute + "' does not exist");
            }
        }
        catch (IllegalArgumentException e) {
            throw new ReflectionException(e, e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e, e.getMessage());
        }
        catch (NoSuchMethodException e) {
            throw new ReflectionException(e, e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new ReflectionException(e, e.getMessage());
        }
        return attributeObject;
    }

    @Override
    public synchronized AttributeList getAttributes(String[] attributes) {
        AttributeList list = new AttributeList();
        for (String attribute : attributes) {
            try {
                list.add(new Attribute(attribute, this.getAttribute(attribute)));
            }
            catch (AttributeNotFoundException e) {
                this.bootstrap.getLogger().warning("Failed to get attribute '" + attribute + "' in the extension MBean : " + e.getClass().getSimpleName() + " : " + e.getMessage());
            }
            catch (MBeanException e) {
                this.bootstrap.getLogger().warning("Failed to get attribute '" + attribute + "' in the extension MBean : " + e.getClass().getSimpleName() + " : " + e.getMessage());
            }
            catch (ReflectionException e) {
                this.bootstrap.getLogger().warning("Failed to get attribute '" + attribute + "' in the extension MBean : " + e.getClass().getSimpleName() + " : " + e.getMessage());
            }
        }
        return list;
    }

    private Field findInheritedField(Class<?> clazz, String fieldName) throws NoSuchFieldException {
        Class<?> currentClazz = clazz;
        while (currentClazz != null) {
            try {
                return currentClazz.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {
                if ((currentClazz = currentClazz.getSuperclass()) != null) continue;
                throw e;
            }
        }
        return null;
    }

    @Override
    public synchronized void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        try {
            Field field = Component.class.getDeclaredField(attribute.getName());
            if (field.getType().equals(Runtimepositivestrictint.class)) {
                if (field.getName().equals(PROCESSOR_MAX_POOL_SIZE_ATTR_NAME) && (Integer)attribute.getValue() <= (Integer)this.getAttribute(PROCESSOR_POOL_SIZE_ATTR_NAME)) {
                    throw new InvalidAttributeValueException("Invalid value for attribute '" + attribute.getName() + "': The value must be upper or equals to the processor core pool size.");
                }
                if (field.getName().equals(PROCESSOR_POOL_SIZE_ATTR_NAME) && (Integer)attribute.getValue() > (Integer)this.getAttribute(PROCESSOR_MAX_POOL_SIZE_ATTR_NAME)) {
                    throw new InvalidAttributeValueException("Invalid value for attribute '" + attribute.getName() + "': The value must be lower or equals to the processor max pool size.");
                }
                if ((Integer)attribute.getValue() <= 0) {
                    throw new InvalidAttributeValueException("Invalid value for attribute '" + attribute.getName() + "': The value must be upper or equals to 1.");
                }
            }
            field.setAccessible(true);
            Object settableObject = field.get(this.bootstrap.getJbiComponentConfiguration().getComponent());
            Field primitiveField = this.findInheritedField(field.getType(), "value");
            Method method = settableObject.getClass().getMethod("setValue", primitiveField.getType());
            method.invoke(settableObject, attribute.getValue());
        }
        catch (SecurityException e) {
            throw new AttributeNotFoundException("Attribute '" + attribute.getName() + "' is not reachable");
        }
        catch (NoSuchFieldException e) {
            boolean isFound = false;
            try {
                for (AttributeSetterGetter attributeSetterGetter : this.attributeSetterGetterList) {
                    if (!attributeSetterGetter.attributeName.equals(attribute.getName())) continue;
                    attributeSetterGetter.setter.invoke((Object)this.bootstrap, attribute.getValue());
                    isFound = true;
                    break;
                }
            }
            catch (IllegalArgumentException e1) {
                throw new ReflectionException(e, e.getMessage());
            }
            catch (IllegalAccessException e1) {
                throw new ReflectionException(e, e.getMessage());
            }
            catch (InvocationTargetException e1) {
                throw new ReflectionException(e, e.getMessage());
            }
            if (!isFound) {
                throw new AttributeNotFoundException("Attribute '" + attribute + "' does not exist");
            }
        }
        catch (IllegalArgumentException e) {
            throw new ReflectionException(e);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e);
        }
        catch (NoSuchMethodException e) {
            throw new ReflectionException(e);
        }
        catch (InvocationTargetException e) {
            throw new ReflectionException(e);
        }
    }

    @Override
    public synchronized AttributeList setAttributes(AttributeList list) {
        AttributeList attributeList = new AttributeList();
        for (Object attribute : list) {
            try {
                this.setAttribute((Attribute)attribute);
            }
            catch (Throwable t) {
                this.bootstrap.getLogger().warning("Failed to set attribute '" + ((Attribute)attribute).getName() + "' in the extension MBean : " + t.getClass().getSimpleName() + " : " + t.getMessage());
            }
        }
        return attributeList;
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        Object result = null;
        Class<?>[] parameters = null;
        Class<?> objClass = this.bootstrap.getClass();
        ClassLoader loader = objClass.getClassLoader();
        if (signature != null) {
            parameters = this.findSignatureClasses(signature, loader);
        }
        Method method = null;
        try {
            method = objClass.getMethod(actionName, parameters);
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (method == null) {
            throw new ReflectionException(new NoSuchMethodException(actionName), "The operation with name " + actionName + " could not be found");
        }
        try {
            result = method.invoke((Object)this.bootstrap, params);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e, "IllegalAccessException occured trying to invoke operation " + actionName);
        }
        catch (RuntimeException e) {
            throw new RuntimeOperationsException(e, "RuntimeException occured trying to invoke operation " + actionName);
        }
        catch (InvocationTargetException e) {
            throw new MBeanException(e, "Exception thrown in operation " + actionName);
        }
        return result;
    }

    @Override
    public synchronized MBeanInfo getMBeanInfo() {
        MBeanAttributeInfo[] attrs = this.getAttributesInfos();
        MBeanOperationInfo[] opps = this.getOperationsInfos();
        return new MBeanInfo(this.getClass().getName(), "Property Manager MBean", attrs, null, opps, null);
    }

    protected MBeanAttributeInfo[] getAttributesInfos() {
        MBeanAttributeInfo[] attrs = null;
        Field[] fields = Component.class.getDeclaredFields();
        ArrayList<Field> settableFields = new ArrayList<Field>();
        Component componentConfiguration = this.bootstrap.getJbiComponentConfiguration().getComponent();
        try {
            Method getter;
            for (Field field : fields) {
                if (!field.getType().getSimpleName().startsWith("Runtime") && !field.getType().getSimpleName().startsWith("Settable")) continue;
                field.setAccessible(true);
                if (field.get(componentConfiguration) == null) continue;
                settableFields.add(field);
            }
            List<String> customAttrs = this.bootstrap.getAttributeList();
            int count = 0;
            attrs = new MBeanAttributeInfo[settableFields.size() + customAttrs.size()];
            Method[] methodList = this.bootstrap.getClass().getMethods();
            for (String attr : customAttrs) {
                Method setter = null;
                getter = null;
                for (Method method : methodList) {
                    if (method.getName().equalsIgnoreCase("set" + attr)) {
                        setter = method;
                        continue;
                    }
                    if (!method.getName().equalsIgnoreCase("get" + attr) && !method.getName().equalsIgnoreCase("is" + attr)) continue;
                    getter = method;
                }
                attrs[count] = new MBeanAttributeInfo(attr, "Property " + attr, getter, setter);
                this.attributeSetterGetterList.add(new AttributeSetterGetter(attr, getter, setter));
                ++count;
            }
            for (Field field : settableFields) {
                Object settableObject = field.get(componentConfiguration);
                getter = field.getType().getSimpleName().endsWith("boolean") ? settableObject.getClass().getMethod("isValue", new Class[0]) : settableObject.getClass().getMethod("getValue", new Class[0]);
                Field primitiveField = this.findInheritedField(field.getType(), "value");
                Method setter = settableObject.getClass().getMethod("setValue", primitiveField.getType());
                attrs[count] = new MBeanAttributeInfo(field.getName(), "Property " + field.getName(), getter, setter);
                ++count;
            }
        }
        catch (IllegalArgumentException e) {
            this.bootstrap.getLogger().warning("Failed to initialize fields of the Bootstrap extension MBean : " + e.getClass().getSimpleName() + " : " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            this.bootstrap.getLogger().warning("Failed to initialize fields of the Bootstrap extension MBean : " + e.getClass().getSimpleName() + " : " + e.getMessage());
        }
        catch (SecurityException e) {
            this.bootstrap.getLogger().warning("Failed to initialize fields of the Bootstrap extension MBean : " + e.getClass().getSimpleName() + " : " + e.getMessage());
        }
        catch (NoSuchMethodException e) {
            this.bootstrap.getLogger().warning("Failed to initialize fields of the Bootstrap extension MBean : " + e.getClass().getSimpleName() + " : " + e.getMessage());
        }
        catch (IntrospectionException e) {
            this.bootstrap.getLogger().warning("Failed to initialize fields of the Bootstrap extension MBean : " + e.getClass().getSimpleName() + " : " + e.getMessage());
        }
        catch (NoSuchFieldException e) {
            this.bootstrap.getLogger().warning("Failed to initialize fields of the Bootstrap extension MBean : " + e.getClass().getSimpleName() + " : " + e.getMessage());
        }
        return attrs;
    }

    protected MBeanOperationInfo[] getOperationsInfos() {
        Method[] methodList;
        List<String> methods = this.bootstrap.getMethodList();
        ArrayList<MBeanOperationInfo> operations = new ArrayList<MBeanOperationInfo>();
        for (Method method : methodList = this.bootstrap.getClass().getMethods()) {
            String name = method.getName();
            if (!methods.contains(name)) continue;
            MBeanOperationInfo oper = new MBeanOperationInfo("Operation description", method);
            operations.add(oper);
        }
        MBeanOperationInfo[] result = new MBeanOperationInfo[operations.size()];
        operations.toArray(result);
        return result;
    }

    private Class<?>[] findSignatureClasses(String[] signature, ClassLoader loader) throws ReflectionException {
        if (signature == null) {
            return null;
        }
        int length = signature.length;
        Class[] tab = new Class[length];
        if (length == 0) {
            return tab;
        }
        try {
            for (int i = 0; i < length; ++i) {
                Class<?> primCla = primitiveClasses.get(signature[i]);
                tab[i] = primCla != null ? primCla : Class.forName(signature[i], false, loader);
            }
        }
        catch (ClassNotFoundException e) {
            throw new ReflectionException(e, "The parameter class could not be found");
        }
        catch (RuntimeException e) {
            throw e;
        }
        return tab;
    }

    static {
        try {
            Component.class.getDeclaredField(PROCESSOR_MAX_POOL_SIZE_ATTR_NAME);
            Component.class.getDeclaredField(PROCESSOR_POOL_SIZE_ATTR_NAME);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        primitiveClasses = new Hashtable(8);
    }

    private static class AttributeSetterGetter {
        public String attributeName;
        public Method getter;
        public Method setter;

        public AttributeSetterGetter(String attributeName, Method getter, Method setter) {
            this.attributeName = attributeName;
            this.getter = getter;
            this.setter = setter;
        }
    }
}

