/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.se.xslt.model;

import com.ebmwebsourcing.easycommons.pooling.PoolException;
import com.ebmwebsourcing.easycommons.pooling.ResourceHandler;
import java.util.Map;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.URIResolver;
import org.ow2.petals.se.xslt.model.XslParameterBean;
import org.ow2.petals.se.xslt.model.XsltConfiguration;

public class XsltTransformerResourceHandler
implements ResourceHandler<Transformer> {
    private Templates template;
    private URIResolver uriResolver;
    private ErrorListener logErrorListener;
    private XsltConfiguration xsltConfiguration;

    public XsltTransformerResourceHandler(Templates template, URIResolver uriResolver, ErrorListener logErrorListener, XsltConfiguration xsltConfiguration) {
        this.template = template;
        this.uriResolver = uriResolver;
        this.logErrorListener = logErrorListener;
        this.xsltConfiguration = xsltConfiguration;
    }

    public void onTake(Transformer transformer) {
    }

    public Transformer create() {
        try {
            Transformer transformer = this.template.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setURIResolver(this.uriResolver);
            transformer.setErrorListener(this.logErrorListener);
            Map<String, XslParameterBean> suXslParameters = this.xsltConfiguration.getParamNameToParamBean();
            for (XslParameterBean paramBean : suXslParameters.values()) {
                transformer.setParameter(paramBean.getName(), paramBean.getValue());
            }
            return transformer;
        }
        catch (TransformerConfigurationException e) {
            throw new PoolException((Throwable)e);
        }
    }

    public void onRelease(Transformer transformer) {
    }
}

