/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.se.xslt.utils;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;

public class ServiceUnitURIResolver
implements URIResolver {
    private final String installRoot;
    private final Logger logger;
    private final String suName;

    public ServiceUnitURIResolver(String installRoot, Logger logger, String suName) {
        this.installRoot = installRoot;
        this.logger = logger;
        this.suName = suName;
    }

    @Override
    public final Source resolve(String href, String base) throws TransformerException {
        StreamSource ret;
        URI uriToResolve = URI.create(href);
        String scheme = uriToResolve.getScheme();
        if (scheme != null && scheme.length() > 0) {
            try {
                ret = new StreamSource(uriToResolve.toURL().openStream());
            }
            catch (MalformedURLException e) {
                throw new TransformerException(e);
            }
            catch (IOException e) {
                throw new TransformerException(e);
            }
        } else {
            File fileToLoad = href.charAt(0) == '/' ? new File(href) : new File(this.installRoot, href);
            if (fileToLoad.exists()) {
                ret = new StreamSource(fileToLoad);
            } else if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine(this.suName + ": a file reference could not be resolved (" + href + ").");
                ret = null;
            } else {
                ret = null;
            }
        }
        return ret;
    }
}

