/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.systemstate;

import java.io.File;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.ow2.petals.systemstate.SystemStateException;
import org.ow2.petals.systemstate.generated.SystemState;
import org.xml.sax.SAXException;

public final class SystemStateBuilder {
    public static final String NAMESPACE_XSD = "http://www.w3.org/2001/XMLSchema";
    public static final String SYSTEMSTATE_XSD = "petalsSystemState.xsd";
    private static Unmarshaller unmarshaller;
    private static SystemStateException unmarshCreationEx;
    private static Marshaller marshaller;
    private static SystemStateException marshallerCreationEx;

    private SystemStateBuilder() {
    }

    public static SystemState createSystemState(String xmlFileName) throws SystemStateException {
        return SystemStateBuilder.createSystemState(new File(xmlFileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SystemState createSystemState(File xmlFile) throws SystemStateException {
        if (unmarshaller == null) {
            throw unmarshCreationEx;
        }
        try {
            JAXBElement root;
            Unmarshaller unmarshaller = SystemStateBuilder.unmarshaller;
            synchronized (unmarshaller) {
                root = SystemStateBuilder.unmarshaller.unmarshal((Source)new StreamSource(xmlFile), SystemState.class);
            }
            return (SystemState)root.getValue();
        }
        catch (JAXBException e) {
            throw new SystemStateException("Failed to build System State", (Exception)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String buildXmlStringSystemState(SystemState systemStateClass) throws SystemStateException {
        if (marshaller == null) {
            throw marshallerCreationEx;
        }
        try {
            StringWriter stringWriter = new StringWriter();
            Marshaller marshaller = SystemStateBuilder.marshaller;
            synchronized (marshaller) {
                SystemStateBuilder.marshaller.marshal((Object)systemStateClass, (Writer)stringWriter);
            }
            return stringWriter.toString();
        }
        catch (JAXBException e) {
            throw new SystemStateException("Failed to build XML binding from System State Java classes", (Exception)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void buildXmlFileSystemState(SystemState systemStateClass, File systemStateFile) throws SystemStateException {
        if (marshaller == null) {
            throw marshallerCreationEx;
        }
        try {
            Marshaller marshaller = SystemStateBuilder.marshaller;
            synchronized (marshaller) {
                SystemStateBuilder.marshaller.marshal((Object)systemStateClass, systemStateFile);
            }
        }
        catch (JAXBException e) {
            throw new SystemStateException("Failed to build XML binding from System State Java classes", (Exception)((Object)e));
        }
    }

    static {
        marshaller = null;
        marshallerCreationEx = null;
        InputStream schemaInputStream = SystemStateBuilder.class.getResourceAsStream("/petalsSystemState.xsd");
        try {
            JAXBContext jaxbContext;
            SchemaFactory factory = SchemaFactory.newInstance(NAMESPACE_XSD);
            Source[] schemas = new StreamSource[]{new StreamSource(schemaInputStream)};
            Schema schema = factory.newSchema(schemas);
            try {
                jaxbContext = JAXBContext.newInstance((Class[])new Class[]{SystemState.class});
                unmarshaller = jaxbContext.createUnmarshaller();
                unmarshaller.setSchema(schema);
            }
            catch (JAXBException e) {
                unmarshCreationEx = new SystemStateException("Failed to create the JAXB unmarshaller", (Exception)((Object)e));
            }
            try {
                jaxbContext = JAXBContext.newInstance((Class[])new Class[]{SystemState.class});
                marshaller = jaxbContext.createMarshaller();
                marshaller.setSchema(schema);
            }
            catch (JAXBException e) {
                marshallerCreationEx = new SystemStateException("Failed to create the JAXB marshaller", (Exception)((Object)e));
            }
        }
        catch (SAXException e) {
            SystemStateException schemaCreationEx = new SystemStateException("Failed to parse resource 'petalsSystemState.xsd'", e);
            unmarshCreationEx = new SystemStateException("Failed to create the JAXB unmarshaller", schemaCreationEx);
            marshallerCreationEx = new SystemStateException("Failed to create the JAXB marshaller", schemaCreationEx);
        }
    }
}

