/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.topology;

import junit.framework.TestCase;
import org.ow2.petals.topology.TopologyBuilder;
import org.ow2.petals.topology.TopologyException;
import org.ow2.petals.topology.TopologyHelper;
import org.ow2.petals.topology.generated.Container;
import org.ow2.petals.topology.generated.Subdomain;
import org.ow2.petals.topology.generated.Topology;

public class TopologyHelperTest
extends TestCase {
    public static final String TEST_SUBDOMAIN_NAME_1 = "subdomain";
    public static final String TEST_SUBDOMAIN_NAME_2 = "subdomain2";
    public static final String TEST_BAD_SUBDOMAIN_NAME = "bad subdomain";
    public static final String TEST_CONTAINER_NAME = "2";
    public static final String TEST_BAD_CONTAINER_NAME = "bad container";
    private Topology topology;

    public void setUp() {
        try {
            this.topology = TopologyBuilder.createTopology((String)((Object)((Object)this)).getClass().getResource("/topology.xml").getFile());
        }
        catch (TopologyException e) {
            TopologyHelperTest.fail((String)e.getMessage());
            e.printStackTrace();
        }
    }

    public void testFindSubdomainByString() {
        Subdomain subdomain = TopologyHelper.findSubdomain((String)TEST_SUBDOMAIN_NAME_2, (Topology)this.topology);
        TopologyHelperTest.assertEquals((String)TEST_SUBDOMAIN_NAME_2, (String)subdomain.getName());
        Subdomain subdomain2 = TopologyHelper.findSubdomain((String)TEST_BAD_SUBDOMAIN_NAME, (Topology)this.topology);
        TopologyHelperTest.assertNull((Object)subdomain2);
    }

    public void testFindContainerInTopology() {
        Container container = TopologyHelper.findContainer((String)TEST_CONTAINER_NAME, (Topology)this.topology);
        TopologyHelperTest.assertEquals((String)TEST_CONTAINER_NAME, (String)container.getName());
        Container badContainer = TopologyHelper.findContainer((String)TEST_BAD_CONTAINER_NAME, (Topology)this.topology);
        TopologyHelperTest.assertNull((Object)badContainer);
    }

    public void testFindSubdomainByContainer() {
        Container container = TopologyHelper.findContainer((String)TEST_CONTAINER_NAME, (Topology)this.topology);
        Subdomain subdomain = TopologyHelper.findSubdomain((Container)container, (Topology)this.topology);
        TopologyHelperTest.assertEquals((String)TEST_SUBDOMAIN_NAME_1, (String)subdomain.getName());
    }

    public void testFindContainerInSubDomain() {
        Subdomain subdomain = TopologyHelper.findSubdomain((String)TEST_SUBDOMAIN_NAME_1, (Topology)this.topology);
        Container container = TopologyHelper.findContainer((String)TEST_CONTAINER_NAME, (Topology)this.topology);
        TopologyHelperTest.assertEquals((String)TEST_CONTAINER_NAME, (String)container.getName());
        Container badContainer = TopologyHelper.findContainer((String)TEST_BAD_CONTAINER_NAME, (Subdomain)subdomain);
        TopologyHelperTest.assertNull((Object)badContainer);
    }
}

