/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.tools.webconsole.business;

import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.petals.tools.webconsole.services.PetalsServiceTechnicalException;
import org.ow2.petals.tools.webconsole.services.monitoring.MonitoringService;
import org.ow2.petals.tools.webconsole.services.monitoring.MonitoringServiceFactory;

public final class AdvancedMonitoringBBean {
    private static final Log LOGGER = LogFactory.getLog(AdvancedMonitoringBBean.class);

    public final List<String> getCommonFlowExchangeIds(String host, int port, String login, String password, String correlationId) throws PetalsServiceTechnicalException {
        MonitoringService service = (MonitoringService)MonitoringServiceFactory.getInstance().getService(host, Integer.valueOf(port), login, password);
        LOGGER.debug((Object)("Monitoring service on Petals ESB node: " + host + "/" + port + "(host/port) correctly recovered"));
        return service.getExchangeIds("org.ow2.petals.propagate.correlation", correlationId);
    }

    public final String getCorrelationId(String host, int port, String login, String password, String exchangeId) throws PetalsServiceTechnicalException {
        String correlationId = null;
        MonitoringService service = (MonitoringService)MonitoringServiceFactory.getInstance().getService(host, Integer.valueOf(port), login, password);
        LOGGER.debug((Object)("Monitoring service on Petals ESB node: " + host + "/" + port + "(host/port) correctly recovered"));
        Map exchangeData = service.getExchange(exchangeId);
        if (exchangeData != null) {
            correlationId = (String)exchangeData.get("property-org.ow2.petals.propagate.correlation");
            LOGGER.debug((Object)("Correlation id [" + correlationId + "] for exchange id [" + exchangeId + "] recovered"));
        } else {
            LOGGER.debug((Object)("No data for exchange id [" + exchangeId + "] recovered"));
        }
        return correlationId;
    }
}

