/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.tools.webconsole.business;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Map;
import javax.management.MBeanAttributeInfo;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.opensuit.core.impl.multiparts.IFileUploadPart;
import org.ow2.petals.tools.webconsole.services.PetalsServiceTechnicalException;
import org.ow2.petals.tools.webconsole.services.management.ManagementService;
import org.ow2.petals.tools.webconsole.services.management.ManagementServiceFactory;
import org.ow2.petals.tools.webconsole.to.ServerTO;
import org.ow2.petals.tools.webconsole.uibeans.ManagementUIBean;
import org.ow2.petals.tools.webconsole.utils.GeneralHelper;
import org.ow2.petals.tools.webconsole.utils.PetalsConsoleException;

public final class InstallComponentBBean {
    private static final Log LOGGER = LogFactory.getLog(InstallComponentBBean.class);
    private String loadedInstaller;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String storeComponent(IFileUploadPart file, HttpServletRequest request) throws IOException {
        File componentDirectory = GeneralHelper.getComponentsRepo();
        File tmpFile = new File(componentDirectory, file.getFileName());
        if (!tmpFile.exists()) {
            if (tmpFile.createNewFile()) {
                LOGGER.info((Object)(tmpFile.getPath() + " file created"));
            } else {
                LOGGER.info((Object)(tmpFile.getPath() + " file not correctly created"));
            }
        }
        tmpFile.deleteOnExit();
        OutputStream out = null;
        InputStream in = null;
        try {
            LOGGER.debug((Object)("Begin to read " + tmpFile.getPath() + " file"));
            out = new FileOutputStream(tmpFile);
            in = file.getFileInputStream();
            byte[] data = new byte[1024];
            while (in.read(data) > -1) {
                out.write(data);
            }
            LOGGER.debug((Object)(tmpFile.getPath() + " file correctly read"));
        }
        finally {
            out.flush();
            out.close();
            in.close();
        }
        GeneralHelper.configureArtifact((File)tmpFile);
        LOGGER.debug((Object)(tmpFile.getPath() + " file access rights configured"));
        return tmpFile.getName();
    }

    public final void install(HttpServletRequest request, String fileName, String serverName, Map<MBeanAttributeInfo, Object> attributes, String loadedInstaller) throws MalformedURLException, IOException, URISyntaxException, PetalsServiceTechnicalException, PetalsConsoleException {
        ManagementService service;
        URL url = GeneralHelper.getFileRepositoryURL((String)fileName, (String)"components", (HttpServletRequest)request);
        LOGGER.debug((Object)(fileName + " file accessible at: " + url));
        ManagementUIBean managementBean = (ManagementUIBean)request.getSession().getAttribute("managementUIBean");
        ServerTO serverTO = null;
        for (ServerTO server : managementBean.getDomain().getServers()) {
            if (!server.getName().equals(serverName)) continue;
            serverTO = server;
        }
        if (serverTO != null) {
            service = null;
            try {
                LOGGER.debug((Object)("Try to recover managament service for server: " + serverTO.getName()));
                service = (ManagementService)ManagementServiceFactory.getInstance().getService(serverTO.getHost(), Integer.valueOf(Integer.parseInt(serverTO.getPort())), serverTO.getLogin(), serverTO.getPassword());
            }
            catch (NumberFormatException e) {
                LOGGER.error((Object)("Error occurred during management service recovery for component installation task (install " + loadedInstaller + " on " + serverTO.getName() + " server)"));
                throw e;
            }
        } else {
            LOGGER.error((Object)("Error occurred during component installation task (install " + loadedInstaller + " on " + serverName + " server), reason: server " + serverName + " not found in current domain"));
            throw new PetalsConsoleException("server " + serverName + " not found in current domain");
        }
        LOGGER.debug((Object)("Begin to install " + loadedInstaller + " on server: " + serverTO.getName()));
        service.installComponent(url, attributes, loadedInstaller);
        LOGGER.debug((Object)(loadedInstaller + " installation on server: " + serverTO.getName() + " correctly performed"));
    }

    public final Map<MBeanAttributeInfo, Object> beginLocalInstallation(ManagementUIBean managementUIBean, String fileName, String serverName, HttpServletRequest request) throws MalformedURLException, PetalsServiceTechnicalException, UnknownHostException, PetalsConsoleException {
        URL url = GeneralHelper.getFileRepositoryURL((String)fileName, (String)"components", (HttpServletRequest)request);
        LOGGER.debug((Object)(fileName + " file accessible at: " + url));
        ServerTO serverTO = null;
        for (ServerTO server : managementUIBean.getDomain().getServers()) {
            if (!server.getName().equals(serverName)) continue;
            serverTO = server;
        }
        if (serverTO == null) {
            LOGGER.error((Object)("Error occurred during begin local component installation task (install " + this.loadedInstaller + " on " + serverName + " server), reason: server " + serverName + " not found in current domain"));
            throw new PetalsConsoleException("server " + serverName + " not found in current domain");
        }
        ManagementService service = null;
        try {
            LOGGER.debug((Object)("Try to recover managament service for server: " + serverTO.getName()));
            service = (ManagementService)ManagementServiceFactory.getInstance().getService(serverTO.getHost(), Integer.valueOf(Integer.parseInt(serverTO.getPort())), serverTO.getLogin(), serverTO.getPassword());
        }
        catch (NumberFormatException e) {
            LOGGER.error((Object)("Error occurred during management service recovery for begin local component installation task (install " + this.loadedInstaller + " on " + serverTO.getName() + " server)"));
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
        LOGGER.debug((Object)("Begin to recover installation attributes for " + fileName + " on server: " + serverTO.getName()));
        Map mbAttributes = service.getComponentConfiguration(url);
        LOGGER.debug((Object)("Installation attributes correctly recovered for " + fileName + " on server: " + serverTO.getName()));
        this.loadedInstaller = service.getLoadedInstaller();
        LOGGER.debug((Object)(this.loadedInstaller + " loaded installer returned by the management service on server " + serverTO.getName()));
        return mbAttributes;
    }

    public final String getLoadedInstaller() {
        return this.loadedInstaller;
    }

    public final Map<MBeanAttributeInfo, Object> beginURLInstallation(ManagementUIBean managementUIBean, String url, String serverName, HttpServletRequest request) throws MalformedURLException, PetalsServiceTechnicalException, PetalsConsoleException {
        ServerTO serverTO = null;
        for (ServerTO server : managementUIBean.getDomain().getServers()) {
            if (!server.getName().equals(serverName)) continue;
            serverTO = server;
        }
        if (serverTO == null) {
            LOGGER.error((Object)("Error occurred during begin url component installation task (install " + this.loadedInstaller + " on " + serverName + " server), reason: server " + serverName + " not found in current domain"));
            throw new PetalsConsoleException("server " + serverName + " not found in current domain");
        }
        ManagementService service = null;
        try {
            LOGGER.debug((Object)("Try to recover managament service for server: " + serverTO.getName()));
            service = (ManagementService)ManagementServiceFactory.getInstance().getService(serverTO.getHost(), Integer.valueOf(Integer.parseInt(serverTO.getPort())), serverTO.getLogin(), serverTO.getPassword());
        }
        catch (NumberFormatException e) {
            LOGGER.error((Object)("Error occurred during management service recovery for begin url component installation task (install " + this.loadedInstaller + " on " + serverTO.getName() + " server)"));
            throw e;
        }
        LOGGER.debug((Object)("Begin to recover installation attributes for " + url + " on server: " + serverTO.getName()));
        Map mbAttributes = service.getComponentConfiguration(new URL(url));
        LOGGER.debug((Object)("Installation attributes correctly recovered for " + url + " on server: " + serverTO.getName()));
        this.loadedInstaller = service.getLoadedInstaller();
        LOGGER.debug((Object)(this.loadedInstaller + " loaded installer returned by the management service on server " + serverTO.getName()));
        return mbAttributes;
    }
}

