/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.tools.webconsole.business;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.opensuit.core.impl.multiparts.IFileUploadPart;
import org.ow2.petals.tools.webconsole.business.utils.SAReporterSAXHandler;
import org.ow2.petals.tools.webconsole.services.PetalsServiceTechnicalException;
import org.ow2.petals.tools.webconsole.services.management.ManagementService;
import org.ow2.petals.tools.webconsole.services.management.ManagementServiceFactory;
import org.ow2.petals.tools.webconsole.to.SUReportTO;
import org.ow2.petals.tools.webconsole.to.ServerTO;
import org.ow2.petals.tools.webconsole.uibeans.ManagementUIBean;
import org.ow2.petals.tools.webconsole.utils.GeneralHelper;
import org.ow2.petals.tools.webconsole.utils.PetalsConsoleException;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public final class InstallServiceAssemblyBBean {
    private static final Log LOGGER = LogFactory.getLog(InstallServiceAssemblyBBean.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String storeServiceAssembly(IFileUploadPart file, HttpServletRequest request) throws IOException {
        File saDirectory = GeneralHelper.getServiceAssembliesRepo();
        File tmpFile = new File(saDirectory, file.getFileName());
        if (!tmpFile.exists()) {
            if (tmpFile.createNewFile()) {
                LOGGER.info((Object)(tmpFile.getPath() + " file created"));
            } else {
                LOGGER.info((Object)(tmpFile.getPath() + " file not correctly created"));
            }
        }
        tmpFile.deleteOnExit();
        OutputStream out = null;
        InputStream in = null;
        try {
            LOGGER.debug((Object)("Begin to read " + tmpFile.getPath() + " file"));
            out = new FileOutputStream(tmpFile);
            in = file.getFileInputStream();
            byte[] data = new byte[1024];
            while (in.read(data) > -1) {
                out.write(data);
            }
            LOGGER.debug((Object)(tmpFile.getPath() + " file correctly read"));
        }
        finally {
            out.flush();
            out.close();
            in.close();
        }
        GeneralHelper.configureArtifact((File)tmpFile);
        LOGGER.debug((Object)(tmpFile.getPath() + " file access rights configured"));
        return tmpFile.getName();
    }

    public final List<SUReportTO> beginLocalInstallation(HttpServletRequest request, ManagementUIBean managementUIBean, String fileName, String serverName) throws PetalsServiceTechnicalException, IOException, URISyntaxException, PetalsConsoleException {
        URL url = GeneralHelper.getFileRepositoryURL((String)fileName, (String)"serviceassemblies", (HttpServletRequest)request);
        LOGGER.debug((Object)(fileName + " file accessible at: " + url));
        ServerTO serverTO = null;
        for (ServerTO server : managementUIBean.getDomain().getServers()) {
            if (!server.getName().equals(serverName)) continue;
            serverTO = server;
        }
        if (serverTO == null) {
            LOGGER.error((Object)("Error occurred during begin local service assembly installation task (install " + fileName + " on " + serverName + " server), reason: server " + serverName + " not found in current domain"));
            throw new PetalsConsoleException("server " + serverName + " not found in current domain");
        }
        ManagementService service = null;
        try {
            LOGGER.debug((Object)("Try to recover managament service for server: " + serverTO.getName()));
            service = (ManagementService)ManagementServiceFactory.getInstance().getService(serverTO.getHost(), Integer.valueOf(Integer.parseInt(serverTO.getPort())), serverTO.getLogin(), serverTO.getPassword());
        }
        catch (NumberFormatException e) {
            LOGGER.error((Object)("Error occurred during management service recovery for local service assembly installation task (install " + fileName + " on " + serverTO.getName() + " server)"));
            throw new PetalsConsoleException((Throwable)e);
        }
        LOGGER.debug((Object)("Begin to install " + fileName + " on server: " + serverTO.getName()));
        String report = service.installServiceAssembly(url);
        LOGGER.debug((Object)(fileName + " installation on server: " + serverTO.getName() + " correctly performed"));
        return this.performReport(report);
    }

    public final List<SUReportTO> beginURLInstallation(ManagementUIBean managementUIBean, String url, String serverName, HttpServletRequest request) throws MalformedURLException, PetalsServiceTechnicalException, PetalsConsoleException {
        ServerTO serverTO = null;
        for (ServerTO server : managementUIBean.getDomain().getServers()) {
            if (!server.getName().equals(serverName)) continue;
            serverTO = server;
        }
        if (serverTO == null) {
            LOGGER.error((Object)("Error occurred during begin url service assembly installation task (install " + url + " on " + serverName + " server), reason: server " + serverName + " not found in current domain"));
            throw new PetalsConsoleException("server " + serverName + " not found in current domain");
        }
        ManagementService service = null;
        try {
            LOGGER.debug((Object)("Try to recover managament service for server: " + serverTO.getName()));
            service = (ManagementService)ManagementServiceFactory.getInstance().getService(serverTO.getHost(), Integer.valueOf(Integer.parseInt(serverTO.getPort())), serverTO.getLogin(), serverTO.getPassword());
        }
        catch (NumberFormatException e) {
            LOGGER.error((Object)("Error occurred during management service recovery for url service assembly installation task (install " + url + " on " + serverTO.getName() + " server)"));
            throw new PetalsConsoleException((Throwable)e);
        }
        LOGGER.debug((Object)("Begin to install " + url + " on server: " + serverTO.getName()));
        String report = service.installServiceAssembly(new URL(url));
        LOGGER.debug((Object)(url + " installation on server: " + serverTO.getName() + " correctly performed"));
        return this.performReport(report);
    }

    private List<SUReportTO> performReport(String report) throws PetalsServiceTechnicalException {
        InputSource source;
        LOGGER.debug((Object)"Begin read report of service assembly installation");
        ArrayList<SUReportTO> suReportTOs = new ArrayList<SUReportTO>();
        XMLReader reader = null;
        try {
            reader = XMLReaderFactory.createXMLReader();
        }
        catch (SAXException e) {
            LOGGER.error((Object)"Error occurred during xml reader creation");
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
        SAReporterSAXHandler handler = new SAReporterSAXHandler();
        reader.setContentHandler((ContentHandler)handler);
        try {
            source = new InputSource(new ByteArrayInputStream(report.getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error((Object)"Error occurred during the input source creation");
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
        if (source != null) {
            try {
                reader.parse(source);
                suReportTOs.addAll(handler.getFailedSUs());
            }
            catch (IOException e) {
                LOGGER.error((Object)"Error occurred during the reading of service assembly installation report");
                throw new PetalsServiceTechnicalException((Throwable)e);
            }
            catch (SAXException e) {
                LOGGER.error((Object)"Error occurred during the reading of service assembly installation report");
                throw new PetalsServiceTechnicalException((Throwable)e);
            }
        }
        return suReportTOs;
    }
}

