/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.tools.webconsole.business;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.opensuit.core.impl.multiparts.IFileUploadPart;
import org.ow2.petals.tools.webconsole.services.PetalsServiceTechnicalException;
import org.ow2.petals.tools.webconsole.services.management.ManagementService;
import org.ow2.petals.tools.webconsole.services.management.ManagementServiceFactory;
import org.ow2.petals.tools.webconsole.to.ServerTO;
import org.ow2.petals.tools.webconsole.uibeans.ManagementUIBean;
import org.ow2.petals.tools.webconsole.utils.GeneralHelper;
import org.ow2.petals.tools.webconsole.utils.PetalsConsoleException;

public final class InstallSharedLibraryBBean {
    private static final Log LOGGER = LogFactory.getLog(InstallSharedLibraryBBean.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String storeSharedLibrary(IFileUploadPart file, HttpServletRequest request) throws IOException {
        File slDirectory = GeneralHelper.getSharedLibrariesRepo();
        File tmpFile = new File(slDirectory, file.getFileName());
        if (!tmpFile.exists()) {
            if (tmpFile.createNewFile()) {
                LOGGER.info((Object)(tmpFile.getPath() + " file created"));
            } else {
                LOGGER.info((Object)(tmpFile.getPath() + " file not correctly created"));
            }
        }
        tmpFile.deleteOnExit();
        OutputStream out = null;
        InputStream in = null;
        try {
            LOGGER.debug((Object)("Begin to read " + tmpFile.getPath() + " file"));
            out = new FileOutputStream(tmpFile);
            in = file.getFileInputStream();
            byte[] data = new byte[1024];
            while (in.read(data) > -1) {
                out.write(data);
            }
            LOGGER.debug((Object)(tmpFile.getPath() + " file correctly read"));
        }
        finally {
            out.flush();
            out.close();
            in.close();
        }
        GeneralHelper.configureArtifact((File)tmpFile);
        LOGGER.debug((Object)(tmpFile.getPath() + " file access rights configured"));
        return tmpFile.getName();
    }

    public final void beginLocalInstallation(HttpServletRequest request, ManagementUIBean managementUIBean, String fileName, String serverName) throws PetalsServiceTechnicalException, IOException, URISyntaxException, PetalsConsoleException {
        if (serverName == null || serverName.equals("")) {
            LOGGER.error((Object)"Server name must no be null or empty in order to begin shared library installation");
            throw new PetalsConsoleException("Server name must no be null or empty in order to begin shared library installation");
        }
        if (fileName == null || fileName.equals("")) {
            LOGGER.error((Object)"File name must no be null or empty in order to begin shared library installation");
            throw new PetalsConsoleException("File name must no be null or empty in order to begin shared library installation");
        }
        URL url = GeneralHelper.getFileRepositoryURL((String)fileName, (String)"sharedlibraries", (HttpServletRequest)request);
        LOGGER.debug((Object)(fileName + " file accessible at: " + url));
        ServerTO serverTO = null;
        for (ServerTO server : managementUIBean.getDomain().getServers()) {
            if (!server.getName().equals(serverName)) continue;
            serverTO = server;
        }
        if (serverTO == null) {
            LOGGER.error((Object)("Error occurred during begin local shared library installation task (install " + fileName + " on " + serverName + " server), reason: server " + serverName + " not found in current domain"));
            throw new PetalsConsoleException("server " + serverName + " not found in current domain");
        }
        ManagementService service = null;
        try {
            LOGGER.debug((Object)("Try to recover managament service for server: " + serverTO.getName()));
            service = (ManagementService)ManagementServiceFactory.getInstance().getService(serverTO.getHost(), Integer.valueOf(Integer.parseInt(serverTO.getPort())), serverTO.getLogin(), serverTO.getPassword());
        }
        catch (NumberFormatException e) {
            LOGGER.error((Object)("Error occurred during management service recovery for local shared library installation task (install " + fileName + " on " + serverTO.getName() + " server)"), (Throwable)e);
            throw new PetalsConsoleException((Throwable)e);
        }
        LOGGER.debug((Object)("Begin to install " + fileName + " on server: " + serverTO.getName()));
        service.installSharedLibrary(url);
        LOGGER.debug((Object)(fileName + " installation on server: " + serverTO.getName() + " correctly performed"));
    }

    public final void beginURLInstallation(HttpServletRequest request, ManagementUIBean managementUIBean, String url, String serverName) throws PetalsServiceTechnicalException, IOException, URISyntaxException, PetalsConsoleException {
        if (serverName == null || serverName.equals("")) {
            LOGGER.error((Object)"Server name must no be null or empty in order to begin shared library installation");
            throw new PetalsServiceTechnicalException("Server name must no be null or empty in order to begin shared library installation");
        }
        if (url == null || url.equals("")) {
            LOGGER.error((Object)"File name must no be null or empty in order to begin shared library installation");
            throw new PetalsServiceTechnicalException("URL must no be null or empty in order to begin shared library installation");
        }
        ServerTO serverTO = null;
        for (ServerTO server : managementUIBean.getDomain().getServers()) {
            if (!server.getName().equals(serverName)) continue;
            serverTO = server;
        }
        if (serverTO == null) {
            LOGGER.error((Object)("Error occurred during begin url shared library installation task (install " + url + " on " + serverName + " server), reason: server " + serverName + " not found in current domain"));
            throw new PetalsConsoleException("server " + serverName + " not found in current domain");
        }
        ManagementService service = null;
        try {
            LOGGER.debug((Object)("Try to recover managament service for server: " + serverTO.getName()));
            service = (ManagementService)ManagementServiceFactory.getInstance().getService(serverTO.getHost(), Integer.valueOf(Integer.parseInt(serverTO.getPort())), serverTO.getLogin(), serverTO.getPassword());
        }
        catch (NumberFormatException e) {
            LOGGER.error((Object)("Error occurred during management service recovery for url shared library installation task (install " + url + " on " + serverTO.getName() + " server)"));
            throw new PetalsConsoleException((Throwable)e);
        }
        LOGGER.debug((Object)("Begin to install " + url + " on server: " + serverTO.getName()));
        service.installSharedLibrary(new URL(url));
        LOGGER.debug((Object)(url + " installation on server: " + serverTO.getName() + " correctly performed"));
    }
}

