/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.tools.webconsole.business;

import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanAttributeInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.petals.tools.webconsole.services.PetalsServiceTechnicalException;
import org.ow2.petals.tools.webconsole.services.management.ManagementService;
import org.ow2.petals.tools.webconsole.services.management.ManagementServiceFactory;
import org.ow2.petals.tools.webconsole.services.monitoring.MonitoringService;
import org.ow2.petals.tools.webconsole.services.monitoring.MonitoringServiceFactory;
import org.ow2.petals.tools.webconsole.to.EndPointTO;
import org.ow2.petals.tools.webconsole.uibeans.utils.TopologyHelper;

public final class ManagementBBean {
    private static final Log LOGGER = LogFactory.getLog(ManagementBBean.class);

    public final Map<MBeanAttributeInfo, Object> recoverRuntimeAttributes(String componentName, String port, String password, String host, String login) throws PetalsServiceTechnicalException {
        LOGGER.debug((Object)("Try to recover management service on Petals ESB node: " + host + "/" + port + "(host/port)"));
        ManagementService service = (ManagementService)ManagementServiceFactory.getInstance().getService(host, Integer.valueOf(Integer.parseInt(port)), login, password);
        LOGGER.debug((Object)("Try to recover runtime attributes for: " + componentName));
        return service.recoverRuntimeAttributes(componentName);
    }

    public final void setRuntimeAttributes(String componentName, String port, String password, String host, String login, Map<MBeanAttributeInfo, Object> attributes) throws PetalsServiceTechnicalException {
        LOGGER.debug((Object)("Try to recover management service on Petals ESB node: " + host + "/" + port + "(host/port)"));
        ManagementService service = (ManagementService)ManagementServiceFactory.getInstance().getService(host, Integer.valueOf(Integer.parseInt(port)), login, password);
        service.setRuntimeAttributes(attributes, componentName);
        LOGGER.debug((Object)("Runtime attributes correctly set for: " + componentName));
    }

    public final void forceUnload(String componentName, ManagementService service) throws PetalsServiceTechnicalException {
        LOGGER.debug((Object)("Try to unload component installer: " + componentName));
        service.forceUnloadInstaller(componentName);
        LOGGER.debug((Object)("Component installer: " + componentName + " correctly unloaded"));
    }

    public final void forceUnDeploy(String saName, ManagementService service) throws PetalsServiceTechnicalException {
        LOGGER.debug((Object)("Try to undeploy service assembly: " + saName));
        service.forceUnDeploy(saName);
        LOGGER.debug((Object)("Service assembly: " + saName + " correctly undeployed"));
    }

    public final String getLevelForLogger(String componentName, String port, String password, String host, String login) throws PetalsServiceTechnicalException {
        LOGGER.debug((Object)("Try to recover management service on Petals ESB node: " + host + "/" + port + "(host/port)"));
        ManagementService service = (ManagementService)ManagementServiceFactory.getInstance().getService(host, Integer.valueOf(Integer.parseInt(port)), login, password);
        String level = service.getLevelForLogger(componentName);
        LOGGER.debug((Object)(componentName + " component logger level recovered: " + level));
        return level;
    }

    public final void setLoggerLevel(String componentName, String level, String port, String password, String host, String login) throws PetalsServiceTechnicalException {
        LOGGER.debug((Object)("Try to recover management service on Petals ESB node: " + host + "/" + port + "(host/port)"));
        ManagementService service = (ManagementService)ManagementServiceFactory.getInstance().getService(host, Integer.valueOf(Integer.parseInt(port)), login, password);
        service.setLoggerLevel(componentName, level);
        LOGGER.debug((Object)("Level: " + level + " correctly set for: " + componentName + " component logger"));
    }

    public final String[] getAllLevels(String port, String password, String host, String login) throws PetalsServiceTechnicalException {
        LOGGER.debug((Object)("Try to recover management service on Petals ESB node: " + host + "/" + port + "(host/port)"));
        ManagementService service = (ManagementService)ManagementServiceFactory.getInstance().getService(host, Integer.valueOf(Integer.parseInt(port)), login, password);
        return service.getAllLevels();
    }

    public final void updateMonitoredMessageAge(String port, String password, String host, String login, long duration) throws PetalsServiceTechnicalException {
        try {
            LOGGER.debug((Object)("Try to recover management service on Petals ESB node: " + host + "/" + port + "(host/port)"));
            MonitoringService service = (MonitoringService)MonitoringServiceFactory.getInstance().getService(host, Integer.valueOf(Integer.parseInt(port)), login, password);
            service.setMonitorStorageDuration(duration);
        }
        catch (NumberFormatException e) {
            LOGGER.error((Object)"Error occurred during the update monitored message age action");
            throw e;
        }
    }

    public final void purgeNow(String port, String password, String host, String login) throws PetalsServiceTechnicalException {
        LOGGER.debug((Object)("Try to recover management service on Petals ESB node: " + host + "/" + port + "(host/port)"));
        try {
            MonitoringService service = (MonitoringService)MonitoringServiceFactory.getInstance().getService(host, Integer.valueOf(Integer.parseInt(port)), login, password);
            service.clearMonitorStorage();
        }
        catch (NumberFormatException e) {
            LOGGER.error((Object)"Error occurred during purge now action");
            throw e;
        }
    }

    public Set<Map<String, String>> getTopology(String host, String port, String login, String password) throws PetalsServiceTechnicalException {
        LOGGER.debug((Object)("Try to recover management service on Petals ESB node: " + host + "/" + port + "(host/port)"));
        try {
            ManagementService service = (ManagementService)ManagementServiceFactory.getInstance().getService(host, Integer.valueOf(Integer.parseInt(port)), login, password);
            return service.getTopology(host, Integer.valueOf(Integer.parseInt(port)), login, password);
        }
        catch (NumberFormatException e) {
            LOGGER.error((Object)"Error occurred during topology recovering action");
            throw e;
        }
    }

    public final void establishConnection(String host, String port, String login, String password) throws PetalsServiceTechnicalException {
        LOGGER.debug((Object)("Try to recover management service on Petals ESB node: " + host + "/" + port + "(host/port)"));
        try {
            ManagementService service = (ManagementService)ManagementServiceFactory.getInstance().getService(host, Integer.valueOf(Integer.parseInt(port)), login, password);
        }
        catch (NumberFormatException e) {
            LOGGER.error((Object)("Error occurred during establish connection action, port value: " + port + " isn't correct"));
            throw e;
        }
    }

    public long getMonitorStorageDuration(String host, String port, String login, String password) throws PetalsServiceTechnicalException {
        LOGGER.debug((Object)("Try to recover management service on Petals ESB node: " + host + "/" + port + "(host/port)"));
        try {
            MonitoringService service = (MonitoringService)MonitoringServiceFactory.getInstance().getService(host, Integer.valueOf(Integer.parseInt(port)), login, password);
            return service.getMonitorStorageDuration();
        }
        catch (NumberFormatException e) {
            LOGGER.error((Object)"Error occurred during monitor storage duration recovering action");
            throw e;
        }
    }

    public List<EndPointTO> recoverEndpointsForComponent(String componentName, String host, String port, String login, String password, String serverName) throws PetalsServiceTechnicalException {
        ManagementService service = (ManagementService)ManagementServiceFactory.getInstance().getService(host, Integer.valueOf(Integer.parseInt(port)), login, password);
        return TopologyHelper.recoverEndpointsForComponent((String)componentName, (ManagementService)service, (String)serverName);
    }
}

