/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.tools.webconsole.business;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.opensuit.core.impl.multiparts.IFileUploadPart;
import org.ow2.petals.jmx.exception.ConnectionErrorException;
import org.ow2.petals.jmx.exception.RouterMonitorServiceErrorException;
import org.ow2.petals.tools.webconsole.services.PetalsServiceTechnicalException;
import org.ow2.petals.tools.webconsole.services.monitoring.MonitoringService;
import org.ow2.petals.tools.webconsole.services.monitoring.MonitoringServiceFactory;
import org.ow2.petals.tools.webconsole.to.ExchangeFilterTO;
import org.ow2.petals.tools.webconsole.to.ServerTO;
import org.ow2.petals.tools.webconsole.utils.GeneralHelper;

public final class MonitoringBBean {
    public static final QName NULL_QNAME = QName.valueOf("null");
    private static final Log LOGGER = LogFactory.getLog(MonitoringBBean.class);

    public final boolean changeMonitoringStatus(boolean status, String host, Integer port, String login, String password, ExchangeFilterTO filter) throws PetalsServiceTechnicalException {
        MonitoringService service = (MonitoringService)MonitoringServiceFactory.getInstance().getService(host, port, login, password);
        QName interfaceName = null;
        QName serviceName = null;
        QName operationName = null;
        String endpointName = null;
        if (!NULL_QNAME.getLocalPart().equals(filter.getInterfaceName().getLocalPart())) {
            interfaceName = filter.getInterfaceName();
        }
        if (!NULL_QNAME.getLocalPart().equals(filter.getServiceName().getLocalPart())) {
            serviceName = filter.getServiceName();
        }
        if (!NULL_QNAME.getLocalPart().equals(filter.getOperationName().getLocalPart())) {
            operationName = filter.getOperationName();
        }
        if (filter.getEndpointName() != null && !filter.getEndpointName().equals("null")) {
            endpointName = filter.getEndpointName();
        }
        if (operationName != null && "[]".equals(operationName.toString())) {
            operationName = null;
        }
        try {
            if (status) {
                LOGGER.debug((Object)("Enabled monitoring for filter: " + filter.getEISO()));
                service.monitorExchanges(interfaceName, serviceName, endpointName, operationName, filter.isStoreExchanges());
            } else {
                LOGGER.debug((Object)("Disabled monitoring for filter: " + filter.getEISO()));
                service.unmonitorExchanges(interfaceName, serviceName, endpointName, operationName);
            }
        }
        catch (PetalsServiceTechnicalException e) {
            if (ConnectionErrorException.class.equals(e.getCause().getClass())) {
                LOGGER.error((Object)("Error occurred during status monitoring changing for filter: " + filter.getEISO()), (Throwable)e);
                service.reInitializeConnection(host, port, login, password);
                if (status) {
                    LOGGER.debug((Object)("Enabled monitoring for filter: " + filter.getEISO()));
                    service.monitorExchanges(interfaceName, serviceName, endpointName, operationName, filter.isStoreExchanges());
                } else {
                    LOGGER.debug((Object)("Disabled monitoring for filter: " + filter.getEISO()));
                    service.unmonitorExchanges(interfaceName, serviceName, endpointName, operationName);
                }
            }
            LOGGER.error((Object)("Error occurred during status monitoring changing for filter: " + filter.getEISO()));
            throw e;
        }
        return status;
    }

    public final boolean isAlreadyCreate(String host, Integer port, String login, String password, ExchangeFilterTO filterTO) throws PetalsServiceTechnicalException {
        try {
            this.changeMonitoringStatus(true, host, port, login, password, filterTO);
        }
        catch (PetalsServiceTechnicalException e) {
            if (e.getCause().getClass().equals(RouterMonitorServiceErrorException.class)) {
                if (e.getMessage().contains("The Router Monitor filter RouterMonitorFilter") && e.getMessage().contains("already exist")) {
                    LOGGER.debug((Object)(filterTO.getEISO() + " filter is already created"));
                    return true;
                }
            }
            LOGGER.error((Object)("Error occurred during the check if filter: " + filterTO.getEISO() + " is already created"));
            throw e;
        }
        this.changeMonitoringStatus(false, host, port, login, password, filterTO);
        return false;
    }

    public final List<String> getFilterExchangeIds(String host, Integer port, String login, String password, ExchangeFilterTO filter, long startingTime, long endingTime) throws PetalsServiceTechnicalException {
        LOGGER.debug((Object)("Try to recover monitoring service on Petals ESB node: " + host + "/" + port + "(host/port)"));
        MonitoringService service = (MonitoringService)MonitoringServiceFactory.getInstance().getService(host, port, login, password);
        QName interfaceName = null;
        QName serviceName = null;
        QName operationName = null;
        String endpointName = null;
        if (!NULL_QNAME.getLocalPart().equals(filter.getInterfaceName().getLocalPart())) {
            interfaceName = filter.getInterfaceName();
        }
        if (!NULL_QNAME.getLocalPart().equals(filter.getServiceName().getLocalPart())) {
            serviceName = filter.getServiceName();
        }
        if (!NULL_QNAME.getLocalPart().equals(filter.getOperationName().getLocalPart())) {
            operationName = filter.getOperationName();
        }
        if (filter.getEndpointName() != null && !filter.getEndpointName().equals("null")) {
            endpointName = filter.getEndpointName();
        }
        ArrayList<String> exchangeIds = new ArrayList<String>();
        try {
            LOGGER.debug((Object)("Try to recover all exchange ids for filter: " + filter.getEISO()));
            exchangeIds.addAll(service.getExchangeIds(interfaceName, serviceName, endpointName, operationName, startingTime, endingTime));
            LOGGER.debug((Object)(exchangeIds.size() + " exchange ids recovered"));
        }
        catch (PetalsServiceTechnicalException e) {
            if (ConnectionErrorException.class.equals(e.getCause().getClass())) {
                LOGGER.debug((Object)("Try to recover all exchange ids for filter: " + filter.getEISO()));
                exchangeIds.addAll(service.getExchangeIds(interfaceName, serviceName, endpointName, operationName, startingTime, endingTime));
                LOGGER.debug((Object)(exchangeIds.size() + " exchange ids recovered"));
            }
            LOGGER.error((Object)("Error occurred during the exchange ids recovery for filter: " + filter.getEISO()));
            throw e;
        }
        return exchangeIds;
    }

    public final Map<String, String> getExchange(String host, Integer port, String login, String password, String exchangeId) throws PetalsServiceTechnicalException {
        LOGGER.debug((Object)("Try to recover monitoring service on Petals ESB node: " + host + "/" + port + "(host/port)"));
        MonitoringService service = (MonitoringService)MonitoringServiceFactory.getInstance().getService(host, port, login, password);
        Map history = null;
        if (service != null) {
            history = service.getExchange(exchangeId);
            if (history != null) {
                LOGGER.debug((Object)("History correctly recovered for exchange id: " + exchangeId + "(history size: " + history.size() + ")"));
            } else {
                LOGGER.debug((Object)("No history recovered for exchange id: " + exchangeId));
            }
        }
        return history;
    }

    public final List<Map<String, String>> recoverFilters(String host, int port, String login, String password) throws PetalsServiceTechnicalException {
        LOGGER.debug((Object)("Try to recover monitoring service on Petals ESB node: " + host + "/" + port + "(host/port)"));
        MonitoringService service = (MonitoringService)MonitoringServiceFactory.getInstance().getService(host, Integer.valueOf(port), login, password);
        LOGGER.debug((Object)"Try to recover all monitored exchange");
        return service.getMonitoredExchange();
    }

    public final String getMEPExchange(String host, int port, String login, String password, String exchangeId) throws PetalsServiceTechnicalException {
        LOGGER.debug((Object)("Try to recover monitoring service on Petals ESB node: " + host + "/" + port + "(host/port)"));
        MonitoringService service = (MonitoringService)MonitoringServiceFactory.getInstance().getService(host, Integer.valueOf(port), login, password);
        Map exchangeMap = service.getExchange(exchangeId);
        String mep = (String)exchangeMap.get("mep");
        LOGGER.debug((Object)("MEP: " + mep + " correctly recovered for exchange id: " + exchangeId));
        return mep;
    }

    public final int getTotalExchangesForFilter(String host, int port, String login, String password, ExchangeFilterTO filter, long startDate, long endDate) throws PetalsServiceTechnicalException {
        LOGGER.debug((Object)("Try to recover monitoring service on Petals ESB node: " + host + "/" + port + "(host/port)"));
        MonitoringService service = (MonitoringService)MonitoringServiceFactory.getInstance().getService(host, Integer.valueOf(port), login, password);
        QName interfaceName = null;
        QName serviceName = null;
        QName operationName = null;
        String endpointName = null;
        if (!NULL_QNAME.getLocalPart().equals(filter.getInterfaceName().getLocalPart())) {
            interfaceName = filter.getInterfaceName();
        }
        if (!NULL_QNAME.getLocalPart().equals(filter.getServiceName().getLocalPart())) {
            serviceName = filter.getServiceName();
        }
        if (!NULL_QNAME.getLocalPart().equals(filter.getOperationName().getLocalPart())) {
            operationName = filter.getOperationName();
        }
        if (filter.getEndpointName() != null && !filter.getEndpointName().equals("null")) {
            endpointName = filter.getEndpointName();
        }
        int totalExchanges = service.getExchanges(interfaceName, serviceName, endpointName, operationName, startDate, endDate);
        LOGGER.debug((Object)("Total of exchanges: " + totalExchanges + ", correctly recovered"));
        return totalExchanges;
    }

    public final String[] getStatusValueForFilter(String host, int port, String login, String password, ExchangeFilterTO filter, long startDate, long endDate) throws PetalsServiceTechnicalException {
        ArrayList<String> exchangeStatus = new ArrayList<String>();
        LOGGER.debug((Object)("Try to recover monitoring service on Petals ESB node: " + host + "/" + port + "(host/port)"));
        MonitoringService service = (MonitoringService)MonitoringServiceFactory.getInstance().getService(host, Integer.valueOf(port), login, password);
        QName interfaceName = null;
        QName serviceName = null;
        QName operationName = null;
        String endpointName = null;
        if (filter != null) {
            if (filter.getInterfaceName() != null && !NULL_QNAME.getLocalPart().equals(filter.getInterfaceName().getLocalPart())) {
                interfaceName = filter.getInterfaceName();
            }
            if (filter.getServiceName() != null && !NULL_QNAME.getLocalPart().equals(filter.getServiceName().getLocalPart())) {
                serviceName = filter.getServiceName();
            }
            if (filter.getOperationName() != null && !NULL_QNAME.getLocalPart().equals(filter.getOperationName().getLocalPart())) {
                operationName = filter.getOperationName();
            }
            if (filter.getEndpointName() != null && filter.getEndpointName() != null && !filter.getEndpointName().equals("null")) {
                endpointName = filter.getEndpointName();
            }
        }
        List exchangeIds = service.getExchangeIds(interfaceName, serviceName, endpointName, operationName, startDate, endDate);
        LOGGER.debug((Object)(exchangeIds.size() + " exchange ids recovered"));
        for (String exchangeId : exchangeIds) {
            Map history = service.getExchangeHistory(exchangeId);
            LOGGER.debug((Object)("History correctly recovered for exchange id: " + exchangeId));
            if (history.get("done-ack-sent") != null || history.get("done-ack-received") != null) {
                exchangeStatus.add("done");
                continue;
            }
            if (history.get("error-ack-sent") != null || history.get("error-ack-received") != null) {
                exchangeStatus.add("error");
                continue;
            }
            exchangeStatus.add("active");
        }
        LOGGER.debug((Object)(exchangeStatus.size() + " exchange status recovered"));
        return exchangeStatus.toArray(new String[exchangeStatus.size()]);
    }

    public final long getDurationForExchange(Map<String, Long> history) throws PetalsServiceTechnicalException {
        Long exchangeTimestamp = 0L;
        if (history != null && history.get("in-sent") != null) {
            Long inSentTimestamp;
            exchangeTimestamp = inSentTimestamp = history.get("in-sent");
            if (history.get("done-ack-received") != null) {
                exchangeTimestamp = history.get("done-ack-received") - history.get("in-sent");
            } else if (history.get("error-ack-received") != null) {
                exchangeTimestamp = history.get("error-ack-received") - history.get("in-sent");
            } else if (history.get("done-ack-sent") != null) {
                exchangeTimestamp = history.get("done-ack-sent") - history.get("in-sent");
            } else if (history.get("error-ack-sent") != null) {
                exchangeTimestamp = history.get("error-ack-sent") - history.get("in-sent");
            } else if (history.get("out-received") != null) {
                exchangeTimestamp = history.get("out-received") - history.get("in-sent");
            } else if (history.get("fault-received") != null) {
                exchangeTimestamp = history.get("fault-received") - history.get("in-sent");
            } else if (history.get("out-sent") != null) {
                exchangeTimestamp = history.get("out-sent") - history.get("in-sent");
            } else if (history.get("fault-sent") != null) {
                exchangeTimestamp = history.get("fault-sent") - history.get("in-sent");
            } else if (history.get("in-received") != null) {
                exchangeTimestamp = history.get("in-received") - history.get("in-sent");
            }
        }
        if (exchangeTimestamp > 0L) {
            return exchangeTimestamp;
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final File storeCSVImport(IFileUploadPart file, HttpServletRequest request) throws IOException, URISyntaxException {
        File othersRepo = GeneralHelper.getOthersRepo();
        String[] splittedPart = file.getFileName().split("\\\\");
        String filePath = othersRepo.getAbsolutePath() + File.separator + splittedPart[splittedPart.length - 1];
        OutputStream out = null;
        InputStream inputStream = null;
        File importation = new File(filePath);
        LOGGER.info((Object)(importation.getPath() + " file created"));
        importation.deleteOnExit();
        try {
            LOGGER.debug((Object)"Begin the copy of data");
            out = new FileOutputStream(importation);
            inputStream = file.getFileInputStream();
            byte[] data = new byte[1024];
            while (inputStream.read(data) > -1) {
                out.write(data);
            }
            LOGGER.debug((Object)"All data correctly written");
        }
        finally {
            out.flush();
            out.close();
            inputStream.close();
        }
        return importation;
    }

    public final Map<String, Long> getExchangeHistory(String host, int port, String login, String password, String exchangeId) throws PetalsServiceTechnicalException {
        LOGGER.debug((Object)("Try to recover monitoring service on Petals ESB node: " + host + "/" + port + "(host/port)"));
        MonitoringService service = (MonitoringService)MonitoringServiceFactory.getInstance().getService(host, Integer.valueOf(port), login, password);
        Map exchangeHistory = service.getExchangeHistory(exchangeId);
        LOGGER.debug((Object)("History for exchange id: " + exchangeId + " correctly recovered"));
        return exchangeHistory;
    }

    public final Map<String, Long> getDistributedExchangeHistory(ServerTO currentServer, ServerTO otherInvolvedServer, String exchangeId) throws NumberFormatException, PetalsServiceTechnicalException {
        HashMap<String, Long> allHistory = new HashMap<String, Long>();
        LOGGER.debug((Object)("Try to recover monitoring service on Petals ESB node: " + currentServer.getHost() + "/" + currentServer.getPort() + "(host/port)"));
        MonitoringService service = (MonitoringService)MonitoringServiceFactory.getInstance().getService(currentServer.getHost(), Integer.valueOf(Integer.parseInt(currentServer.getPort())), currentServer.getLogin(), currentServer.getPassword());
        Map firstHistory = service.getExchangeHistory(exchangeId);
        LOGGER.debug((Object)("History for exchange id: " + exchangeId + " on the current server correctly recovered"));
        LOGGER.debug((Object)("Try to recover monitoring service on Petals ESB node: " + otherInvolvedServer.getHost() + "/" + otherInvolvedServer.getPort() + "(host/port)"));
        service = (MonitoringService)MonitoringServiceFactory.getInstance().getService(otherInvolvedServer.getHost(), Integer.valueOf(Integer.parseInt(otherInvolvedServer.getPort())), otherInvolvedServer.getLogin(), otherInvolvedServer.getPassword());
        Map secondHistory = service.getExchangeHistory(exchangeId);
        LOGGER.debug((Object)("History for exchange id: " + exchangeId + " on the other involved server correctly recovered"));
        if (firstHistory != null && firstHistory.size() > 0) {
            allHistory.putAll(firstHistory);
        }
        if (secondHistory != null && secondHistory.size() > 0) {
            allHistory.putAll(secondHistory);
        }
        return allHistory;
    }
}

