/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.tools.webconsole.business;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.rmi.ConnectException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.activation.DataHandler;
import javax.jbi.messaging.MessageExchange;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.opensuit.core.impl.multiparts.IFileUploadPart;
import org.ow2.petals.tools.webconsole.services.PetalsServiceTechnicalException;
import org.ow2.petals.tools.webconsole.services.management.ManagementService;
import org.ow2.petals.tools.webconsole.services.management.ManagementServiceFactory;
import org.ow2.petals.tools.webconsole.services.remoteinjector.RemoteInjectorService;
import org.ow2.petals.tools.webconsole.services.remoteinjector.RemoteInjectorServiceFactory;
import org.ow2.petals.tools.webconsole.services.remoteinjector.models.Property;
import org.ow2.petals.tools.webconsole.to.ServerTO;
import org.ow2.petals.tools.webconsole.utils.GeneralHelper;

public final class RemoteInjectorBBean {
    private static final Log LOGGER = LogFactory.getLog(RemoteInjectorBBean.class);
    private final RemoteInjectorService service;
    private boolean correctRemotePort;
    private List<MessageExchange> exchanges = new ArrayList();

    public RemoteInjectorBBean(ServerTO remoteServer) throws PetalsServiceTechnicalException {
        this.service = (RemoteInjectorService)RemoteInjectorServiceFactory.getInstance().getService();
        LOGGER.debug((Object)"Remote injector service recovered");
        Map connectionPropertiesMap = this.createConnectionPropertiesMap(remoteServer);
        if (this.service.getRemoteComponentContext() == null) {
            try {
                this.service.initialize(connectionPropertiesMap);
                LOGGER.debug((Object)"Connection properties map for remote injection initialized: ");
                if (connectionPropertiesMap != null) {
                    for (String value : connectionPropertiesMap.values()) {
                        LOGGER.debug((Object)("Connection properties map value: " + value));
                    }
                }
                this.correctRemotePort = true;
            }
            catch (PetalsServiceTechnicalException e) {
                if (e.getCause() != null && e.getCause().getClass() != null && e.getCause().getClass().equals(ConnectException.class)) {
                    this.correctRemotePort = false;
                    LOGGER.warn((Object)"Bad remote injector port used", (Throwable)e);
                }
                LOGGER.error((Object)"Error occurred during remote injector business bean constructor");
                throw e;
            }
        } else {
            this.correctRemotePort = true;
        }
    }

    public final MessageExchange send(List<File> attachments, String mep, QName operation, Long synchronousSend, QName _interface, QName service, String endpoint, List<Property> mEXProperties, List<Property> normalizedProperties, String content) throws PetalsServiceTechnicalException {
        MessageExchange exchange = null;
        exchange = this.service.injectMessage(_interface, normalizedProperties, service, endpoint, operation, mep, mEXProperties, content, attachments, synchronousSend);
        LOGGER.debug((Object)("Exchange[id:" + exchange.getExchangeId() + "] performed on " + service + "/" + endpoint + "/" + operation + "/" + _interface));
        if (this.exchanges == null) {
            this.exchanges = new ArrayList();
        }
        return exchange;
    }

    private void storeAllReceivedAttachments(MessageExchange exchange) throws PetalsServiceTechnicalException {
        Object nMessage = null;
        nMessage = exchange.getMessage("OUT") != null ? exchange.getMessage("OUT") : exchange.getFault();
        if (nMessage != null && nMessage.getAttachmentNames() != null) {
            Set set = nMessage.getAttachmentNames();
            Iterator iterator = set.iterator();
            File repoAttachment = null;
            repoAttachment = GeneralHelper.getAttachmentsRepo();
            while (iterator.hasNext()) {
                String attachmentId = (String)iterator.next();
                DataHandler handler = nMessage.getAttachment(attachmentId);
                File attachment = new File(repoAttachment, handler.getName());
                if (attachment.exists()) continue;
                InputStream inputStream = null;
                try {
                    if (attachment.createNewFile()) {
                        LOGGER.info((Object)("Received attachment stored at: " + attachment.getPath()));
                    } else {
                        LOGGER.info((Object)("Received attachment not correctly stored at: " + attachment.getPath()));
                    }
                    inputStream = new FileInputStream(attachment);
                    handler.getOutputStream();
                }
                catch (IOException e) {
                    LOGGER.error((Object)("Error occurred during received attachment storing, impossible to store the returned attachment: " + handler.getName()));
                    throw new PetalsServiceTechnicalException("Impossible to store the returned attachment: " + handler.getName(), (Throwable)e);
                }
                finally {
                    if (inputStream == null) continue;
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        LOGGER.error((Object)"Error occurred during received attachment storing");
                        throw new PetalsServiceTechnicalException((Throwable)e);
                    }
                }
            }
        }
    }

    private Map<String, String> createConnectionPropertiesMap(ServerTO remoteServer) {
        HashMap<String, String> connectionPropertiesMap = null;
        if (remoteServer != null) {
            connectionPropertiesMap = new HashMap<String, String>();
            connectionPropertiesMap.put("rmiPort", String.valueOf(remoteServer.getRemotePort()));
            connectionPropertiesMap.put("rmiIP", remoteServer.getHost());
            connectionPropertiesMap.put("rmiContext", remoteServer.getRemoteContext());
            connectionPropertiesMap.put("acceptTimeout", "60000");
            LOGGER.debug((Object)"Remote connection properties map correclty created");
        } else {
            LOGGER.warn((Object)"Error occurred during connection properties map creation, no remote server available");
        }
        return connectionPropertiesMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final File storeAttachement(IFileUploadPart file, HttpServletRequest request) throws IOException, URISyntaxException {
        String[] splittedPart;
        File repoAttachment = GeneralHelper.getAttachmentsRepo();
        File attachment = new File(repoAttachment, (splittedPart = file.getFileName().split("\\\\"))[splittedPart.length - 1]);
        if (!attachment.exists()) {
            if (attachment.createNewFile()) {
                LOGGER.info((Object)("Received attachment stored at: " + attachment.getPath()));
            } else {
                LOGGER.info((Object)("Received attachment not correctly stored at: " + attachment.getPath()));
            }
        }
        attachment.deleteOnExit();
        FileOutputStream out = null;
        InputStream inputStream = null;
        try {
            int readedBytes;
            out = new FileOutputStream(attachment);
            inputStream = file.getFileInputStream();
            byte[] data = new byte[1024];
            do {
                if ((readedBytes = inputStream.read(data)) == -1) continue;
                ((OutputStream)out).write(data, 0, readedBytes);
                out.flush();
            } while (readedBytes != -1);
            LOGGER.debug((Object)(attachment.getPath() + " attachment correctly stored"));
        }
        finally {
            if (out != null) {
                ((OutputStream)out).close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return attachment;
    }

    public final List<MessageExchange> getExchanges() {
        return this.exchanges;
    }

    public final void setExchanges(List<MessageExchange> exchanges) {
        this.exchanges = exchanges;
    }

    public final boolean checkRemoteComponentAvailable(ServerTO remoteServer) throws NumberFormatException, PetalsServiceTechnicalException {
        if (this.correctRemotePort) {
            ManagementService service = (ManagementService)ManagementServiceFactory.getInstance().getService(remoteServer.getHost(), Integer.valueOf(Integer.parseInt(remoteServer.getPort())), remoteServer.getLogin(), remoteServer.getPassword());
            LOGGER.debug((Object)"Management service recovered for remote component checking");
            if (service != null) {
                String componentStatus = service.getComponentState("petals-se-rmi");
                LOGGER.debug((Object)("[petals-se-rmi] status recovered: " + componentStatus));
                if (componentStatus != null && componentStatus.equals("Started")) {
                    return true;
                }
            }
        }
        return false;
    }

    public final void removeAttachments(List<String> attachments, HttpServletRequest request) throws IOException, URISyntaxException {
        File repoAttachement = GeneralHelper.getAttachmentsRepo();
        for (File file : repoAttachement.listFiles()) {
            if (!attachments.contains(file.getName()) || file.delete()) continue;
            LOGGER.warn((Object)("Unable to delete attachment: " + file.getPath()));
        }
    }

    public final boolean isCorrectRemotePort() {
        return this.correctRemotePort;
    }

    public final MessageExchange performAcknowledgment(String mep, String acknowledgmentType, MessageExchange exchange, String returnedContent) throws PetalsServiceTechnicalException {
        MessageExchange returnedME = this.service.performAcknowledgment(mep, acknowledgmentType, exchange, returnedContent);
        this.exchanges.add(returnedME);
        this.storeAllReceivedAttachments(returnedME);
        return returnedME;
    }
}

