/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.tools.webconsole.business;

import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.petals.tools.webconsole.services.PetalsServiceFunctionalException;
import org.ow2.petals.tools.webconsole.services.PetalsServiceTechnicalException;
import org.ow2.petals.tools.webconsole.services.security.SecurityService;
import org.ow2.petals.tools.webconsole.services.security.SecurityServiceFactory;

public final class SecurityBBean {
    private static final Log LOGGER = LogFactory.getLog(SecurityBBean.class);

    public final boolean deleteUser(String username) throws PetalsServiceTechnicalException {
        SecurityService service = (SecurityService)SecurityServiceFactory.getInstance().getService();
        try {
            return service.deleteUser(username);
        }
        catch (PetalsServiceTechnicalException e) {
            LOGGER.error((Object)("Technical Error occurred during the delete of user '" + username + "'"));
            throw e;
        }
    }

    public final boolean addUser(String username, String password, String[] principals) throws PetalsServiceTechnicalException, PetalsServiceFunctionalException {
        SecurityService service = (SecurityService)SecurityServiceFactory.getInstance().getService();
        boolean result = false;
        try {
            result = service.addUser(username, password, principals);
        }
        catch (PetalsServiceTechnicalException e) {
            LOGGER.error((Object)("Technical Error occurred during the add of user '" + username + "'"));
            throw e;
        }
        catch (PetalsServiceFunctionalException e) {
            LOGGER.error((Object)("Functional Error occurred during the add of user '" + username + "'"));
            LOGGER.error((Object)e.getMessage());
            result = false;
        }
        return result;
    }

    public final boolean modifyUser(String oldUser, String modifiedUsername, String oldPassword, String modifiedPassword, String confirmModifiedPassword, String[] selectedRoles) throws PetalsServiceTechnicalException, PetalsServiceFunctionalException {
        SecurityService service = (SecurityService)SecurityServiceFactory.getInstance().getService();
        try {
            return service.modifyUser(oldUser, modifiedUsername, oldPassword, modifiedPassword, confirmModifiedPassword, selectedRoles);
        }
        catch (PetalsServiceTechnicalException e) {
            LOGGER.error((Object)("Technical Error occurred during the modification of user '" + modifiedUsername + "'"));
            throw e;
        }
        catch (PetalsServiceFunctionalException e) {
            LOGGER.error((Object)("Functional Error occurred during the modification of user '" + modifiedUsername + "'"));
            throw e;
        }
    }

    public String encrypt(String password) throws PetalsServiceTechnicalException {
        SecurityService service = (SecurityService)SecurityServiceFactory.getInstance().getService();
        return service.encrypt(password);
    }

    public String[] getUserRoles(String username) throws PetalsServiceTechnicalException, PetalsServiceFunctionalException {
        SecurityService service = (SecurityService)SecurityServiceFactory.getInstance().getService();
        try {
            return service.getUserRoles(username);
        }
        catch (PetalsServiceTechnicalException e) {
            LOGGER.error((Object)("Technical Error occurred during the modification of user '" + username + "'"));
            throw e;
        }
        catch (PetalsServiceFunctionalException e) {
            LOGGER.error((Object)("Functional Error occurred during the modification of user '" + username + "'"));
            throw e;
        }
    }

    public String getUserPassword(String username) throws PetalsServiceTechnicalException, PetalsServiceFunctionalException {
        SecurityService service = (SecurityService)SecurityServiceFactory.getInstance().getService();
        try {
            return service.getUserPassword(username);
        }
        catch (PetalsServiceTechnicalException e) {
            LOGGER.error((Object)("Technical Error occurred during the modification of user '" + username + "'"));
            throw e;
        }
        catch (PetalsServiceFunctionalException e) {
            LOGGER.error((Object)("Functional Error occurred during the modification of user '" + username + "'"));
            throw e;
        }
    }

    public Collection<String> getAllUsers() throws PetalsServiceTechnicalException, PetalsServiceFunctionalException {
        SecurityService service = (SecurityService)SecurityServiceFactory.getInstance().getService();
        try {
            return service.getAllUsers();
        }
        catch (PetalsServiceTechnicalException e) {
            LOGGER.error((Object)"Technical Error occurred during users recovering");
            throw e;
        }
        catch (PetalsServiceFunctionalException e) {
            LOGGER.error((Object)"Functional Error occurred during users recovering");
            throw e;
        }
    }
}

