/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.tools.webconsole.business;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.petals.tools.webconsole.services.PetalsServiceTechnicalException;
import org.ow2.petals.tools.webconsole.services.management.ManagementService;
import org.ow2.petals.tools.webconsole.services.management.ManagementServiceFactory;
import org.ow2.petals.tools.webconsole.utils.StringHelper;
import org.w3c.dom.Document;

public final class ServerBBean {
    private static final Log LOGGER = LogFactory.getLog(ServerBBean.class);

    public final String loadWsdlEndpoint(String serviceName, String endpointName, String hostname, Integer port, String login, String password) throws PetalsServiceTechnicalException {
        ManagementService service = (ManagementService)ManagementServiceFactory.getInstance().getService(hostname, port, login, password);
        Document document = service.getDocument(serviceName, endpointName);
        String wsdl = "";
        if (document != null) {
            LOGGER.debug((Object)("Document correctly recovered for " + serviceName + "/" + endpointName + " [service/endpoint]"));
            wsdl = StringHelper.prettyPrint((Document)document);
        }
        return wsdl;
    }

    public List<String> getLoadedComponentInstallers(String hostname, Integer port, String login, String password) throws PetalsServiceTechnicalException {
        ManagementService service = (ManagementService)ManagementServiceFactory.getInstance().getService(hostname, port, login, password);
        return service.getLoadedComponentInstallers();
    }

    public void unloadInstallers(List<String> selectedInstallers, String hostname, Integer port, String login, String password) throws PetalsServiceTechnicalException {
        ManagementService service = (ManagementService)ManagementServiceFactory.getInstance().getService(hostname, port, login, password);
        for (String selectedInstaller : selectedInstallers) {
            service.forceUnloadInstaller(selectedInstaller);
        }
    }
}

