/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.tools.webconsole.business;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.petals.tools.webconsole.utils.ConfigHelper;
import org.ow2.petals.tools.webconsole.utils.PetalsConsoleException;
import org.ow2.petals.tools.webconsole.xmlbeans.Server;
import org.xml.sax.SAXException;

/*
 * Exception performing whole class analysis ignored.
 */
public final class ServerFeatureBBean {
    private static final Log LOGGER = LogFactory.getLog(ServerFeatureBBean.class);
    public static final String ACTION_TYPE_MODIFY = "modify";
    public static final String ACTION_TYPE_ADD = "add";
    public static final String INSTANCE_FILE_NAME = "webconsole.xml";
    public static final String SCHEMA_FILE_NAME = "webconsole.xsd";
    private static final List<Server> CONFIGURED_SERVERS = new ArrayList();

    private static List<Server> initializeConfiguredServers() throws MalformedURLException, IOException, SAXException, ParserConfigurationException, FactoryConfigurationError, URISyntaxException {
        List servers = ConfigHelper.readConfiguration((URL)Thread.currentThread().getContextClassLoader().getResource("webconsole.xml"));
        LOGGER.debug((Object)(servers.size() + " configured servers recovered"));
        return servers;
    }

    public final void modifyServer(String host, String port, String login, String password, String modifiedName, String modifiedDomain, boolean installedRemoteComponent, int remotePort, String remoteContext) throws URISyntaxException, ParserConfigurationException, IOException {
        for (Server server : CONFIGURED_SERVERS) {
            if (!server.getName().equals(modifiedName) || !server.getDomain().equals(modifiedDomain)) continue;
            LOGGER.debug((Object)"Set properties for remote server");
            server.setHost(host);
            server.setPort(port);
            server.setPassword(password);
            server.setLogin(login);
            server.setInstalledRemoteComponent(installedRemoteComponent);
            server.setRemoteContext(remoteContext);
            server.setRemotePort(remotePort);
        }
        try {
            ConfigHelper.writeConfiguration((String)"webconsole.xml", (String)"webconsole.xsd", (List)CONFIGURED_SERVERS);
            LOGGER.debug((Object)"Server modification correctly saved in webconsole.xml");
        }
        catch (URISyntaxException e) {
            LOGGER.error((Object)"Error occurred during the save of server modifications");
            throw e;
        }
        catch (ParserConfigurationException e) {
            LOGGER.error((Object)"Error occurred during the save of server modifications");
            throw e;
        }
        catch (IOException e) {
            LOGGER.error((Object)"Error occurred during the save of server modifications");
            throw e;
        }
    }

    public final void addServer(String host, String port, String login, String password, boolean installedRemoteComponent, int remotePort, String remoteContext) throws PetalsConsoleException {
        for (Server server : CONFIGURED_SERVERS) {
            if (!server.getHost().equals(host) || !server.getPort().equals(port) || !server.getPassword().equals(password) || !server.getLogin().equals(login)) continue;
            LOGGER.warn((Object)("Error occurred during server[" + server.getName() + "/" + server.getHost() + "/" + server.getPort() + "] adding in configuration (server configuration already exist in the " + "webconsole.xml" + ")"));
            throw new PetalsConsoleException("Server configuration already exist in the webconsole.xml");
        }
        Server server = new Server();
        server.setHost(host);
        server.setPort(port);
        server.setPassword(password);
        server.setLogin(login);
        if (remotePort != 0 && remoteContext != null && !remoteContext.equals("")) {
            server.setInstalledRemoteComponent(installedRemoteComponent);
        }
        if (remoteContext != null && !remoteContext.equals("")) {
            server.setRemoteContext(remoteContext);
        }
        if (remotePort != 0) {
            server.setRemotePort(remotePort);
        }
        CONFIGURED_SERVERS.add(server);
        try {
            ConfigHelper.writeConfiguration((String)"webconsole.xml", (String)"webconsole.xsd", (List)CONFIGURED_SERVERS);
        }
        catch (URISyntaxException e) {
            LOGGER.error((Object)"Error occurred during server adding in configuration file");
            throw new PetalsConsoleException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            LOGGER.error((Object)"Error occurred during server adding in configuration file");
            throw new PetalsConsoleException((Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error((Object)"Error occurred during server adding in configuration file");
            throw new PetalsConsoleException((Throwable)e);
        }
    }

    public final void addServer(Server server) throws URISyntaxException, ParserConfigurationException, IOException {
        for (Server configuredServer : CONFIGURED_SERVERS) {
            if (!configuredServer.getDomain().equals(server.getDomain()) || !configuredServer.getName().equals(server.getName())) continue;
            LOGGER.warn((Object)("Error occurred during server[" + server.getDomain() + "/" + server.getName() + "] adding in configuration (server configuration already exist in the " + "webconsole.xml" + ")"));
            throw new IllegalArgumentException("Server configuration already exist in the webconsole.xml");
        }
        CONFIGURED_SERVERS.add(server);
        try {
            ConfigHelper.writeConfiguration((String)"webconsole.xml", (String)"webconsole.xsd", (List)CONFIGURED_SERVERS);
        }
        catch (URISyntaxException e) {
            LOGGER.error((Object)"Error occurred during server adding in configuration file");
            throw e;
        }
        catch (ParserConfigurationException e) {
            LOGGER.error((Object)"Error occurred during server adding in configuration file");
            throw e;
        }
        catch (IOException e) {
            LOGGER.error((Object)"Error occurred during server adding in configuration file");
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final List<Server> getConfiguredServers() {
        List list = CONFIGURED_SERVERS;
        synchronized (list) {
            return CONFIGURED_SERVERS;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void populateServerList() throws IOException, SAXException, URISyntaxException, ParserConfigurationException {
        List list = CONFIGURED_SERVERS;
        synchronized (list) {
            try {
                CONFIGURED_SERVERS.clear();
                CONFIGURED_SERVERS.addAll(ServerFeatureBBean.initializeConfiguredServers());
                LOGGER.debug((Object)(CONFIGURED_SERVERS.size() + " servers recovered during configured servers populating"));
            }
            catch (MalformedURLException e) {
                LOGGER.error((Object)"Error occurred during configured servers populating");
                throw e;
            }
            catch (IOException e) {
                LOGGER.error((Object)"Error occurred during configured servers populating");
                throw e;
            }
            catch (SAXException e) {
                LOGGER.error((Object)"Error occurred during configured servers populating");
                throw e;
            }
            catch (ParserConfigurationException e) {
                LOGGER.error((Object)"Error occurred during configured servers populating");
                throw e;
            }
            catch (FactoryConfigurationError e) {
                LOGGER.error((Object)"Error occurred during configured servers populating");
                throw e;
            }
            catch (URISyntaxException e) {
                LOGGER.error((Object)"Error occurred during configured servers populating");
                throw e;
            }
        }
    }

    public final void deleteServer(String host, String port, String login, String password) throws URISyntaxException, ParserConfigurationException, IOException {
        int index = 0;
        for (Server s : CONFIGURED_SERVERS) {
            if (!s.getHost().equals(host) || !s.getPort().equals(port) || !s.getPassword().equals(password) || !s.getLogin().equals(login)) continue;
            index = CONFIGURED_SERVERS.indexOf(s);
        }
        if (!CONFIGURED_SERVERS.isEmpty()) {
            CONFIGURED_SERVERS.remove(index);
        }
        LOGGER.debug((Object)("Remove of [" + host + "/" + port + "] server in configuration file"));
        try {
            ConfigHelper.writeConfiguration((String)"webconsole.xml", (String)"webconsole.xsd", (List)CONFIGURED_SERVERS);
            LOGGER.debug((Object)("Server [" + host + "/" + port + "] removing correctly saved in configuration file: " + "webconsole.xml"));
        }
        catch (URISyntaxException e) {
            LOGGER.error((Object)"Error occurred during the save of server deleting action");
            throw e;
        }
        catch (ParserConfigurationException e) {
            LOGGER.error((Object)"Error occurred during the save of server deleting action");
            throw e;
        }
        catch (IOException e) {
            LOGGER.error((Object)"Error occurred during the save of server deleting action");
            throw e;
        }
    }

    static {
        try {
            ServerFeatureBBean.populateServerList();
        }
        catch (IOException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Error occuring during static server feature initialization", (Throwable)e);
            } else {
                LOGGER.warn((Object)("Error occuring during static server feature initialization" + e.getMessage()));
            }
        }
        catch (SAXException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Error occuring during static server feature initialization", (Throwable)e);
            } else {
                LOGGER.warn((Object)("Error occuring during static server feature initialization" + e.getMessage()));
            }
        }
        catch (URISyntaxException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Error occuring during static server feature initialization", (Throwable)e);
            } else {
                LOGGER.warn((Object)("Error occuring during static server feature initialization" + e.getMessage()));
            }
        }
        catch (ParserConfigurationException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Error occuring during static server feature initialization", (Throwable)e);
            }
            LOGGER.warn((Object)("Error occuring during static server feature initialization" + e.getMessage()));
        }
    }
}

