/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.tools.webconsole.business.utils;

import java.util.ArrayList;
import java.util.List;
import org.ow2.petals.tools.webconsole.to.SUReportTO;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class SAReporterSAXHandler
extends DefaultHandler {
    private static final String TASK_RESULT_TAG = "task-result";
    private static final String LOC_PARAM_TAG = "loc-param";
    private static final String STACK_TRACE_TAG = "stack-trace";
    private static final String FAILED_TASK_RESULT = "FAILED";
    private List<SUReportTO> failedSUs = new ArrayList();
    private boolean currentSUFailed;
    private boolean currentTaskResult;
    private boolean currentLocParam;
    private boolean currentStackTrace;
    private String locParamValue;
    private String stackTraceValue;

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals(TASK_RESULT_TAG)) {
            this.currentTaskResult = true;
        } else if (qName.equals(LOC_PARAM_TAG)) {
            this.currentLocParam = true;
        } else if (qName.equals(STACK_TRACE_TAG)) {
            this.currentStackTrace = true;
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals(LOC_PARAM_TAG)) {
            this.currentLocParam = false;
        }
        if (qName.equals(STACK_TRACE_TAG)) {
            if (this.currentSUFailed) {
                this.failedSUs.add(new SUReportTO(this.locParamValue, this.stackTraceValue));
            }
            this.currentTaskResult = false;
            this.currentStackTrace = false;
            this.currentSUFailed = false;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String lecture = new String(ch, start, length);
        if (this.currentTaskResult && FAILED_TASK_RESULT.equals(lecture)) {
            this.currentSUFailed = true;
        }
        if (this.currentSUFailed && this.currentLocParam) {
            this.locParamValue = lecture;
        }
        if (this.currentSUFailed && this.currentStackTrace) {
            this.stackTraceValue = lecture;
        }
    }

    public List<SUReportTO> getFailedSUs() {
        return this.failedSUs;
    }
}

