/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.tools.webconsole.services.management;

import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.Semaphore;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.petals.tools.webconsole.services.AbstractServiceFactory;
import org.ow2.petals.tools.webconsole.services.PetalsService;
import org.ow2.petals.tools.webconsole.services.PetalsServiceTechnicalException;
import org.ow2.petals.tools.webconsole.services.management.ManagementService;
import org.ow2.petals.tools.webconsole.services.management.ManagementServiceJMXImpl;
import org.ow2.petals.tools.webconsole.services.utils.ConnectionHelper;

public class ManagementServiceFactory
extends AbstractServiceFactory {
    private static final Log LOGGER = LogFactory.getLog(ManagementServiceFactory.class);
    private static ManagementServiceFactory INSTANCE = null;
    private ManagementService service = null;
    private String host;
    private String port;
    private String login;
    private String password;
    private static final Semaphore SEMAPHORE = new Semaphore(1);

    private ManagementServiceFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AbstractServiceFactory getInstance() {
        Semaphore semaphore = SEMAPHORE;
        synchronized (semaphore) {
            if (INSTANCE == null) {
                INSTANCE = new ManagementServiceFactory();
            }
            return INSTANCE;
        }
    }

    public ManagementService getService(String hostname, Integer port, String login, String password) throws PetalsServiceTechnicalException {
        if (!(this.service != null && hostname.equals(this.host) && port.equals(Integer.valueOf(this.port)) && login.equals(this.login) && password.equals(this.password))) {
            this.service = this.getImplementation(hostname, port, login, password);
            this.host = hostname;
            this.port = String.valueOf(port);
            this.login = login;
            this.password = password;
        }
        return this.service;
    }

    private ManagementService getImplementation(String hostname, Integer port, String login, String password) throws PetalsServiceTechnicalException {
        Class<?>[] interfaces;
        Properties props = new Properties();
        try {
            props.load(Thread.currentThread().getContextClassLoader().getResourceAsStream("services.properties"));
        }
        catch (IOException e) {
            LOGGER.error((Object)"Error occurred during properties loading for the get of management service implementation");
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
        String className = props.getProperty("management.service.impl");
        Class<?> loadedClass = null;
        try {
            loadedClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error((Object)"Error occurred during invoked class returning for the get of management service implementation");
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
        boolean checkManagementServiceImplementation = Boolean.FALSE;
        for (Class<?> inter : interfaces = loadedClass.getInterfaces()) {
            if (!inter.equals(ManagementService.class)) continue;
            checkManagementServiceImplementation = Boolean.TRUE;
        }
        if (checkManagementServiceImplementation) {
            ManagementService managementService = null;
            try {
                managementService = (ManagementService)loadedClass.newInstance();
            }
            catch (InstantiationException e) {
                LOGGER.error((Object)"Error occurred during invoked class instantiation for the get of management service implementation");
                throw new PetalsServiceTechnicalException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                LOGGER.error((Object)"Error occurred during invoked class instantiation for the get of management service implementation");
                throw new PetalsServiceTechnicalException((Throwable)e);
            }
            catch (IllegalArgumentException e) {
                LOGGER.error((Object)"Error occurred during invoked class instantiation for the get of management service implementation");
                throw new PetalsServiceTechnicalException((Throwable)e);
            }
            catch (SecurityException e) {
                LOGGER.error((Object)"Error occurred during invoked class instantiation for the get of management service implementation");
                throw new PetalsServiceTechnicalException((Throwable)e);
            }
            if (managementService != null) {
                managementService.setHostname(hostname);
                managementService.setPort(port);
                managementService.setLogin(login);
                managementService.setPassword(password);
            }
            if (ManagementServiceJMXImpl.class.equals(managementService.getClass())) {
                ((ManagementServiceJMXImpl)managementService).setJmxClient(ConnectionHelper.connect((String)hostname, (Integer)port, (String)login, (String)password, (boolean)false));
            }
            return managementService;
        }
        LOGGER.error((Object)("Error occurred during the get of management service implementation (" + loadedClass.getName() + " class don't implement " + ManagementService.class + ")"));
        throw new PetalsServiceTechnicalException(loadedClass.getName() + " don't " + "implement " + ManagementService.class);
    }

    public PetalsService getService() throws PetalsServiceTechnicalException {
        return this.service;
    }
}

