/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.tools.webconsole.services.management;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanAttributeInfo;
import javax.management.ObjectName;
import javax.management.RuntimeOperationsException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.petals.jmx.AdminServiceClient;
import org.ow2.petals.jmx.ComponentClient;
import org.ow2.petals.jmx.ConfigurationInstallerComponentClient;
import org.ow2.petals.jmx.DeploymentServiceClient;
import org.ow2.petals.jmx.EndpointRegistryClient;
import org.ow2.petals.jmx.InstallationServiceClient;
import org.ow2.petals.jmx.InstallerComponentClient;
import org.ow2.petals.jmx.JMXClient;
import org.ow2.petals.jmx.LoggerServiceClient;
import org.ow2.petals.jmx.PetalsAdminServiceClient;
import org.ow2.petals.jmx.RuntimeConfigurationComponentClient;
import org.ow2.petals.jmx.exception.AdminDoesNotExistException;
import org.ow2.petals.jmx.exception.AdminServiceErrorException;
import org.ow2.petals.jmx.exception.AttributeErrorException;
import org.ow2.petals.jmx.exception.ComponentDoesNotExistException;
import org.ow2.petals.jmx.exception.ComponentErrorException;
import org.ow2.petals.jmx.exception.ConnectionErrorException;
import org.ow2.petals.jmx.exception.DeploymentServiceDoesNotExistException;
import org.ow2.petals.jmx.exception.DeploymentServiceErrorException;
import org.ow2.petals.jmx.exception.EndpointRegistryServiceDoesNotExistException;
import org.ow2.petals.jmx.exception.EndpointRegistryServiceErrorException;
import org.ow2.petals.jmx.exception.InstallationServiceDoesNotExistException;
import org.ow2.petals.jmx.exception.InstallationServiceErrorException;
import org.ow2.petals.jmx.exception.LoggerDoesNotExistException;
import org.ow2.petals.jmx.exception.LoggerServiceErrorException;
import org.ow2.petals.jmx.exception.PerformActionErrorException;
import org.ow2.petals.jmx.exception.PetalsAdminDoesNotExistException;
import org.ow2.petals.jmx.exception.PetalsAdminServiceErrorException;
import org.ow2.petals.jmx.exception.RuntimeConfigurationDoesNotExistException;
import org.ow2.petals.jmx.exception.RuntimeConfigurationErrorException;
import org.ow2.petals.tools.webconsole.services.PetalsServiceFunctionalException;
import org.ow2.petals.tools.webconsole.services.PetalsServiceTechnicalException;
import org.ow2.petals.tools.webconsole.services.management.ManagementService;
import org.ow2.petals.tools.webconsole.services.utils.ConnectionHelper;
import org.ow2.petals.tools.webconsole.services.utils.TransformerHelper;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class ManagementServiceJMXImpl
implements ManagementService {
    private static final Log LOGGER = LogFactory.getLog(ManagementServiceJMXImpl.class);
    private JMXClient jmxClient;
    private String loadedInstaller;
    private String hostname;
    private Integer port;
    private String login;
    private String password;

    ManagementServiceJMXImpl() {
    }

    public void setJmxClient(JMXClient jmxClient) {
        this.jmxClient = jmxClient;
    }

    public void startComponent(String componentName) throws PetalsServiceTechnicalException, PetalsServiceFunctionalException {
        try {
            ComponentClient cc = this.getComponentClient(componentName);
            if ("Started".equals(cc.getState())) {
                LOGGER.warn((Object)("Component: " + componentName + " already started"));
                throw new PetalsServiceFunctionalException("Component: " + componentName + " already started");
            }
            if (!"Shutdown".equals(cc.getState()) && !"Stopped".equals(cc.getState())) {
                LOGGER.warn((Object)("Can't perform start action, because the component: " + componentName + " is in the following state: " + cc.getState()));
                throw new PetalsServiceFunctionalException("Can't perform start action, because the component: " + componentName + " is in the following state: " + cc.getState());
            }
            cc.start();
        }
        catch (ComponentErrorException e) {
            LOGGER.error((Object)("Error occurred during " + componentName + " component starting"));
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
    }

    public void stopComponent(String componentName) throws PetalsServiceTechnicalException, PetalsServiceFunctionalException {
        try {
            ComponentClient cc = this.getComponentClient(componentName);
            if (!"Started".equals(cc.getState())) {
                LOGGER.warn((Object)("Can't stop the component: " + componentName + " because, is it in the following state: " + cc.getState()));
                throw new PetalsServiceFunctionalException("Can't stop the component: " + componentName + " because, is it in the following state: " + cc.getState());
            }
            cc.stop();
        }
        catch (ComponentErrorException e) {
            LOGGER.error((Object)("Error occurred during " + componentName + " component stoping"));
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
    }

    public void shutdownComponent(String componentName) throws PetalsServiceTechnicalException, PetalsServiceFunctionalException {
        try {
            ComponentClient cc = this.getComponentClient(componentName);
            if (!"Stopped".equals(cc.getState())) {
                LOGGER.warn((Object)("Can't shutdown the component: " + componentName + " because, is it in the following state: " + cc.getState()));
                throw new PetalsServiceFunctionalException("Can't shutdown the component: " + componentName + " because, is it in the following state: " + cc.getState());
            }
            cc.shutdown();
        }
        catch (ComponentErrorException e) {
            LOGGER.error((Object)("Error occurred during " + componentName + " component shutdown"));
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
    }

    public ObjectName[] componentsInventory() throws PetalsServiceTechnicalException {
        AdminServiceClient asc = this.getAdminServiceClient();
        try {
            ObjectName[] bcs = asc.getBindingComponents();
            LOGGER.debug((Object)(bcs.length + " binding components recovered"));
            return bcs;
        }
        catch (AdminServiceErrorException e) {
            LOGGER.error((Object)"Error occurred during binding component inventory");
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
    }

    public ObjectName[] enginesInventory() throws PetalsServiceTechnicalException {
        AdminServiceClient asc = this.getAdminServiceClient();
        try {
            ObjectName[] ses = asc.getEngineComponents();
            LOGGER.debug((Object)(ses.length + " service engines recovered"));
            return ses;
        }
        catch (AdminServiceErrorException e) {
            LOGGER.error((Object)"Error occurred during service engine inventory");
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
    }

    public String[] serviceAssembliesInventory() throws PetalsServiceTechnicalException {
        DeploymentServiceClient dsc = this.getDeploymentServiceClient();
        try {
            String[] sas = dsc.getDeployedServiceAssemblies();
            LOGGER.debug((Object)(sas.length + " service assemblies recovered"));
            return sas;
        }
        catch (DeploymentServiceErrorException e) {
            LOGGER.error((Object)"Error occurred during service assemblies inventory");
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
    }

    public String[] sharedLibrariesInventory() throws PetalsServiceTechnicalException {
        InstallationServiceClient isc = this.getInstallationServiceClient();
        try {
            String[] sls = isc.getInstalledSharedLibraries();
            LOGGER.debug((Object)(sls.length + " shared libraries recovered"));
            return sls;
        }
        catch (InstallationServiceErrorException e) {
            LOGGER.error((Object)"Error occurred during shared libraries inventory");
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
    }

    public void installComponent(URL fileURL, Map<MBeanAttributeInfo, Object> attributes, String loadedInstaller) throws PetalsServiceTechnicalException {
        InstallationServiceClient isc = this.getInstallationServiceClient();
        try {
            InstallerComponentClient icc = isc.loadInstaller(loadedInstaller);
            if (icc == null) {
                LOGGER.warn((Object)(loadedInstaller + " installer not correctly loaded during component installation"));
                throw new PetalsServiceTechnicalException(loadedInstaller + " installer not correctly loaded component installation");
            }
            LOGGER.debug((Object)(loadedInstaller + " installer correctly loaded component installation"));
            if (!attributes.isEmpty()) {
                ConfigurationInstallerComponentClient ccic = icc.getConfigurationInstallerClient();
                try {
                    ccic.setAttributes(attributes);
                }
                catch (AttributeErrorException e) {
                    LOGGER.error((Object)("Error occurred during the getting of configuration installer client for: " + loadedInstaller + " installer"));
                    throw new PetalsServiceTechnicalException((Throwable)e);
                }
            }
            icc.install();
            LOGGER.debug((Object)("Component for " + loadedInstaller + " loaded installer correctly installed"));
        }
        catch (InstallationServiceErrorException e) {
            LOGGER.error((Object)("Error occurred during component installation for: " + loadedInstaller + " installer"));
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
        catch (PerformActionErrorException e) {
            LOGGER.error((Object)("Error occurred during component installation for: " + loadedInstaller + " installer"));
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
    }

    public String installServiceAssembly(URL saURL) throws PetalsServiceTechnicalException {
        DeploymentServiceClient dsc = this.getDeploymentServiceClient();
        try {
            String result = dsc.deploy(saURL);
            LOGGER.debug((Object)("Result: " + result + " for service assembly deployment of " + saURL));
            return result;
        }
        catch (DeploymentServiceErrorException e) {
            LOGGER.error((Object)("Error occurred during service assembly deployment for: " + saURL));
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
    }

    public String installSharedLibrary(URL slURL) throws PetalsServiceTechnicalException {
        InstallationServiceClient isc = this.getInstallationServiceClient();
        try {
            String result = isc.installSharedLibrary(slURL);
            LOGGER.debug((Object)("Result: " + result + " for shared library installation of " + slURL));
            return result;
        }
        catch (InstallationServiceErrorException e) {
            LOGGER.error((Object)("Error occurred during shared library  installation for: " + slURL));
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
    }

    public void startServiceAssembly(String saName) throws PetalsServiceTechnicalException, PetalsServiceFunctionalException {
        DeploymentServiceClient dsc = this.getDeploymentServiceClient();
        try {
            if (dsc.isServiceAssemblyDeployed(saName)) {
                if (!"Shutdown".equals(dsc.getState(saName)) && !"Stopped".equals(dsc.getState(saName))) {
                    if ("Started".equals(dsc.getState(saName))) {
                        LOGGER.warn((Object)(saName + " service-assembly already started"));
                        throw new PetalsServiceFunctionalException(saName + " service-assembly already started");
                    }
                    LOGGER.warn((Object)("Can't start: " + saName + " service assembly, " + "because is in the following state: " + dsc.getState(saName)));
                    throw new PetalsServiceFunctionalException("Can't start: " + saName + " service assembly, " + "because is in the following state: " + dsc.getState(saName));
                }
            } else {
                LOGGER.warn((Object)(saName + " service-assembly is not deployed"));
                throw new PetalsServiceFunctionalException(saName + " service-assembly is not deployed.");
            }
            dsc.start(saName);
            LOGGER.debug((Object)(saName + " service assembly correclty started"));
        }
        catch (DeploymentServiceErrorException e) {
            LOGGER.error((Object)("Error occured during the start action of " + saName + " service assembly"));
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
    }

    public void stopServiceAssembly(String saName) throws PetalsServiceTechnicalException, PetalsServiceFunctionalException {
        DeploymentServiceClient dsc = this.getDeploymentServiceClient();
        try {
            if (dsc.isServiceAssemblyDeployed(saName)) {
                if (!"Started".equals(dsc.getState(saName))) {
                    LOGGER.warn((Object)("Can't stop " + saName + " service assembly, " + "because is in the following state: " + dsc.getState(saName)));
                    throw new PetalsServiceFunctionalException("Can't stop " + saName + " service assembly, " + "because is in the following state: " + dsc.getState(saName));
                }
            } else {
                LOGGER.warn((Object)("Can't perform stop action, because the service-assembly: " + saName + " is not deployed."));
                throw new PetalsServiceFunctionalException("Can't perform stop action, because the service-assembly: " + saName + " is not deployed.");
            }
            dsc.stop(saName);
            LOGGER.debug((Object)(saName + " service assembly correclty stopped"));
        }
        catch (DeploymentServiceErrorException e) {
            LOGGER.error((Object)("Error occured during the stop action of " + saName + " service assembly"));
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
    }

    public void uninstallComponent(String componentName) throws PetalsServiceTechnicalException {
        InstallationServiceClient isc = this.getInstallationServiceClient();
        try {
            InstallerComponentClient icc = isc.loadInstaller(componentName);
            if (icc == null) {
                LOGGER.warn((Object)(componentName + " installer not correctly loaded for component uninstallation"));
                throw new PetalsServiceTechnicalException(componentName + " installer not correctly loaded for component uninstallation");
            }
            LOGGER.debug((Object)(componentName + " installer correctly loaded for component uninstallation"));
            if (icc.isInstalled()) {
                icc.uninstall();
                LOGGER.debug((Object)(componentName + " component correctly uninstalled"));
            }
            isc.unloadInstaller(componentName);
            LOGGER.debug((Object)(componentName + " installer correctly unloaded for component uninstallation"));
        }
        catch (InstallationServiceErrorException e) {
            LOGGER.error((Object)("Error occurred during " + componentName + "component uninstallation"));
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
        catch (PerformActionErrorException e) {
            LOGGER.error((Object)("Error occurred during " + componentName + " component uninstallation"));
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
    }

    public String uninstallServiceAssembly(String saName) throws PetalsServiceTechnicalException {
        DeploymentServiceClient dsc = this.getDeploymentServiceClient();
        try {
            String result = dsc.undeploy(saName);
            LOGGER.debug((Object)("Result: " + result + " for service assembly uninstallation of: " + saName));
            return result;
        }
        catch (DeploymentServiceErrorException e) {
            LOGGER.error((Object)("Error occurred during " + saName + " service assembly uninstallation"));
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
    }

    public boolean uninstallSharedLibrary(String slName) throws PetalsServiceTechnicalException {
        InstallationServiceClient isc = this.getInstallationServiceClient();
        try {
            boolean result = isc.uninstallSharedLibrary(slName);
            LOGGER.debug((Object)("Result: " + result + " for shared library uninstallation of: " + slName));
            return result;
        }
        catch (InstallationServiceErrorException e) {
            LOGGER.error((Object)("Error occurred during " + slName + " shared library uninstallation"));
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
    }

    public String shutdownServiceAssembly(String saName) throws PetalsServiceTechnicalException, PetalsServiceFunctionalException {
        DeploymentServiceClient dsc = this.getDeploymentServiceClient();
        try {
            if (dsc.isServiceAssemblyDeployed(saName)) {
                if ("Stopped".equals(dsc.getState(saName))) {
                    String result = dsc.shutdown(saName);
                    LOGGER.debug((Object)("Result: " + result + " for service assembly shutdown of: " + saName));
                    return result;
                }
                LOGGER.warn((Object)("Can't shutdown the service assembly: " + saName + " because, is in the following state: " + dsc.getState(saName)));
                throw new PetalsServiceFunctionalException("Can't shutdown the service assembly: " + saName + " because, is in the following state: " + dsc.getState(saName));
            }
            LOGGER.warn((Object)("Service assembly: " + saName + ", isn't deployed"));
            throw new PetalsServiceFunctionalException("Service assembly: " + saName + ", isn't deployed");
        }
        catch (DeploymentServiceErrorException e) {
            LOGGER.error((Object)("Error occurred during service assembly shutdown of: " + saName));
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
    }

    public Set<Map<String, String>> getTopology(String hostname, Integer port, String login, String password) throws PetalsServiceTechnicalException {
        PetalsAdminServiceClient pasc = this.getPetalsAdminServiceClient();
        try {
            Set topology = pasc.retrieveTopology();
            LOGGER.debug((Object)("Domain topology where " + hostname + "/" + port + " [hostname/port] node is hosted, correctly retrieved"));
            return topology;
        }
        catch (PetalsAdminServiceErrorException e) {
            LOGGER.error((Object)("Error occurred during domain topology retrieving for " + hostname + "/" + port + " [hostname/port] node"));
            throw new PetalsServiceTechnicalException("Can't get petals topology for " + hostname + "/" + port + " [hostname/port] node", (Throwable)e);
        }
    }

    public String getComponentState(String componentName) throws PetalsServiceTechnicalException {
        ComponentClient cc = this.getComponentClient(componentName);
        try {
            String state = cc.getState();
            LOGGER.debug((Object)("State: " + state + " for " + componentName + " component recovered"));
            return state;
        }
        catch (ComponentErrorException e) {
            LOGGER.error((Object)("Error occurred during state retrieving for: " + componentName + " component"));
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
    }

    public List<Map<String, Object>> getAllEndpoints() throws PetalsServiceTechnicalException {
        EndpointRegistryClient erc = this.getEndpointRegistryClient();
        try {
            List endpoints = erc.getAllEndpoints();
            LOGGER.debug((Object)(endpoints.size() + " endpoints recovered"));
            return endpoints;
        }
        catch (EndpointRegistryServiceErrorException e) {
            LOGGER.error((Object)"Error occurred during endpoints recovering");
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
    }

    public String getServiceAssemblyState(String saName) throws PetalsServiceTechnicalException {
        DeploymentServiceClient dsc = this.getDeploymentServiceClient();
        try {
            String state = dsc.getState(saName);
            LOGGER.debug((Object)("State: " + state + " for " + saName + " service assembly recovered"));
            return state;
        }
        catch (DeploymentServiceErrorException e) {
            LOGGER.error((Object)("Error occurred during state retrieving for: " + saName + " component"));
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
    }

    public Map<MBeanAttributeInfo, Object> getComponentConfiguration(URL fileURL) throws PetalsServiceTechnicalException {
        InstallationServiceClient isc = this.getInstallationServiceClient();
        try {
            InstallerComponentClient icc = isc.loadNewInstaller(fileURL);
            if (icc != null) {
                HashMap<MBeanAttributeInfo, Object> attributes;
                LOGGER.info((Object)("Component installer for: " + fileURL + " correctly loaded"));
                this.loadedInstaller = icc.getMBeanName().getKeyProperty("name");
                try {
                    ConfigurationInstallerComponentClient cicc = icc.getConfigurationInstallerClient();
                    attributes = cicc.getAttributes();
                }
                catch (AttributeErrorException e) {
                    LOGGER.error((Object)("Error occurred during the getting of client installer configuration for: " + fileURL));
                    throw new PetalsServiceTechnicalException((Throwable)e);
                }
                catch (PerformActionErrorException e) {
                    LOGGER.error((Object)("Error occurred during the getting of client installer configuration for: " + fileURL));
                    throw new PetalsServiceTechnicalException((Throwable)e);
                }
                catch (RuntimeOperationsException e) {
                    attributes = new HashMap<MBeanAttributeInfo, Object>();
                }
                LOGGER.debug((Object)(attributes.size() + " attributes recovered for: " + fileURL + " component configuration"));
                return attributes;
            }
            LOGGER.warn((Object)("Component installer for: " + fileURL + " not correctly loaded"));
            throw new PetalsServiceTechnicalException("Component installer for: " + fileURL + " not correctly loaded");
        }
        catch (InstallationServiceErrorException e) {
            LOGGER.error((Object)"Error occurred during component configuration getting");
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
    }

    public Document getDocument(String serviceName, String endpointName) throws PetalsServiceTechnicalException {
        Document result = null;
        if (serviceName != null && !serviceName.equals("") && endpointName != null && !endpointName.equals("")) {
            EndpointRegistryClient erc = this.getEndpointRegistryClient();
            try {
                String in = erc.getDescription(serviceName, endpointName);
                if (in != null) {
                    result = TransformerHelper.stringToDocument((String)in);
                }
            }
            catch (EndpointRegistryServiceErrorException e) {
                LOGGER.error((Object)("Error occurred during document getting of " + serviceName + endpointName + " [service/endpoint]"));
                throw new PetalsServiceTechnicalException((Throwable)e);
            }
            catch (SAXException e) {
                LOGGER.error((Object)("Error occurred during document transformation of " + serviceName + endpointName + " [service/endpoint]"));
                throw new PetalsServiceTechnicalException((Throwable)e);
            }
            catch (IOException e) {
                LOGGER.error((Object)("Error occurred during document transformation of " + serviceName + endpointName + " [service/endpoint]"));
                throw new PetalsServiceTechnicalException((Throwable)e);
            }
            catch (ParserConfigurationException e) {
                LOGGER.error((Object)("Error occurred during document transformation of " + serviceName + endpointName + " [service/endpoint]"));
                throw new PetalsServiceTechnicalException((Throwable)e);
            }
        }
        LOGGER.debug((Object)("Document correctly got for " + serviceName + endpointName + " [service/endpoint]"));
        return result;
    }

    public String getLoadedInstaller() {
        return this.loadedInstaller;
    }

    public Map<MBeanAttributeInfo, Object> recoverRuntimeAttributes(String componentName) throws PetalsServiceTechnicalException {
        Map attributes = null;
        RuntimeConfigurationComponentClient rccc = this.getRuntimeConfigurationComponentClient(componentName);
        if (rccc != null) {
            try {
                attributes = rccc.getConfigurationMBeanAttributes();
            }
            catch (RuntimeConfigurationErrorException e) {
                LOGGER.error((Object)("Error occurred during runtime attributes recovering for: " + componentName));
                throw new PetalsServiceTechnicalException((Throwable)e);
            }
            catch (PerformActionErrorException e) {
                LOGGER.error((Object)("Error occurred during runtime attributes recovering for: " + componentName));
                throw new PetalsServiceTechnicalException((Throwable)e);
            }
        } else {
            LOGGER.warn((Object)("Runtime configuration component client not corretly recovered for: " + componentName));
            throw new PetalsServiceTechnicalException("Runtime configuration component client not corretly recovered for: " + componentName);
        }
        LOGGER.debug((Object)(attributes.size() + " runtime attributes recovered for: " + componentName));
        return attributes;
    }

    public void setRuntimeAttributes(Map<MBeanAttributeInfo, Object> attributes, String componentName) throws PetalsServiceTechnicalException {
        RuntimeConfigurationComponentClient rccc = this.getRuntimeConfigurationComponentClient(componentName);
        if (rccc != null) {
            try {
                rccc.setAttributes(attributes);
                LOGGER.debug((Object)(attributes.size() + " runtime attributes set for: " + componentName + " component"));
            }
            catch (RuntimeConfigurationErrorException e) {
                LOGGER.error((Object)("Error occurred during runtime attributes setting for: " + componentName));
                throw new PetalsServiceTechnicalException((Throwable)e);
            }
            catch (PerformActionErrorException e) {
                LOGGER.error((Object)("Error occurred during runtime attributes setting for: " + componentName));
                throw new PetalsServiceTechnicalException((Throwable)e);
            }
        } else {
            LOGGER.warn((Object)("Runtime configuration component client not corretly recovered for: " + componentName));
            throw new PetalsServiceTechnicalException("Runtime configuration component client not corretly recovered for: " + componentName);
        }
    }

    public boolean forceUnloadInstaller(String componentName) throws PetalsServiceTechnicalException {
        InstallationServiceClient isc = this.getInstallationServiceClient();
        if (isc != null) {
            try {
                boolean result = isc.forceUnloadInstaller(componentName);
                LOGGER.debug((Object)("Result: " + result + " for the force unload installer action on " + componentName + " component"));
                return result;
            }
            catch (InstallationServiceErrorException e) {
                LOGGER.error((Object)("Error occurred during the force unload installer action on " + componentName + " component"));
                throw new PetalsServiceTechnicalException((Throwable)e);
            }
        }
        LOGGER.warn((Object)("Installation service client not correctly recovered for " + componentName + " component"));
        throw new PetalsServiceTechnicalException("Installation service client not correctly recovered for " + componentName + " component");
    }

    public boolean forceUnDeploy(String saName) throws PetalsServiceTechnicalException {
        DeploymentServiceClient dsc = this.getDeploymentServiceClient();
        if (dsc != null) {
            try {
                boolean result = dsc.forceUndeploy(saName);
                LOGGER.debug((Object)("Result: " + result + " for force undeploy action of " + saName + " service assembly"));
                return result;
            }
            catch (DeploymentServiceErrorException e) {
                LOGGER.error((Object)("Error occurred during the force undeploy action of " + saName + " service assembly"));
                throw new PetalsServiceTechnicalException((Throwable)e);
            }
        }
        LOGGER.warn((Object)("Deployment service client not correctly recovered for " + saName + " service assembly"));
        throw new PetalsServiceTechnicalException("Deployment service client not correctly recovered for " + saName + " service assemblyt");
    }

    protected void finalize() throws Throwable {
        this.jmxClient.disconnect();
        LOGGER.debug((Object)("JMX Client correctly disconnected for " + this.hostname + "/" + this.port + " [host/port] server"));
        super.finalize();
    }

    public void reInitializeConnection(String hostname, Integer port, String login, String password) throws PetalsServiceTechnicalException {
        this.jmxClient = ConnectionHelper.connect((String)hostname, (Integer)port, (String)login, (String)password, (boolean)true);
        this.hostname = hostname;
        this.port = port;
        this.login = login;
        this.password = password;
        LOGGER.debug((Object)("JMX Client correclty reinitialized for " + this.hostname + "/" + this.port + " [host/port] server"));
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    private ComponentClient getComponentClient(String componentName) throws PetalsServiceTechnicalException {
        ComponentClient cc = null;
        try {
            cc = this.jmxClient.getComponentClient(componentName);
        }
        catch (ConnectionErrorException e) {
            LOGGER.debug((Object)("Error occurred during the first component client getting action on " + componentName + "component"));
            this.jmxClient = ConnectionHelper.connect((String)this.hostname, (Integer)this.port, (String)this.login, (String)this.password, (boolean)true);
            try {
                cc = this.jmxClient.getComponentClient(componentName);
            }
            catch (ComponentDoesNotExistException ex) {
                LOGGER.error((Object)("Error occurred during the second component client getting action on " + componentName + "component"));
                throw new PetalsServiceTechnicalException((Throwable)ex);
            }
            catch (ComponentErrorException ex) {
                LOGGER.error((Object)("Error occurred during the second component client getting action on " + componentName + "component"));
                throw new PetalsServiceTechnicalException((Throwable)ex);
            }
            catch (ConnectionErrorException ex) {
                LOGGER.error((Object)("Error occurred during the second component client getting action on " + componentName + "component"));
                throw new PetalsServiceTechnicalException((Throwable)ex);
            }
        }
        catch (ComponentDoesNotExistException e) {
            LOGGER.error((Object)("Error occurred during the first component client getting action on " + componentName + "component"));
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
        catch (ComponentErrorException e) {
            LOGGER.error((Object)("Error occurred during the first component client getting action on " + componentName + "component"));
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
        if (cc == null) {
            LOGGER.warn((Object)("Component client not correclty recovered for " + componentName + " component"));
            throw new PetalsServiceTechnicalException("Component client not correclty recovered for " + componentName + " component");
        }
        return cc;
    }

    private AdminServiceClient getAdminServiceClient() throws PetalsServiceTechnicalException {
        AdminServiceClient asc = null;
        try {
            asc = this.jmxClient.getAdminServiceClient();
        }
        catch (AdminDoesNotExistException e) {
            LOGGER.error((Object)"Error occurred during the first admin service client getting action");
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
        catch (AdminServiceErrorException e) {
            LOGGER.error((Object)"Error occurred during the first admin service client getting action");
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
        catch (ConnectionErrorException e) {
            LOGGER.debug((Object)"Error occurred during the first admin service client getting action");
            this.jmxClient = ConnectionHelper.connect((String)this.hostname, (Integer)this.port, (String)this.login, (String)this.password, (boolean)true);
            try {
                asc = this.jmxClient.getAdminServiceClient();
            }
            catch (ConnectionErrorException ex) {
                LOGGER.error((Object)"Error occurred during the second admin service client getting action");
                throw new PetalsServiceTechnicalException((Throwable)ex);
            }
            catch (AdminDoesNotExistException ex) {
                LOGGER.error((Object)"Error occurred during the second admin service client getting action");
                throw new PetalsServiceTechnicalException((Throwable)ex);
            }
            catch (AdminServiceErrorException ex) {
                LOGGER.error((Object)"Error occurred during the second admin service client getting action");
                throw new PetalsServiceTechnicalException((Throwable)ex);
            }
        }
        if (asc == null) {
            LOGGER.warn((Object)"Admin service client not correclty recovered");
            throw new PetalsServiceTechnicalException("Admin service client not correclty recovered");
        }
        return asc;
    }

    private DeploymentServiceClient getDeploymentServiceClient() throws PetalsServiceTechnicalException {
        DeploymentServiceClient dsc = null;
        try {
            dsc = this.jmxClient.getDeploymentServiceClient();
        }
        catch (DeploymentServiceDoesNotExistException e) {
            LOGGER.error((Object)"Error occurred during the first deployment service client getting action");
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
        catch (DeploymentServiceErrorException e) {
            LOGGER.error((Object)"Error occurred during the first deployment service client getting action");
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
        catch (ConnectionErrorException e) {
            LOGGER.debug((Object)"Error occurred during the first deployment service client getting action");
            this.jmxClient = ConnectionHelper.connect((String)this.hostname, (Integer)this.port, (String)this.login, (String)this.password, (boolean)true);
            try {
                dsc = this.jmxClient.getDeploymentServiceClient();
            }
            catch (ConnectionErrorException ex) {
                LOGGER.error((Object)"Error occurred during the second deployment service client getting action");
                throw new PetalsServiceTechnicalException((Throwable)ex);
            }
            catch (DeploymentServiceErrorException ex) {
                LOGGER.error((Object)"Error occurred during the second deployment service client getting action");
                throw new PetalsServiceTechnicalException((Throwable)ex);
            }
            catch (DeploymentServiceDoesNotExistException ex) {
                LOGGER.error((Object)"Error occurred during the second deployment service client getting action");
                throw new PetalsServiceTechnicalException((Throwable)ex);
            }
        }
        if (dsc == null) {
            LOGGER.warn((Object)"Deployment service client not correclty recovered");
            throw new PetalsServiceTechnicalException("Deployment service client not correclty recovered");
        }
        return dsc;
    }

    private InstallationServiceClient getInstallationServiceClient() throws PetalsServiceTechnicalException {
        InstallationServiceClient isc = null;
        try {
            isc = this.jmxClient.getInstallationServiceClient();
        }
        catch (InstallationServiceDoesNotExistException e) {
            LOGGER.error((Object)"Error occurred during the first installation service client getting action");
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
        catch (InstallationServiceErrorException e) {
            LOGGER.error((Object)"Error occurred during the first installation service client getting action");
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
        catch (ConnectionErrorException e) {
            LOGGER.debug((Object)"Error occurred during the first installation service client getting action");
            this.jmxClient = ConnectionHelper.connect((String)this.hostname, (Integer)this.port, (String)this.login, (String)this.password, (boolean)true);
            try {
                isc = this.jmxClient.getInstallationServiceClient();
            }
            catch (ConnectionErrorException ex) {
                LOGGER.error((Object)"Error occurred during the second installation service client getting action");
                throw new PetalsServiceTechnicalException((Throwable)ex);
            }
            catch (InstallationServiceErrorException ex) {
                LOGGER.error((Object)"Error occurred during the second installation service client getting action");
                throw new PetalsServiceTechnicalException((Throwable)ex);
            }
            catch (InstallationServiceDoesNotExistException ex) {
                LOGGER.error((Object)"Error occurred during the second installation service client getting action");
                throw new PetalsServiceTechnicalException((Throwable)ex);
            }
        }
        if (isc == null) {
            LOGGER.warn((Object)"Installation service client not correclty recovered");
            throw new PetalsServiceTechnicalException("Installation service client not correclty recovered");
        }
        return isc;
    }

    private PetalsAdminServiceClient getPetalsAdminServiceClient() throws PetalsServiceTechnicalException {
        PetalsAdminServiceClient pasc = null;
        try {
            pasc = this.jmxClient.getPetalsAdminServiceClient();
        }
        catch (PetalsAdminDoesNotExistException e) {
            LOGGER.error((Object)"Error occurred during the first Petals admin service client getting action");
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
        catch (PetalsAdminServiceErrorException e) {
            LOGGER.error((Object)"Error occurred during the first Petals admin service client getting action");
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
        catch (ConnectionErrorException e) {
            LOGGER.debug((Object)"Error occurred during the first Petals admin service client getting action");
            this.jmxClient = ConnectionHelper.connect((String)this.hostname, (Integer)this.port, (String)this.login, (String)this.password, (boolean)true);
            try {
                pasc = this.jmxClient.getPetalsAdminServiceClient();
            }
            catch (ConnectionErrorException ex) {
                LOGGER.error((Object)"Error occurred during the second Petals admin service client getting action");
                throw new PetalsServiceTechnicalException((Throwable)ex);
            }
            catch (PetalsAdminServiceErrorException ex) {
                LOGGER.error((Object)"Error occurred during the second Petals admin service client getting action");
                throw new PetalsServiceTechnicalException((Throwable)ex);
            }
            catch (PetalsAdminDoesNotExistException ex) {
                LOGGER.error((Object)"Error occurred during the second Petals admin service client getting action");
                throw new PetalsServiceTechnicalException((Throwable)ex);
            }
        }
        if (pasc == null) {
            LOGGER.warn((Object)"Petals admin service client not correclty recovered");
            throw new PetalsServiceTechnicalException("Petals admin service client not correclty recovered");
        }
        return pasc;
    }

    private EndpointRegistryClient getEndpointRegistryClient() throws PetalsServiceTechnicalException {
        EndpointRegistryClient erc = null;
        try {
            erc = this.jmxClient.getEndpointRegistryClient();
        }
        catch (EndpointRegistryServiceDoesNotExistException e) {
            LOGGER.error((Object)"Error occurred during the first endpoint registry service client getting action");
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
        catch (EndpointRegistryServiceErrorException e) {
            LOGGER.error((Object)"Error occurred during the first endpoint registry service client getting action");
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
        catch (ConnectionErrorException e) {
            LOGGER.debug((Object)"Error occurred during the first endpoint registry service client getting action");
            this.jmxClient = ConnectionHelper.connect((String)this.hostname, (Integer)this.port, (String)this.login, (String)this.password, (boolean)true);
            try {
                erc = this.jmxClient.getEndpointRegistryClient();
            }
            catch (EndpointRegistryServiceDoesNotExistException ex) {
                LOGGER.error((Object)"Error occurred during the second endpoint registry service client getting action");
                throw new PetalsServiceTechnicalException((Throwable)ex);
            }
            catch (EndpointRegistryServiceErrorException ex) {
                LOGGER.error((Object)"Error occurred during the second endpoint registry service client getting action");
                throw new PetalsServiceTechnicalException((Throwable)ex);
            }
            catch (ConnectionErrorException ex) {
                LOGGER.error((Object)"Error occurred during the second endpoint registry service client getting action");
                throw new PetalsServiceTechnicalException((Throwable)ex);
            }
        }
        if (erc == null) {
            LOGGER.warn((Object)"Endpoint registry service client not correclty recovered");
            throw new PetalsServiceTechnicalException("Endpoint registry service client not correclty recovered");
        }
        return erc;
    }

    private RuntimeConfigurationComponentClient getRuntimeConfigurationComponentClient(String componentName) throws PetalsServiceTechnicalException {
        RuntimeConfigurationComponentClient rccc = null;
        try {
            rccc = this.jmxClient.getRuntimeConfigurationClient(componentName);
        }
        catch (RuntimeConfigurationDoesNotExistException e) {
            LOGGER.error((Object)("Error occurred during the first runtime configuration component client getting action for " + componentName + " component"));
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
        catch (RuntimeConfigurationErrorException e) {
            LOGGER.error((Object)("Error occurred during the first runtime configuration component client getting action for " + componentName + " component"));
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
        catch (ConnectionErrorException e) {
            LOGGER.debug((Object)("Error occurred during the first runtime configuration component client getting action for " + componentName + " component"));
            this.jmxClient = ConnectionHelper.connect((String)this.hostname, (Integer)this.port, (String)this.login, (String)this.password, (boolean)true);
            try {
                rccc = this.jmxClient.getRuntimeConfigurationClient(componentName);
            }
            catch (RuntimeConfigurationDoesNotExistException ex) {
                LOGGER.error((Object)("Error occurred during the second runtime configuration component client getting action for " + componentName + " component"));
                throw new PetalsServiceTechnicalException((Throwable)ex);
            }
            catch (RuntimeConfigurationErrorException ex) {
                LOGGER.error((Object)("Error occurred during the second runtime configuration component client getting action for " + componentName + " component"));
                throw new PetalsServiceTechnicalException((Throwable)ex);
            }
            catch (ConnectionErrorException ex) {
                LOGGER.error((Object)("Error occurred during the second runtime configuration component client getting action for " + componentName + " component"));
                throw new PetalsServiceTechnicalException((Throwable)ex);
            }
        }
        if (rccc == null) {
            LOGGER.warn((Object)("Runtime configuration component client not correclty recovered for " + componentName + " component"));
            throw new PetalsServiceTechnicalException("Runtime configuration component client not correclty recovered for " + componentName + " component");
        }
        return rccc;
    }

    public List<String> uninstallAllComponents() throws PetalsServiceTechnicalException {
        InstallationServiceClient isc = this.getInstallationServiceClient();
        if (isc == null) {
            LOGGER.warn((Object)"Installation service client not correctly recovered");
            throw new PetalsServiceTechnicalException("Installation service client not correctly recovered");
        }
        DeploymentServiceClient dsc = this.getDeploymentServiceClient();
        if (dsc == null) {
            LOGGER.warn((Object)"Deployment service client not correctly recovered");
            throw new PetalsServiceTechnicalException("Deployment service client not correctly recovered");
        }
        ArrayList<String> uninstalledComponents = new ArrayList<String>();
        try {
            AdminServiceClient asc = this.getAdminServiceClient();
            if (asc == null) {
                LOGGER.warn((Object)"Admin service client not correctly recovered");
                throw new PetalsServiceTechnicalException("Admin service client not correctly recovered");
            }
            ObjectName[] bcs = asc.getBindingComponents();
            ObjectName[] ses = asc.getEngineComponents();
            ArrayList<ObjectName> components = new ArrayList<ObjectName>();
            if (bcs != null) {
                LOGGER.debug((Object)(bcs.length + " binding components recovered"));
                components.addAll(Arrays.asList(bcs));
            }
            if (ses != null) {
                LOGGER.debug((Object)(ses.length + " service engines recovered"));
                components.addAll(Arrays.asList(ses));
            }
            String[] undeployedSas = dsc.undeployAllServiceAssemblies(true);
            if (LOGGER.isDebugEnabled()) {
                StringBuilder builder = new StringBuilder("[");
                for (String undeployedSa : undeployedSas) {
                    builder.append(undeployedSa).append(",");
                }
                builder.append("] service assemblies undeployed");
                LOGGER.debug((Object)builder.toString());
            }
            if (components != null) {
                for (ObjectName component : components) {
                    String componentName = component.getKeyProperty("name");
                    ComponentClient cc = this.getComponentClient(componentName);
                    LOGGER.debug((Object)("Component client correctly recovered for " + componentName + " component"));
                    try {
                        if ("Started".equals(cc.getState())) {
                            cc.stop();
                            LOGGER.debug((Object)(componentName + " component correctly stopped"));
                            cc.shutdown();
                            LOGGER.debug((Object)(componentName + " component correctly shutdown"));
                            continue;
                        }
                        if (!"Stopped".equals(cc.getState())) continue;
                        cc.shutdown();
                        LOGGER.debug((Object)(componentName + " component correctly shutdown"));
                    }
                    catch (ComponentErrorException e) {
                        LOGGER.error((Object)("Error occurred during uninstall all components action, unable to uninstall component: " + componentName + (Object)((Object)e)));
                    }
                }
            }
            String[] ucs = isc.uninstallAllComponents();
            StringBuilder builder = null;
            if (LOGGER.isDebugEnabled()) {
                builder = new StringBuilder("[");
            }
            for (String uc : ucs) {
                uninstalledComponents.add(uc);
                if (!LOGGER.isDebugEnabled()) continue;
                builder.append(uc).append(",");
            }
            if (LOGGER.isDebugEnabled()) {
                builder.append("] component uninstalled");
                LOGGER.debug((Object)builder.toString());
            }
        }
        catch (InstallationServiceErrorException e) {
            LOGGER.error((Object)"Error occurred during uninstall all component action");
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
        catch (AdminServiceErrorException e) {
            LOGGER.error((Object)"Error occurred during uninstall all component action");
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
        catch (DeploymentServiceErrorException e) {
            LOGGER.error((Object)"Error occurred during uninstall all component action");
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
        return uninstalledComponents;
    }

    public List<String> unloadAllInstallers() throws PetalsServiceTechnicalException {
        InstallationServiceClient isc = this.getInstallationServiceClient();
        if (isc == null) {
            LOGGER.warn((Object)"Installation service client not correctly recovered");
            throw new PetalsServiceTechnicalException("Installation service client not correctly recovered");
        }
        String[] results = null;
        ArrayList<String> unloadedInstallers = new ArrayList<String>();
        try {
            results = isc.unloadAllInstallers(true);
        }
        catch (InstallationServiceErrorException e) {
            LOGGER.error((Object)"Error occurred during unload all installers");
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
        StringBuilder builder = null;
        if (LOGGER.isDebugEnabled()) {
            builder = new StringBuilder("[");
        }
        if (results != null) {
            for (String result : results) {
                unloadedInstallers.add(result);
                if (!LOGGER.isDebugEnabled()) continue;
                builder.append(result).append(",");
            }
        }
        if (LOGGER.isDebugEnabled()) {
            builder.append("] installers unloaded");
            LOGGER.debug((Object)builder.toString());
        }
        return unloadedInstallers;
    }

    public List<String> uninstallAllSharedLibraries() throws PetalsServiceTechnicalException {
        InstallationServiceClient isc = this.getInstallationServiceClient();
        if (isc == null) {
            LOGGER.warn((Object)"Installation service client not correctly recovered");
            throw new PetalsServiceTechnicalException("Installation service client not correctly recovered");
        }
        String[] results = null;
        ArrayList<String> uninstalledSharedLibraries = new ArrayList<String>();
        try {
            results = isc.uninstallAllSharedLibrary();
        }
        catch (InstallationServiceErrorException e) {
            LOGGER.error((Object)"Error occurred during uninstall all libraries");
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
        StringBuilder builder = null;
        if (LOGGER.isDebugEnabled()) {
            builder = new StringBuilder("[");
        }
        if (results != null) {
            for (String result : results) {
                uninstalledSharedLibraries.add(result);
                if (!LOGGER.isDebugEnabled()) continue;
                builder.append(result).append(",");
            }
        }
        if (LOGGER.isDebugEnabled()) {
            builder.append("] shared libraries uninstalled");
            LOGGER.debug((Object)builder.toString());
        }
        return uninstalledSharedLibraries;
    }

    public List<String> uninstallAllServiceAssemblies() throws PetalsServiceTechnicalException {
        DeploymentServiceClient dsc = this.getDeploymentServiceClient();
        if (dsc == null) {
            LOGGER.warn((Object)"Deployment service client not correctly recovered");
            throw new PetalsServiceTechnicalException("Deployment service client not correctly recovered");
        }
        ArrayList<String> uninstalledServiceAssemblies = new ArrayList<String>();
        String[] sas = null;
        try {
            sas = dsc.getDeployedServiceAssemblies();
            StringBuilder builder = null;
            if (LOGGER.isDebugEnabled()) {
                builder = new StringBuilder("[");
            }
            if (sas != null) {
                for (String sa : sas) {
                    if (!dsc.forceUndeploy(sa).booleanValue()) continue;
                    uninstalledServiceAssemblies.add(sa);
                    if (!LOGGER.isDebugEnabled()) continue;
                    builder.append(sa).append(",");
                }
            }
            if (LOGGER.isDebugEnabled()) {
                builder.append("] service assemblies uninstalled");
                LOGGER.debug((Object)builder.toString());
            }
        }
        catch (DeploymentServiceErrorException e) {
            LOGGER.error((Object)"Error occurred during uninstall all service assemblies");
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
        return uninstalledServiceAssemblies;
    }

    public String[] getAllLevels() throws PetalsServiceTechnicalException {
        LoggerServiceClient lsc = this.getLoggerServiceClient();
        if (lsc == null) {
            LOGGER.warn((Object)"Logger service client not correctly recovered");
            throw new PetalsServiceTechnicalException("Logger service client not correctly recovered");
        }
        try {
            String[] loggerLevels = lsc.getAllLevels();
            if (LOGGER.isDebugEnabled()) {
                StringBuilder builder = new StringBuilder();
                builder.append("[");
                for (String loggerLevel : loggerLevels) {
                    builder.append(loggerLevel).append(",");
                }
                builder.append("] logger levels retrieved");
            }
            return loggerLevels;
        }
        catch (LoggerServiceErrorException e) {
            LOGGER.error((Object)"Error occurred during logger levels retrieving");
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
    }

    public String getLevelForLogger(String logger) throws PetalsServiceTechnicalException {
        LoggerServiceClient lsc = this.getLoggerServiceClient();
        if (lsc == null) {
            LOGGER.warn((Object)"Logger service client not correctly recovered");
            throw new PetalsServiceTechnicalException("Logger service client not correctly recovered");
        }
        try {
            String level = lsc.getLevelForLogger(logger);
            LOGGER.debug((Object)(logger + " logger have " + level + " for logging level"));
            return level;
        }
        catch (LoggerServiceErrorException e) {
            LOGGER.error((Object)("Error occurred during logging level retrieving for " + logger + " logger"));
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
    }

    public void setLoggerLevel(String logger, String level) throws PetalsServiceTechnicalException {
        LoggerServiceClient lsc = this.getLoggerServiceClient();
        if (lsc == null) {
            LOGGER.warn((Object)"Logger service client not correctly recovered");
            throw new PetalsServiceTechnicalException("Logger service client not correctly recovered");
        }
        try {
            lsc.setLevelForLogger(logger, level);
            LOGGER.debug((Object)("Set logger level action correctly performed for: " + logger + "/" + level + " [logger/level]"));
        }
        catch (LoggerServiceErrorException e) {
            LOGGER.error((Object)("Error occurred during the set of logger level: " + logger + "/" + level + " [logger/level]"));
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
    }

    private LoggerServiceClient getLoggerServiceClient() throws PetalsServiceTechnicalException {
        LoggerServiceClient lsc = null;
        try {
            lsc = this.jmxClient.getLoggerServiceClient();
        }
        catch (LoggerDoesNotExistException e) {
            LOGGER.error((Object)"Error occurred during the first logger service client getting action");
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
        catch (LoggerServiceErrorException e) {
            LOGGER.error((Object)"Error occurred during the first logger service client getting action");
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
        catch (ConnectionErrorException e) {
            LOGGER.debug((Object)"Error occurred during the first logger service client getting action");
            this.jmxClient = ConnectionHelper.connect((String)this.hostname, (Integer)this.port, (String)this.login, (String)this.password, (boolean)true);
            try {
                lsc = this.jmxClient.getLoggerServiceClient();
            }
            catch (ConnectionErrorException ex) {
                LOGGER.error((Object)"Error occurred during the second logger service client getting action");
                throw new PetalsServiceTechnicalException((Throwable)ex);
            }
            catch (LoggerServiceErrorException ex) {
                LOGGER.error((Object)"Error occurred during the second logger service client getting action");
                throw new PetalsServiceTechnicalException((Throwable)ex);
            }
            catch (LoggerDoesNotExistException ex) {
                LOGGER.error((Object)"Error occurred during the second logger service client getting action");
                throw new PetalsServiceTechnicalException((Throwable)ex);
            }
        }
        if (lsc == null) {
            LOGGER.warn((Object)"Logger service client not correclty recovered");
            throw new PetalsServiceTechnicalException("Logger service client not correclty recovered");
        }
        return lsc;
    }

    public String[] getComponentServiceAssembly(String name) throws PetalsServiceTechnicalException {
        DeploymentServiceClient dsc = this.getDeploymentServiceClient();
        try {
            String[] sas = dsc.getDeployedServiceAssembliesForComponent(name);
            LOGGER.debug((Object)(sas.length + " service assemblies recovered for [" + name + "] component"));
            return sas;
        }
        catch (DeploymentServiceErrorException e) {
            LOGGER.error((Object)("Error occurred during service assemblies recovery for [" + name + "] component"));
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
    }

    public List<String> getLoadedComponentInstallers() throws PetalsServiceTechnicalException {
        String[] lcis;
        try {
            lcis = this.jmxClient.getInstallationServiceClient().getInstallers();
        }
        catch (InstallationServiceErrorException e) {
            LOGGER.error((Object)"Error occurred during the loaded component installers recovering");
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
        catch (InstallationServiceDoesNotExistException e) {
            LOGGER.error((Object)"Error occurred during the loaded component installers recovering");
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
        catch (ConnectionErrorException e) {
            LOGGER.error((Object)"Error occurred during the loaded component installers recovering");
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
        if (lcis != null && lcis.length > 0) {
            LOGGER.debug((Object)(lcis.length + " loaded component installers recovered"));
        } else {
            LOGGER.debug((Object)"No loaded component installers recovered");
        }
        return Arrays.asList(lcis);
    }
}

