/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.tools.webconsole.services.management.pooling;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.petals.jmx.exception.ConnectionErrorException;
import org.ow2.petals.tools.webconsole.services.management.pooling.ClientContext;
import org.ow2.petals.tools.webconsole.services.utils.ConnectionHelper;

public class CleaningWorker
implements Runnable {
    private static final Log LOGGER = LogFactory.getLog(CleaningWorker.class);
    private final long laptime;

    public CleaningWorker() {
        Properties props = new Properties();
        try {
            props.load(Thread.currentThread().getContextClassLoader().getResourceAsStream("general.properties"));
        }
        catch (IOException e) {
            LOGGER.error((Object)"Error occurred during CleaningWorker constructor", (Throwable)e);
        }
        String prop = props.getProperty("cleaningworker.laptime");
        if (prop == null) {
            this.laptime = 300000L;
            LOGGER.warn((Object)"Property 'cleaningworker.laptime' not found in general.propreties file, Cleaning Worker has been initialized with 300000 for timelap");
        } else {
            this.laptime = Long.parseLong(prop);
            LOGGER.debug((Object)("Configured laptime for cleaning worker: " + this.laptime));
        }
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    Thread.sleep(this.laptime);
                    this.work();
                    System.gc();
                }
            }
            catch (InterruptedException e) {
                LOGGER.error((Object)"Error occurred during the run of one cleaning worker", (Throwable)e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void work() {
        Set clientContextList = ConnectionHelper.getClientContextSet();
        ArrayList<ClientContext> clientRemoverList = new ArrayList<ClientContext>();
        for (ClientContext clientContext : clientContextList) {
            if (clientContext.isState()) {
                clientContext.setState(false);
                continue;
            }
            clientRemoverList.add(clientContext);
            try {
                if (clientContext.getJmxClient() == null) continue;
                clientContext.getJmxClient().disconnect();
            }
            catch (ConnectionErrorException e) {
                LOGGER.error((Object)"Error occurred during the work of one cleaning worker", (Throwable)e);
            }
        }
        Iterator i$ = clientRemoverList.iterator();
        while (i$.hasNext()) {
            ClientContext clientContext;
            ClientContext clientContext2 = clientContext = (ClientContext)i$.next();
            synchronized (clientContext2) {
                clientContextList.remove(clientContext);
                if (clientContext != null) {
                    LOGGER.debug((Object)("Client connection '" + clientContext.getId() + "' will be released from connections list"));
                }
            }
        }
        if (!clientRemoverList.isEmpty()) {
            clientRemoverList.clear();
            LOGGER.debug((Object)"All client connections have been released");
        }
    }
}

