/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.tools.webconsole.services.monitoring;

import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.Semaphore;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.petals.tools.webconsole.services.AbstractServiceFactory;
import org.ow2.petals.tools.webconsole.services.PetalsService;
import org.ow2.petals.tools.webconsole.services.PetalsServiceTechnicalException;
import org.ow2.petals.tools.webconsole.services.monitoring.MonitoringService;
import org.ow2.petals.tools.webconsole.services.monitoring.MonitoringServiceJMXImpl;
import org.ow2.petals.tools.webconsole.services.utils.ConnectionHelper;

public class MonitoringServiceFactory
extends AbstractServiceFactory {
    private static final Log LOGGER = LogFactory.getLog(MonitoringServiceFactory.class);
    private static MonitoringServiceFactory INSTANCE = null;
    private MonitoringService service = null;
    private String host;
    private String port;
    private String login;
    private String password;
    private static final Semaphore SEMAPHORE = new Semaphore(1);

    private MonitoringServiceFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AbstractServiceFactory getInstance() {
        Semaphore semaphore = SEMAPHORE;
        synchronized (semaphore) {
            if (INSTANCE == null) {
                INSTANCE = new MonitoringServiceFactory();
            }
            return INSTANCE;
        }
    }

    public MonitoringService getService(String hostname, Integer port, String login, String password) throws PetalsServiceTechnicalException {
        if (!(this.service != null && hostname.equals(this.host) && port.equals(Integer.valueOf(this.port)) && login.equals(this.login) && password.equals(this.password))) {
            this.service = this.getImplementation(hostname, port, login, password);
            this.host = hostname;
            this.port = String.valueOf(port);
            this.login = login;
            this.password = password;
        }
        return this.service;
    }

    public MonitoringService getImplementation(String hostname, Integer port, String login, String password) throws PetalsServiceTechnicalException {
        Class<?>[] interfaces;
        Properties props = new Properties();
        try {
            props.load(Thread.currentThread().getContextClassLoader().getResourceAsStream("services.properties"));
        }
        catch (IOException e) {
            LOGGER.error((Object)"Error occurred during properties loading for the get of monitoring service implementation");
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
        String className = props.getProperty("monitoring.service.impl");
        Class<?> loadedClass = null;
        try {
            loadedClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error((Object)"Error occurred during invoked class returning for the get of monitoring service implementation");
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
        boolean checkMonitoringServiceImplementation = Boolean.FALSE;
        for (Class<?> inter : interfaces = loadedClass.getInterfaces()) {
            if (!inter.equals(MonitoringService.class)) continue;
            checkMonitoringServiceImplementation = Boolean.TRUE;
        }
        if (checkMonitoringServiceImplementation) {
            MonitoringService monitoringService = null;
            try {
                monitoringService = (MonitoringService)loadedClass.newInstance();
            }
            catch (InstantiationException e) {
                LOGGER.error((Object)"Error occurred during invoked class instantiation for the get of monitoring service implementation");
                throw new PetalsServiceTechnicalException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                LOGGER.error((Object)"Error occurred during invoked class instantiation for the get of monitoring service implementation");
                throw new PetalsServiceTechnicalException((Throwable)e);
            }
            if (monitoringService != null) {
                monitoringService.setHostname(hostname);
                monitoringService.setPort(port);
                monitoringService.setLogin(login);
                monitoringService.setPassword(password);
            }
            if (MonitoringServiceJMXImpl.class.equals(monitoringService.getClass())) {
                ((MonitoringServiceJMXImpl)monitoringService).setJmxClient(ConnectionHelper.connect((String)hostname, (Integer)port, (String)login, (String)password, (boolean)false));
            }
            return monitoringService;
        }
        LOGGER.error((Object)("Error occurred during the get of monitoring service implementation (" + loadedClass.getName() + " class don't implement " + MonitoringService.class + ")"));
        throw new PetalsServiceTechnicalException(loadedClass.getName() + " don't " + "implement " + MonitoringService.class);
    }

    public PetalsService getService() throws PetalsServiceTechnicalException {
        return this.service;
    }
}

