/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.tools.webconsole.services.monitoring;

import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.petals.jmx.JMXClient;
import org.ow2.petals.jmx.RouterMonitorServiceClient;
import org.ow2.petals.jmx.exception.ConnectionErrorException;
import org.ow2.petals.jmx.exception.RouterMonitorServiceDoesNotExistException;
import org.ow2.petals.jmx.exception.RouterMonitorServiceErrorException;
import org.ow2.petals.tools.webconsole.services.PetalsServiceTechnicalException;
import org.ow2.petals.tools.webconsole.services.monitoring.MonitoringService;
import org.ow2.petals.tools.webconsole.services.utils.ConnectionHelper;

public class MonitoringServiceJMXImpl
implements MonitoringService {
    private static final Log LOGGER = LogFactory.getLog(MonitoringServiceJMXImpl.class);
    private JMXClient jmxClient;
    private String hostname;
    private Integer port;
    private String login;
    private String password;

    MonitoringServiceJMXImpl() {
    }

    public void setJmxClient(JMXClient jmxClient) {
        this.jmxClient = jmxClient;
    }

    public Map<String, String> getExchange(String exchangeId) throws PetalsServiceTechnicalException {
        RouterMonitorServiceClient rmsc = this.getRouterMonitorServiceClient();
        if (rmsc == null) {
            LOGGER.warn((Object)"Router monitor service client not correctly recovered");
            throw new PetalsServiceTechnicalException("Router monitor service client not correctly recovered");
        }
        try {
            Map exchange = rmsc.getExchange(exchangeId);
            if (exchange != null) {
                LOGGER.debug((Object)(exchange.size() + " informations recovered for exchange: " + exchangeId));
            } else {
                LOGGER.debug((Object)("No informations recovered for exchange: " + exchangeId));
            }
            return exchange;
        }
        catch (RouterMonitorServiceErrorException e) {
            LOGGER.error((Object)("Error occurred during get exchange action for " + exchangeId + " exchange ID"));
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
    }

    public Map<String, Long> getExchangeHistory(String exchangeId) throws PetalsServiceTechnicalException {
        RouterMonitorServiceClient rmsc = this.getRouterMonitorServiceClient();
        if (rmsc == null) {
            LOGGER.warn((Object)"Router monitor service client not correctly recovered");
            throw new PetalsServiceTechnicalException("Router monitor service client not correctly recovered");
        }
        try {
            Map history = rmsc.getExchangeHistory(exchangeId);
            if (history == null) {
                LOGGER.debug((Object)("History informations not recovered for exchange: " + exchangeId));
            } else {
                LOGGER.debug((Object)(history.size() + " history informations recovered for exchange: " + exchangeId));
            }
            return history;
        }
        catch (RouterMonitorServiceErrorException e) {
            LOGGER.error((Object)("Error occurred during get exchange history action for " + exchangeId + " exchange ID"));
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
    }

    public List<String> getExchangeIds(QName interfaceName, QName serviceName, String endpointName, QName operationName, long startDate, long endDate) throws PetalsServiceTechnicalException {
        RouterMonitorServiceClient rmsc = this.getRouterMonitorServiceClient();
        if (rmsc == null) {
            LOGGER.warn((Object)"Router monitor service client not correctly recovered");
            throw new PetalsServiceTechnicalException("Router monitor service client not correctly recovered");
        }
        try {
            List exchangeIds = rmsc.getExchangeIds(interfaceName, serviceName, endpointName, operationName, startDate, endDate);
            LOGGER.debug((Object)(exchangeIds.size() + " exchange IDs recovered for filter: [" + interfaceName + "/" + serviceName + "/" + endpointName + "/" + operationName + "]"));
            return exchangeIds;
        }
        catch (RouterMonitorServiceErrorException e) {
            LOGGER.error((Object)("Error occurred during get exchange ids action for filter: [" + interfaceName + "/" + serviceName + "/" + endpointName + "/" + operationName + "]"));
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
    }

    public int getExchanges(QName interfaceName, QName serviceName, String endpointName, QName operationName, long startDate, long endDate) throws PetalsServiceTechnicalException {
        RouterMonitorServiceClient rmsc = this.getRouterMonitorServiceClient();
        if (rmsc == null) {
            LOGGER.warn((Object)"Router monitor service client not correctly recovered");
            throw new PetalsServiceTechnicalException("Router monitor service client not correctly recovered");
        }
        try {
            int exchanges = rmsc.getExchanges(interfaceName, serviceName, endpointName, operationName, startDate, endDate);
            LOGGER.debug((Object)(exchanges + " exchanges recovered"));
            return exchanges;
        }
        catch (RouterMonitorServiceErrorException e) {
            LOGGER.error((Object)("Error occurred during get exchanges action for filter: [" + interfaceName + "/" + serviceName + "/" + endpointName + "/" + operationName + "]"));
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
    }

    public void monitorExchanges(QName interfaceName, QName serviceName, String endpointName, QName operationName, boolean storeExchanges) throws PetalsServiceTechnicalException {
        RouterMonitorServiceClient rmsc = this.getRouterMonitorServiceClient();
        if (rmsc == null) {
            LOGGER.warn((Object)"Router monitor service client not correctly recovered");
            throw new PetalsServiceTechnicalException("Router monitor service client not correctly recovered");
        }
        try {
            rmsc.monitorExchanges(interfaceName, serviceName, endpointName, operationName, storeExchanges);
            LOGGER.debug((Object)("Exchange monitoring enabled for filter: [" + interfaceName + "/" + serviceName + "/" + endpointName + "/" + operationName + "]"));
        }
        catch (RouterMonitorServiceErrorException e) {
            LOGGER.error((Object)("Error occurred during monitor exchanges action for filter: [" + interfaceName + "/" + serviceName + "/" + endpointName + "/" + operationName + "]"));
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
    }

    public void unmonitorExchanges(QName interfaceName, QName serviceName, String endpointName, QName operationName) throws PetalsServiceTechnicalException {
        RouterMonitorServiceClient rmsc = this.getRouterMonitorServiceClient();
        if (rmsc == null) {
            LOGGER.warn((Object)"Router monitor service client not correctly recovered");
            throw new PetalsServiceTechnicalException("Router monitor service client not correctly recovered");
        }
        try {
            rmsc.unmonitorExchanges(interfaceName, serviceName, endpointName, operationName);
            LOGGER.debug((Object)("Exchange monitoring disabled for filter: [" + interfaceName + "/" + serviceName + "/" + endpointName + "/" + operationName + "]"));
        }
        catch (RouterMonitorServiceErrorException e) {
            LOGGER.error((Object)("Error occurred during unmonitor exchanges action for filter: [" + interfaceName + "/" + serviceName + "/" + endpointName + "/" + operationName + "]"));
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
    }

    public List<Map<String, String>> getMonitoredExchange() throws PetalsServiceTechnicalException {
        RouterMonitorServiceClient rmsc = this.getRouterMonitorServiceClient();
        if (rmsc == null) {
            LOGGER.warn((Object)"Router monitor service client not correctly recovered");
            throw new PetalsServiceTechnicalException("Router monitor service client not correctly recovered");
        }
        try {
            List monitoredExchanges = rmsc.getMonitoredExchange();
            LOGGER.debug((Object)(monitoredExchanges.size() + " exchanges monitored"));
            return monitoredExchanges;
        }
        catch (RouterMonitorServiceErrorException e) {
            LOGGER.error((Object)"Error occurred during get monitored exchange action");
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
    }

    protected void finalize() throws Throwable {
        this.jmxClient.disconnect();
        LOGGER.debug((Object)("JMX Client correctly disconnected for " + this.hostname + "/" + this.port + " [host/port] server"));
        super.finalize();
    }

    public void reInitializeConnection(String hostname, Integer port, String login, String password) throws PetalsServiceTechnicalException {
        this.jmxClient = ConnectionHelper.connect((String)hostname, (Integer)port, (String)login, (String)password, (boolean)true);
        this.hostname = hostname;
        this.port = port;
        this.login = login;
        this.password = password;
        LOGGER.debug((Object)("JMX Client correclty reinitialized for " + this.hostname + "/" + this.port + " [host/port] server"));
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    private RouterMonitorServiceClient getRouterMonitorServiceClient() throws PetalsServiceTechnicalException {
        RouterMonitorServiceClient rmsc = null;
        try {
            rmsc = this.jmxClient.getRouterMonitoringServiceClient();
        }
        catch (RouterMonitorServiceDoesNotExistException e) {
            LOGGER.error((Object)"Error occurred during the first router monitoring service client getting action");
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
        catch (RouterMonitorServiceErrorException e) {
            LOGGER.error((Object)"Error occurred during the first router monitoring service client getting action");
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
        catch (ConnectionErrorException e) {
            LOGGER.debug((Object)"Error occurred during the first router monitoring service client getting action");
            this.jmxClient = ConnectionHelper.connect((String)this.hostname, (Integer)this.port, (String)this.login, (String)this.password, (boolean)true);
            try {
                rmsc = this.jmxClient.getRouterMonitoringServiceClient();
            }
            catch (RouterMonitorServiceDoesNotExistException ex) {
                LOGGER.error((Object)"Error occurred during the second router monitoring service client getting action");
                throw new PetalsServiceTechnicalException((Throwable)ex);
            }
            catch (RouterMonitorServiceErrorException ex) {
                LOGGER.error((Object)"Error occurred during the second router monitoring service client getting action");
                throw new PetalsServiceTechnicalException((Throwable)ex);
            }
            catch (ConnectionErrorException ex) {
                LOGGER.error((Object)"Error occurred during the second router monitoring service client getting action");
                throw new PetalsServiceTechnicalException((Throwable)ex);
            }
        }
        if (rmsc == null) {
            LOGGER.warn((Object)"Router monitor service client not correctly recovered");
            throw new PetalsServiceTechnicalException("Router monitor service client not correctly recovered");
        }
        return rmsc;
    }

    public void setMonitorStorageDuration(long monitoredMessageAge) throws PetalsServiceTechnicalException {
        RouterMonitorServiceClient rmsc = this.getRouterMonitorServiceClient();
        if (rmsc == null) {
            LOGGER.warn((Object)"Router monitor service client not correctly recovered");
            throw new PetalsServiceTechnicalException("Router monitor service client not correctly recovered");
        }
        try {
            rmsc.setMonitorStorageDuration(monitoredMessageAge);
            LOGGER.debug((Object)("Monitoring storage duration correctly update with the value: " + monitoredMessageAge));
        }
        catch (RouterMonitorServiceErrorException e) {
            LOGGER.error((Object)"Error occurred during the set of monitor storage duration");
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
    }

    public void clearMonitorStorage() throws PetalsServiceTechnicalException {
        RouterMonitorServiceClient rmsc = this.getRouterMonitorServiceClient();
        if (rmsc == null) {
            LOGGER.warn((Object)"Router monitor service client not correctly recovered");
            throw new PetalsServiceTechnicalException("Router monitor service client not correctly recovered");
        }
        try {
            rmsc.clearMonitorStorage();
            LOGGER.debug((Object)"Monitor storage cleaning correctly performed");
        }
        catch (RouterMonitorServiceErrorException e) {
            LOGGER.error((Object)"Error occurred during monitor storage cleaning");
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
    }

    public List<String> getExchangeIds(String propertyKey, String propertyValue) throws PetalsServiceTechnicalException {
        RouterMonitorServiceClient rmsc = this.getRouterMonitorServiceClient();
        if (rmsc == null) {
            LOGGER.warn((Object)"Router monitor service client not correctly recovered");
            throw new PetalsServiceTechnicalException("Router monitor service client not correctly recovered");
        }
        try {
            List exchangeIds = rmsc.getExchangeIds(propertyKey, propertyValue);
            if (exchangeIds != null) {
                LOGGER.debug((Object)(exchangeIds.size() + " exchange ids recovered for property key/value: " + propertyKey + "/" + propertyValue + " searching"));
            }
            return exchangeIds;
        }
        catch (RouterMonitorServiceErrorException e) {
            LOGGER.error((Object)("Error occurred during exchange ids recovering for property key/value: " + propertyKey + "/" + propertyValue));
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
    }

    public long getMonitorStorageDuration() throws PetalsServiceTechnicalException {
        long duration;
        RouterMonitorServiceClient rmsc = this.getRouterMonitorServiceClient();
        if (rmsc == null) {
            LOGGER.warn((Object)"Router monitor service client not correctly recovered");
            throw new PetalsServiceTechnicalException("Router monitor service client not correctly recovered");
        }
        try {
            duration = rmsc.getMonitorStorageDuration();
            LOGGER.debug((Object)("Monitoring storage duration correctly recovered with the value: " + duration));
        }
        catch (RouterMonitorServiceErrorException e) {
            LOGGER.error((Object)"Error occurred during the get of monitor storage duration");
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
        return duration;
    }
}

