/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.tools.webconsole.services.remoteinjector;

import com.ebmwebsourcing.easycommons.stream.InputStreamForker;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.rmi.ConnectException;
import java.rmi.NoSuchObjectException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.MimetypesFileTypeMap;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.InOptionalOut;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.messaging.RobustInOnly;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.objectweb.petals.tools.rmi.client.ComponentContextLocator;
import org.objectweb.petals.tools.rmi.server.remote.interfaces.RemoteComponentContext;
import org.objectweb.petals.tools.rmi.server.remote.interfaces.RemoteDeliveryChannel;
import org.ow2.petals.tools.webconsole.services.PetalsServiceTechnicalException;
import org.ow2.petals.tools.webconsole.services.remoteinjector.RemoteInjectorService;
import org.ow2.petals.tools.webconsole.services.remoteinjector.models.Mep;
import org.ow2.petals.tools.webconsole.services.remoteinjector.models.Property;
import org.ow2.petals.tools.webconsole.services.remoteinjector.utils.RemotingHelper;
import org.ow2.petals.tools.webconsole.services.remoteinjector.utils.StreamDataSource;
import org.ow2.petals.tools.webconsole.utils.StringHelper;

public class RemoteInjectorRMIServiceImpl
implements RemoteInjectorService {
    private static final Log LOGGER = LogFactory.getLog(RemoteInjectorRMIServiceImpl.class);
    private long defautAcceptTimeout = Long.parseLong("60000");
    private RemoteComponentContext remoteComponentContext;
    private static final String UTF8 = "UTF-8";
    private int remotePort = 1099;
    private String remoteContext = "RMIComponentContext";
    private String remoteIP = "localhost";
    private NormalizedMessage sendedNormalizedMessage;

    RemoteInjectorRMIServiceImpl() {
    }

    public void initialize(Map<String, String> propertiesMap) throws PetalsServiceTechnicalException {
        if (propertiesMap != null) {
            if (propertiesMap.get("rmiPort") != null) {
                try {
                    this.remotePort = Integer.parseInt(propertiesMap.get("rmiPort"));
                    LOGGER.debug((Object)("Remote port set: " + this.remotePort));
                }
                catch (NumberFormatException e) {
                    LOGGER.error((Object)"Error occurred during the set of remote port");
                    throw new PetalsServiceTechnicalException("Bad format for the rmiPort property", (Throwable)e);
                }
            } else {
                LOGGER.warn((Object)"Property: rmiPort, wasn't present in the properties map");
                throw new PetalsServiceTechnicalException("Property: rmiPort, wasn't present in the properties map");
            }
            if (propertiesMap.get("rmiIP") != null) {
                try {
                    this.remoteIP = propertiesMap.get("rmiIP");
                    LOGGER.debug((Object)("Remote ip set: " + this.remoteIP));
                }
                catch (NumberFormatException e) {
                    LOGGER.error((Object)"Error occurred during the set of remote IP");
                    throw new PetalsServiceTechnicalException("Bad format for the rmiIP property", (Throwable)e);
                }
            } else {
                LOGGER.warn((Object)"Property: rmiIP, wasn't present in the properties map");
                throw new PetalsServiceTechnicalException("property: rmiIP, wasn't present in the properties map");
            }
            if (propertiesMap.get("rmiContext") != null) {
                try {
                    this.remoteContext = propertiesMap.get("rmiContext");
                    LOGGER.debug((Object)("Remote context set: " + this.remoteContext));
                }
                catch (NumberFormatException e) {
                    LOGGER.error((Object)"Error occurred during the set of remote Context");
                    throw new PetalsServiceTechnicalException("Bad format for the rmiContext property", (Throwable)e);
                }
            } else {
                LOGGER.warn((Object)"Property: rmiContext, wasn't present in the properties map");
                throw new PetalsServiceTechnicalException("property: rmiContext, wasn't present in the properties map");
            }
            if (propertiesMap.get("acceptTimeout") != null) {
                try {
                    this.defautAcceptTimeout = Long.parseLong(propertiesMap.get("acceptTimeout"));
                    LOGGER.debug((Object)("Acceptimeout set: " + this.defautAcceptTimeout));
                }
                catch (NumberFormatException e) {
                    LOGGER.error((Object)"Error occurred during the set of acceptimeout");
                    throw new PetalsServiceTechnicalException("Bad format for the acceptTimeout property", (Throwable)e);
                }
            } else {
                LOGGER.warn((Object)"Property: acceptTimeout, wasn't present in the properties map");
                throw new PetalsServiceTechnicalException("property: acceptTimeout, wasn't present in the properties map");
            }
            this.remoteComponentContext = this.createRemoteComponentContext(this.remoteIP, this.remotePort, this.remoteContext);
            if (this.remoteComponentContext != null) {
                LOGGER.debug((Object)("Remote component context correctly create with following parameters [" + this.remoteIP + "/" + this.remotePort + "/" + this.remoteContext + "]"));
            }
        } else {
            LOGGER.warn((Object)"Properties map for remote injector initialization null");
        }
    }

    public MessageExchange injectMessage(QName _interface, List<Property> normalizedProperties, QName service, String endpoint, QName operation, String mep, List<Property> mEXProperties, String content, List<File> attachments, Long synchronousSend) throws PetalsServiceTechnicalException {
        Boolean timeoutReached = null;
        try {
            return this.sendSynch(mep, _interface, service, endpoint, operation, mEXProperties, normalizedProperties, attachments, content, synchronousSend, timeoutReached);
        }
        catch (MessagingException e) {
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
        catch (TransformerConfigurationException e) {
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
        catch (TransformerException e) {
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
        catch (IOException e) {
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
    }

    private MessageExchange sendSynch(String mep, QName _interface, QName service, String endpoint, QName operation, List<Property> mEXProperties, List<Property> normalizedProperties, List<File> attachments, String content, Long synchronousSend, Boolean timeoutReached) throws MessagingException, PetalsServiceTechnicalException, TransformerConfigurationException, TransformerException, IOException {
        MessageExchange exchange = this.createMessageExchange(_interface, mep, service, endpoint, operation, mEXProperties, normalizedProperties, attachments, content);
        RemoteDeliveryChannel channel = null;
        if (synchronousSend != null) {
            this.sendedNormalizedMessage = exchange.getMessage("IN");
            InputStreamForker forker = StringHelper.fork((Source)this.sendedNormalizedMessage.getContent());
            this.sendedNormalizedMessage.setContent((Source)new StreamSource(forker.fork()));
            if (this.remoteComponentContext == null) {
                throw new PetalsServiceTechnicalException("The remote remote component context is null, verify if it's correctly declared into the configuration file");
            }
            try {
                channel = this.remoteComponentContext.getDeliveryChannel();
                if (channel == null) {
                    throw new PetalsServiceTechnicalException("Delivery channel of the remote remote component context is unavailable ");
                }
                exchange = channel.sendSync(exchange, synchronousSend.longValue());
            }
            catch (IllegalStateException e) {
                throw new PetalsServiceTechnicalException((Throwable)e);
            }
            if (exchange == null) {
                throw new PetalsServiceTechnicalException("Injection failed, unexpected timeout reached, you have certainly assigned a timeout too short. Timeout used: " + synchronousSend + " milli-seconds");
            }
            this.sendedNormalizedMessage.setContent((Source)new StreamSource(forker.fork()));
            exchange.setMessage(this.sendedNormalizedMessage, "in");
        } else {
            this.sendedNormalizedMessage = exchange.getMessage("IN");
            InputStreamForker forker = StringHelper.fork((Source)this.sendedNormalizedMessage.getContent());
            this.sendedNormalizedMessage.setContent((Source)new StreamSource(forker.fork()));
            this.remoteComponentContext.getDeliveryChannel().send(exchange);
            exchange = this.remoteComponentContext.getDeliveryChannel().accept(this.defautAcceptTimeout);
            this.sendedNormalizedMessage.setContent((Source)new StreamSource(forker.fork()));
            exchange.setMessage(this.sendedNormalizedMessage, "in");
        }
        return exchange;
    }

    public MessageExchange performAcknowledgment(String mep, String acknowledgmentType, MessageExchange exchange, String returnedContent) throws PetalsServiceTechnicalException {
        if (!acknowledgmentType.equals("Active")) {
            if (Mep.IN_OPTIONAL_OUT.value().equals(mep)) {
                // empty if block
            }
            HashMap<String, NormalizedMessage> nms = new HashMap<String, NormalizedMessage>();
            InputStreamForker inForker = null;
            InputStreamForker outForker = null;
            InputStreamForker faultForker = null;
            InputStreamForker returnedFaultForker = null;
            HashMap inProperties = new HashMap();
            HashMap outProperties = new HashMap();
            HashMap faultProperties = new HashMap();
            if (exchange.getMessage("IN") != null) {
                inForker = RemotingHelper.forkBeforeAck((NormalizedMessage)exchange.getMessage("IN"), inProperties);
                nms.put("IN", exchange.getMessage("IN"));
            }
            if (exchange.getMessage("OUT") != null) {
                outForker = RemotingHelper.forkBeforeAck((NormalizedMessage)exchange.getMessage("OUT"), outProperties);
                nms.put("OUT", exchange.getMessage("OUT"));
            }
            if (exchange.getMessage("FAULT") != null) {
                faultForker = RemotingHelper.forkBeforeAck((NormalizedMessage)exchange.getMessage("FAULT"), faultProperties);
                nms.put("FAULT", exchange.getMessage("FAULT"));
            }
            if (acknowledgmentType.equals("Done")) {
                try {
                    exchange.setStatus(ExchangeStatus.DONE);
                }
                catch (MessagingException e) {
                    LOGGER.error((Object)("Error occurred during perfom acknowledgment: " + e.getMessage()));
                    throw new PetalsServiceTechnicalException((Throwable)e);
                }
            }
            if (acknowledgmentType.equals("Fault")) {
                Fault fault;
                try {
                    exchange.setStatus(ExchangeStatus.DONE);
                }
                catch (MessagingException e) {
                    LOGGER.error((Object)("Error occurred during perfom acknowledgment: " + e.getMessage()));
                    throw new PetalsServiceTechnicalException((Throwable)e);
                }
                try {
                    fault = exchange.createFault();
                }
                catch (MessagingException e) {
                    LOGGER.error((Object)("Error occurred during perfom acknowledgment: " + e.getMessage()));
                    throw new PetalsServiceTechnicalException((Throwable)e);
                }
                try {
                    returnedFaultForker = StringHelper.fork((Source)new StreamSource(new ByteArrayInputStream(returnedContent.trim().getBytes(UTF8))));
                }
                catch (UnsupportedEncodingException e) {
                    LOGGER.error((Object)("Error occurred during perfom acknowledgment: " + e.getMessage()));
                    throw new PetalsServiceTechnicalException((Throwable)e);
                }
                catch (TransformerFactoryConfigurationError e) {
                    LOGGER.error((Object)("Error occurred during perfom acknowledgment: " + e.getMessage()));
                    throw new PetalsServiceTechnicalException((Throwable)e);
                }
                catch (IOException e) {
                    LOGGER.error((Object)("Error occurred during perfom acknowledgment: " + e.getMessage()));
                    throw new PetalsServiceTechnicalException((Throwable)e);
                }
                catch (TransformerException e) {
                    LOGGER.error((Object)("Error occurred during perfom acknowledgment: " + e.getMessage()));
                    throw new PetalsServiceTechnicalException((Throwable)e);
                }
                try {
                    fault.setContent((Source)new StreamSource(returnedFaultForker.fork()));
                }
                catch (MessagingException e) {
                    LOGGER.error((Object)("Error occurred during perfom acknowledgment: " + e.getMessage()));
                    throw new PetalsServiceTechnicalException((Throwable)e);
                }
                catch (IOException e) {
                    LOGGER.error((Object)("Error occurred during perfom acknowledgment: " + e.getMessage()));
                    throw new PetalsServiceTechnicalException((Throwable)e);
                }
                try {
                    exchange.setFault(fault);
                }
                catch (MessagingException e) {
                    LOGGER.error((Object)("Error occurred during perfom acknowledgment: " + e.getMessage()));
                    throw new PetalsServiceTechnicalException((Throwable)e);
                }
            }
            try {
                exchange.setStatus(ExchangeStatus.ERROR);
            }
            catch (MessagingException e) {
                LOGGER.error((Object)("Error occurred during perfom acknowledgment: " + e.getMessage()));
                throw new PetalsServiceTechnicalException((Throwable)e);
            }
            exchange.setError((Exception)((Object)new MessagingException(returnedContent)));
            try {
                RemoteDeliveryChannel channel = this.remoteComponentContext.getDeliveryChannel();
                if (channel == null) {
                    throw new PetalsServiceTechnicalException("Delivery channel of the remote remote component context is unavailable ");
                }
                channel.send(exchange);
            }
            catch (MessagingException e) {
                LOGGER.error((Object)("Error occurred during perfom acknowledgment: " + e.getMessage()));
                throw new PetalsServiceTechnicalException((Throwable)e);
            }
            catch (RemoteException e) {
                LOGGER.error((Object)("Error occurred during perfom acknowledgment: " + e.getMessage()));
                throw new PetalsServiceTechnicalException((Throwable)e);
            }
            RemotingHelper.forkExchange(nms, (MessageExchange)exchange, (InputStreamForker)inForker, (InputStreamForker)faultForker, returnedFaultForker, (InputStreamForker)outForker, inProperties, faultProperties, outProperties);
        }
        return exchange;
    }

    private MessageExchange createMessageExchange(QName interfaz, String mep, QName service, String endpoint, QName operation, List<Property> mEXProperties, List<Property> normalizedProperties, List<File> attachments, String content) throws PetalsServiceTechnicalException {
        NormalizedMessage nm;
        InOnly msg;
        block51: {
            msg = null;
            nm = null;
            try {
                if (Mep.IN_ONLY.value().equals(mep)) {
                    try {
                        msg = this.remoteComponentContext.getDeliveryChannel().createExchangeFactory().createInOnlyExchange();
                    }
                    catch (ConnectException e) {
                        this.remoteComponentContext = this.createRemoteComponentContext(this.remoteIP, this.remotePort, this.remoteContext);
                    }
                    catch (MessagingException e) {
                        this.remoteComponentContext = this.createRemoteComponentContext(this.remoteIP, this.remotePort, this.remoteContext);
                    }
                    catch (NoSuchObjectException e) {
                        this.remoteComponentContext = this.createRemoteComponentContext(this.remoteIP, this.remotePort, this.remoteContext);
                        if (this.remoteComponentContext != null) {
                            LOGGER.debug((Object)("Remote component context correctly recreate with following parameters [" + this.remoteIP + "/" + this.remotePort + "/" + this.remoteContext + "]"));
                        }
                        LOGGER.debug((Object)("Remote component context not correctly recreate with following parameters [" + this.remoteIP + "/" + this.remotePort + "/" + this.remoteContext + "]"));
                    }
                    if (msg == null) {
                        msg = this.remoteComponentContext.getDeliveryChannel().createExchangeFactory().createInOnlyExchange();
                    }
                    nm = msg.createMessage();
                    msg.setInMessage(nm);
                    break block51;
                }
                if (Mep.IN_OUT.value().equals(mep)) {
                    try {
                        msg = this.remoteComponentContext.getDeliveryChannel().createExchangeFactory().createInOutExchange();
                    }
                    catch (ConnectException e) {
                        this.remoteComponentContext = this.createRemoteComponentContext(this.remoteIP, this.remotePort, this.remoteContext);
                    }
                    catch (MessagingException e) {
                        this.remoteComponentContext = this.createRemoteComponentContext(this.remoteIP, this.remotePort, this.remoteContext);
                    }
                    catch (NoSuchObjectException e) {
                        this.remoteComponentContext = this.createRemoteComponentContext(this.remoteIP, this.remotePort, this.remoteContext);
                        if (this.remoteComponentContext != null) {
                            LOGGER.debug((Object)("Remote component context correctly recreate with following parameters [" + this.remoteIP + "/" + this.remotePort + "/" + this.remoteContext + "]"));
                        }
                        LOGGER.debug((Object)("Remote component context not correctly recreate with following parameters [" + this.remoteIP + "/" + this.remotePort + "/" + this.remoteContext + "]"));
                    }
                    if (msg == null) {
                        msg = this.remoteComponentContext.getDeliveryChannel().createExchangeFactory().createInOutExchange();
                    }
                    nm = msg.createMessage();
                    ((InOut)msg).setInMessage(nm);
                    break block51;
                }
                if (Mep.IN_OPTIONAL_OUT.value().equals(mep)) {
                    try {
                        msg = this.remoteComponentContext.getDeliveryChannel().createExchangeFactory().createInOptionalOutExchange();
                    }
                    catch (ConnectException e) {
                        this.remoteComponentContext = this.createRemoteComponentContext(this.remoteIP, this.remotePort, this.remoteContext);
                    }
                    catch (MessagingException e) {
                        this.remoteComponentContext = this.createRemoteComponentContext(this.remoteIP, this.remotePort, this.remoteContext);
                    }
                    catch (NoSuchObjectException e) {
                        this.remoteComponentContext = this.createRemoteComponentContext(this.remoteIP, this.remotePort, this.remoteContext);
                        if (this.remoteComponentContext != null) {
                            LOGGER.debug((Object)("Remote component context correctly recreate with following parameters [" + this.remoteIP + "/" + this.remotePort + "/" + this.remoteContext + "]"));
                        }
                        LOGGER.debug((Object)("Remote component context not correctly recreate with following parameters [" + this.remoteIP + "/" + this.remotePort + "/" + this.remoteContext + "]"));
                    }
                    if (msg == null) {
                        msg = this.remoteComponentContext.getDeliveryChannel().createExchangeFactory().createInOptionalOutExchange();
                    }
                    nm = msg.createMessage();
                    ((InOptionalOut)msg).setInMessage(nm);
                    break block51;
                }
                if (!Mep.ROBUST_IN_ONLY.value().equals(mep)) break block51;
                try {
                    msg = this.remoteComponentContext.getDeliveryChannel().createExchangeFactory().createRobustInOnlyExchange();
                }
                catch (ConnectException e) {
                    this.remoteComponentContext = this.createRemoteComponentContext(this.remoteIP, this.remotePort, this.remoteContext);
                }
                catch (MessagingException e) {
                    this.remoteComponentContext = this.createRemoteComponentContext(this.remoteIP, this.remotePort, this.remoteContext);
                }
                catch (NoSuchObjectException e) {
                    this.remoteComponentContext = this.createRemoteComponentContext(this.remoteIP, this.remotePort, this.remoteContext);
                    if (this.remoteComponentContext != null) {
                        LOGGER.debug((Object)("Remote component context correctly recreate with following parameters [" + this.remoteIP + "/" + this.remotePort + "/" + this.remoteContext + "]"));
                    }
                    LOGGER.debug((Object)("Remote component context not correctly recreate with following parameters [" + this.remoteIP + "/" + this.remotePort + "/" + this.remoteContext + "]"));
                }
                if (msg == null) {
                    msg = this.remoteComponentContext.getDeliveryChannel().createExchangeFactory().createRobustInOnlyExchange();
                }
                nm = msg.createMessage();
                ((RobustInOnly)msg).setInMessage(nm);
            }
            catch (MessagingException e) {
                throw new PetalsServiceTechnicalException((Throwable)e);
            }
            catch (RemoteException e) {
                throw new PetalsServiceTechnicalException((Throwable)e);
            }
        }
        if (nm != null) {
            if (endpoint != null) {
                try {
                    msg.setEndpoint(this.remoteComponentContext.getEndpoint(service, endpoint));
                }
                catch (RemoteException e) {
                    LOGGER.error((Object)"Error occurred during the set of endpoint");
                    throw new PetalsServiceTechnicalException((Throwable)e);
                }
            }
            msg.setService(service);
            msg.setInterfaceName(interfaz);
            if (operation != null) {
                msg.setOperation(operation);
            }
            for (Property property : mEXProperties) {
                msg.setProperty(property.getName(), (Object)property.getValue());
            }
            for (Property property : normalizedProperties) {
                nm.setProperty(property.getName(), (Object)property.getValue());
            }
            try {
                nm.setContent((Source)new StreamSource(new ByteArrayInputStream(content.getBytes(UTF8))));
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.error((Object)"Error occurred during the set of normalized message content", (Throwable)e);
            }
            catch (MessagingException e) {
                LOGGER.error((Object)"Error occurred during the set of normalized message content", (Throwable)e);
                throw new PetalsServiceTechnicalException((Throwable)e);
            }
        }
        for (File attachment : attachments) {
            MimetypesFileTypeMap mime = new MimetypesFileTypeMap();
            FileInputStream in = null;
            try {
                in = new FileInputStream(attachment);
                byte[] data = new byte[((InputStream)in).available()];
                ((InputStream)in).read(data);
                StreamDataSource dataSource = new StreamDataSource(new ByteArrayInputStream(data), attachment.getName(), mime.getContentType(attachment));
                nm.addAttachment(attachment.getName(), new DataHandler((DataSource)dataSource));
            }
            catch (IOException e) {
                throw new PetalsServiceTechnicalException((Throwable)e);
            }
            catch (MessagingException e) {
                throw new PetalsServiceTechnicalException((Throwable)e);
            }
            finally {
                if (in == null) continue;
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {
                    throw new PetalsServiceTechnicalException((Throwable)e);
                }
            }
        }
        return msg;
    }

    public RemoteComponentContext getRemoteComponentContext() {
        return this.remoteComponentContext;
    }

    private RemoteComponentContext createRemoteComponentContext(String remoteIP, int remotePort, String remoteContext) throws PetalsServiceTechnicalException {
        ComponentContextLocator ccl;
        try {
            ccl = new ComponentContextLocator(remoteIP, remotePort, remoteContext);
        }
        catch (MalformedURLException e) {
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
        catch (RemoteException e) {
            throw new PetalsServiceTechnicalException("Check your petals-se-rmi localized on '" + remoteIP + "' server with remote Port: " + remotePort + " and remote Context: " + remoteContext + ". You can also remove or disabled remote component declaration into 'webconsole.xml'", (Throwable)e);
        }
        catch (NotBoundException e) {
            LOGGER.error((Object)(e.getMessage() + " not bound." + " Check your petals-se-rmi localized on '" + remoteIP + "' server with remote Port: " + remotePort + " and remote Context: " + remoteContext + ". You can also remove or disabled remote component declaration into 'webconsole.xml'"));
            throw new PetalsServiceTechnicalException(e.getMessage() + " not bound." + " Check your petals-se-rmi localized on '" + remoteIP + "' server with remote Port: " + remotePort + " and remote Context: " + remoteContext + ". You can also remove or disabled remote component declaration into 'webconsole.xml'", (Throwable)e);
        }
        return ccl.getComponentContext();
    }
}

