/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.tools.webconsole.services.remoteinjector.models;

import java.io.File;
import java.io.IOException;
import java.rmi.dgc.VMID;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Set;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.petals.tools.webconsole.services.remoteinjector.models.Property;
import org.ow2.petals.tools.webconsole.utils.GeneralHelper;
import org.ow2.petals.tools.webconsole.utils.StringHelper;

public class Response {
    private static final Log LOGGER = LogFactory.getLog(Response.class);
    private Fault fault;
    private ExchangeStatus status;
    private Exception error;
    private NormalizedMessage outMessage;
    private String timestamp;
    private Date date;
    private String endpoint;
    private QName service;
    private QName iInterface;
    private String formatedContent;
    private List<Property> mEXProperties;

    public Fault getFault() {
        return this.fault;
    }

    public void setFault(Fault fault) {
        this.fault = fault;
    }

    public ExchangeStatus getStatus() {
        return this.status;
    }

    public String getStringStatus() {
        String stringStatus = null;
        if (this.status.equals(ExchangeStatus.ACTIVE)) {
            stringStatus = "ACTIVE";
        } else if (this.status.equals(ExchangeStatus.DONE)) {
            stringStatus = "DONE";
        } else if (this.status.equals(ExchangeStatus.ERROR)) {
            stringStatus = "ERROR";
        }
        return stringStatus;
    }

    public void setStatus(ExchangeStatus status) {
        this.status = status;
    }

    public Exception getError() {
        return this.error;
    }

    public void setError(Exception error) {
        this.error = error;
    }

    public NormalizedMessage getOutMessage() {
        return this.outMessage;
    }

    public void setOutMessage(NormalizedMessage outMessage) {
        this.outMessage = outMessage;
    }

    public Response(Exception error, Fault fault, NormalizedMessage outMessage, ExchangeStatus status) {
        this.error = error;
        this.fault = fault;
        this.outMessage = outMessage;
        this.status = status;
        this.timestamp = new VMID().toString() + " --> " + new GregorianCalendar().getTime();
        this.mEXProperties = new ArrayList();
    }

    public Response(Exception error) {
        this.error = error;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public String getContent() {
        String content = "";
        if (this.error != null) {
            content = this.error.getMessage();
        } else if (this.fault != null) {
            content = this.fault.getContent().toString();
        } else if (this.outMessage != null) {
            content = this.outMessage.getContent().toString();
        }
        return content;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public QName getService() {
        return this.service;
    }

    public void setService(QName service) {
        this.service = service;
    }

    public QName getIInterface() {
        return this.iInterface;
    }

    public void setIInterface(QName _iInterface) {
        this.iInterface = _iInterface;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String getFormatedContent() throws TransformerFactoryConfigurationError, IOException, TransformerException {
        if (this.formatedContent == null) {
            String format = "no content for this message exchange";
            if (this.outMessage != null) {
                format = StringHelper.createString((Source)this.outMessage.getContent());
            }
            if (this.fault != null) {
                format = StringHelper.createString((Source)this.fault.getContent());
            }
            if (this.error != null) {
                format = this.error.getMessage() + ": \n " + String.valueOf(this.error.getStackTrace());
            }
            this.formatedContent = format;
        }
        return StringHelper.prettyPrint((String)this.formatedContent);
    }

    public void setFormatedContent(String formatedContent) {
        this.formatedContent = formatedContent;
    }

    public String getLocalInterface() {
        return this.iInterface.getLocalPart();
    }

    public String getLocalService() {
        return this.service.getLocalPart();
    }

    public String getNameSpace() {
        return this.iInterface.getNamespaceURI();
    }

    public List<Property> getMEXProperties() {
        return this.mEXProperties;
    }

    public void setMEXProperties(List<Property> properties) {
        this.mEXProperties = properties;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        Set attachments = this.outMessage.getAttachmentNames();
        File slTree = GeneralHelper.getAttachmentsRepo();
        if (slTree != null && slTree.exists()) {
            List<File> attachFiles = Arrays.asList(slTree.listFiles());
            for (String attachName : attachments) {
                for (File file : attachFiles) {
                    if (!file.getName().equals(attachName) || file.delete()) continue;
                    LOGGER.info((Object)("Unable to delete the new file: " + file.getPath()));
                }
            }
        }
    }
}

