/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.tools.webconsole.services.remoteinjector.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;
import javax.activation.FileTypeMap;

public class StreamDataSource
implements DataSource {
    private ByteArrayInputStream input;
    private String fileName;
    private String contentType;

    public StreamDataSource(ByteArrayInputStream input, String fileName, String contentType) {
        this.input = input;
        this.fileName = fileName;
        this.contentType = contentType;
    }

    public String getContentType() {
        if (this.contentType != null) {
            return this.contentType;
        }
        return FileTypeMap.getDefaultFileTypeMap().getContentType(this.fileName);
    }

    public InputStream getInputStream() throws IOException {
        return this.input;
    }

    public String getName() {
        return this.fileName;
    }

    public OutputStream getOutputStream() throws IOException {
        byte[] bytes = new byte[1024];
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        while (this.input.available() > 0) {
            this.input.read(bytes);
            outputStream.write(bytes);
        }
        return new ByteArrayOutputStream();
    }
}

