/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.tools.webconsole.services.security;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.petals.tools.webconsole.services.PetalsServiceFunctionalException;
import org.ow2.petals.tools.webconsole.services.PetalsServiceTechnicalException;
import org.ow2.petals.tools.webconsole.services.security.SecurityService;
import org.ow2.petals.tools.webconsole.services.security.auth.EntityPrincipal;
import org.ow2.petals.tools.webconsole.services.security.util.CipherHelper;
import org.ow2.petals.tools.webconsole.services.security.util.FilerDAOHelper;
import org.xml.sax.SAXException;

public class EntitySecurityServiceImpl
implements SecurityService {
    private static final Log LOGGER = LogFactory.getLog(EntitySecurityServiceImpl.class);

    EntitySecurityServiceImpl() {
    }

    public void save(Set<EntityPrincipal> entities) throws PetalsServiceTechnicalException {
        try {
            FilerDAOHelper.writeConfiguration((String)"security.xml", (String)"security.xsd", entities);
        }
        catch (ParserConfigurationException e) {
            LOGGER.error((Object)"Error occurred during entities saving");
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error((Object)"Error occurred during entities saving");
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
        catch (URISyntaxException e) {
            LOGGER.error((Object)"Error occurred during entities saving");
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
    }

    public String encrypt(String plainText) throws PetalsServiceTechnicalException {
        try {
            return CipherHelper.encrypt((String)plainText);
        }
        catch (IOException e) {
            LOGGER.error((Object)("Error occurred during encryption of: " + plainText + " plain text"));
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
    }

    public boolean deleteUser(String username) throws PetalsServiceTechnicalException {
        HashSet entities = new HashSet();
        try {
            URL securityFile = Thread.currentThread().getContextClassLoader().getResource("security.xml");
            entities.addAll(FilerDAOHelper.readConfig((URL)securityFile));
        }
        catch (ParserConfigurationException e) {
            LOGGER.error((Object)("Error occurred during user '" + username + "' deleting action"));
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error((Object)("Error occurred during user '" + username + "' deleting action"));
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
        catch (SAXException e) {
            LOGGER.error((Object)("Error occurred during user '" + username + "' deleting action"));
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
        catch (FactoryConfigurationError e) {
            LOGGER.error((Object)("Error occurred during user '" + username + "' deleting action"));
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
        if (!entities.isEmpty()) {
            EntityPrincipal removedPrincipal = null;
            for (EntityPrincipal ePrincipal : entities) {
                if (!ePrincipal.getName().equals(username)) continue;
                removedPrincipal = ePrincipal;
            }
            if (removedPrincipal != null) {
                entities.remove(removedPrincipal);
                try {
                    this.save(entities);
                    return true;
                }
                catch (PetalsServiceTechnicalException e) {
                    LOGGER.error((Object)("Error occurred during user '" + username + "' deleting action"));
                    throw e;
                }
            }
        }
        return false;
    }

    public boolean addUser(String username, String password, String[] principals) throws PetalsServiceTechnicalException, PetalsServiceFunctionalException {
        if (this.entityExisting(username) != null) {
            throw new PetalsServiceFunctionalException("User with username '" + username + "' already exist");
        }
        StringBuilder roles = new StringBuilder();
        for (int i = 0; i < principals.length; ++i) {
            roles.append(principals[i]);
            if (i >= principals.length - 1) continue;
            roles.append(",");
        }
        HashSet<EntityPrincipal> entities = new HashSet<EntityPrincipal>();
        try {
            URL securityFile = Thread.currentThread().getContextClassLoader().getResource("security.xml");
            entities.addAll(FilerDAOHelper.readConfig((URL)securityFile));
            EntityPrincipal ePrincipal = new EntityPrincipal(username);
            ePrincipal.setPassword(password);
            ePrincipal.setRoles(roles.toString());
            ePrincipal.setName(username);
            entities.add(ePrincipal);
            this.save(entities);
        }
        catch (ParserConfigurationException e) {
            LOGGER.error((Object)("Error occurred during user '" + username + "' adding action"));
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error((Object)("Error occurred during user '" + username + "' adding action"));
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
        catch (SAXException e) {
            LOGGER.error((Object)("Error occurred during user '" + username + "' adding action"));
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
        catch (FactoryConfigurationError e) {
            LOGGER.error((Object)("Error occurred during user '" + username + "' adding action"));
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
        return true;
    }

    private EntityPrincipal entityExisting(String username) throws PetalsServiceTechnicalException {
        HashSet entities = new HashSet();
        try {
            URL securityFile = Thread.currentThread().getContextClassLoader().getResource("security.xml");
            entities.addAll(FilerDAOHelper.readConfig((URL)securityFile));
        }
        catch (ParserConfigurationException e) {
            LOGGER.error((Object)("Error occurred during user '" + username + "' deleting action"));
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error((Object)("Error occurred during user '" + username + "' deleting action"));
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
        catch (SAXException e) {
            LOGGER.error((Object)("Error occurred during user '" + username + "' deleting action"));
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
        catch (FactoryConfigurationError e) {
            LOGGER.error((Object)("Error occurred during user '" + username + "' deleting action"));
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
        if (!entities.isEmpty()) {
            for (EntityPrincipal ePrincipal : entities) {
                if (!ePrincipal.getName().equals(username)) continue;
                return ePrincipal;
            }
        }
        return null;
    }

    public boolean modifyUser(String oldUser, String modifiedUsername, String oldPassword, String modifiedPassword, String confirmModifiedPassword, String[] principals) throws PetalsServiceTechnicalException, PetalsServiceFunctionalException {
        EntityPrincipal ePrincipal = this.entityExisting(modifiedUsername);
        if (ePrincipal == null) {
            throw new PetalsServiceFunctionalException("User with username '" + modifiedUsername + "' doesn't exist");
        }
        if (ePrincipal.getPassword().equals(oldPassword)) {
            ePrincipal.setPassword(modifiedPassword);
            StringBuilder roles = new StringBuilder();
            if (principals != null) {
                for (int i = 0; i < principals.length; ++i) {
                    roles.append(principals[i]);
                    if (i >= principals.length - 1) continue;
                    roles.append(",");
                }
            }
            ePrincipal.setRoles(roles.toString());
            HashSet<EntityPrincipal> entities = new HashSet<EntityPrincipal>();
            try {
                URL securityFile = Thread.currentThread().getContextClassLoader().getResource("security.xml");
                entities.addAll(FilerDAOHelper.readConfig((URL)securityFile));
                entities.remove(ePrincipal);
                entities.add(ePrincipal);
                this.save(entities);
            }
            catch (ParserConfigurationException e) {
                LOGGER.error((Object)("Error occurred during user '" + oldUser + "' modification action"));
                throw new PetalsServiceTechnicalException((Throwable)e);
            }
            catch (IOException e) {
                LOGGER.error((Object)("Error occurred during user '" + oldUser + "' modification action"));
                throw new PetalsServiceTechnicalException((Throwable)e);
            }
            catch (SAXException e) {
                LOGGER.error((Object)("Error occurred during user '" + oldUser + "' modification action"));
                throw new PetalsServiceTechnicalException((Throwable)e);
            }
            catch (FactoryConfigurationError e) {
                LOGGER.error((Object)("Error occurred during user '" + oldUser + "' modification action"));
                throw new PetalsServiceTechnicalException((Throwable)e);
            }
            return true;
        }
        return false;
    }

    public String getUserPassword(String username) throws PetalsServiceFunctionalException, PetalsServiceTechnicalException {
        EntityPrincipal ePrincipal = this.entityExisting(username);
        if (ePrincipal == null) {
            throw new PetalsServiceFunctionalException("User with username '" + username + "' doesn't exist");
        }
        return ePrincipal.getPassword();
    }

    public String[] getUserRoles(String username) throws PetalsServiceFunctionalException, PetalsServiceTechnicalException {
        EntityPrincipal ePrincipal = this.entityExisting(username);
        if (ePrincipal == null) {
            throw new PetalsServiceFunctionalException("User with username '" + username + "' doesn't exist");
        }
        return ePrincipal.getRolesList();
    }

    public Collection<String> getAllUsers() throws PetalsServiceFunctionalException, PetalsServiceTechnicalException {
        HashSet<String> userLogins = new HashSet<String>();
        HashSet entities = new HashSet();
        try {
            URL securityFile = Thread.currentThread().getContextClassLoader().getResource("security.xml");
            entities.addAll(FilerDAOHelper.readConfig((URL)securityFile));
        }
        catch (ParserConfigurationException e) {
            LOGGER.error((Object)"Error occurred during all users recovering");
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error((Object)"Error occurred during all users recovering");
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
        catch (SAXException e) {
            LOGGER.error((Object)"Error occurred during all users recovering");
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
        catch (FactoryConfigurationError e) {
            LOGGER.error((Object)"Error occurred during all users recovering");
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
        if (!entities.isEmpty()) {
            for (EntityPrincipal ePrincipal : entities) {
                userLogins.add(ePrincipal.getName());
            }
        }
        return userLogins;
    }
}

