/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.tools.webconsole.services.security;

import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.Semaphore;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.petals.tools.webconsole.services.AbstractServiceFactory;
import org.ow2.petals.tools.webconsole.services.PetalsService;
import org.ow2.petals.tools.webconsole.services.PetalsServiceTechnicalException;
import org.ow2.petals.tools.webconsole.services.remoteinjector.RemoteInjectorService;
import org.ow2.petals.tools.webconsole.services.security.SecurityService;

public class SecurityServiceFactory
extends AbstractServiceFactory {
    private static final Log LOGGER = LogFactory.getLog(SecurityServiceFactory.class);
    private static SecurityServiceFactory INSTANCE = null;
    private SecurityService service = null;
    private static final Semaphore SEMAPHORE = new Semaphore(1);

    private SecurityServiceFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AbstractServiceFactory getInstance() {
        Semaphore semaphore = SEMAPHORE;
        synchronized (semaphore) {
            if (INSTANCE == null) {
                INSTANCE = new SecurityServiceFactory();
            }
            return INSTANCE;
        }
    }

    public PetalsService getService(String hostname, Integer port, String login, String password) throws PetalsServiceTechnicalException {
        throw new PetalsServiceTechnicalException("Method not implemented yet !");
    }

    public PetalsService getService() throws PetalsServiceTechnicalException {
        if (this.service == null) {
            this.service = this.getImplementation();
        }
        return this.service;
    }

    private SecurityService getImplementation() throws PetalsServiceTechnicalException {
        Class<?>[] interfaces;
        Properties props = new Properties();
        try {
            props.load(Thread.currentThread().getContextClassLoader().getResourceAsStream("services.properties"));
        }
        catch (IOException e) {
            LOGGER.error((Object)"Error occurred during properties loading for the get of security service implementation");
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
        String className = props.getProperty("security.service.impl");
        Class<?> loadedClass = null;
        try {
            loadedClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error((Object)"Error occurred during invoked class returning for the get of security service implementation");
            throw new PetalsServiceTechnicalException((Throwable)e);
        }
        boolean checkSecurityServiceImplementation = Boolean.FALSE;
        for (Class<?> inter : interfaces = loadedClass.getInterfaces()) {
            if (!inter.equals(SecurityService.class)) continue;
            checkSecurityServiceImplementation = Boolean.TRUE;
        }
        if (checkSecurityServiceImplementation) {
            SecurityService securityService = null;
            try {
                securityService = (SecurityService)loadedClass.newInstance();
            }
            catch (InstantiationException e) {
                LOGGER.error((Object)"Error occurred during invoked class instantiation for the get of security service implementation");
                throw new PetalsServiceTechnicalException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                LOGGER.error((Object)"Error occurred during invoked class instantiation for the get of security service implementation");
                throw new PetalsServiceTechnicalException((Throwable)e);
            }
            return securityService;
        }
        LOGGER.error((Object)("Error occurred during the get of security service implementation (" + loadedClass.getName() + " class don't implement " + RemoteInjectorService.class + ")"));
        throw new PetalsServiceTechnicalException(loadedClass.getName() + " don't " + "implement " + RemoteInjectorService.class);
    }
}

