/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.tools.webconsole.services.security.auth;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.petals.tools.webconsole.services.security.auth.EntityPrincipal;
import org.ow2.petals.tools.webconsole.services.security.auth.EntityRolePrincipal;
import org.ow2.petals.tools.webconsole.services.security.util.CipherHelper;
import org.ow2.petals.tools.webconsole.services.security.util.FilerDAOHelper;
import org.xml.sax.SAXException;

public class EntityJAASLoginModule
implements LoginModule {
    public static final String SECURITY_FILE = "security.xml";
    public static final String SECURITY_FILE_SCHEMA = "security.xsd";
    private static final Log LOGGER = LogFactory.getLog(EntityJAASLoginModule.class);
    private CallbackHandler callbackHandler = null;
    private Subject subject = null;
    private Map sharedState;
    private Map options;
    private EntityPrincipal entityPrincipal;
    private EntityRolePrincipal erPrincipal;
    private List<EntityRolePrincipal> erPrincipals = new ArrayList();
    private List<EntityPrincipal> ePrincipals;
    private boolean success = false;
    private boolean commited = false;

    @Override
    public boolean abort() throws LoginException {
        if (!this.success) {
            return false;
        }
        if (!this.commited) {
            this.reset();
        } else {
            this.logout();
        }
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        if (!this.success) {
            this.commited = false;
        } else {
            if (!this.subject.getPrincipals().contains(this.entityPrincipal)) {
                this.subject.getPrincipals().add((Principal)this.entityPrincipal);
            }
            for (EntityRolePrincipal erPrincipal : this.erPrincipals) {
                this.subject.getPrincipals().add((Principal)erPrincipal);
            }
            this.commited = true;
        }
        return this.commited;
    }

    @Override
    public boolean login() throws LoginException {
        if (this.callbackHandler == null) {
            throw new LoginException("Error no callback defined!");
        }
        Callback[] callbacks = new Callback[]{new NameCallback("Login:"), new PasswordCallback("Password:", false)};
        try {
            this.callbackHandler.handle(callbacks);
            String userName = ((NameCallback)callbacks[0]).getName();
            String password = new String(((PasswordCallback)callbacks[1]).getPassword());
            ((PasswordCallback)callbacks[1]).clearPassword();
            this.success = this.authenticate(userName, password);
            callbacks[0] = null;
            callbacks[1] = null;
            return this.success;
        }
        catch (IOException e) {
            LOGGER.error((Object)"Error occurred during login authentication", (Throwable)e);
        }
        catch (UnsupportedCallbackException e) {
            LOGGER.error((Object)"Error occurred during login authentication", (Throwable)e);
        }
        return false;
    }

    @Override
    public boolean logout() throws LoginException {
        for (Principal principal : this.subject.getPrincipals()) {
            this.subject.getPrincipals().remove(principal);
        }
        return true;
    }

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        this.options = options;
    }

    private boolean authenticate(String name, String password) throws LoginException {
        EntityPrincipal ePrincipal;
        boolean passwordMatch = false;
        boolean result = false;
        try {
            ePrincipal = this.retrievePrincipalByName(name);
        }
        catch (MalformedURLException e) {
            LOGGER.error((Object)("Error occurred during authentication of: " + name + "/" + password), (Throwable)e);
            throw new LoginException(e.getMessage());
        }
        catch (IOException e) {
            LOGGER.error((Object)("Error occurred during authentication of: " + name + "/" + password), (Throwable)e);
            throw new LoginException(e.getMessage());
        }
        catch (SAXException e) {
            LOGGER.error((Object)("Error occurred during authentication of: " + name + "/" + password), (Throwable)e);
            throw new LoginException(e.getMessage());
        }
        catch (ParserConfigurationException e) {
            LOGGER.error((Object)("Error occurred during authentication of: " + name + "/" + password), (Throwable)e);
            throw new LoginException(e.getMessage());
        }
        catch (FactoryConfigurationError e) {
            LOGGER.error((Object)("Error occurred during authentication of: " + name + "/" + password), (Throwable)e);
            throw new LoginException(e.getMessage());
        }
        if (ePrincipal != null) {
            String pPassword = ePrincipal.getPassword();
            if (pPassword == null) {
                LOGGER.info((Object)"Incorrect user password");
            }
            String passwordTmp = null;
            try {
                passwordTmp = CipherHelper.encrypt((String)password);
            }
            catch (IOException e) {
                LOGGER.error((Object)"Error occurred during password ciphering in authenticate method", (Throwable)e);
                throw new LoginException(e.getMessage());
            }
            passwordMatch = passwordTmp.equals(pPassword);
            if (passwordMatch) {
                this.entityPrincipal = new EntityPrincipal();
                this.entityPrincipal.setPassword(passwordTmp);
                this.entityPrincipal.setName(ePrincipal.getName());
                this.entityPrincipal.setRoles(ePrincipal.getRoles());
                for (String roleName : ePrincipal.getRolesList()) {
                    this.erPrincipal = EntityRolePrincipal.getPrincipalByName((String)roleName);
                    this.erPrincipals.add(this.erPrincipal);
                }
                result = true;
            }
        }
        return result;
    }

    private EntityPrincipal retrievePrincipalByName(String name) throws MalformedURLException, IOException, SAXException, ParserConfigurationException, FactoryConfigurationError {
        URL securityFile = Thread.currentThread().getContextClassLoader().getResource(SECURITY_FILE);
        Set entities = FilerDAOHelper.readConfig((URL)securityFile);
        if (entities != null && !entities.isEmpty()) {
            for (EntityPrincipal entity : entities) {
                if (!entity.getName().equals(name)) continue;
                return entity;
            }
        }
        return null;
    }

    private void reset() {
        this.success = false;
        this.callbackHandler = null;
        this.subject = null;
        this.commited = false;
    }
}

