/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.tools.webconsole.services.security.auth;

import java.security.Principal;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.petals.tools.webconsole.services.security.auth.EntityCredential;

public class EntityLoginModule
implements LoginModule {
    private static final Log LOGGER = LogFactory.getLog(EntityLoginModule.class);
    final Set<Subject> subjects = new HashSet();
    Subject currentSubject;

    @Override
    public boolean abort() throws LoginException {
        LOGGER.debug((Object)("Abort action has been called for subject: " + this.currentSubject));
        this.currentSubject = null;
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        Set<Object> credentials = this.currentSubject.getPrivateCredentials();
        EntityCredential[] credsTable = credentials.toArray(new EntityCredential[credentials.size()]);
        boolean result = false;
        for (Subject subject : this.subjects) {
            Set<Object> credentialsLoop = subject.getPrivateCredentials();
            EntityCredential[] credsTableLoop = credentialsLoop.toArray(new EntityCredential[credentialsLoop.size()]);
            if (!credsTableLoop[0].getLogin().equals(credsTable[0].getLogin()) || !credsTableLoop[0].getPassword().equals(credsTable[0].getPassword())) continue;
            this.currentSubject = subject;
            result = true;
        }
        if (result) {
            LOGGER.info((Object)("Commit successful for subject [" + credsTable[0].getLogin() + "/" + credsTable[0].getPassword() + "]"));
        } else {
            LOGGER.info((Object)("Commit fail for subject [" + credsTable[0].getLogin() + "/" + credsTable[0].getPassword() + "]"));
        }
        return result;
    }

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        if (subject == null) {
            LOGGER.info((Object)"'subject' parameter must not be null");
            throw new IllegalArgumentException("'subject' parameter must not be null");
        }
        if (sharedState == null) {
            LOGGER.info((Object)"'sharedState' parameter must not be null");
            throw new IllegalArgumentException("'sharedState' parameter must not be null");
        }
        if (sharedState.get("subjects") == null) {
            LOGGER.info((Object)"'sharedState' must contain the subjects list in order to correclty be initialized");
            throw new IllegalArgumentException("'sharedState' must contain the subjects list in order to correclty be initialized");
        }
        this.subjects.clear();
        this.subjects.addAll((Set)sharedState.get("subjects"));
        LOGGER.debug((Object)("Subjects list of login module correctly fill with " + this.subjects.size() + " subjects"));
        this.currentSubject = subject;
    }

    @Override
    public boolean login() throws LoginException {
        Set<Object> privCreds = this.currentSubject.getPrivateCredentials();
        Object cred = privCreds.iterator().next();
        System.out.println(cred);
        Set<Object> credentials = this.currentSubject.getPrivateCredentials();
        EntityCredential[] credsTable = credentials.toArray(new EntityCredential[credentials.size()]);
        for (Subject subjectLoop : this.subjects) {
            Set<Object> credentialsLoop = subjectLoop.getPrivateCredentials();
            EntityCredential[] credsTableLoop = credentialsLoop.toArray(new EntityCredential[credentialsLoop.size()]);
            if (!credsTableLoop[0].getLogin().equals(credsTable[0].getLogin()) || !credsTableLoop[0].getPassword().equals(credsTable[0].getPassword())) continue;
            LOGGER.info((Object)("Login successful for subject [" + credsTable[0].getLogin() + "/" + credsTable[0].getPassword() + "]"));
            return true;
        }
        this.currentSubject = null;
        LOGGER.info((Object)("Login fail for subject [" + credsTable[0].getLogin() + "/" + credsTable[0].getPassword() + "]"));
        return false;
    }

    @Override
    public boolean logout() throws LoginException {
        LOGGER.debug((Object)("Logout action has been called for subject: " + this.currentSubject));
        this.currentSubject = null;
        return true;
    }

    public Collection<? extends Principal> recoverPrincipals(String login, String password) {
        return this.currentSubject.getPrincipals();
    }

    public void updateSubjects(Set<Subject> updatedSubject) throws LoginException {
        this.subjects.clear();
        this.subjects.addAll(updatedSubject);
        LOGGER.debug((Object)("Subjects list of login module correctly fill with " + this.subjects.size() + " subjects"));
        this.login();
    }
}

