/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.tools.webconsole.services.security.util;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.opensuit.xmlmap.XmlInstantiator;
import org.ow2.opensuit.xmlmap.XmlSerializer;
import org.ow2.opensuit.xmlmap.schema.SchemasManager;
import org.ow2.petals.tools.webconsole.services.security.auth.EntityPrincipal;
import org.ow2.petals.tools.webconsole.services.security.auth.EntityPrincipals;
import org.ow2.petals.tools.webconsole.utils.GeneralHelper;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class FilerDAOHelper {
    private static final Log LOGGER = LogFactory.getLog(FilerDAOHelper.class);

    private FilerDAOHelper() {
    }

    public static final Set<EntityPrincipal> readConfig(URL securityFile) throws MalformedURLException, IOException, SAXException, ParserConfigurationException, FactoryConfigurationError {
        LOGGER.debug((Object)("Reading of security file locate at: " + securityFile));
        XmlInstantiator xi = XmlInstantiator.instantiate((URL)securityFile, null);
        EntityPrincipals entities = (EntityPrincipals)xi.getRoot();
        HashSet<EntityPrincipal> eSet = new HashSet<EntityPrincipal>();
        if (entities.getEntityPrincipals() != null && entities.getEntityPrincipals().length > 0) {
            LOGGER.debug((Object)(entities.getEntityPrincipals().length + " entities recovered from security file"));
            for (EntityPrincipal entity : entities.getEntityPrincipals()) {
                eSet.add(entity);
            }
        } else {
            LOGGER.debug((Object)"No entities recovered from security file");
        }
        return eSet;
    }

    public static final void writeConfiguration(String instanceFileName, String schemafileName, Set<EntityPrincipal> eSet) throws ParserConfigurationException, IOException, URISyntaxException {
        LOGGER.debug((Object)("Writting of security file locate at: " + instanceFileName));
        File securityFile = new File(Thread.currentThread().getContextClassLoader().getResource(instanceFileName).toURI().getPath());
        File schema = new File(Thread.currentThread().getContextClassLoader().getResource(schemafileName).toURI().getPath());
        EntityPrincipals entities = new EntityPrincipals();
        entities.setEntityPrincipals(eSet.toArray(new EntityPrincipal[eSet.size()]));
        SchemasManager schemasManager = new SchemasManager();
        schemasManager.declareSchema("ns", schema.getPath(), "org.ow2.petals.tools.webconsole.services.security.auth");
        XmlSerializer xs = XmlSerializer.serialize((SchemasManager)schemasManager, (Object)entities);
        try {
            GeneralHelper.writeXmlFile((Document)xs.getDocument(), (File)securityFile);
        }
        catch (TransformerException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Error occurred during modify SOAP WSDL Address", (Throwable)e);
            }
            LOGGER.warn((Object)("Error occurred during modify SOAP WSDL Address: " + e.getMessage()));
        }
        LOGGER.debug((Object)(eSet.size() + " of entities have been written in security file"));
    }
}

