/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.tools.webconsole.services.utils;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.naming.ServiceUnavailableException;
import javax.security.auth.login.FailedLoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.petals.jmx.JMXClient;
import org.ow2.petals.jmx.exception.ConnectionErrorException;
import org.ow2.petals.tools.webconsole.services.PetalsServiceTechnicalException;
import org.ow2.petals.tools.webconsole.services.management.pooling.CleaningWorker;
import org.ow2.petals.tools.webconsole.services.management.pooling.ClientContext;

/*
 * Exception performing whole class analysis ignored.
 */
public final class ConnectionHelper {
    private static final Log LOGGER = LogFactory.getLog(ConnectionHelper.class);
    private static final Set<ClientContext> CLIENTCONTEXTSET = Collections.synchronizedSet(new HashSet());
    private static final Thread WORKER = new Thread((Runnable)new CleaningWorker());

    private ConnectionHelper() {
    }

    public static JMXClient connect(String hostname, Integer port, String login, String password, boolean reinitialize) throws PetalsServiceTechnicalException {
        JMXClient jmxClient = null;
        if (reinitialize) {
            jmxClient = ConnectionHelper.connectionInstanciator((String)hostname, (Integer)port, (String)login, (String)password);
            LOGGER.debug((Object)("JMX connection reinitialization performed for: " + hostname + "/" + port + " server"));
        } else {
            jmxClient = ConnectionHelper.checkPoolConnections((String)hostname, (Integer)port, (String)login, (String)password);
            if (jmxClient == null) {
                jmxClient = ConnectionHelper.connectionInstanciator((String)hostname, (Integer)port, (String)login, (String)password);
            } else {
                LOGGER.debug((Object)("JMX client : " + hostname + "/" + port + " already exsist in connection pool"));
            }
        }
        return jmxClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JMXClient checkPoolConnections(String hostname, Integer port, String login, String password) {
        StringBuilder builder = new StringBuilder();
        builder.append(hostname).append(":").append(port);
        Set set = CLIENTCONTEXTSET;
        synchronized (set) {
            for (ClientContext clientContext : CLIENTCONTEXTSET) {
                if (!clientContext.getId().equals(builder.toString())) continue;
                clientContext.setState(true);
                LOGGER.debug((Object)(clientContext.getId() + " client context always used, its state remains true"));
                return clientContext.getJmxClient();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JMXClient connectionInstanciator(String hostname, Integer port, String login, String password) throws PetalsServiceTechnicalException {
        JMXClient jmxClient = null;
        ClientContext clientContext = null;
        try {
            jmxClient = new JMXClient(hostname, port, login, password);
            clientContext = new ClientContext(jmxClient, hostname + ":" + port);
            LOGGER.debug((Object)("New client context [id:" + clientContext.getId() + "] : " + hostname + "/" + port + " was created "));
            Set set = CLIENTCONTEXTSET;
            synchronized (set) {
                CLIENTCONTEXTSET.add(clientContext);
                LOGGER.debug((Object)("Client context stored in connection pool, the set have now " + CLIENTCONTEXTSET.size() + " items"));
            }
            return jmxClient;
        }
        catch (ConnectionErrorException e) {
            Set set;
            if (e.getCause().getCause().getClass().equals(ServiceUnavailableException.class) && e.getCause().getMessage().contains("Failed to retrieve RMIServer stub")) {
                LOGGER.warn((Object)("Fail to retrieve RMIServer stub for connection: " + hostname + "/" + port + ", check if server isn't down"));
            }
            StringBuffer errMsg = new StringBuffer("Can't connect to Petals server on " + hostname + ":" + port);
            if (e.getCause() != null && e.getCause().getCause() != null && e.getCause().getCause() instanceof FailedLoginException) {
                errMsg.append(" - Invalid username or password");
                LOGGER.warn((Object)("Can't connect to Petals server on " + hostname + ":" + port + " because invalid username or password"));
            } else {
                LOGGER.warn((Object)("Can't connect to Petals server on " + hostname + ":" + port));
            }
            if (clientContext == null) {
                set = CLIENTCONTEXTSET;
                synchronized (set) {
                    for (ClientContext cc : CLIENTCONTEXTSET) {
                        if (!cc.getId().equals(hostname + ":" + port)) continue;
                        clientContext = cc;
                    }
                }
            }
            if (clientContext != null) {
                try {
                    clientContext.getJmxClient().disconnect();
                }
                catch (ConnectionErrorException e1) {
                    // empty catch block
                }
                set = CLIENTCONTEXTSET;
                synchronized (set) {
                    CLIENTCONTEXTSET.remove(clientContext);
                }
            }
            throw new PetalsServiceTechnicalException(errMsg.toString(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<ClientContext> getClientContextSet() {
        Set set = CLIENTCONTEXTSET;
        synchronized (set) {
            return CLIENTCONTEXTSET;
        }
    }

    static {
        WORKER.setName("CleaningWorker-" + WORKER.getId());
        WORKER.start();
    }
}

