/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.tools.webconsole.services.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class FilePermissionHelper {
    private static final Log LOGGER = LogFactory.getLog(FilePermissionHelper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setRights(File file, int[] rights, boolean asynch) throws IOException {
        if (file == null) {
            throw new IOException("File cannot be null");
        }
        if (rights.length != 3) {
            throw new IllegalArgumentException("rights[] must be 3 example: [7][7][7]");
        }
        for (int i : rights) {
            if (i >= 0 || i <= 7) continue;
            throw new IllegalArgumentException("Rights must be -1<r<8 ");
        }
        Runtime runtime = Runtime.getRuntime();
        String command = null;
        if (System.getProperty("os.name").equals("Linux")) {
            command = "chmod -R " + rights[0] + rights[1] + rights[2] + " " + file.getAbsolutePath();
        }
        if (System.getProperty("os.name").equals("Windows")) {
            // empty if block
        }
        if (command != null && runtime != null) {
            Process process = runtime.exec(command);
            if (!asynch) {
                Process process2 = process;
                synchronized (process2) {
                    try {
                        process.waitFor();
                    }
                    catch (InterruptedException e) {
                        LOGGER.error((Object)"Error occurred during setting rigths", (Throwable)e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setRightInZip(File zip, int[] rights, boolean asynch) throws IOException {
        Runtime runtime = Runtime.getRuntime();
        StringBuilder command = new StringBuilder();
        String dirPath = zip.getAbsolutePath().substring(0, zip.getAbsolutePath().length() - 4);
        if (System.getProperty("os.name").equals("Linux")) {
            command.append("unzip -X ").append(zip.getAbsolutePath()).append(" -d ").append(dirPath);
        }
        if (System.getProperty("os.name").equals("Windows")) {
            // empty if block
        }
        Process process = null;
        if (command != null && runtime != null) {
            process = runtime.exec(command.toString());
            if (!asynch) {
                Process process2 = process;
                synchronized (process2) {
                    try {
                        process.waitFor();
                    }
                    catch (InterruptedException e) {
                        LOGGER.error((Object)"Error occurred during setting rigths in zip archive", (Throwable)e);
                    }
                }
            }
        }
        if (System.getProperty("os.name").equals("Linux")) {
            command.delete(0, command.length());
            command.append("zip -r ").append(zip.getAbsolutePath());
        }
        if (System.getProperty("os.name").equals("Windows")) {
            // empty if block
        }
        File directory = new File(dirPath);
        ArrayList<String> files = new ArrayList<String>();
        for (File f : directory.listFiles()) {
            FilePermissionHelper.setRights((File)f, (int[])rights, (boolean)false);
            command.append(" ").append(f.getCanonicalPath());
            if (f.isDirectory()) continue;
            files.add(f.getName());
        }
        String zipAbsolutePath = zip.getAbsolutePath();
        if (!zip.delete()) {
            LOGGER.warn((Object)("Unable to delete zip file: " + zip.getPath()));
        }
        for (File f : directory.listFiles()) {
            if (!f.getName().equals("home") || f.delete()) continue;
            LOGGER.warn((Object)("Unable to delete file: " + zip.getPath()));
        }
        String zipPath = zip.getAbsolutePath().substring(0, zip.getAbsolutePath().indexOf(".zip"));
        command.delete(0, command.length());
        command.append("zip -r ").append(zip.getAbsolutePath()).append(" ").append(zipPath);
        if (command != null && runtime != null) {
            process = runtime.exec(command.toString());
            if (!asynch) {
                Process process3 = process;
                synchronized (process3) {
                    try {
                        process.waitFor();
                    }
                    catch (InterruptedException e) {
                        LOGGER.error((Object)"Error occurred during setting rights in zip archive", (Throwable)e);
                    }
                }
            }
        }
        FilePermissionHelper.creationZip((String)zipAbsolutePath, (String[])files.toArray(new String[files.size()]));
        command = null;
        dirPath = null;
        directory = null;
    }

    private static void creationZip(String zipPath, String[] cheminsFichiers) {
        int BUFFER = 2048;
        try {
            BufferedInputStream origin = null;
            FileOutputStream dest = new FileOutputStream(zipPath);
            ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(dest));
            byte[] data = new byte[BUFFER];
            for (int i = 0; i < cheminsFichiers.length; ++i) {
                int count;
                LOGGER.info((Object)("Adding: " + cheminsFichiers[i]));
                FileInputStream fi = new FileInputStream(cheminsFichiers[i]);
                origin = new BufferedInputStream(fi, BUFFER);
                ZipEntry entry = new ZipEntry(cheminsFichiers[i]);
                out.putNextEntry(entry);
                while ((count = origin.read(data, 0, BUFFER)) != -1) {
                    out.write(data, 0, count);
                }
                origin.close();
            }
            out.close();
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error occurred during creation zip archive", (Throwable)e);
        }
    }
}

