/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.tools.webconsole.to;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ow2.petals.tools.webconsole.to.ServerTO;

public final class DomainTO
implements Serializable {
    private static final long serialVersionUID = -6264947815285973578L;
    private String name;
    private String description;
    private List<ServerTO> servers;
    private String mode;
    private String topologyType;
    private boolean networkSynchronized;

    public final String getName() {
        return this.name;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public final List<ServerTO> getServers() {
        Collections.sort(this.servers);
        return this.servers;
    }

    public final void setServers(List<ServerTO> servers) {
        this.servers = servers;
    }

    public final String getDescription() {
        return this.description;
    }

    public final void setDescription(String description) {
        this.description = description;
    }

    public final boolean isNetworkSynchronized() {
        return this.networkSynchronized;
    }

    public final void setNetworkSynchronized(boolean networkSynchronized) {
        this.networkSynchronized = networkSynchronized;
    }

    public final String getTopologyType() {
        return this.topologyType;
    }

    public final void setTopologyType(String topologyType) {
        this.topologyType = topologyType;
    }

    public final String getMode() {
        return this.mode;
    }

    public final void setMode(String mode) {
        this.mode = mode;
    }

    public DomainTO() {
        this.servers = new ArrayList();
    }

    public DomainTO(String description, String mode, String name, boolean networkSynchronized, List<ServerTO> servers, String topologyType) {
        this.description = description;
        this.mode = mode;
        this.name = name;
        this.networkSynchronized = networkSynchronized;
        this.servers = servers;
        this.topologyType = topologyType;
    }

    public final ServerTO findServer(String serverName) {
        for (ServerTO server : this.servers) {
            if (!server.getName().equals(serverName)) continue;
            return server;
        }
        return null;
    }

    public final ServerTO findServerbyHost(String serverHost) {
        for (ServerTO server : this.servers) {
            if (!server.getHost().equals(serverHost)) continue;
            return server;
        }
        return null;
    }

    public final ServerTO findRemoteServer() {
        for (ServerTO server : this.servers) {
            if (!server.isInstalledRemoteComponent()) continue;
            return server;
        }
        return null;
    }

    public final ServerTO findServerByConnectionParameters(String host, String port, String login, String password) {
        for (ServerTO server : this.servers) {
            if (!server.getHost().equals(host) || !server.getPort().equals(port) || !server.getLogin().equals(login) || !server.getPassword().equals(password)) continue;
            return server;
        }
        return null;
    }
}

