/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.tools.webconsole.to;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.ow2.petals.tools.webconsole.to.ComponentTO;
import org.ow2.petals.tools.webconsole.to.EndPointTO;
import org.ow2.petals.tools.webconsole.to.ExchangeFilterTO;
import org.ow2.petals.tools.webconsole.to.ServiceAssemblyTO;

public final class ServerTO
implements Comparable<ServerTO>,
Serializable {
    private static final long serialVersionUID = 6665379156435439615L;
    private String host;
    private String state;
    private String port;
    private int remotePort;
    private String remoteContext;
    private String login;
    private String password;
    private boolean installedRemoteComponent;
    private String name;
    private String description;
    private String version;
    private String confTransportTCPPort;
    private String confTransportSSLPort;
    private String confTransportHTTPPort;
    private String domainName;
    private String showMessageContent;
    private List<ComponentTO> bindingComponents = new ArrayList();
    private List<ComponentTO> serviceEngines = new ArrayList();
    private List<ServiceAssemblyTO> serviceAssemblies = new ArrayList();
    private List<EndPointTO> endpoints;
    private List<ExchangeFilterTO> filters;
    private List<String> sharedLibraries = new ArrayList();
    private boolean available;
    public static final String STARTED_STATE = "STARTED";
    public static final String STOPPED_STATE = "STOPPED";

    public final String getName() {
        return this.name;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public final String getDescription() {
        return this.description;
    }

    public final void setDescription(String description) {
        this.description = description;
    }

    public final String getVersion() {
        return this.version;
    }

    public final void setVersion(String version) {
        this.version = version;
    }

    public final String getHost() {
        return this.host;
    }

    public final void setHost(String host) {
        this.host = host;
    }

    public final String getState() {
        return this.state;
    }

    public final void setState(String state) {
        this.state = state;
    }

    public final String getPort() {
        return this.port;
    }

    public final void setPort(String port) {
        this.port = port;
    }

    public final String getLogin() {
        return this.login;
    }

    public final void setLogin(String login) {
        this.login = login;
    }

    public final String getPassword() {
        return this.password;
    }

    public final void setPassword(String password) {
        this.password = password;
    }

    public final String getShowMessageContent() {
        return this.showMessageContent;
    }

    public final void setShowMessageContent(String showMessageContent) {
        this.showMessageContent = showMessageContent;
    }

    public final List<ComponentTO> getBindingComponents() {
        return this.bindingComponents;
    }

    public final void setBindingComponents(List<ComponentTO> bindingComponents) {
        this.bindingComponents = bindingComponents;
    }

    public final List<ComponentTO> getServiceEngines() {
        return this.serviceEngines;
    }

    public final void setServiceEngines(List<ComponentTO> serviceEngines) {
        this.serviceEngines = serviceEngines;
    }

    public final List<String> getSharedLibraries() {
        return this.sharedLibraries;
    }

    public final void setSharedLibraries(List<String> sharedLibraries) {
        this.sharedLibraries = sharedLibraries;
    }

    public ServerTO() {
        this.endpoints = new ArrayList();
        this.filters = new ArrayList();
    }

    public final List<ServiceAssemblyTO> getServiceAssemblies() {
        return this.serviceAssemblies;
    }

    public final void setServiceAssemblies(List<ServiceAssemblyTO> serviceAssemblies) {
        this.serviceAssemblies = serviceAssemblies;
    }

    public final String getDomainName() {
        return this.domainName;
    }

    public final void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public final boolean isInstalledRemoteComponent() {
        return this.installedRemoteComponent;
    }

    public final void setInstalledRemoteComponent(boolean installedRemoteComponent) {
        this.installedRemoteComponent = installedRemoteComponent;
    }

    public final int getRemotePort() {
        return this.remotePort;
    }

    public final void setRemotePort(int remotePort) {
        this.remotePort = remotePort;
    }

    public final String getRemoteContext() {
        return this.remoteContext;
    }

    public final void setRemoteContext(String remoteContext) {
        this.remoteContext = remoteContext;
    }

    @Override
    public final int compareTo(ServerTO serverTO) {
        return this.name.compareTo(serverTO.getName());
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.available ? 1231 : 1237);
        result = 31 * result + (this.bindingComponents == null ? 0 : ((Object)this.bindingComponents).hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.domainName == null ? 0 : this.domainName.hashCode());
        result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
        result = 31 * result + (this.installedRemoteComponent ? 1231 : 1237);
        result = 31 * result + (this.login == null ? 0 : this.login.hashCode());
        result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
        result = 31 * result + (this.port == null ? 0 : this.port.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.remoteContext == null ? 0 : this.remoteContext.hashCode());
        result = 31 * result + this.remotePort;
        result = 31 * result + (this.serviceAssemblies == null ? 0 : ((Object)this.serviceAssemblies).hashCode());
        result = 31 * result + (this.serviceEngines == null ? 0 : ((Object)this.serviceEngines).hashCode());
        result = 31 * result + (this.sharedLibraries == null ? 0 : ((Object)this.sharedLibraries).hashCode());
        result = 31 * result + (this.showMessageContent == null ? 0 : this.showMessageContent.hashCode());
        result = 31 * result + (this.state == null ? 0 : this.state.hashCode());
        result = 31 * result + (this.confTransportHTTPPort == null ? 0 : this.confTransportHTTPPort.hashCode());
        result = 31 * result + (this.confTransportSSLPort == null ? 0 : this.confTransportSSLPort.hashCode());
        result = 31 * result + (this.confTransportTCPPort == null ? 0 : this.confTransportTCPPort.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public final boolean equals(Object obj) {
        boolean result;
        if (this == obj) {
            boolean bl = true;
        }
        if (obj == null) {
            result = false;
        } else {
            ServerTO other;
            if (this.getClass() != obj.getClass()) {
                result = false;
            }
            result = this.domainName.equals((other = (ServerTO)obj).getDomainName()) && this.name.equals(other.getName());
        }
        return result;
    }

    public final boolean isAvailable() {
        return this.available;
    }

    public final void setAvailable(boolean available) {
        this.available = available;
    }

    public final String getConfTransportTCPPort() {
        return this.confTransportTCPPort;
    }

    public final void setConfTransportTCPPort(String confTransportTCPPort) {
        this.confTransportTCPPort = confTransportTCPPort;
    }

    public final String getConfTransportSSLPort() {
        return this.confTransportSSLPort;
    }

    public final void setConfTransportSSLPort(String confTransportSSLPort) {
        this.confTransportSSLPort = confTransportSSLPort;
    }

    public final String getConfTransportHTTPPort() {
        return this.confTransportHTTPPort;
    }

    public final void setConfTransportHTTPPort(String confTransportHTTPPort) {
        this.confTransportHTTPPort = confTransportHTTPPort;
    }

    public final List<EndPointTO> getEndpoints() {
        return this.endpoints;
    }

    public final void setEndpoints(List<EndPointTO> endpoints) {
        this.endpoints = endpoints;
    }

    public final List<ExchangeFilterTO> getFilters() {
        if (this.filters == null) {
            this.filters = new ArrayList();
        }
        return this.filters;
    }

    public final void setFilters(List<ExchangeFilterTO> filters) {
        this.filters = filters;
    }

    public final ExchangeFilterTO getExchangeFilter(String uuid) {
        for (ExchangeFilterTO filter : this.filters) {
            if (!filter.getUuid().toString().equals(uuid)) continue;
            return filter;
        }
        return null;
    }

    public final boolean filterAlreadyCreated(ExchangeFilterTO filter) {
        for (ExchangeFilterTO filterTO : this.filters) {
            if (!filterTO.getEndpointName().equals(filter.getEndpointName()) || !filterTO.getInterfaceName().equals(filter.getInterfaceName()) || !filterTO.getOperationName().equals(filter.getOperationName()) || !filterTO.getServiceName().equals(filter.getServiceName()) || filterTO.isStoreExchanges() != filter.isStoreExchanges()) continue;
            return true;
        }
        return false;
    }

    public final EndPointTO getEndpoint(String selectedEndpointName, String selectedServiceName) {
        for (EndPointTO endPointTO : this.endpoints) {
            if (!(selectedEndpointName != null && !selectedEndpointName.equals("") && !selectedEndpointName.equals("null") && selectedServiceName != null && !selectedServiceName.equals("") && !selectedServiceName.equals("null") ? endPointTO.getName().equals(selectedEndpointName) && endPointTO.getService().toString().equals(selectedServiceName) : (selectedEndpointName != null && !selectedEndpointName.equals("") && !selectedEndpointName.equals("null") && (selectedServiceName == null || selectedServiceName.equals("") || selectedServiceName.equals("null")) ? endPointTO.getName().equals(selectedEndpointName) : selectedServiceName != null && !selectedServiceName.equals("") && !selectedServiceName.equals("null") && (selectedEndpointName == null || selectedEndpointName.equals("") || selectedEndpointName.equals("null")) && endPointTO.getService().toString().equals(selectedServiceName)))) continue;
            return endPointTO;
        }
        return null;
    }

    public final void removeFilter(ExchangeFilterTO exchangefilterTO) {
        ExchangeFilterTO filterToDelete = null;
        for (ExchangeFilterTO filterTO : this.filters) {
            if (!filterTO.getEndpointName().equals(exchangefilterTO.getEndpointName()) || !filterTO.getInterfaceName().equals(exchangefilterTO.getInterfaceName()) || !filterTO.getOperationName().equals(exchangefilterTO.getOperationName()) || !filterTO.getServiceName().equals(exchangefilterTO.getServiceName()) || filterTO.isStoreExchanges() != exchangefilterTO.isStoreExchanges()) continue;
            filterToDelete = filterTO;
        }
        if (filterToDelete != null) {
            this.filters.remove(filterToDelete);
        }
    }
}

