/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.tools.webconsole.uibeans;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.opensuit.core.error.NonLocalizedError;
import org.ow2.opensuit.core.impl.context.OpenSuitSessionImpl;
import org.ow2.opensuit.core.session.OpenSuitSession;
import org.ow2.opensuit.core.session.PageContext;
import org.ow2.opensuit.xml.base.page.ctx.IPageContextDef;
import org.ow2.petals.tools.webconsole.business.AdvancedManagementBBean;
import org.ow2.petals.tools.webconsole.to.ServerTO;
import org.ow2.petals.tools.webconsole.uibeans.ManagementUIBean;
import org.ow2.petals.tools.webconsole.uibeans.utils.UIResult;

public class AdvancedManagementUIBean {
    private static final Log LOGGER = LogFactory.getLog(AdvancedManagementUIBean.class);
    public static final String ERROR_COUNTER_KEY = "Error";
    public static final String DONE_COUNTER_KEY = "Done";
    public static final String PENDING_COUNTER_KEY = "Pending/Active";
    public static final String PERCENTILE_10_KEY = "Percentile 10 of response duration";
    public static final String PERCENTILE_50_KEY = "Percentile 50 of response duration";
    public static final String PERCENTILE_90_KEY = "Percentile 90 of response duration";
    public static final String MIN_TIME_KEY = "Min time response";
    public static final String MAX_TIME_KEY = "Max time response";
    private final Map<String, Long> statisticInfos;
    private long resetPeriod = 300000L;
    private long oldResetPeriod = 300000L;
    private long intervalTime = 30000L;
    private long oldIntervaleTime = 30000L;
    private long chartTime = 0L;
    private AdvancedManagementBBean businessBean;
    private Map<String, Integer> monitoringMap = new HashMap();
    private QName serviceName;
    private String endpointName;
    private ServerTO currentServer;

    public AdvancedManagementUIBean() {
        this.statisticInfos = new HashMap();
        this.monitoringMap.put(ERROR_COUNTER_KEY, 0);
        this.monitoringMap.put(DONE_COUNTER_KEY, 0);
        this.monitoringMap.put(PENDING_COUNTER_KEY, 0);
        this.statisticInfos.put(PERCENTILE_10_KEY, 0L);
        this.statisticInfos.put(PERCENTILE_50_KEY, 0L);
        this.statisticInfos.put(PERCENTILE_90_KEY, 0L);
        this.statisticInfos.put(MIN_TIME_KEY, 0L);
        this.statisticInfos.put(MAX_TIME_KEY, 0L);
        this.chartTime = System.currentTimeMillis();
    }

    public void load(HttpServletRequest request) throws NonLocalizedError {
        this.serviceName = QName.valueOf(request.getParameter("serviceName"));
        this.endpointName = request.getParameter("endpointName");
        ManagementUIBean managementUIBean = (ManagementUIBean)request.getSession().getAttribute("managementUIBean");
        this.currentServer = managementUIBean.getDomain().findServer(managementUIBean.getCurrentServerName());
        this.businessBean = new AdvancedManagementBBean(this.serviceName, this.endpointName, this.currentServer);
        this.chartTime = System.currentTimeMillis();
        OpenSuitSessionImpl ossi = (OpenSuitSessionImpl)OpenSuitSession.getCurrentSession();
        PageContext pci = ossi.getCurrentPageContext();
        IPageContextDef ipcd = pci.getContextDefinition();
        try {
            Field pageField = ipcd.getClass().getDeclaredField("page");
            pageField.setAccessible(true);
            Object c = pageField.get(ipcd);
            Field refreshField = c.getClass().getSuperclass().getDeclaredField("refresh");
            refreshField.setAccessible(true);
            this.intervalTime = refreshField.getInt(c) * 1000;
        }
        catch (SecurityException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Error occurred during loading interval time", (Throwable)e);
            } else {
                LOGGER.warn((Object)("Error occurred during loading interval time: " + e.getMessage()));
            }
        }
        catch (NoSuchFieldException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Error occurred during loading interval time", (Throwable)e);
            } else {
                LOGGER.warn((Object)("Error occurred during loading interval time: " + e.getMessage()));
            }
        }
        catch (IllegalArgumentException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Error occurred during loading reset perdiod and interval time", (Throwable)e);
            } else {
                LOGGER.warn((Object)("Error occurred during loading reset perdiod and interval time: " + e.getMessage()));
            }
        }
        catch (IllegalAccessException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Error occurred during loading reset perdiod and interval time", (Throwable)e);
            }
            LOGGER.warn((Object)("Error occurred during loading reset perdiod and interval time: " + e.getMessage()));
        }
    }

    public List<String> getChartStatus() {
        return new ArrayList<String>(this.monitoringMap.keySet());
    }

    public List<String> getTableStatus() {
        ArrayList<String> status = new ArrayList<String>(this.monitoringMap.keySet());
        status.add("All");
        Collections.sort(status);
        return status;
    }

    public List<String> getTableInfos() {
        ArrayList<String> infos = new ArrayList<String>(this.statisticInfos.keySet());
        Collections.sort(infos);
        return infos;
    }

    public final String getServiceName() {
        return this.serviceName.toString();
    }

    public final String getEndpointName() {
        return this.endpointName;
    }

    public Integer getChartStatusValue(String itStatus) {
        return (Integer)this.monitoringMap.get(itStatus);
    }

    public Integer getTableStatusValue(String status) {
        Integer result = 0;
        if (!"All".equals(status)) {
            result = (Integer)this.monitoringMap.get(status);
        } else {
            Collection values = this.monitoringMap.values();
            for (Integer value : values) {
                result = result + value;
            }
        }
        return result;
    }

    public Long getTableInfosValue(String info) {
        return (Long)this.statisticInfos.get(info);
    }

    public final long getIntervalTime() {
        return this.intervalTime;
    }

    public final long getChartTime() throws Exception {
        this.chartTime = System.currentTimeMillis();
        this.doPreRendering();
        return this.chartTime;
    }

    public void doPreRendering() throws Exception {
    }

    public final long getResetPeriod() {
        return this.resetPeriod;
    }

    public final void setResetPeriod(long resetPeriod) {
        this.oldResetPeriod = this.resetPeriod;
        this.resetPeriod = resetPeriod;
    }

    public String updateParameters() {
        if (this.oldIntervaleTime != this.intervalTime) {
            OpenSuitSessionImpl ossi = (OpenSuitSessionImpl)OpenSuitSession.getCurrentSession();
            PageContext pci = ossi.getCurrentPageContext();
            IPageContextDef ipcd = pci.getContextDefinition();
            try {
                Field pageField = ipcd.getClass().getDeclaredField("page");
                pageField.setAccessible(true);
                Object c = pageField.get(ipcd);
                Field refreshField = c.getClass().getSuperclass().getDeclaredField("refresh");
                refreshField.setAccessible(true);
                refreshField.setInt(c, Integer.valueOf(Long.toString(this.intervalTime / 1000L)));
            }
            catch (IllegalArgumentException e) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"Error occurred during update interval time", (Throwable)e);
                } else {
                    LOGGER.warn((Object)("Error occurred during update interval time: " + e.getMessage()));
                }
            }
            catch (IllegalAccessException e) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"Error occurred during update interval time", (Throwable)e);
                } else {
                    LOGGER.warn((Object)("Error occurred during update interval time: " + e.getMessage()));
                }
            }
            catch (SecurityException e) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"Error occurred during update interval time", (Throwable)e);
                } else {
                    LOGGER.warn((Object)("Error occurred during update interval time: " + e.getMessage()));
                }
            }
            catch (NoSuchFieldException e) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"Error occurred during update interval time", (Throwable)e);
                }
                LOGGER.warn((Object)("Error occurred during update interval time: " + e.getMessage()));
            }
        }
        return UIResult.SUCCESS.getValue();
    }

    public final void setIntervalTime(long intervalTime) {
        this.oldIntervaleTime = this.intervalTime;
        this.intervalTime = intervalTime;
    }
}

