/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.tools.webconsole.uibeans;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.opensuit.core.error.NonLocalizedError;
import org.ow2.petals.tools.webconsole.business.AdvancedMonitoringBBean;
import org.ow2.petals.tools.webconsole.services.PetalsServiceTechnicalException;
import org.ow2.petals.tools.webconsole.to.DomainTO;
import org.ow2.petals.tools.webconsole.to.ServerTO;
import org.ow2.petals.tools.webconsole.uibeans.ManagementUIBean;
import org.ow2.petals.tools.webconsole.uibeans.utils.UIResult;

public class AdvancedMonitoringUIBean
implements Serializable {
    private static final long serialVersionUID = -7385393191630988634L;
    private static final Log LOGGER = LogFactory.getLog(AdvancedMonitoringUIBean.class);
    private List<String> exchangeIds = new ArrayList();
    private final AdvancedMonitoringBBean advancedMonitoringBBean = new AdvancedMonitoringBBean();
    private String correlationId;
    private ServerTO currentServer;
    private String searchingValue;
    private String searchingType;
    private static final String[] SEARCHINGTYPES = new String[]{"correlationID", "exchangeID"};

    public List<String> getExchangeIds() {
        return this.exchangeIds;
    }

    public void setExchangeIds(List<String> exchangeIds) {
        this.exchangeIds = exchangeIds;
    }

    public String getSearchingValue() {
        return this.searchingValue;
    }

    public void setSearchingValue(String searchingValue) {
        this.searchingValue = searchingValue;
    }

    public String getSearchingType() {
        return this.searchingType;
    }

    public void setSearchingType(String searchingType) {
        this.searchingType = searchingType;
    }

    public static String[] getSearchingTypes() {
        return SEARCHINGTYPES;
    }

    public String search(HttpServletRequest request) {
        if (this.searchingType.equals(SEARCHINGTYPES[0])) {
            this.correlationId = this.searchingValue;
            return UIResult.CORRELATIONSEARCHSUCCESS.getValue();
        }
        request.getSession().setAttribute("exchangeId", (Object)this.searchingValue);
        return UIResult.EXCHANGESEARCHSUCCESS.getValue();
    }

    public String getRecoverCommonFlowForExchange(HttpServletRequest request) throws NonLocalizedError {
        DomainTO domain;
        String serverName;
        ManagementUIBean managementUIBean;
        if (request.getParameter("correlationId") != null) {
            this.correlationId = request.getParameter("correlationId");
        }
        if ((managementUIBean = (ManagementUIBean)request.getSession().getAttribute("managementUIBean")) != null && (serverName = request.getParameter("serverName")) != null && !serverName.equals("") && (domain = managementUIBean.getDomain()) != null) {
            this.currentServer = domain.findServer(serverName);
        }
        try {
            this.exchangeIds = this.advancedMonitoringBBean.getCommonFlowExchangeIds(this.currentServer.getHost(), Integer.parseInt(this.currentServer.getPort()), this.currentServer.getLogin(), this.currentServer.getPassword(), this.correlationId);
        }
        catch (NumberFormatException e) {
            LOGGER.error((Object)"Error occurred during exchanges for common flow recovering", (Throwable)e);
            NonLocalizedError error = new NonLocalizedError(ManagementUIBean.NUMBER_FORMAT_ERROR, "The port value: " + this.currentServer.getPort() + " is not properly formatted");
            error.setType((short)0);
            throw error;
        }
        catch (PetalsServiceTechnicalException e) {
            LOGGER.error((Object)"Error occurred during exchanges for common flow recovering", (Throwable)e);
            throw new NonLocalizedError(ManagementUIBean.PETALS_SERVICE_ERROR, e.getLocalizedMessage(), (Throwable)e);
        }
        if (this.exchangeIds != null) {
            return UIResult.SUCCESS.getValue();
        }
        return UIResult.ERROR.getValue();
    }

    public String getCorrelationId(ServerTO currentServer, String exchangeId, HttpServletRequest request) throws NonLocalizedError {
        this.currentServer = currentServer;
        if (this.currentServer == null) {
            this.currentServer = (ServerTO)request.getSession().getAttribute("connectedServer");
        }
        try {
            return this.advancedMonitoringBBean.getCorrelationId(this.currentServer.getHost(), Integer.parseInt(this.currentServer.getPort()), this.currentServer.getLogin(), this.currentServer.getPassword(), exchangeId);
        }
        catch (NumberFormatException e) {
            LOGGER.error((Object)"Error occurred during correlation id recovering", (Throwable)e);
            NonLocalizedError error = new NonLocalizedError(ManagementUIBean.NUMBER_FORMAT_ERROR, "The port value: " + this.currentServer.getPort() + " is not properly formatted");
            error.setType((short)0);
            throw error;
        }
        catch (PetalsServiceTechnicalException e) {
            LOGGER.error((Object)"Error occurred during correlation id recovering", (Throwable)e);
            throw new NonLocalizedError(ManagementUIBean.PETALS_SERVICE_ERROR, e.getLocalizedMessage(), (Throwable)e);
        }
    }
}

