/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.tools.webconsole.uibeans;

import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.management.MBeanAttributeInfo;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.opensuit.core.error.NonLocalizedError;
import org.ow2.opensuit.core.impl.multiparts.IFileUploadPart;
import org.ow2.petals.tools.webconsole.business.InstallComponentBBean;
import org.ow2.petals.tools.webconsole.services.PetalsServiceTechnicalException;
import org.ow2.petals.tools.webconsole.uibeans.ManagementUIBean;
import org.ow2.petals.tools.webconsole.uibeans.utils.UIResult;
import org.ow2.petals.tools.webconsole.utils.GeneralHelper;
import org.ow2.petals.tools.webconsole.utils.PetalsConsoleException;

public class InstallComponentUIBean
implements Serializable {
    private static final long serialVersionUID = 2315379879583726311L;
    private static final Log LOGGER = LogFactory.getLog(InstallComponentUIBean.class);
    private String fileName;
    private transient InstallComponentBBean businessBean = new InstallComponentBBean();
    private String serverName;
    private List<String> listFileRepo = new ArrayList();
    private String selectedComponent;
    private String urlRepo;
    private String url;
    private String visibility;
    private List<String> visibilities;
    private boolean validate;
    private String occurredError;
    private String loadedInstaller;
    private boolean urlVisibility;
    private boolean localVisibility;

    public void upload(IFileUploadPart file, String serverName, String domainName, HttpServletRequest request) throws NonLocalizedError {
        try {
            if (!("application/zip".equals(file.getFileContentType()) || "application/x-compress".equals(file.getFileContentType()) || "application/x-compressed".equals(file.getFileContentType()) || "application/x-zip".equals(file.getFileContentType()) || "application/x-zip-compressed".equals(file.getFileContentType()) || "application/zip-compressed".equals(file.getFileContentType()) || "application/x-7zip-compressed".equals(file.getFileContentType()))) {
                LOGGER.warn((Object)"Error occurred during component uploading, artefact content-type must be [application/zip] [application/x-compress] [application/x-compressed] [application/x-zip] [application/x-zip-compressed] [application/zip-compressed] [application/x-7zip-compressed]");
                NonLocalizedError error = new NonLocalizedError(ManagementUIBean.USER_ACTION_ERROR, "Artefact content-type must be [application/zip] [application/x-compress] [application/x-compressed] [application/x-zip] [application/x-zip-compressed] [application/x-7zip-compressed]");
                error.setType((short)0);
                throw error;
            }
            this.fileName = this.getBusinessBean().storeComponent(file, request);
        }
        catch (IOException e) {
            LOGGER.error((Object)"Error occurred during component uploading", (Throwable)e);
            throw new NonLocalizedError(ManagementUIBean.IOEXCEPTION_ERROR, e.getLocalizedMessage(), (Throwable)e);
        }
        this.serverName = serverName;
    }

    public void getCheckRadioButton() {
        if ("local".equals(this.visibility)) {
            this.localVisibility = true;
            this.urlVisibility = false;
        } else if ("url".equals(this.visibility)) {
            this.urlVisibility = true;
            this.localVisibility = false;
        }
    }

    public String install(HttpServletRequest request, String serverName) throws NonLocalizedError {
        this.serverName = serverName != null ? serverName : request.getParameter("serverName");
        Map attributes = null;
        ManagementUIBean managementUIBean = (ManagementUIBean)request.getSession().getAttribute("managementUIBean");
        if (this.visibility.equals("url")) {
            try {
                attributes = this.getBusinessBean().beginURLInstallation(managementUIBean, this.url, this.serverName, request);
            }
            catch (MalformedURLException e) {
                LOGGER.error((Object)"Error occurred during component installation", (Throwable)e);
                NonLocalizedError error = new NonLocalizedError(ManagementUIBean.MALFORMED_URL_ERROR, e.getMessage());
                error.setType((short)1);
                throw error;
            }
            catch (PetalsServiceTechnicalException e) {
                LOGGER.error((Object)"Error occurred during component installation", (Throwable)e);
                NonLocalizedError error = new NonLocalizedError(ManagementUIBean.PETALS_SERVICE_ERROR, e.getMessage(), (Throwable)e);
                error.setType((short)1);
                throw error;
            }
            catch (PetalsConsoleException e) {
                LOGGER.error((Object)"Error occurred during component installation", (Throwable)e);
                NonLocalizedError error = new NonLocalizedError(ManagementUIBean.PETALS_CONSOLE_ERROR, e.getMessage(), (Throwable)e);
                error.setType((short)0);
                throw error;
            }
            catch (NumberFormatException e) {
                LOGGER.error((Object)"Error occurred during component installation", (Throwable)e);
                NonLocalizedError error = new NonLocalizedError(ManagementUIBean.NUMBER_FORMAT_ERROR, "The server port value is not properly formatted");
                error.setType((short)0);
                throw error;
            }
        }
        if (this.visibility.equals("local") && this.fileName != null) {
            try {
                attributes = this.getBusinessBean().beginLocalInstallation(managementUIBean, this.fileName, this.serverName, request);
            }
            catch (MalformedURLException e) {
                LOGGER.error((Object)"Error occurred during component installation", (Throwable)e);
                NonLocalizedError error = new NonLocalizedError(ManagementUIBean.MALFORMED_URL_ERROR, e.getMessage());
                error.setType((short)1);
                throw error;
            }
            catch (PetalsServiceTechnicalException e) {
                LOGGER.error((Object)"Error occurred during component installation", (Throwable)e);
                NonLocalizedError error = new NonLocalizedError(ManagementUIBean.PETALS_SERVICE_ERROR, e.getMessage(), (Throwable)e);
                error.setType((short)1);
                throw error;
            }
            catch (UnknownHostException e) {
                LOGGER.error((Object)"Error occurred during component installation", (Throwable)e);
                NonLocalizedError error = new NonLocalizedError(ManagementUIBean.UNKNOW_HOST_ERROR, e.getMessage());
                error.setType((short)0);
                throw error;
            }
            catch (PetalsConsoleException e) {
                LOGGER.error((Object)"Error occurred during component installation", (Throwable)e);
                NonLocalizedError error = new NonLocalizedError(ManagementUIBean.PETALS_CONSOLE_ERROR, e.getMessage(), (Throwable)e);
                error.setType((short)0);
                throw error;
            }
        }
        this.loadedInstaller = this.getBusinessBean().getLoadedInstaller();
        managementUIBean.reconnect(request);
        if (attributes != null) {
            request.getSession().setAttribute("attributes", (Object)attributes);
            return UIResult.SUCCESS.getValue();
        }
        this.occurredError = "empty installation attributes";
        return UIResult.ERROR.getValue();
    }

    public InstallComponentUIBean() throws NonLocalizedError {
        try {
            this.visibilities = this.loadVisibilities();
        }
        catch (IOException e) {
            LOGGER.error((Object)"Error occurred during InstallComponentUIBean constructor", (Throwable)e);
            throw new NonLocalizedError(ManagementUIBean.IOEXCEPTION_ERROR, e.getLocalizedMessage(), (Throwable)e);
        }
        if ("local".equals(this.visibilities.get(0))) {
            this.visibility = "local";
            this.localVisibility = true;
        } else {
            this.visibility = "url";
            this.urlVisibility = true;
            this.localVisibility = false;
        }
        if (this.listFileRepo.size() == 0) {
            this.listFileRepo.add("ListFile");
            this.listFileRepo.add("liste de fichier");
        }
    }

    private List<String> loadVisibilities() throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        if (!GeneralHelper.checkDistributedInstallation()) {
            list.add("local");
        }
        list.add("url");
        return list;
    }

    public List<String> getListFileRepo() {
        return this.listFileRepo;
    }

    public void setListFileRepo(List<String> listFileRepo) {
        this.listFileRepo = listFileRepo;
    }

    public String getSelectedComponent() {
        return this.selectedComponent;
    }

    public void setSelectedComponent(String selectedComponent) {
        this.selectedComponent = selectedComponent;
    }

    public String getUrlRepo() {
        return this.urlRepo;
    }

    public void setUrlRepo(String urlRepo) throws NonLocalizedError {
        this.urlRepo = urlRepo;
        String[] tmp = urlRepo.split(":");
        if (tmp.length != 2) {
            NonLocalizedError error = new NonLocalizedError(ManagementUIBean.USER_ACTION_ERROR, "the syntax must be x.x.x.x:x , example 192.168.1.1:8080");
            error.setType((short)0);
            throw error;
        }
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean getBrowserVisibility() {
        return "local".equals(this.visibility);
    }

    public boolean getUrlVisibility() {
        return "url".equals(this.visibility);
    }

    public String getVisibility() {
        return this.visibility;
    }

    public void setVisibility(String visibility) {
        this.visibility = visibility;
    }

    public List<String> getVisibilities() {
        return this.visibilities;
    }

    public void setVisibilities(List<String> visibilities) {
        this.visibilities = visibilities;
    }

    public boolean isValidate() {
        return this.validate;
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }

    public String validateAttributes(HttpServletRequest request) throws NonLocalizedError {
        Map attributes = (Map)request.getSession().getAttribute("attributes");
        ArrayList<String> occurredErrors = new ArrayList<String>();
        for (MBeanAttributeInfo info : attributes.keySet()) {
            String s = request.getParameter(info.getName());
            Object result = null;
            try {
                if (info.getType().equals("int") || info.getType().equals("Int") || info.getType().equals("integer") || info.getType().equals("Integer")) {
                    result = Integer.valueOf(s);
                }
                if (info.getType().equals("string") || info.getType().equals("String") || info.getType().equals("java.lang.String")) {
                    result = s;
                }
                if (info.getType().equals("float") || info.getType().equals("Float")) {
                    result = Float.valueOf(s);
                }
                if (info.getType().equals("double") || info.getType().equals("Double")) {
                    result = Double.valueOf(s);
                }
                if (info.getType().equals("short") || info.getType().equals("Short")) {
                    result = Short.valueOf(s);
                }
                if (info.getType().equals("bool") || info.getType().equals("Bool") || info.getType().equals("boolean") || info.getType().equals("Boolean")) {
                    result = Boolean.valueOf(s);
                }
                if (info.getType().equals("char") || info.getType().equals("Char") || info.getType().equals("character") || info.getType().equals("Character")) {
                    result = s.toCharArray();
                }
                if (info.getType().equals("byte") || info.getType().equals("Byte")) {
                    result = Byte.valueOf(s);
                }
                if (info.getType().equals("long") || info.getType().equals("Long")) {
                    result = Long.valueOf(s);
                }
                attributes.put(info, result);
            }
            catch (NumberFormatException e) {
                LOGGER.error((Object)"Error occurred during installation attributes validation", (Throwable)e);
                LOGGER.info((Object)("The value '" + s + "' isn't appropriate for '" + info.getName() + "' attribute, must be '" + info.getType() + "' type"));
                occurredErrors.add("The value '" + s + "' isn't appropriate for '" + info.getName() + "' attribute, must be '" + info.getType() + "' type");
            }
        }
        if (occurredErrors.isEmpty()) {
            NonLocalizedError error;
            if (this.url != null) {
                try {
                    this.getBusinessBean().install(request, this.url, this.serverName, attributes, this.loadedInstaller);
                }
                catch (MalformedURLException e) {
                    LOGGER.error((Object)"Error occurred during installation attributes validation", (Throwable)e);
                    error = new NonLocalizedError(ManagementUIBean.MALFORMED_URL_ERROR, e.getLocalizedMessage());
                    error.setType((short)1);
                    throw error;
                }
                catch (IOException e) {
                    LOGGER.error((Object)"Error occurred during installation attributes validation", (Throwable)e);
                    throw new NonLocalizedError(ManagementUIBean.IOEXCEPTION_ERROR, e.getLocalizedMessage(), (Throwable)e);
                }
                catch (URISyntaxException e) {
                    LOGGER.error((Object)"Error occurred during installation attributes validation", (Throwable)e);
                    error = new NonLocalizedError(ManagementUIBean.URI_SYNTAX_ERROR, e.getLocalizedMessage());
                    error.setType((short)1);
                    throw error;
                }
                catch (PetalsServiceTechnicalException e) {
                    LOGGER.error((Object)"Error occurred during installation attributes validation", (Throwable)e);
                    throw new NonLocalizedError(ManagementUIBean.PETALS_SERVICE_ERROR, e.getLocalizedMessage(), (Throwable)e);
                }
                catch (PetalsConsoleException e) {
                    LOGGER.error((Object)"Error occurred during installation attributes validation", (Throwable)e);
                    error = new NonLocalizedError(ManagementUIBean.PETALS_CONSOLE_ERROR, e.getMessage(), (Throwable)e);
                    error.setType((short)1);
                    throw error;
                }
            }
            try {
                this.getBusinessBean().install(request, this.fileName, this.serverName, attributes, this.loadedInstaller);
            }
            catch (MalformedURLException e) {
                LOGGER.error((Object)"Error occurred during installation attributes validation", (Throwable)e);
                error = new NonLocalizedError(ManagementUIBean.MALFORMED_URL_ERROR, e.getLocalizedMessage());
                error.setType((short)1);
                throw error;
            }
            catch (IOException e) {
                LOGGER.error((Object)"Error occurred during installation attributes validation", (Throwable)e);
                throw new NonLocalizedError(ManagementUIBean.IOEXCEPTION_ERROR, e.getLocalizedMessage(), (Throwable)e);
            }
            catch (URISyntaxException e) {
                LOGGER.error((Object)"Error occurred during installation attributes validation", (Throwable)e);
                error = new NonLocalizedError(ManagementUIBean.URI_SYNTAX_ERROR, e.getLocalizedMessage());
                error.setType((short)1);
                throw error;
            }
            catch (PetalsServiceTechnicalException e) {
                LOGGER.error((Object)"Error occurred during installation attributes validation", (Throwable)e);
                throw new NonLocalizedError(ManagementUIBean.PETALS_SERVICE_ERROR, e.getLocalizedMessage(), (Throwable)e);
            }
            catch (PetalsConsoleException e) {
                LOGGER.error((Object)"Error occurred during installation attributes validation", (Throwable)e);
                error = new NonLocalizedError(ManagementUIBean.PETALS_CONSOLE_ERROR, e.getMessage(), (Throwable)e);
                error.setType((short)1);
                throw error;
            }
            catch (NumberFormatException e) {
                LOGGER.error((Object)"Error occurred during installation attributes validation", (Throwable)e);
                error = new NonLocalizedError(ManagementUIBean.NUMBER_FORMAT_ERROR, e.getLocalizedMessage());
                error.setType((short)0);
                throw error;
            }
            ManagementUIBean managementUIBean = (ManagementUIBean)request.getSession().getAttribute("managementUIBean");
            if (managementUIBean != null) {
                managementUIBean.setCurrentServerName(this.serverName);
                managementUIBean.reconnect(request);
            }
            return UIResult.SUCCESS.getValue();
        }
        request.getSession().setAttribute("occurredErrors", occurredErrors);
        return UIResult.ERROR.getValue();
    }

    public String getOccurredError() {
        return this.occurredError;
    }

    public boolean isLocalVisibility() {
        return this.localVisibility;
    }

    public void setLocalVisibility(boolean localVisibility) {
        this.localVisibility = localVisibility;
    }

    public void setUrlVisibility(boolean urlVisibility) {
        this.urlVisibility = urlVisibility;
    }

    public boolean isUrlVisibility() {
        return this.urlVisibility;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    protected InstallComponentBBean getBusinessBean() {
        if (this.businessBean == null) {
            this.businessBean = new InstallComponentBBean();
        }
        return this.businessBean;
    }

    public void onLoad(HttpServletRequest request) {
        String pathComponent = request.getParameter("pathComponent");
        String installType = request.getParameter("installType");
        if (pathComponent != null && !pathComponent.equals("") && !pathComponent.equals("null")) {
            this.url = pathComponent;
        }
        if (installType != null && installType.equals("url")) {
            this.visibility = "url";
            this.localVisibility = false;
            this.urlVisibility = true;
        }
    }
}

