/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.tools.webconsole.uibeans;

import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.opensuit.core.error.NonLocalizedError;
import org.ow2.opensuit.core.impl.multiparts.IFileUploadPart;
import org.ow2.petals.tools.webconsole.business.InstallSharedLibraryBBean;
import org.ow2.petals.tools.webconsole.services.PetalsServiceTechnicalException;
import org.ow2.petals.tools.webconsole.uibeans.ManagementUIBean;
import org.ow2.petals.tools.webconsole.uibeans.utils.UIResult;
import org.ow2.petals.tools.webconsole.utils.GeneralHelper;
import org.ow2.petals.tools.webconsole.utils.PetalsConsoleException;

public class InstallSharedLibraryUIBean
implements Serializable {
    private static final long serialVersionUID = -5029506879700787992L;
    private static final Log LOGGER = LogFactory.getLog(InstallSharedLibraryUIBean.class);
    private String fileName;
    private transient InstallSharedLibraryBBean businessBean;
    private String serverName;
    private String url;
    private String visibility;
    private List<String> visibilities;
    private boolean urlVisibility;
    private boolean localVisibility;

    public InstallSharedLibraryUIBean() throws NonLocalizedError {
        try {
            this.visibilities = this.loadVisibilities();
        }
        catch (IOException e) {
            LOGGER.error((Object)"Error occurred during shared library installation ui bean initialization", (Throwable)e);
            throw new NonLocalizedError(ManagementUIBean.IOEXCEPTION_ERROR, e.getLocalizedMessage(), (Throwable)e);
        }
        if ("local".equals(this.visibilities.get(0))) {
            this.visibility = "local";
            this.localVisibility = true;
        } else {
            this.visibility = "url";
            this.urlVisibility = true;
            this.localVisibility = false;
        }
        this.businessBean = new InstallSharedLibraryBBean();
    }

    private List<String> loadVisibilities() throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        if (!GeneralHelper.checkDistributedInstallation()) {
            list.add("local");
        }
        list.add("url");
        return list;
    }

    public String getVisibility() {
        return this.visibility;
    }

    public void setVisibility(String visibility) {
        this.visibility = visibility;
    }

    public List<String> getVisibilities() {
        return this.visibilities;
    }

    public void setVisibilities(List<String> visibilities) {
        this.visibilities = visibilities;
    }

    public boolean getBrowserVisibility() {
        return this.visibility.equals("local");
    }

    public boolean getUrlVisibility() {
        return this.visibility.equals("url");
    }

    public void upload(IFileUploadPart file, HttpServletRequest request) throws NonLocalizedError {
        try {
            if (!("application/zip".equals(file.getFileContentType()) || "application/x-compress".equals(file.getFileContentType()) || "application/x-compressed".equals(file.getFileContentType()) || "application/x-zip".equals(file.getFileContentType()) || "application/x-zip-compressed".equals(file.getFileContentType()) || "application/zip-compressed".equals(file.getFileContentType()) || "application/x-7zip-compressed".equals(file.getFileContentType()))) {
                LOGGER.warn((Object)"Error occurred during shared library uploading, artefact content-type must be [application/zip] [application/x-compress] [application/x-compressed] [application/x-zip] [application/x-zip-compressed] [application/zip-compressed] [application/x-7zip-compressed]");
                NonLocalizedError error = new NonLocalizedError(ManagementUIBean.USER_ACTION_ERROR, "Artefact content-type must be [application/zip] [application/x-compress] [application/x-compressed] [application/x-zip] [application/x-zip-compressed] [application/x-7zip-compressed]");
                error.setType((short)0);
                throw error;
            }
            this.fileName = this.getBusinessBean().storeSharedLibrary(file, request);
        }
        catch (IOException e) {
            LOGGER.error((Object)"Error occurred during shared library uploading", (Throwable)e);
            throw new NonLocalizedError(ManagementUIBean.IOEXCEPTION_ERROR, e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String install(HttpServletRequest request, String serverName) throws NonLocalizedError {
        this.serverName = serverName != null ? serverName : request.getParameter("serverName");
        ManagementUIBean managementUIBean = (ManagementUIBean)request.getSession().getAttribute("managementUIBean");
        if (this.visibility.equals("url")) {
            try {
                this.getBusinessBean().beginURLInstallation(request, managementUIBean, this.url, this.serverName);
            }
            catch (MalformedURLException e) {
                LOGGER.error((Object)"Error occurred during shared library installation", (Throwable)e);
                NonLocalizedError error = new NonLocalizedError(ManagementUIBean.MALFORMED_URL_ERROR, e.getLocalizedMessage());
                error.setType((short)1);
                throw error;
            }
            catch (PetalsServiceTechnicalException e) {
                LOGGER.error((Object)"Error occurred during shared library installation", (Throwable)e);
                NonLocalizedError error = new NonLocalizedError(ManagementUIBean.PETALS_SERVICE_ERROR, e.getMessage(), (Throwable)e);
                error.setType((short)1);
                throw error;
            }
            catch (IOException e) {
                LOGGER.error((Object)"Error occurred during shared library installation", (Throwable)e);
                NonLocalizedError error = new NonLocalizedError(ManagementUIBean.IOEXCEPTION_ERROR, e.getLocalizedMessage());
                error.setType((short)1);
                throw error;
            }
            catch (URISyntaxException e) {
                LOGGER.error((Object)"Error occurred during shared library installation", (Throwable)e);
                NonLocalizedError error = new NonLocalizedError(ManagementUIBean.URI_SYNTAX_ERROR, e.getLocalizedMessage());
                error.setType((short)1);
                throw error;
            }
            catch (PetalsConsoleException e) {
                LOGGER.error((Object)"Error occurred during shared library installation", (Throwable)e);
                NonLocalizedError error = new NonLocalizedError(ManagementUIBean.PETALS_CONSOLE_ERROR, e.getLocalizedMessage());
                error.setType((short)0);
                throw error;
            }
        }
        if (this.visibility.equals("local") && this.fileName != null) {
            try {
                this.getBusinessBean().beginLocalInstallation(request, managementUIBean, this.fileName, this.serverName);
            }
            catch (MalformedURLException e) {
                LOGGER.error((Object)"Error occurred during shared library installation", (Throwable)e);
                NonLocalizedError error = new NonLocalizedError(ManagementUIBean.MALFORMED_URL_ERROR, e.getLocalizedMessage());
                error.setType((short)1);
                throw error;
            }
            catch (PetalsServiceTechnicalException e) {
                LOGGER.error((Object)"Error occurred during shared library installation", (Throwable)e);
                NonLocalizedError error = new NonLocalizedError(ManagementUIBean.PETALS_SERVICE_ERROR, e.getMessage(), (Throwable)e);
                error.setType((short)1);
                throw error;
            }
            catch (IOException e) {
                LOGGER.error((Object)"Error occurred during shared library installation", (Throwable)e);
                NonLocalizedError error = new NonLocalizedError(ManagementUIBean.IOEXCEPTION_ERROR, e.getLocalizedMessage());
                error.setType((short)1);
            }
            catch (URISyntaxException e) {
                LOGGER.error((Object)"Error occurred during shared library installation", (Throwable)e);
                NonLocalizedError error = new NonLocalizedError(ManagementUIBean.URI_SYNTAX_ERROR, e.getLocalizedMessage());
                error.setType((short)1);
                throw error;
            }
            catch (PetalsConsoleException e) {
                LOGGER.error((Object)"Error occurred during shared library installation", (Throwable)e);
                NonLocalizedError error = new NonLocalizedError(ManagementUIBean.PETALS_CONSOLE_ERROR, e.getLocalizedMessage());
                error.setType((short)0);
                throw error;
            }
        }
        managementUIBean.reconnect(request);
        return UIResult.SUCCESS.getValue();
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public void getCheckRadioButton() {
        if (this.visibility.equals("local")) {
            this.localVisibility = true;
            this.urlVisibility = false;
        } else if (this.visibility.equals("url")) {
            this.urlVisibility = true;
            this.localVisibility = false;
        }
    }

    public boolean isLocalVisibility() {
        return this.localVisibility;
    }

    public void setLocalVisibility(boolean localVisibility) {
        this.localVisibility = localVisibility;
    }

    public void setUrlVisibility(boolean urlVisibility) {
        this.urlVisibility = urlVisibility;
    }

    public boolean isUrlVisibility() {
        return this.urlVisibility;
    }

    protected InstallSharedLibraryBBean getBusinessBean() {
        if (this.businessBean == null) {
            this.businessBean = new InstallSharedLibraryBBean();
        }
        return this.businessBean;
    }
}

