/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.tools.webconsole.uibeans;

import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.rmi.ConnectException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.management.MBeanAttributeInfo;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.opensuit.core.error.NonLocalizedError;
import org.ow2.petals.jmx.exception.ConnectionErrorException;
import org.ow2.petals.jmx.exception.PetalsAdminServiceErrorException;
import org.ow2.petals.jmx.exception.RuntimeConfigurationDoesNotExistException;
import org.ow2.petals.tools.webconsole.business.ManagementBBean;
import org.ow2.petals.tools.webconsole.business.ServerFeatureBBean;
import org.ow2.petals.tools.webconsole.services.PetalsServiceTechnicalException;
import org.ow2.petals.tools.webconsole.services.management.ManagementService;
import org.ow2.petals.tools.webconsole.services.management.ManagementServiceFactory;
import org.ow2.petals.tools.webconsole.to.DomainTO;
import org.ow2.petals.tools.webconsole.to.ServerTO;
import org.ow2.petals.tools.webconsole.uibeans.ManagementUIBean;
import org.ow2.petals.tools.webconsole.uibeans.RemoteInjectorUIBean;
import org.ow2.petals.tools.webconsole.uibeans.ServerFeatureUIBean;
import org.ow2.petals.tools.webconsole.uibeans.ServerUIBean;
import org.ow2.petals.tools.webconsole.uibeans.utils.TOAdapter;
import org.ow2.petals.tools.webconsole.uibeans.utils.TopologyHelper;
import org.ow2.petals.tools.webconsole.uibeans.utils.UIResult;
import org.ow2.petals.tools.webconsole.utils.ConfigHelper;
import org.ow2.petals.tools.webconsole.utils.PetalsConsoleException;
import org.ow2.petals.tools.webconsole.xmlbeans.Server;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ManagementUIBean
implements Serializable {
    private static final long serialVersionUID = -5509131488572379389L;
    private static final Log LOGGER = LogFactory.getLog(ManagementUIBean.class);
    private transient ManagementBBean businessBean = new ManagementBBean();
    private DomainTO domain = new DomainTO();
    private String host = null;
    private String port = null;
    private String login = null;
    private String password = null;
    private String remoteContext = null;
    private int remotePort = 0;
    private boolean installedRemoteComponent = false;
    private boolean failedConnection = true;
    private String currentServerName = null;
    private String componentName = null;
    private String componentLoggerLevel = null;
    private String[] loggerLevels = null;
    private int monitoredMessageAgeType = 0;
    private transient AgeType[] monitoredMessageAgeTypes = null;
    private long monitoredMessageAge = 0L;
    private boolean domainDisplaying;
    private boolean addServer;
    private ManagementService managementService;
    public static String NUMBER_FORMAT_ERROR;
    public static String UNKNOW_HOST_ERROR;
    public static String PETALS_SERVICE_ERROR;
    public static String PETALS_CONSOLE_ERROR;
    public static String USER_ACTION_ERROR;
    public static String CONFIGURATION_ERROR;
    public static String SAX_ERROR;
    public static String PARSER_CONFIGURATION_ERROR;
    public static String FACTORY_CONFIGURATION_ERROR;
    public static String WSDLEXCEPTION_ERROR;
    public static String MALFORMED_URL_ERROR;
    public static String IOEXCEPTION_ERROR;
    public static String URI_SYNTAX_ERROR;
    public static String FILE_NOT_FOUND_ERROR;
    public static String REMOTE_SERVER_CONFIGURATION_ERROR;
    public static String ILLEGAL_ARGUMENT_ERROR;
    public static String CLASS_LOADER_ERROR;
    public static String CONFIGURATION_FILE_ERROR;
    public static String SELECTED_ENDPOINT_ERROR;
    public static String TRANSFORMER_ERROR;
    public static String TRANSFORMER_FACTORY_CONFIGURATION_ERROR;
    public static String MESSAGING_ERROR;
    public static String DOWNLOAD_ATTACHMENT_ERROR;
    public static String FORM_FIELD_ERROR;
    public static final String INITIALIZATION_ERROR = "initialization error";

    public ManagementUIBean() throws NonLocalizedError {
        Set servers = this.recoverXMLServer();
        if (servers != null && servers.size() > 0) {
            this.failedConnection = false;
        }
    }

    public String reconnectWithRemoteLoading(HttpServletRequest request) throws NonLocalizedError {
        RemoteInjectorUIBean remoteInjectorUIBean;
        String result = this.serverConnection(request);
        ServerUIBean currentServerUIBean = (ServerUIBean)request.getSession().getAttribute("serverUIBean");
        if (currentServerUIBean != null) {
            currentServerUIBean.updateServer(this.domain);
        }
        if ((remoteInjectorUIBean = (RemoteInjectorUIBean)request.getSession().getAttribute("remoteInjectorUIBean")) != null) {
            remoteInjectorUIBean.load(request);
        }
        return result;
    }

    public String reconnect(HttpServletRequest request) throws NonLocalizedError {
        String result = this.serverConnection(request);
        ServerUIBean currentServerUIBean = (ServerUIBean)request.getSession().getAttribute("serverUIBean");
        if (currentServerUIBean != null) {
            currentServerUIBean.updateServer(this.domain);
        }
        return result;
    }

    public String connect() throws NonLocalizedError {
        String result = UIResult.ERROR.getValue();
        this.failedConnection = true;
        this.managementService = null;
        HashSet configuredServers = new HashSet();
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            URL url = null;
            if (loader == null) {
                NonLocalizedError error = new NonLocalizedError(CLASS_LOADER_ERROR, "class loader not found");
                error.setType((short)0);
                LOGGER.warn((Object)"class loader not found");
                throw error;
            }
            url = loader.getResource("webconsole.xml");
            if (url == null) {
                NonLocalizedError error = new NonLocalizedError(CONFIGURATION_FILE_ERROR, "'webconsole.xml' configuration file not found");
                LOGGER.warn((Object)"'webconsole.xml' configuration file not found");
                error.setType((short)0);
                throw error;
            }
            configuredServers.addAll(ConfigHelper.readConfig((URL)url));
        }
        catch (MalformedURLException e) {
            NonLocalizedError error = new NonLocalizedError(MALFORMED_URL_ERROR, e.getLocalizedMessage());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)e.getLocalizedMessage(), (Throwable)e);
            } else {
                LOGGER.warn((Object)e.getMessage());
            }
            error.setType((short)0);
            throw error;
        }
        catch (IOException e) {
            NonLocalizedError error = new NonLocalizedError(IOEXCEPTION_ERROR, e.getLocalizedMessage());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)e.getLocalizedMessage(), (Throwable)e);
            } else {
                LOGGER.warn((Object)e.getMessage());
            }
            error.setType((short)0);
            throw error;
        }
        catch (SAXParseException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.error((Object)"Error occurred during configuration file reading", (Throwable)e);
            } else {
                LOGGER.error((Object)("Error occurred during configuration file reading: " + e.getMessage()));
            }
            NonLocalizedError error = new NonLocalizedError(SAX_ERROR, e.getLocalizedMessage());
            error.setType((short)0);
            throw error;
        }
        catch (SAXException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.error((Object)"Error occurred during configuration file reading", (Throwable)e);
            } else {
                LOGGER.error((Object)("Error occurred during configuration file reading: " + e.getMessage()));
            }
            NonLocalizedError error = new NonLocalizedError(SAX_ERROR, e.getLocalizedMessage());
            error.setType((short)0);
            throw error;
        }
        catch (ParserConfigurationException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.error((Object)"Error occurred during configuration file reading", (Throwable)e);
            } else {
                LOGGER.error((Object)("Error occurred during configuration file reading: " + e.getMessage()));
            }
            NonLocalizedError error = new NonLocalizedError(PARSER_CONFIGURATION_ERROR, e.getLocalizedMessage());
            error.setType((short)0);
            throw error;
        }
        catch (FactoryConfigurationError e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.error((Object)"Error occurred during configuration file reading", (Throwable)e);
            } else {
                LOGGER.error((Object)("Error occurred during configuration file reading: " + e.getMessage()));
            }
            NonLocalizedError error = new NonLocalizedError(FACTORY_CONFIGURATION_ERROR, e.getLocalizedMessage());
            error.setType((short)0);
            throw error;
        }
        ManagementServiceFactory factory = (ManagementServiceFactory)ManagementServiceFactory.getInstance();
        for (ServerTO server : configuredServers) {
            NonLocalizedError error;
            try {
                this.managementService = factory.getService(server.getHost(), Integer.valueOf(Integer.parseInt(server.getPort())), server.getLogin(), server.getPassword());
            }
            catch (NumberFormatException e) {
                continue;
            }
            catch (PetalsServiceTechnicalException e) {
                continue;
            }
            if (this.managementService == null) continue;
            try {
                Set topology = this.managementService.getTopology(server.getHost(), Integer.valueOf(Integer.parseInt(server.getPort())), server.getLogin(), server.getPassword());
                if (this.domain != null) {
                    this.domain = TopologyHelper.getDomain(configuredServers, (Set)topology, (String)server.getHost(), (Integer)Integer.parseInt(server.getPort()), (String)server.getLogin(), (String)server.getPassword(), (String)server.getDomainName());
                    String currentDomain = this.domain.getName();
                    List newServers = this.domain.getServers();
                    for (ServerTO configuredServer : configuredServers) {
                        if (!configuredServer.getDomainName().equals(currentDomain) || !newServers.contains(configuredServer)) continue;
                        int index = newServers.indexOf(configuredServer);
                        ServerTO newServer = (ServerTO)newServers.get(index);
                        newServer.setHost(configuredServer.getHost());
                        newServer.setPort(configuredServer.getPort());
                        newServer.setLogin(configuredServer.getLogin());
                        newServer.setPassword(configuredServer.getPassword());
                        newServer.setInstalledRemoteComponent(configuredServer.isInstalledRemoteComponent());
                        newServer.setRemoteContext(configuredServer.getRemoteContext());
                        newServer.setRemotePort(configuredServer.getRemotePort());
                    }
                } else {
                    this.domain = TopologyHelper.getDomain(configuredServers, (Set)topology, (String)server.getHost(), (Integer)Integer.parseInt(server.getPort()), (String)server.getLogin(), (String)server.getPassword(), (String)server.getDomainName());
                }
                this.host = server.getHost();
                this.port = server.getPort();
                this.login = server.getLogin();
                this.password = server.getPassword();
                this.failedConnection = false;
                result = UIResult.SUCCESS.getValue();
            }
            catch (NumberFormatException e) {
                error = new NonLocalizedError(NUMBER_FORMAT_ERROR, "The port value: " + this.port + " is not properly formatted " + e.getLocalizedMessage());
                error.setType((short)0);
                throw error;
            }
            catch (PetalsServiceTechnicalException e) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.error((Object)"Error occurred during topology or domain retrieving", (Throwable)e);
                } else {
                    LOGGER.error((Object)("Error occurred during topology or domain retrieving: " + e.getMessage()));
                }
                error = new NonLocalizedError(PETALS_SERVICE_ERROR, e.getLocalizedMessage());
                error.setType((short)0);
                throw error;
            }
            catch (UnknownHostException e) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.error((Object)"Error occurred during topology or domain retrieving", (Throwable)e);
                } else {
                    LOGGER.error((Object)("Error occurred during topology or domain retrieving: " + e.getMessage()));
                }
                error = new NonLocalizedError(UNKNOW_HOST_ERROR, e.getLocalizedMessage());
                error.setType((short)0);
                throw error;
            }
            catch (PetalsConsoleException e) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.error((Object)"Error occurred during topology or domain retrieving", (Throwable)e);
                } else {
                    LOGGER.error((Object)("Error occurred during topology or domain retrieving: " + e.getMessage()));
                }
                error = new NonLocalizedError(PETALS_CONSOLE_ERROR, e.getLocalizedMessage());
                error.setType((short)0);
                throw error;
            }
        }
        return result;
    }

    public String serverConnection(HttpServletRequest request) throws NonLocalizedError {
        ManagementServiceFactory factory = (ManagementServiceFactory)ManagementServiceFactory.getInstance();
        this.failedConnection = true;
        String result = UIResult.ERROR.getValue();
        if (this.host != null && this.port != null) {
            ServerTO serverTO;
            try {
                this.managementService = factory.getService(this.host, Integer.valueOf(Integer.parseInt(this.port)), this.login, this.password);
            }
            catch (NumberFormatException e) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.error((Object)e);
                } else {
                    LOGGER.error((Object)e.getLocalizedMessage());
                }
                this.addServer = false;
                NonLocalizedError error = new NonLocalizedError(NUMBER_FORMAT_ERROR, "The port value: " + this.port + " is not properly formatted " + e.getLocalizedMessage());
                error.setType((short)0);
                throw error;
            }
            catch (PetalsServiceTechnicalException e) {
                this.addServer = false;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.error((Object)e);
                } else {
                    LOGGER.error((Object)e.getLocalizedMessage());
                }
                NonLocalizedError error = new NonLocalizedError(PETALS_SERVICE_ERROR, e.getLocalizedMessage());
                error.setType((short)0);
                throw error;
            }
            ServerUIBean serverUIBean = (ServerUIBean)request.getSession().getAttribute("serverUIBean");
            if (this.managementService != null) {
                try {
                    Set topology = this.managementService.getTopology(this.host, Integer.valueOf(Integer.parseInt(this.port)), this.login, this.password);
                    Set referentialServers = this.recoverXMLServer();
                    this.domain = TopologyHelper.getDomain((Set)referentialServers, (Set)topology, (String)this.host, (Integer)Integer.parseInt(this.port), (String)this.login, (String)this.password, null);
                    this.currentServerName = TopologyHelper.getCurrentServerName((Set)topology, (String)this.host, (String)this.port, (String)this.login, (String)this.password);
                }
                catch (PetalsServiceTechnicalException e) {
                    this.addServer = false;
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.error((Object)e);
                    } else {
                        LOGGER.error((Object)e.getLocalizedMessage());
                    }
                    NonLocalizedError error = null;
                    if (e.getCause() != null && (e.getCause().getClass().equals(ConnectionErrorException.class) || e.getCause().getClass().equals(PetalsAdminServiceErrorException.class)) && e.getCause().getCause() != null && (e.getCause().getCause().getClass().equals(ConnectException.class) || e.getCause().getCause().getClass().equals(IOException.class))) {
                        error = new NonLocalizedError(PETALS_SERVICE_ERROR, "Connection refused to host: " + this.host);
                        error.setType((short)0);
                    } else {
                        error = new NonLocalizedError(PETALS_SERVICE_ERROR, e.getLocalizedMessage());
                        error.setType((short)0);
                    }
                    throw error;
                }
                catch (NumberFormatException e) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.error((Object)("The port value: " + this.port + " is not properly formatted " + e));
                    } else {
                        LOGGER.error((Object)("The port value: " + this.port + " is not properly formatted " + e.getLocalizedMessage()));
                    }
                    NonLocalizedError error = new NonLocalizedError(NUMBER_FORMAT_ERROR, e.getLocalizedMessage());
                    error.setType((short)0);
                    throw error;
                }
                catch (UnknownHostException e) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.error((Object)("The host: " + this.host + " is unknow or unreachable "), (Throwable)e);
                    } else {
                        LOGGER.error((Object)("The host: " + this.host + " is unknow or unreachable " + e.getLocalizedMessage()));
                    }
                    NonLocalizedError error = new NonLocalizedError(UNKNOW_HOST_ERROR, e.getLocalizedMessage());
                    error.setType((short)0);
                    throw error;
                }
                catch (PetalsConsoleException e) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.error((Object)e);
                    } else {
                        LOGGER.error((Object)e.getLocalizedMessage());
                    }
                    NonLocalizedError error = new NonLocalizedError(PETALS_CONSOLE_ERROR, e.getLocalizedMessage());
                    error.setType((short)0);
                    throw error;
                }
            }
            if (serverUIBean != null) {
                ServerFeatureUIBean sfuiBean;
                this.currentServerName = serverUIBean.getServerName();
                serverTO = this.domain.findServer(this.currentServerName);
                if (this.addServer && (sfuiBean = (ServerFeatureUIBean)request.getSession().getAttribute("serverFeatureUIBean")) != null) {
                    if (serverTO != null) {
                        sfuiBean.saveServer(TOAdapter.toServerToXMLServer((ServerTO)serverTO));
                    } else {
                        LOGGER.error((Object)("The server: " + this.host + "/" + this.port + " can't be add in referencial because isn't reconized in recovered topology (check host parameter)"));
                        NonLocalizedError error = new NonLocalizedError(PETALS_CONSOLE_ERROR, "The server: " + this.host + "/" + this.port + " can't be add in referencial because isn't reconized in recovered topology (check host parameter)");
                        error.setType((short)0);
                        throw error;
                    }
                }
                if (serverTO != null) {
                    this.failedConnection = serverTO.isAvailable();
                }
            } else {
                if (!this.domain.getServers().isEmpty()) {
                    this.currentServerName = ((ServerTO)this.domain.getServers().get(0)).getName();
                }
                serverTO = this.domain.findServerByConnectionParameters(this.host, this.port, this.login, this.password);
                if (this.addServer) {
                    try {
                        ServerFeatureBBean sfbBean = new ServerFeatureBBean();
                        if (serverTO == null) {
                            LOGGER.error((Object)("The server: " + this.host + "/" + this.port + " couldn't be added in referencial because isn't reconized in recovered topology (check host parameter)"));
                            NonLocalizedError error = new NonLocalizedError(PETALS_CONSOLE_ERROR, "The server: " + this.host + "/" + this.port + " couldn't be added in referencial because isn't reconized in recovered topology (check host parameter)");
                            error.setType((short)0);
                            throw error;
                        }
                        sfbBean.addServer(TOAdapter.toServerToXMLServer((ServerTO)serverTO));
                    }
                    catch (IllegalArgumentException e) {
                        LOGGER.info((Object)("Server: " + serverTO.getDomainName() + ":" + serverTO.getName() + " is already present in configuration file, it cannot added again"));
                    }
                    catch (URISyntaxException e) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.error((Object)"Error occurred during saving servers", (Throwable)e);
                        } else {
                            LOGGER.error((Object)("Error occurred during saving servers: " + e.getLocalizedMessage()));
                        }
                        NonLocalizedError error = new NonLocalizedError(URI_SYNTAX_ERROR, e.getLocalizedMessage());
                        error.setType((short)0);
                        throw error;
                    }
                    catch (ParserConfigurationException e) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.error((Object)"Error occurred during saving servers", (Throwable)e);
                        } else {
                            LOGGER.error((Object)("Error occurred during saving servers: " + e.getLocalizedMessage()));
                        }
                        NonLocalizedError error = new NonLocalizedError(PARSER_CONFIGURATION_ERROR, e.getLocalizedMessage());
                        error.setType((short)0);
                        throw error;
                    }
                    catch (IOException e) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.error((Object)"Error occurred during saving servers", (Throwable)e);
                        } else {
                            LOGGER.error((Object)("Error occurred during saving servers: " + e.getLocalizedMessage()));
                        }
                        NonLocalizedError error = new NonLocalizedError(IOEXCEPTION_ERROR, e.getLocalizedMessage());
                        error.setType((short)0);
                        throw error;
                    }
                }
                if (serverTO != null) {
                    this.failedConnection = serverTO.isAvailable();
                }
            }
            this.domainDisplaying = true;
            result = UIResult.SUCCESS.getValue();
        }
        this.addServer = false;
        return result;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public DomainTO getDomain() {
        return this.domain;
    }

    public String getDomainName() {
        if (this.domain != null && this.domain.getName() != null) {
            return this.domain.getName();
        }
        return "No domain";
    }

    private void resetManagementBean() {
        this.domain = null;
        this.host = null;
        this.port = null;
        this.login = null;
        this.password = null;
        this.failedConnection = true;
    }

    public void updateDomain(String modifiedDomain) throws NonLocalizedError {
        if (this.managementService != null) {
            Set referentialServers = this.recoverXMLServer();
            try {
                Set topology = this.managementService.getTopology(this.host, Integer.valueOf(Integer.parseInt(this.port)), this.login, this.password);
                if (this.domain != null) {
                    List oldServers = this.domain.getServers();
                    this.domain = TopologyHelper.getDomain((Set)referentialServers, (Set)topology, (String)this.host, (Integer)Integer.parseInt(this.port), (String)this.login, (String)this.password, (String)modifiedDomain);
                    List newServers = this.domain.getServers();
                    for (ServerTO oldServer : oldServers) {
                        if (newServers.contains(oldServer)) continue;
                        newServers.add(oldServer);
                    }
                } else {
                    this.domain = TopologyHelper.getDomain((Set)referentialServers, (Set)topology, (String)this.host, (Integer)Integer.parseInt(this.port), (String)this.login, (String)this.password, (String)modifiedDomain);
                }
                this.failedConnection = false;
            }
            catch (UnknownHostException e) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.error((Object)("The host: " + this.host + " is unknow or unreachable "), (Throwable)e);
                } else {
                    LOGGER.error((Object)("The host: " + this.host + " is unknow or unreachable " + e.getLocalizedMessage()));
                }
                NonLocalizedError error = new NonLocalizedError(UNKNOW_HOST_ERROR, e.getLocalizedMessage());
                error.setType((short)0);
                throw error;
            }
            catch (NumberFormatException e) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.error((Object)("The port value: " + this.port + " is not properly formatted " + e.getLocalizedMessage()), (Throwable)e);
                } else {
                    LOGGER.error((Object)("The port value: " + this.port + " is not properly formatted " + e.getLocalizedMessage()));
                }
                NonLocalizedError error = new NonLocalizedError(NUMBER_FORMAT_ERROR, e.getLocalizedMessage());
                error.setType((short)0);
                throw error;
            }
            catch (PetalsServiceTechnicalException e) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.error((Object)"Error occurred during updating domain", (Throwable)e);
                } else {
                    LOGGER.error((Object)("Error occurred during updating domain: " + e.getMessage()));
                }
                NonLocalizedError error = new NonLocalizedError(PETALS_SERVICE_ERROR, e.getLocalizedMessage());
                error.setType((short)0);
                throw error;
            }
            catch (PetalsConsoleException e) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.error((Object)"Error occurred during updating domain", (Throwable)e);
                } else {
                    LOGGER.error((Object)("Error occurred during updating domain: " + e.getMessage()));
                }
                NonLocalizedError error = new NonLocalizedError(PETALS_CONSOLE_ERROR, e.getLocalizedMessage());
                error.setType((short)0);
                throw error;
            }
        }
    }

    public boolean isFailedConnection() {
        return this.failedConnection;
    }

    public void setFailedConnection(boolean successConnection) {
        this.failedConnection = successConnection;
    }

    public String getCurrentServerName() {
        if (this.currentServerName != null) {
            return this.currentServerName;
        }
        return "No server";
    }

    public void setCurrentServerName(String currentServerName) {
        this.currentServerName = currentServerName;
    }

    public String editRuntimeAttributes(HttpServletRequest request, String serverName) throws NonLocalizedError {
        Map attrs;
        this.componentName = request.getParameter("componentName");
        ServerTO server = this.domain.findServer(serverName);
        if (server == null) {
            LOGGER.info((Object)"Invalid selected server during the runtime attributes edit");
            throw new NonLocalizedError(PETALS_CONSOLE_ERROR, "Invalid selected server");
        }
        this.port = server.getPort();
        this.host = server.getHost();
        this.login = server.getLogin();
        this.password = server.getPassword();
        this.currentServerName = server.getName();
        try {
            attrs = this.getBusinessBean().recoverRuntimeAttributes(this.componentName, this.port, this.password, this.host, this.login);
        }
        catch (PetalsServiceTechnicalException e) {
            if (e.getCause().getClass().equals(RuntimeConfigurationDoesNotExistException.class)) {
                LOGGER.error((Object)"Error occurred during runtime attributes recovery", (Throwable)e);
                throw new NonLocalizedError(PETALS_SERVICE_ERROR, "The component isn't started or runtime configuration for this component doesn't exist");
            }
            LOGGER.error((Object)"Error occurred during runtime attributes recovery", (Throwable)e);
            throw new NonLocalizedError(PETALS_SERVICE_ERROR, e.getLocalizedMessage(), (Throwable)e);
        }
        request.getSession().setAttribute("attributes", (Object)attrs);
        return UIResult.SUCCESS.getValue();
    }

    public String validateAttributes(HttpServletRequest request) throws NonLocalizedError {
        Map attributes = (Map)request.getSession().getAttribute("attributes");
        ArrayList<String> occurredErrors = new ArrayList<String>();
        for (MBeanAttributeInfo info : attributes.keySet()) {
            String s = request.getParameter(info.getName());
            Object result = null;
            try {
                if (info.getType().equals("int") || info.getType().equals("Int") || info.getType().equals("integer") || info.getType().equals("Integer")) {
                    result = Integer.valueOf(s);
                }
                if (info.getType().equals("string") || info.getType().equals("String") || info.getType().equals("java.lang.String")) {
                    result = s;
                }
                if (info.getType().equals("float") || info.getType().equals("Float")) {
                    result = Float.valueOf(s);
                }
                if (info.getType().equals("double") || info.getType().equals("Double")) {
                    result = Double.valueOf(s);
                }
                if (info.getType().equals("short") || info.getType().equals("Short")) {
                    result = Short.valueOf(s);
                }
                if (info.getType().equals("bool") || info.getType().equals("Bool") || info.getType().equals("boolean") || info.getType().equals("Boolean")) {
                    result = Boolean.valueOf(s);
                }
                if (info.getType().equals("char") || info.getType().equals("Char") || info.getType().equals("character") || info.getType().equals("Character")) {
                    result = s.toCharArray();
                }
                if (info.getType().equals("byte") || info.getType().equals("Byte")) {
                    result = Byte.valueOf(s);
                }
                if (info.getType().equals("long") || info.getType().equals("Long")) {
                    result = Long.valueOf(s);
                }
                attributes.put(info, result);
            }
            catch (NumberFormatException e) {
                occurredErrors.add("The value '" + s + "' isn't appropriate for '" + info.getName() + "' attribute, must be '" + info.getType() + "' type");
            }
        }
        if (occurredErrors.isEmpty()) {
            try {
                this.getBusinessBean().setRuntimeAttributes(this.componentName, this.port, this.password, this.host, this.login, attributes);
            }
            catch (PetalsServiceTechnicalException e) {
                LOGGER.error((Object)"Error occurred during the set of runtime attributes", (Throwable)e);
                throw new NonLocalizedError(PETALS_SERVICE_ERROR, e.getLocalizedMessage(), (Throwable)e);
            }
            ManagementUIBean managementUIBean = (ManagementUIBean)request.getSession().getAttribute("managementUIBean");
            managementUIBean.reconnect(request);
            return UIResult.SUCCESS.getValue();
        }
        request.getSession().setAttribute("occurredErrors", occurredErrors);
        return UIResult.ERROR.getValue();
    }

    public List<ServerTO> getCheckedServers(HttpServletRequest request) throws NonLocalizedError {
        ArrayList<ServerTO> serversTO = new ArrayList<ServerTO>();
        this.connect();
        if (this.domain != null) {
            serversTO.addAll(this.domain.getServers());
            for (ServerTO serverTO : serversTO) {
                serverTO.setAvailable(false);
                ManagementService service = null;
                try {
                    service = (ManagementService)ManagementServiceFactory.getInstance().getService(serverTO.getHost(), Integer.valueOf(serverTO.getPort()), serverTO.getLogin(), serverTO.getPassword());
                }
                catch (PetalsServiceTechnicalException e) {
                    if (e.getMessage() != null && e.getMessage().startsWith("Can't connect to Petals server on ")) {
                        LOGGER.warn((Object)e.getMessage());
                        if (e.getCause() != null && e.getCause().getMessage() != null) {
                            LOGGER.warn((Object)e.getCause().getMessage());
                        }
                    }
                    LOGGER.error((Object)"Error occurred during management service recovering", (Throwable)e);
                }
                if (service == null) continue;
                serverTO.setAvailable(true);
            }
        }
        return serversTO;
    }

    public String editComponentLogger(HttpServletRequest request) throws NonLocalizedError {
        if (this.loggerLevels == null || this.loggerLevels.length > 0) {
            try {
                this.loggerLevels = this.getBusinessBean().getAllLevels(this.port, this.password, this.host, this.login);
            }
            catch (PetalsServiceTechnicalException e) {
                LOGGER.error((Object)"Error occurred during recover of all component logger level", (Throwable)e);
                throw new NonLocalizedError(PETALS_SERVICE_ERROR, e.getMessage(), (Throwable)e);
            }
        }
        this.componentName = request.getParameter("componentName");
        if (this.componentName != null && !this.componentName.equals("")) {
            try {
                this.componentLoggerLevel = this.getBusinessBean().getLevelForLogger(this.getFormatedLoggerName(), this.port, this.password, this.host, this.login);
            }
            catch (PetalsServiceTechnicalException e) {
                LOGGER.error((Object)"Error occurred during component logger level recovery", (Throwable)e);
                throw new NonLocalizedError(PETALS_SERVICE_ERROR, e.getMessage(), (Throwable)e);
            }
        } else {
            LOGGER.warn((Object)"Logger component name must not be null in order to retrieve the wanted component logger");
            NonLocalizedError error = new NonLocalizedError(PETALS_CONSOLE_ERROR, "Logger component name must not be null in order to retrieve the wanted logger");
            error.setType((short)0);
            throw error;
        }
        return UIResult.SUCCESS.getValue();
    }

    public String modifyComponentLoggerLevel(HttpServletRequest request) throws NonLocalizedError {
        try {
            this.getBusinessBean().setLoggerLevel(this.getFormatedLoggerName(), this.componentLoggerLevel, this.port, this.password, this.host, this.login);
        }
        catch (PetalsServiceTechnicalException e) {
            LOGGER.error((Object)"Error occurred during component logger level modification", (Throwable)e);
            throw new NonLocalizedError(PETALS_SERVICE_ERROR, e.getMessage(), (Throwable)e);
        }
        return UIResult.SUCCESS.getValue();
    }

    public String getComponentLoggerLevel() {
        return this.componentLoggerLevel;
    }

    public void setComponentLoggerLevel(String componentLoggerLevel) {
        this.componentLoggerLevel = componentLoggerLevel;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public String getFormatedLoggerName() {
        StringBuilder builder = new StringBuilder();
        builder.append("Petals.Container.Components.");
        builder.append(this.componentName);
        return builder.toString();
    }

    public String getFormatedLoggerLevel() {
        String[] parts = this.componentLoggerLevel.split("\\.");
        return parts[parts.length - 1];
    }

    public String[] getLoggerLevels() {
        return this.loggerLevels;
    }

    public boolean establishConnection(ServerTO server, HttpServletRequest request) throws NonLocalizedError {
        boolean result = false;
        if (server.getHost() != null && server.getPort() != null) {
            try {
                server.setAvailable(false);
                this.getBusinessBean().establishConnection(server.getHost(), server.getPort(), server.getLogin(), server.getPassword());
                result = this.recoverDomain(server, request);
            }
            catch (PetalsServiceTechnicalException e) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Error occurred during connection establishment for server: " + server.getHost() + "/" + server.getPort() + "(host/port)"), (Throwable)e);
                } else {
                    LOGGER.warn((Object)("Error occurred during connection establishment for server: " + server.getHost() + "/" + server.getPort() + "(host/port)"));
                    LOGGER.warn((Object)e.getMessage());
                }
            }
            catch (NumberFormatException e) {
                LOGGER.error((Object)("Server: " + server.getHost() + "/" + server.getPort() + " not found, check the host attribute for declared servers into webconsole.xml"));
            }
        }
        return result;
    }

    public String establishConnection(HttpServletRequest request) throws NonLocalizedError {
        String serverNameConnection = request.getParameter("serverNameConnection");
        if (serverNameConnection == null || serverNameConnection.equals("")) {
            LOGGER.error((Object)"Parameter 'serverNameConnection' cannot be null or empty");
            throw new NonLocalizedError("Request error", "Parameter 'serverNameConnection' cannot be null or empty");
        }
        ServerFeatureUIBean sfuiBean = (ServerFeatureUIBean)request.getSession().getAttribute("serverFeatureUIBean");
        if (sfuiBean != null) {
            List configuredServers = sfuiBean.getConfiguredServers();
            for (Server configuredServer : configuredServers) {
                if (!configuredServer.getName().equals(serverNameConnection)) continue;
                try {
                    this.getBusinessBean().establishConnection(configuredServer.getHost(), configuredServer.getPort(), configuredServer.getLogin(), configuredServer.getPassword());
                }
                catch (NumberFormatException e) {
                    LOGGER.error((Object)"Error occurred during connection establishment", (Throwable)e);
                    return UIResult.ERROR.getValue();
                }
                catch (PetalsServiceTechnicalException e) {
                    LOGGER.error((Object)"Error occurred during connection establishment", (Throwable)e);
                    return UIResult.ERROR.getValue();
                }
                if (!this.recoverDomain(TOAdapter.xmlServerToTOServer((Server)configuredServer), request)) continue;
                return UIResult.SUCCESS.getValue();
            }
        }
        return UIResult.ERROR.getValue();
    }

    public String persistTopology(HttpServletRequest request) throws PetalsConsoleException, NonLocalizedError {
        ServerFeatureUIBean sfuiBean;
        ArrayList xmlServers = new ArrayList();
        if (this.domain != null) {
            xmlServers.addAll(TOAdapter.toServersToXMLServers((List)this.domain.getServers()));
        }
        if ((sfuiBean = (ServerFeatureUIBean)request.getSession().getAttribute("serverFeatureUIBean")) != null) {
            sfuiBean.saveServers(xmlServers);
        } else {
            ServerFeatureBBean sfbBean = new ServerFeatureBBean();
            for (Server xmlServer : xmlServers) {
                try {
                    sfbBean.addServer(xmlServer);
                }
                catch (IllegalArgumentException e) {
                    LOGGER.info((Object)"Server cannot again persist because, it's already present in configuration file");
                }
                catch (IOException e) {
                    LOGGER.error((Object)"Error occurred during server adding during persist topology action", (Throwable)e);
                    throw new NonLocalizedError(IOEXCEPTION_ERROR, e.getLocalizedMessage(), (Throwable)e);
                }
                catch (URISyntaxException e) {
                    LOGGER.error((Object)"Error occurred during server adding during persist topology action", (Throwable)e);
                    throw new NonLocalizedError(URI_SYNTAX_ERROR, e.getLocalizedMessage(), (Throwable)e);
                }
                catch (ParserConfigurationException e) {
                    LOGGER.error((Object)"Error occurred during server adding during persist topology action", (Throwable)e);
                    throw new NonLocalizedError(PARSER_CONFIGURATION_ERROR, e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
        return UIResult.SUCCESS.getValue();
    }

    public void refresh(HttpServletRequest request) {
        String serverName = request.getParameter("serverName");
        if (this.domain != null) {
            for (ServerTO server : this.domain.getServers()) {
                if (!server.getName().equals(serverName)) continue;
                this.host = server.getHost();
                this.login = server.getLogin();
                this.password = server.getPassword();
                this.port = server.getPort();
                this.currentServerName = server.getName();
            }
        }
    }

    public String getRemoteContext() {
        return this.remoteContext;
    }

    public void setRemoteContext(String remoteContext) {
        this.remoteContext = remoteContext;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public void setRemotePort(int remotePort) {
        this.remotePort = remotePort;
    }

    public boolean isInstalledRemoteComponent() {
        return this.installedRemoteComponent;
    }

    public void setInstalledRemoteIComponent(boolean installedRemoteComponent) {
        this.installedRemoteComponent = installedRemoteComponent;
    }

    public String changeConnection(HttpServletRequest request) throws NonLocalizedError {
        Server server2;
        String serverName = request.getParameter("name");
        String domain = request.getParameter("domain");
        ServerFeatureUIBean serverFeatureUIBean = (ServerFeatureUIBean)request.getSession().getAttribute("serverFeatureUIBean");
        ArrayList servers = new ArrayList();
        if (serverFeatureUIBean != null) {
            servers.addAll(serverFeatureUIBean.getConfiguredServers());
        }
        String oldConnectedDomain = "";
        if (this.domain != null && this.domain.getName() != null) {
            oldConnectedDomain = this.domain.getName();
        }
        for (Server server2 : servers) {
            if (!server2.getDomain().equals(domain) || !server2.getName().equals(serverName)) continue;
            this.host = server2.getHost();
            this.login = server2.getLogin();
            this.password = server2.getPassword();
            this.port = server2.getPort();
        }
        ServerUIBean serverUIBean = (ServerUIBean)request.getSession().getAttribute("serverUIBean");
        server2 = new ServerTO();
        server2.setHost(this.host);
        server2.setLogin(this.login);
        server2.setPassword(this.password);
        server2.setPort(this.port);
        server2.setDomainName(domain);
        server2.setName(serverName);
        if (this.establishConnection((ServerTO)server2, request)) {
            RemoteInjectorUIBean remoteInjectorUIBean;
            request.getSession().setAttribute("connectedServer", (Object)server2);
            this.currentServerName = server2.getName();
            if (this.domain != null && !oldConnectedDomain.equals(this.domain.getName()) && (remoteInjectorUIBean = (RemoteInjectorUIBean)request.getSession().getAttribute("remoteInjectorUIBean")) != null) {
                remoteInjectorUIBean.getExchanges().clear();
            }
        } else {
            if (serverUIBean != null) {
                this.currentServerName = serverUIBean.getServerName();
                if (this.domain != null) {
                    ServerTO serverTO = this.domain.findServer(this.currentServerName);
                    if (serverTO != null) {
                        this.failedConnection = serverTO.isAvailable();
                        this.currentServerName = serverTO.getName();
                    } else if (!this.domain.getServers().isEmpty()) {
                        this.currentServerName = ((ServerTO)this.domain.getServers().get(0)).getName();
                    }
                }
            }
            return UIResult.ERROR.getValue();
        }
        this.domainDisplaying = true;
        return UIResult.SUCCESS.getValue();
    }

    private Set<ServerTO> recoverXMLServer() throws NonLocalizedError {
        Set servers;
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            URL url = null;
            if (loader == null) {
                LOGGER.error((Object)"Class loader not found for webconsole.xml file recovering");
                throw new NonLocalizedError(CLASS_LOADER_ERROR, "class loader not found");
            }
            url = loader.getResource("webconsole.xml");
            if (url == null) {
                LOGGER.error((Object)"The webconsole.xml configuration file not found");
                throw new NonLocalizedError(CONFIGURATION_FILE_ERROR, "'webconsole.xml' configuration file not found");
            }
            servers = ConfigHelper.readConfig((URL)url);
        }
        catch (MalformedURLException e) {
            LOGGER.error((Object)"Error occurred during xml server recovering", (Throwable)e);
            throw new NonLocalizedError(MALFORMED_URL_ERROR, e.getLocalizedMessage(), (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error((Object)"Error occurred during xml server recovering", (Throwable)e);
            throw new NonLocalizedError(IOEXCEPTION_ERROR, e.getLocalizedMessage(), (Throwable)e);
        }
        catch (SAXException e) {
            LOGGER.error((Object)"Error occurred during xml server recovering", (Throwable)e);
            throw new NonLocalizedError(SAX_ERROR, e.getLocalizedMessage(), (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            LOGGER.error((Object)"Error occurred during xml server recovering", (Throwable)e);
            throw new NonLocalizedError(PARSER_CONFIGURATION_ERROR, e.getLocalizedMessage(), (Throwable)e);
        }
        catch (FactoryConfigurationError e) {
            LOGGER.error((Object)"Error occurred during xml server recovering", (Throwable)e);
            throw new NonLocalizedError(FACTORY_CONFIGURATION_ERROR, e.getLocalizedMessage(), (Throwable)e);
        }
        return servers;
    }

    public boolean recoverDomain(ServerTO server, HttpServletRequest request) throws NonLocalizedError {
        this.failedConnection = true;
        server.setAvailable(false);
        this.host = null;
        this.port = null;
        this.login = null;
        this.password = null;
        Set referentialServers = this.recoverXMLServer();
        try {
            Set topology = this.getBusinessBean().getTopology(server.getHost(), server.getPort(), server.getLogin(), server.getPassword());
            if (this.domain != null) {
                List oldServers = this.domain.getServers();
                this.domain = TopologyHelper.getDomain((Set)referentialServers, (Set)topology, (String)server.getHost(), (Integer)Integer.parseInt(server.getPort()), (String)server.getLogin(), (String)server.getPassword(), (String)server.getDomainName());
                List newServers = this.domain.getServers();
                for (ServerTO oldServer : oldServers) {
                    if (newServers.contains(oldServer)) continue;
                    newServers.add(oldServer);
                }
            } else {
                this.domain = TopologyHelper.getDomain((Set)referentialServers, (Set)topology, (String)server.getHost(), (Integer)Integer.parseInt(server.getPort()), (String)server.getLogin(), (String)server.getPassword(), (String)server.getDomainName());
            }
            for (ServerTO serverTO : this.domain.getServers()) {
                if (!serverTO.getHost().equals(server.getHost()) || !serverTO.getPort().equals(server.getPort()) || !serverTO.getPassword().equals(server.getPassword()) || !serverTO.getLogin().equals(server.getLogin())) continue;
                server.setName(serverTO.getName());
            }
            this.host = server.getHost();
            this.port = server.getPort();
            this.login = server.getLogin();
            this.password = server.getPassword();
            this.failedConnection = false;
            this.currentServerName = server.getName();
            request.getSession().setAttribute("connectedServer", (Object)server);
            return true;
        }
        catch (UnknownHostException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.error((Object)("The host: " + this.host + " is unknow or unreachable "), (Throwable)e);
            } else {
                LOGGER.error((Object)("The host: " + this.host + " is unknow or unreachable " + e.getLocalizedMessage()));
            }
            NonLocalizedError error = new NonLocalizedError(UNKNOW_HOST_ERROR, e.getLocalizedMessage());
            error.setType((short)0);
            throw error;
        }
        catch (NumberFormatException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.error((Object)("The port value: " + this.port + " is not properly formatted " + e.getLocalizedMessage()), (Throwable)e);
            } else {
                LOGGER.error((Object)("The port value: " + this.port + " is not properly formatted " + e.getLocalizedMessage()));
            }
            NonLocalizedError error = new NonLocalizedError(NUMBER_FORMAT_ERROR, e.getLocalizedMessage());
            error.setType((short)0);
            throw error;
        }
        catch (PetalsServiceTechnicalException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.error((Object)"Error occurred during updating domain", (Throwable)e);
            } else {
                LOGGER.error((Object)("Error occurred during updating domain: " + e.getMessage()));
            }
            NonLocalizedError error = new NonLocalizedError(PETALS_SERVICE_ERROR, e.getLocalizedMessage());
            error.setType((short)0);
            throw error;
        }
        catch (PetalsConsoleException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.error((Object)"Error occurred during updating domain", (Throwable)e);
            } else {
                LOGGER.error((Object)("Error occurred during updating domain: " + e.getMessage()));
            }
            NonLocalizedError error = new NonLocalizedError(PETALS_CONSOLE_ERROR, e.getLocalizedMessage());
            error.setType((short)0);
            throw error;
        }
    }

    public int getMonitoredMessageAgeType() {
        return this.monitoredMessageAgeType;
    }

    public void setMonitoredMessageAgeType(int monitoredMessageAgeType) {
        this.monitoredMessageAgeType = monitoredMessageAgeType;
    }

    public AgeType[] getMonitoredMessageAgeTypes() {
        return this.monitoredMessageAgeTypes;
    }

    public void setMonitoredMessageAgeTypes(AgeType[] monitoredMessageAgeTypes) {
        this.monitoredMessageAgeTypes = monitoredMessageAgeTypes;
    }

    public long getMonitoredMessageAge() {
        return this.monitoredMessageAge;
    }

    public void setMonitoredMessageAge(long monitoredMessageAge) {
        this.monitoredMessageAge = monitoredMessageAge;
    }

    public String performServerPropertiesForm() throws NonLocalizedError {
        if (this.businessBean == null) {
            this.businessBean = new ManagementBBean();
        }
        try {
            this.businessBean.updateMonitoredMessageAge(this.port, this.password, this.host, this.login, this.monitoredMessageAge * (long)this.monitoredMessageAgeType);
            return UIResult.SUCCESS.getValue();
        }
        catch (PetalsServiceTechnicalException e) {
            LOGGER.error((Object)"Error occurred during the update of monitored message age", (Throwable)e);
            NonLocalizedError error = new NonLocalizedError(PETALS_SERVICE_ERROR, "The host: " + this.host + " is unknown or unreachable " + e.getLocalizedMessage(), (Throwable)e);
            error.setType((short)1);
            throw error;
        }
        catch (NumberFormatException e) {
            LOGGER.error((Object)"Error occurred during the update of monitored message age", (Throwable)e);
            NonLocalizedError error = new NonLocalizedError(NUMBER_FORMAT_ERROR, "The port value: " + this.port + " is not properly formatted");
            error.setType((short)0);
            throw error;
        }
    }

    public String purgeNow() throws NonLocalizedError {
        try {
            this.getBusinessBean().purgeNow(this.port, this.password, this.host, this.login);
        }
        catch (PetalsServiceTechnicalException e) {
            LOGGER.error((Object)"Error occurred during purge now", (Throwable)e);
            NonLocalizedError error = new NonLocalizedError(PETALS_SERVICE_ERROR, "The host: " + this.host + " is unknown or unreachable " + e.getLocalizedMessage(), (Throwable)e);
            error.setType((short)1);
            throw error;
        }
        catch (NumberFormatException e) {
            LOGGER.error((Object)"Error occurred during purge now", (Throwable)e);
            NonLocalizedError error = new NonLocalizedError(NUMBER_FORMAT_ERROR, "The port value: " + this.port + " is not properly formatted");
            error.setType((short)0);
            throw error;
        }
        return UIResult.SUCCESS.getValue();
    }

    public void reloadServerPropertiesForm() {
        this.monitoredMessageAge = 0L;
        this.monitoredMessageAgeType = 0;
    }

    public void initServerPropertiesForm() throws NonLocalizedError {
        try {
            this.monitoredMessageAge = this.businessBean.getMonitorStorageDuration(this.host, this.port, this.login, this.password) / 60000L;
        }
        catch (NumberFormatException e) {
            LOGGER.error((Object)"Error occurred during monitor storage duration recovering", (Throwable)e);
            NonLocalizedError error = new NonLocalizedError(NUMBER_FORMAT_ERROR, "The port value: " + this.port + " is not properly formatted");
            error.setType((short)0);
            throw error;
        }
        catch (PetalsServiceTechnicalException e) {
            LOGGER.error((Object)"Error occurred during monitor storage duration recovering", (Throwable)e);
            NonLocalizedError error = new NonLocalizedError(PETALS_SERVICE_ERROR, e.getLocalizedMessage(), (Throwable)e);
            error.setType((short)1);
            throw error;
        }
        this.monitoredMessageAgeTypes = new AgeType[]{new AgeType(60000, "Minutes"), new AgeType(3600000, "Hours"), new AgeType(86400000, "Days")};
    }

    protected ManagementBBean getBusinessBean() {
        if (this.businessBean == null) {
            this.businessBean = new ManagementBBean();
        }
        return this.businessBean;
    }

    public final boolean isDomainDisplaying() {
        return this.domainDisplaying;
    }

    public final void setDomainDisplaying(boolean domainDisplaying) {
        this.domainDisplaying = domainDisplaying;
    }

    public String prepareAddingServer() {
        this.addServer = true;
        return UIResult.SUCCESS.getValue();
    }

    public String reInitializeAddingServer() {
        this.addServer = false;
        return UIResult.SUCCESS.getValue();
    }

    static {
        Properties props = new Properties();
        try {
            props.load(Thread.currentThread().getContextClassLoader().getResourceAsStream("general.properties"));
            NUMBER_FORMAT_ERROR = props.getProperty("number_format_error");
            UNKNOW_HOST_ERROR = props.getProperty("unknow_host_error");
            PETALS_SERVICE_ERROR = props.getProperty("petals_service_error");
            PETALS_CONSOLE_ERROR = props.getProperty("petals_console_error");
            USER_ACTION_ERROR = props.getProperty("user_action_error");
            CONFIGURATION_ERROR = props.getProperty("configuration_error");
            SAX_ERROR = props.getProperty("sax_error");
            PARSER_CONFIGURATION_ERROR = props.getProperty("parser_configuration_error");
            FACTORY_CONFIGURATION_ERROR = props.getProperty("factory_configuration_error");
            WSDLEXCEPTION_ERROR = props.getProperty("wsdlexception_error");
            MALFORMED_URL_ERROR = props.getProperty("malformed_url_error");
            IOEXCEPTION_ERROR = props.getProperty("ioexception_error");
            URI_SYNTAX_ERROR = props.getProperty("uri_syntax_error");
            FILE_NOT_FOUND_ERROR = props.getProperty("file_not_found_error");
            REMOTE_SERVER_CONFIGURATION_ERROR = props.getProperty("remote_server_configuration_error");
            ILLEGAL_ARGUMENT_ERROR = props.getProperty("illegal_argument_error");
            CLASS_LOADER_ERROR = props.getProperty("class_loader_error");
            CONFIGURATION_FILE_ERROR = props.getProperty("configuration_file_error");
            SELECTED_ENDPOINT_ERROR = props.getProperty("selected_endpoint_error");
            TRANSFORMER_ERROR = props.getProperty("transformer_error");
            TRANSFORMER_FACTORY_CONFIGURATION_ERROR = props.getProperty("transformer_factory_configuration_error");
            MESSAGING_ERROR = props.getProperty("messaging_error");
            DOWNLOAD_ATTACHMENT_ERROR = props.getProperty("download_attachment_error");
            FORM_FIELD_ERROR = props.getProperty("form_field_error");
        }
        catch (IOException e) {
            LOGGER.error((Object)"Unable to load errors message located in general.properties, due to the following exception", (Throwable)e);
        }
    }
}

