/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.tools.webconsole.uibeans;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.easywsdl.wsdl.api.Description;
import org.ow2.easywsdl.wsdl.api.InterfaceType;
import org.ow2.easywsdl.wsdl.api.Operation;
import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.ow2.easywsdl.wsdl.api.WSDLImportException;
import org.ow2.opensuit.core.error.NonLocalizedError;
import org.ow2.opensuit.core.impl.multiparts.IFileUploadPart;
import org.ow2.opensuit.core.session.OpenSuitSession;
import org.ow2.opensuit.core.util.HtmlUtils;
import org.ow2.petals.tools.webconsole.business.ManagementBBean;
import org.ow2.petals.tools.webconsole.business.MonitoringBBean;
import org.ow2.petals.tools.webconsole.services.PetalsServiceTechnicalException;
import org.ow2.petals.tools.webconsole.services.management.ManagementService;
import org.ow2.petals.tools.webconsole.services.management.ManagementServiceFactory;
import org.ow2.petals.tools.webconsole.to.ComponentTO;
import org.ow2.petals.tools.webconsole.to.DomainTO;
import org.ow2.petals.tools.webconsole.to.EndPointTO;
import org.ow2.petals.tools.webconsole.to.ExchangeFilterTO;
import org.ow2.petals.tools.webconsole.to.MonitoredExchangeTO;
import org.ow2.petals.tools.webconsole.to.MonitoredNormalizedMessageTO;
import org.ow2.petals.tools.webconsole.to.MonitoredPropertyTO;
import org.ow2.petals.tools.webconsole.to.ServerTO;
import org.ow2.petals.tools.webconsole.uibeans.ManagementUIBean;
import org.ow2.petals.tools.webconsole.uibeans.utils.ExchangeTransformerHelper;
import org.ow2.petals.tools.webconsole.uibeans.utils.UIResult;
import org.ow2.petals.tools.webconsole.utils.GeneralHelper;
import org.ow2.petals.tools.webconsole.utils.StringHelper;
import org.w3c.dom.Document;

public class MonitoringUIBean
implements Serializable {
    private static final long serialVersionUID = 7281598549919402452L;
    private static final Log LOGGER = LogFactory.getLog(MonitoringUIBean.class);
    private static final String BEGIN_XML_CONTENT_FORMAT_TAG = "\\html\\<pre class=xmlContentFormat>";
    private static final String ENDING_XML_CONTENT_FORMAT_TAG = "</pre>";
    private static final List<String> STATUS;
    private static final EndPointTO DEFAULT_ENDPOINT;
    private static final String NULL = "null";
    private static final String ALL_EXCHANGE_SERIE = "all";
    private static final String PETALS_GENERIC_COMPONENT = "petals-bcse-component";
    private ServerTO currentServer;
    private EndPointTO currentEndpoint;
    private String selectedInterfaceName;
    private String selectedServiceName;
    private String selectedEndpointName;
    private String selectedOperationName;
    private boolean selectedStoreExchanges;
    private transient MonitoringBBean businessBean;
    private MonitoredExchangeTO monitoredExchange;
    private static final int ONE_MIN_IN_MILLISEC = 1000;
    private long exchangeCountStartDate;
    private long exchangeCountEndDate;
    private int exchangeMaxTime = 3600000;
    private int exchangeIntervalTime = 300000;
    private int exchangeCountSteps = this.exchangeMaxTime / this.exchangeIntervalTime;
    private List<String> exchangesCountSeries;
    private List<ExchangeFilterTO> createdFilters;
    private boolean manually;
    private boolean endpointFiltering;
    private boolean interfaceFiltering;
    private boolean serviceFiltering;
    private boolean operationFiltering;
    private Date startingDate;
    private Date endingDate;
    private File importedCSVFile;
    private boolean badCriteria;
    private SortedMap<Long, String[]> exchangeStatusSteps;
    private String[] exchangeStatusForCurrentSlice;

    public MonitoringUIBean() {
        this.businessBean = new MonitoringBBean();
        this.exchangeStatusSteps = new TreeMap();
        this.exchangesCountSeries = new ArrayList();
        this.exchangesCountSeries.add(ALL_EXCHANGE_SERIE);
        this.exchangesCountSeries.add("done");
        this.exchangesCountSeries.add("active");
        this.exchangesCountSeries.add("error");
        Calendar calendar = GregorianCalendar.getInstance();
        this.startingDate = calendar.getTime();
        calendar.add(6, 1);
        this.endingDate = calendar.getTime();
        this.createdFilters = new ArrayList();
    }

    public ServerTO getCurrentServer() {
        if (this.currentServer == null) {
            this.load(OpenSuitSession.getCurrentRequest());
        }
        return this.currentServer;
    }

    public void setCurrentServer(ServerTO currentServer) {
        this.currentServer = currentServer;
    }

    public String getSelectedInterfaceName() {
        return this.selectedInterfaceName;
    }

    public void setSelectedInterfaceName(String selectedInterfaceName) {
        this.selectedInterfaceName = selectedInterfaceName == null || selectedInterfaceName.equals("") ? NULL : selectedInterfaceName;
    }

    public String getSelectedServiceName() {
        return this.selectedServiceName;
    }

    public void setSelectedServiceName(String selectedServiceName) {
        this.selectedServiceName = selectedServiceName == null || selectedServiceName.equals("") ? NULL : selectedServiceName;
    }

    public String getSelectedEndpointName() {
        return this.selectedEndpointName;
    }

    public void setSelectedEndpointName(String selectedEndpointName) {
        this.selectedEndpointName = selectedEndpointName == null || selectedEndpointName.equals("") ? NULL : selectedEndpointName;
    }

    public String getSelectedOperationName() {
        return this.selectedOperationName;
    }

    public void setSelectedOperationName(String selectedOperationName) {
        this.selectedOperationName = selectedOperationName == null || selectedOperationName.equals("") ? NULL : selectedOperationName;
    }

    public boolean isSelectedStoreExchanges() {
        return this.selectedStoreExchanges;
    }

    public void setSelectedStoreExchanges(boolean selectedStoreExchanges) {
        this.selectedStoreExchanges = selectedStoreExchanges;
    }

    public String createFilter() throws NonLocalizedError {
        ExchangeFilterTO filterTO = new ExchangeFilterTO();
        if (this.endpointFiltering) {
            filterTO.setEndpointName(this.selectedEndpointName);
        } else {
            filterTO.setEndpointName(NULL);
        }
        if (this.interfaceFiltering) {
            filterTO.setInterfaceName(QName.valueOf(this.selectedInterfaceName));
        } else {
            filterTO.setInterfaceName(QName.valueOf(NULL));
        }
        if (this.operationFiltering) {
            filterTO.setOperationName(QName.valueOf(this.selectedOperationName));
        } else {
            filterTO.setOperationName(QName.valueOf(NULL));
        }
        if (this.serviceFiltering) {
            filterTO.setServiceName(QName.valueOf(this.selectedServiceName));
        } else {
            filterTO.setServiceName(QName.valueOf(NULL));
        }
        filterTO.setStoreExchanges(this.selectedStoreExchanges);
        filterTO.setServerOwner(this.currentServer.getName());
        try {
            if (this.filterAlreadyCreated(filterTO)) {
                LOGGER.warn((Object)("Filter [endpointName=" + this.selectedEndpointName + ", interfaceName=" + this.selectedInterfaceName + ", operationName=" + this.selectedOperationName + ", serviceName=" + this.selectedServiceName + "] already exist"));
                NonLocalizedError error = new NonLocalizedError(ManagementUIBean.USER_ACTION_ERROR, "Filter [endpointName=" + this.selectedEndpointName + ", interfaceName=" + this.selectedInterfaceName + ", operationName=" + this.selectedOperationName + ", serviceName=" + this.selectedServiceName + "] already exist");
                error.setType((short)0);
                throw error;
            }
            this.createdFilters.add(filterTO);
        }
        catch (NumberFormatException e) {
            LOGGER.error((Object)"Error occurred during creation filter", (Throwable)e);
            NonLocalizedError error = new NonLocalizedError(ManagementUIBean.NUMBER_FORMAT_ERROR, e.getLocalizedMessage());
            error.setType((short)0);
            throw error;
        }
        return UIResult.SUCCESS.getValue();
    }

    private EndPointTO findCurrentEndpoint(String endpointName, String serviceName) {
        this.loadEndpoints();
        EndPointTO edTO = null;
        for (EndPointTO endPointTO : this.currentServer.getEndpoints()) {
            if (!endPointTO.getName().equals(endpointName)) continue;
            if (serviceName != null && serviceName.equals(endPointTO.getService().toString())) {
                if (endPointTO.getOperations() == null) {
                    endPointTO.setOperations(new ArrayList());
                }
                if (endPointTO.getOperations().size() == 0) {
                    endPointTO.getOperations().add(QName.valueOf(NULL));
                }
                edTO = endPointTO;
                break;
            }
            if (serviceName != null) continue;
            if (endPointTO.getOperations() == null) {
                endPointTO.setOperations(new ArrayList());
            }
            if (endPointTO.getOperations().size() == 0) {
                endPointTO.getOperations().add(QName.valueOf(NULL));
            }
            edTO = endPointTO;
            break;
        }
        return edTO;
    }

    private EndPointTO findCurrentEndpoint(String endpointName) {
        this.loadEndpoints();
        EndPointTO edTO = null;
        for (EndPointTO endPointTO : this.currentServer.getEndpoints()) {
            if (!endPointTO.getName().equals(endpointName)) continue;
            edTO = endPointTO;
            break;
        }
        return edTO;
    }

    public EndPointTO getCurrentEndpoint() {
        return this.currentEndpoint;
    }

    public void setCurrentEndpoint(EndPointTO currentEndpoint) {
        this.currentEndpoint = currentEndpoint;
    }

    public void load(HttpServletRequest request) {
        DomainTO domain;
        String serverName;
        ManagementUIBean managementUIBean = (ManagementUIBean)request.getSession().getAttribute("managementUIBean");
        if (managementUIBean != null && (serverName = request.getParameter("serverName")) != null && !serverName.equals("") && (domain = managementUIBean.getDomain()) != null) {
            this.currentServer = domain.findServer(serverName);
        }
        ArrayList createFilterTOs = new ArrayList();
        if (this.currentServer != null) {
            createFilterTOs.addAll(this.currentServer.getFilters());
        }
        if (this.currentServer != null) {
            this.loadEndpoints();
            if (this.currentServer.getEndpoints() != null && this.currentServer.getEndpoints().size() > 0) {
                if (this.selectedEndpointName == null) {
                    this.currentEndpoint = (EndPointTO)this.currentServer.getEndpoints().get(0);
                } else {
                    if (this.endpointFiltering && this.serviceFiltering) {
                        this.currentEndpoint = this.findCurrentEndpoint(this.selectedEndpointName, this.selectedServiceName);
                    } else if (this.endpointFiltering && !this.serviceFiltering) {
                        this.currentEndpoint = this.findCurrentEndpoint(this.selectedEndpointName);
                    } else if (!this.endpointFiltering && this.serviceFiltering) {
                        this.currentEndpoint = this.findCurrentEndpointByService(this.selectedServiceName);
                    }
                    this.badCriteria = this.currentEndpoint == null;
                }
            } else if (this.selectedEndpointName == null || this.selectedEndpointName.equals("") || this.selectedEndpointName.equals(NULL)) {
                this.currentEndpoint = DEFAULT_ENDPOINT;
            }
            for (ExchangeFilterTO currentFilterTO : createFilterTOs) {
                if (this.filterAlreadyCreated(currentFilterTO)) continue;
                this.currentServer.getFilters().add(currentFilterTO);
            }
            this.refreshFormFields();
        }
    }

    private void refreshFormFields() {
        if (this.currentEndpoint != null) {
            this.selectedEndpointName = this.currentEndpoint.getName();
            this.selectedInterfaceName = this.currentEndpoint.getInterfaceName().toString();
            this.selectedOperationName = this.currentEndpoint.getOperations() != null && this.currentEndpoint.getOperations().size() > 0 ? ((QName)this.currentEndpoint.getOperations().get(0)).toString() : ("[]".equals(this.currentEndpoint.getOperations().toString()) ? NULL : this.currentEndpoint.getOperations().toString());
            this.selectedServiceName = this.currentEndpoint.getService().toString();
        }
    }

    public String deleteExchangeFilter(HttpServletRequest request) throws NonLocalizedError {
        NonLocalizedError error;
        String filterUUID = request.getParameter("filterUUID");
        ExchangeFilterTO deleteFilter = null;
        if (filterUUID != null && !filterUUID.equals("")) {
            for (ExchangeFilterTO exchangeFilterTO : this.getAllFilters()) {
                if (!filterUUID.equals(exchangeFilterTO.getUuid().toString())) continue;
                deleteFilter = exchangeFilterTO;
            }
        } else {
            LOGGER.warn((Object)"UUID filter not correctly sent for exchange filter deleting");
            NonLocalizedError error2 = new NonLocalizedError(ManagementUIBean.PETALS_CONSOLE_ERROR, "UUID filter not correctly sent for exchange filter deleting");
            error2.setType((short)0);
            throw error2;
        }
        if (deleteFilter != null) {
            if (this.removeFilter(deleteFilter)) {
                return UIResult.SUCCESS.getValue();
            }
            LOGGER.error((Object)("Error occurred during filter removing unable to delete filter: " + deleteFilter.getUuid() + ", on endpoint: " + deleteFilter.getEndpointName()));
            error = new NonLocalizedError(ManagementUIBean.PETALS_CONSOLE_ERROR, "Unable to delete filter: " + deleteFilter.getUuid() + ", on endpoint: " + deleteFilter.getEndpointName());
            error.setType((short)0);
            throw error;
        }
        LOGGER.warn((Object)("Error occurred during filter deleting, no filter found for delete the [ " + filterUUID + "] filter UUID"));
        error = new NonLocalizedError(ManagementUIBean.PETALS_CONSOLE_ERROR, "No filter found for delete the [ " + filterUUID + "] filter UUID");
        error.setType((short)0);
        throw error;
    }

    public String changeMonitoringStatusFilter(HttpServletRequest request) throws NonLocalizedError {
        String monitoringStatus = request.getParameter("monitoringStatus");
        String filterUUID = request.getParameter("filterUUID");
        if (monitoringStatus != null && !monitoringStatus.equals("") && filterUUID != null && !filterUUID.equals("")) {
            for (ExchangeFilterTO exchangeFilterTO : this.getAllFilters()) {
                if (!filterUUID.equals(exchangeFilterTO.getUuid().toString())) continue;
                try {
                    if (Boolean.valueOf(monitoringStatus).booleanValue()) {
                        exchangeFilterTO.setActivateMonitoring(this.getBusinessBean().changeMonitoringStatus(false, this.currentServer.getHost(), Integer.valueOf(this.currentServer.getPort()), this.currentServer.getLogin(), this.currentServer.getPassword(), exchangeFilterTO));
                        this.createdFilters.add(exchangeFilterTO);
                        this.currentServer.getFilters().remove(exchangeFilterTO);
                        continue;
                    }
                    exchangeFilterTO.setActivateMonitoring(this.getBusinessBean().changeMonitoringStatus(true, this.currentServer.getHost(), Integer.valueOf(this.currentServer.getPort()), this.currentServer.getLogin(), this.currentServer.getPassword(), exchangeFilterTO));
                    this.createdFilters.remove(exchangeFilterTO);
                    if (this.currentServer.filterAlreadyCreated(exchangeFilterTO)) continue;
                    this.currentServer.getFilters().add(exchangeFilterTO);
                }
                catch (PetalsServiceTechnicalException e) {
                    LOGGER.error((Object)"Error occurred during filter monitoring status changing", (Throwable)e);
                    if (e.getMessage().contains("The Router Monitor filter RouterMonitorFilter") && e.getMessage().contains("is not registered")) {
                        this.removeFilter(exchangeFilterTO);
                    }
                    throw new NonLocalizedError(ManagementUIBean.PETALS_SERVICE_ERROR, e.getLocalizedMessage(), (Throwable)e);
                }
            }
        } else {
            LOGGER.warn((Object)"UUID filter or monitoring status not correctly sent for filter monitoring status changing");
            NonLocalizedError error = new NonLocalizedError(ManagementUIBean.PETALS_CONSOLE_ERROR, "UUID filter or monitoring status not correctly sent");
            error.setType((short)0);
            throw error;
        }
        return UIResult.SUCCESS.getValue();
    }

    public List<EndPointTO> getCurrentServerEndpoints() {
        if (this.currentServer.getEndpoints() != null && this.currentServer.getEndpoints().size() > 0) {
            return this.currentServer.getEndpoints();
        }
        ArrayList<EndPointTO> endpointList = new ArrayList<EndPointTO>();
        endpointList.add(DEFAULT_ENDPOINT);
        return endpointList;
    }

    public List<String> getFilterExchangeIds(String filterUUID) throws NonLocalizedError {
        ArrayList<String> exchangeIds = new ArrayList<String>();
        for (ExchangeFilterTO exchangeFilterTO : this.currentServer.getFilters()) {
            if (!exchangeFilterTO.getUuid().toString().equals(filterUUID)) continue;
            try {
                exchangeIds.addAll(this.getBusinessBean().getFilterExchangeIds(this.currentServer.getHost(), Integer.valueOf(Integer.parseInt(this.currentServer.getPort())), this.currentServer.getLogin(), this.currentServer.getPassword(), exchangeFilterTO, this.startingDate.getTime(), this.endingDate.getTime()));
            }
            catch (NumberFormatException e) {
                LOGGER.error((Object)"Error occurred during filter exchange ids recovery", (Throwable)e);
                NonLocalizedError error = new NonLocalizedError(ManagementUIBean.NUMBER_FORMAT_ERROR, "The port value: " + this.currentServer.getPort() + " is not properly formatted");
                error.setType((short)0);
                throw error;
            }
            catch (PetalsServiceTechnicalException e) {
                LOGGER.error((Object)"Error occurred during filter exchange ids recovery", (Throwable)e);
                throw new NonLocalizedError(ManagementUIBean.PETALS_SERVICE_ERROR, e.getMessage(), (Throwable)e);
            }
        }
        return exchangeIds;
    }

    public String getExchangeOverview(HttpServletRequest request) throws NonLocalizedError {
        if (request != null && this.currentServer != null) {
            String exchangeId = request.getParameter("exchangeId");
            if (exchangeId == null) {
                exchangeId = (String)request.getSession().getAttribute("exchangeId");
                request.getSession().removeAttribute("exchangeId");
            }
            if (exchangeId != null) {
                Map exchangeMapResult;
                block20: {
                    exchangeMapResult = null;
                    try {
                        exchangeMapResult = this.getBusinessBean().getExchange(this.currentServer.getHost(), Integer.valueOf(Integer.parseInt(this.currentServer.getPort())), this.currentServer.getLogin(), this.currentServer.getPassword(), exchangeId);
                    }
                    catch (NumberFormatException e) {
                        LOGGER.error((Object)"Error occurred during exchange history recovery", (Throwable)e);
                        NonLocalizedError error = new NonLocalizedError(ManagementUIBean.NUMBER_FORMAT_ERROR, "The port value: " + this.currentServer.getPort() + " is not properly formatted");
                        error.setType((short)0);
                        throw error;
                    }
                    catch (PetalsServiceTechnicalException e) {
                        LOGGER.error((Object)"Error occurred during exchange history recovery", (Throwable)e);
                        NonLocalizedError error = new NonLocalizedError(ManagementUIBean.PETALS_SERVICE_ERROR, e.getMessage(), (Throwable)e);
                        error.setType((short)0);
                        throw error;
                    }
                    this.monitoredExchange = new MonitoredExchangeTO();
                    if (exchangeMapResult == null) {
                        return UIResult.ERROR.getValue();
                    }
                    ExchangeTransformerHelper.transformMonitoredExchange((MonitoredExchangeTO)this.monitoredExchange, (Map)exchangeMapResult);
                    try {
                        if (this.distributedMonitoredExchange(this.monitoredExchange)) {
                            ManagementUIBean managementUIBean = (ManagementUIBean)request.getSession().getAttribute("managementUIBean");
                            if (managementUIBean == null) break block20;
                            String otherServerName = null;
                            otherServerName = this.monitoredExchange.getConsumerContainer().equals(this.currentServer.getName()) ? this.monitoredExchange.getProviderContainer() : this.monitoredExchange.getConsumerContainer();
                            ServerTO otherInvolvedServer = managementUIBean.getDomain().findServer(otherServerName);
                            if (otherInvolvedServer == null) break block20;
                            this.monitoredExchange.setHistory(this.getBusinessBean().getDistributedExchangeHistory(this.currentServer, otherInvolvedServer, this.monitoredExchange.getId()));
                            try {
                                if (exchangeMapResult != null) {
                                    exchangeMapResult.putAll(this.getBusinessBean().getExchange(otherInvolvedServer.getHost(), Integer.valueOf(Integer.parseInt(otherInvolvedServer.getPort())), otherInvolvedServer.getLogin(), otherInvolvedServer.getPassword(), exchangeId));
                                } else {
                                    exchangeMapResult = this.getBusinessBean().getExchange(otherInvolvedServer.getHost(), Integer.valueOf(Integer.parseInt(otherInvolvedServer.getPort())), otherInvolvedServer.getLogin(), otherInvolvedServer.getPassword(), exchangeId);
                                }
                                break block20;
                            }
                            catch (NumberFormatException e) {
                                LOGGER.error((Object)"Error occurred during exchange informations recovery, located on the other involved node", (Throwable)e);
                                NonLocalizedError error = new NonLocalizedError(ManagementUIBean.NUMBER_FORMAT_ERROR, "The port value: " + this.currentServer.getPort() + " is not properly formatted");
                                error.setType((short)0);
                                throw error;
                            }
                            catch (PetalsServiceTechnicalException e) {
                                LOGGER.error((Object)"Error occurred during exchange informations recovery, located on the other involved node", (Throwable)e);
                                throw new NonLocalizedError(ManagementUIBean.PETALS_SERVICE_ERROR, e.getMessage(), (Throwable)e);
                            }
                        }
                        this.monitoredExchange.setHistory(this.getBusinessBean().getExchangeHistory(this.currentServer.getHost(), Integer.parseInt(this.currentServer.getPort()), this.currentServer.getLogin(), this.currentServer.getPassword(), this.monitoredExchange.getId()));
                    }
                    catch (NumberFormatException e) {
                        LOGGER.error((Object)"Error occurred during exchange history recovery", (Throwable)e);
                        NonLocalizedError error = new NonLocalizedError(ManagementUIBean.NUMBER_FORMAT_ERROR, "The port value: " + this.currentServer.getPort() + " is not properly formatted");
                        error.setType((short)0);
                        throw error;
                    }
                    catch (PetalsServiceTechnicalException e) {
                        LOGGER.error((Object)"Error occurred during exchange history recovery", (Throwable)e);
                        throw new NonLocalizedError(ManagementUIBean.PETALS_SERVICE_ERROR, e.getMessage(), (Throwable)e);
                    }
                }
                if (exchangeMapResult != null) {
                    ExchangeTransformerHelper.transformMonitoredExchange((MonitoredExchangeTO)this.monitoredExchange, (Map)exchangeMapResult);
                }
                try {
                    this.monitoredExchange.setDuration(Long.valueOf(this.getBusinessBean().getDurationForExchange(this.monitoredExchange.getHistory())));
                }
                catch (NumberFormatException e) {
                    LOGGER.error((Object)"Error occurred for setting duration while history recovery", (Throwable)e);
                    NonLocalizedError error = new NonLocalizedError(ManagementUIBean.NUMBER_FORMAT_ERROR, "The port value: " + this.currentServer.getPort() + " is not properly formatted");
                    error.setType((short)0);
                    throw error;
                }
                catch (PetalsServiceTechnicalException e) {
                    LOGGER.error((Object)"Error occurred for setting duration while history recovery", (Throwable)e);
                    throw new NonLocalizedError(ManagementUIBean.PETALS_SERVICE_ERROR, e.getMessage(), (Throwable)e);
                }
            }
        }
        return UIResult.SUCCESS.getValue();
    }

    public void recoverFilters() throws NonLocalizedError {
        List filters = null;
        if (this.currentServer == null) {
            this.currentServer = (ServerTO)OpenSuitSession.getCurrentRequest().getSession().getAttribute("connectedServer");
        }
        try {
            filters = this.getBusinessBean().recoverFilters(this.currentServer.getHost(), Integer.parseInt(this.currentServer.getPort()), this.currentServer.getLogin(), this.currentServer.getPassword());
        }
        catch (NumberFormatException e) {
            LOGGER.error((Object)"Error occurred during filter recovery", (Throwable)e);
            NonLocalizedError error = new NonLocalizedError(ManagementUIBean.NUMBER_FORMAT_ERROR, "The port value: " + this.currentServer.getPort() + " is not properly formatted");
            error.setType((short)0);
            throw error;
        }
        catch (PetalsServiceTechnicalException e) {
            LOGGER.error((Object)"Error occurred during filter recovery", (Throwable)e);
            throw new NonLocalizedError(ManagementUIBean.PETALS_SERVICE_ERROR, e.getMessage(), (Throwable)e);
        }
        if (filters != null && filters.size() > 0) {
            for (Map entryMap : filters) {
                ExchangeFilterTO exchangeFilterTO = new ExchangeFilterTO();
                exchangeFilterTO.setInterfaceName(QName.valueOf((String)entryMap.get("interfaceName")));
                if (entryMap.get("endpointName") != null) {
                    exchangeFilterTO.setEndpointName((String)entryMap.get("endpointName"));
                } else {
                    exchangeFilterTO.setEndpointName(NULL);
                }
                exchangeFilterTO.setServiceName(QName.valueOf((String)entryMap.get("serviceName")));
                exchangeFilterTO.setOperationName(QName.valueOf((String)entryMap.get("operationName")));
                exchangeFilterTO.setStoreExchanges(Boolean.parseBoolean((String)entryMap.get("storeExchanges")));
                exchangeFilterTO.setServerOwner(this.currentServer.getName());
                if (this.filterAlreadyActivated(exchangeFilterTO)) continue;
                exchangeFilterTO.setActivateMonitoring(true);
                this.currentServer.getFilters().add(exchangeFilterTO);
            }
        }
    }

    private boolean filterAlreadyActivated(ExchangeFilterTO exchangeFilterTO) {
        for (ExchangeFilterTO currentFilterTO : this.currentServer.getFilters()) {
            if (!exchangeFilterTO.getEndpointName().equals(currentFilterTO.getEndpointName()) || !exchangeFilterTO.getInterfaceName().equals(currentFilterTO.getInterfaceName()) || !exchangeFilterTO.getServiceName().equals(currentFilterTO.getServiceName()) || !exchangeFilterTO.getOperationName().equals(currentFilterTO.getOperationName()) || exchangeFilterTO.isStoreExchanges() != currentFilterTO.isStoreExchanges()) continue;
            return true;
        }
        return false;
    }

    private boolean filterAlreadyCreated(ExchangeFilterTO currentFilterTO) {
        for (ExchangeFilterTO exchangeFilterTO : this.getAllFilters()) {
            if (!exchangeFilterTO.getEndpointName().equals(currentFilterTO.getEndpointName()) || !exchangeFilterTO.getInterfaceName().equals(currentFilterTO.getInterfaceName()) || !exchangeFilterTO.getServiceName().equals(currentFilterTO.getServiceName()) || !exchangeFilterTO.getOperationName().equals(currentFilterTO.getOperationName()) || exchangeFilterTO.isStoreExchanges() != currentFilterTO.isStoreExchanges()) continue;
            return true;
        }
        return false;
    }

    public MonitoredExchangeTO getMonitoredExchange() {
        return this.monitoredExchange;
    }

    public void setMonitoredExchange(MonitoredExchangeTO monitoredExchange) {
        this.monitoredExchange = monitoredExchange;
    }

    public boolean hasInSentMessage() {
        boolean result = false;
        if (this.monitoredExchange.isStored()) {
            for (MonitoredNormalizedMessageTO mnm : this.monitoredExchange.getNormalizedMessages()) {
                if (!mnm.getNormalizedMessageType().equals("in")) continue;
                result = true;
            }
        } else if (this.monitoredExchange.getHistory().get("in-sent") != null) {
            result = true;
        }
        return result;
    }

    public boolean hasOutSentMessage() {
        boolean result = false;
        if (this.monitoredExchange.isStored()) {
            for (MonitoredNormalizedMessageTO mnm : this.monitoredExchange.getNormalizedMessages()) {
                if (!mnm.getNormalizedMessageType().equals("out")) continue;
                result = true;
            }
        } else if (this.monitoredExchange.getHistory().get("out-sent") != null) {
            result = true;
        }
        return result;
    }

    public boolean hasFaultSentMessage() {
        boolean result = false;
        if (this.monitoredExchange.isStored()) {
            for (MonitoredNormalizedMessageTO mnm : this.monitoredExchange.getNormalizedMessages()) {
                if (!mnm.getNormalizedMessageType().equals("fault")) continue;
                result = true;
            }
        } else if (this.monitoredExchange.getHistory().get("fault-sent") != null) {
            result = true;
        }
        return result;
    }

    public String renderMessages(HttpServletRequest request) throws NonLocalizedError {
        StringBuilder builder = new StringBuilder();
        try {
            if (this.componentImageAvailable("/resources/img/components/" + this.monitoredExchange.getConsumerComponent() + ".png")) {
                builder.append("<img src='" + request.getContextPath() + "/resources/img/components/" + this.monitoredExchange.getConsumerComponent() + ".png' title='Component consumer: " + this.monitoredExchange.getConsumerComponent() + " / Container consumer: " + this.monitoredExchange.getConsumerContainer() + "'  id='consumerComponentImg'/>");
            } else {
                builder.append("<img src='" + request.getContextPath() + "/resources/img/components/" + PETALS_GENERIC_COMPONENT + ".png' title='Component consumer: " + this.monitoredExchange.getConsumerComponent() + " / Container consumer: " + this.monitoredExchange.getConsumerContainer() + "'  id='consumerComponentImg'/>");
            }
        }
        catch (MalformedURLException e) {
            LOGGER.error((Object)"Error occurred during monitoring rendering", (Throwable)e);
            throw new NonLocalizedError(ManagementUIBean.MALFORMED_URL_ERROR, e.getLocalizedMessage(), (Throwable)e);
        }
        if ("InOut".equals(this.monitoredExchange.getMep())) {
            builder.append("<div id='monitoringMessagesDiv'>");
            if (this.hasInSentMessage()) {
                builder.append("<img src='" + request.getContextPath() + "/resources/img/monitoring/min-in-narrow.png' title='in message, transfert duration: " + this.getInTransfertTime() + " ms'  id='inInOutMessageImg'/>");
            }
            if (this.hasOutSentMessage()) {
                builder.append("<img src='" + request.getContextPath() + "/resources/img/monitoring/min-out-narrow.png' title='out message, transfert duration: " + this.getOutTransfertTime() + " ms' id='outInOutMessageImg'/>");
            }
            if (this.hasFaultSentMessage()) {
                builder.append("<img src='" + request.getContextPath() + "/resources/img/monitoring/min-fault-narrow-provider.png' title='fault message, transfert duration: " + this.getFaultTransfertTime() + " ms' id='faultInOutMessageImg'/>");
            }
            if (this.hasDoneSentMessage()) {
                builder.append("<img src='" + request.getContextPath() + "/resources/img/monitoring/min-done-narrow-consumer.png' title='done message, transfert duration: " + this.getDoneAckTransfertTime() + " ms'  id='doneInOutMessageImg'/>");
            }
            if (this.hasErrorMessage()) {
                builder.append("<img src='" + request.getContextPath() + "/resources/img/monitoring/min-error-narrow-provider.png' title='error message, transfert duration: " + this.getErrorAckTransfertTime() + " ms'  id='errorInOutMessageImg'/>");
            }
            builder.append("</div>");
        }
        if ("InOnly".equals(this.monitoredExchange.getMep())) {
            builder.append("<div id='monitoringMessagesDiv'>");
            if (this.hasInSentMessage()) {
                builder.append("<img src='" + request.getContextPath() + "/resources/img/monitoring/min-in-narrow.png' title='in message, transfert duration: " + this.getInTransfertTime() + " ms'  id='inInOnlyMessageImg'/>");
            }
            if (this.hasDoneSentMessage()) {
                builder.append("<img src='" + request.getContextPath() + "/resources/img/monitoring/min-done-narrow-provider.png' title='done message, transfert duration: " + this.getDoneAckTransfertTime() + " ms'  id='doneInOnlyMessageImg'/>");
            }
            if (this.hasErrorMessage()) {
                builder.append("<img src='" + request.getContextPath() + "/resources/img/monitoring/min-error-narrow-provider.png' title='error message, transfert duration: " + this.getErrorAckTransfertTime() + " ms'  id='errorInOutMessageImg'/>");
            }
            builder.append("</div>");
        }
        if ("RobustInOnly".equals(this.monitoredExchange.getMep())) {
            builder.append("<div id='monitoringMessagesDiv'>");
            if (this.hasInSentMessage()) {
                builder.append("<img src='" + request.getContextPath() + "/resources/img/monitoring/min-in-narrow.png' title='in message, transfert duration: " + this.getInTransfertTime() + " ms'  id='inRobustInOnlyMessageImg'/>");
            }
            if (this.hasOutSentMessage()) {
                builder.append("<img src='" + request.getContextPath() + "/resources/img/monitoring/min-out-narrow.png' title='out message, transfert duration: " + this.getOutTransfertTime() + " ms' id='outRobustInOnlyMessageImg'/>");
            }
            if (this.hasFaultSentMessage()) {
                builder.append("<img src='" + request.getContextPath() + "/resources/img/monitoring/min-fault-narrow-provider.png' title='fault message, transfert duration: " + this.getFaultTransfertTime() + " ms' id='faultRobustInOnlyMessageImg'/>");
            }
            if (this.hasDoneSentMessage()) {
                if (this.hasFaultSentMessage()) {
                    builder.append("<img src='" + request.getContextPath() + "/resources/img/monitoring/min-done-narrow-consumer.png' title='done message, transfert duration: " + this.getDoneAckTransfertTime() + " ms'  id='doneRobustInOnlyMessageImg'/>");
                } else {
                    builder.append("<img src='" + request.getContextPath() + "/resources/img/monitoring/min-done-narrow-provider.png' title='done message, transfert duration: " + this.getDoneAckTransfertTime() + " ms'  id='doneRobustInOnlyMessageImg'/>");
                }
            }
            if (this.hasErrorMessage()) {
                builder.append("<img src='" + request.getContextPath() + "/resources/img/monitoring/min-error-narrow-provider.png' title='error message, transfert duration: " + this.getErrorAckTransfertTime() + " ms'  id='errorInOutMessageImg'/>");
            }
            builder.append("</div>");
        }
        if ("InOptionalOut".equals(this.monitoredExchange.getMep())) {
            builder.append("<div id='monitoringMessagesDiv'>");
            if (this.hasInSentMessage()) {
                builder.append("<img src='" + request.getContextPath() + "/resources/img/monitoring/min-in-narrow.png' title='in message, transfert duration: " + this.getInTransfertTime() + " ms'  id='inRobustInOnlyMessageImg'/>");
            }
            if (!this.hasOutSentMessage() && !this.hasFaultSentMessage() && this.hasDoneSentMessage()) {
                builder.append("<img src='" + request.getContextPath() + "/resources/img/monitoring/min-done-narrow-provider.png' title='done message, transfert duration: " + this.getDoneAckTransfertTime() + " ms' id='doneRobustInOnlyMessageImg'/>");
            } else if (!this.hasOutSentMessage() && this.hasFaultSentMessage() && this.hasDoneSentMessage()) {
                builder.append("<img src='" + request.getContextPath() + "/resources/img/monitoring/min-fault-narrow-provider.png' title='fault message, transfert duration: " + this.getFaultTransfertTime() + " ms' id='faultRobustInOnlyMessageImg'/>");
                builder.append("<img src='" + request.getContextPath() + "/resources/img/monitoring/min-done-narrow-consumer.png' title='done message, transfert duration: " + this.getDoneAckTransfertTime() + " ms' id='doneRobustInOnlyMessageImg'/>");
            } else if (this.hasOutSentMessage() && !this.hasFaultSentMessage() && this.hasDoneSentMessage()) {
                builder.append("<img src='" + request.getContextPath() + "/resources/img/monitoring/min-out-narrow.png' title='out message, transfert duration: " + this.getOutTransfertTime() + " ms' id='outRobustInOnlyMessageImg'/>");
                builder.append("<img src='" + request.getContextPath() + "/resources/img/monitoring/min-done-narrow-consumer.png' title='done message, transfert duration: " + this.getDoneAckTransfertTime() + " ms' id='doneRobustInOnlyMessageImg'/>");
            } else if (this.hasOutSentMessage() && this.hasFaultSentMessage() && this.hasDoneSentMessage()) {
                builder.append("<img src='" + request.getContextPath() + "/resources/img/monitoring/min-out-narrow.png' title='out message, transfert duration: " + this.getOutTransfertTime() + " ms' id='outRobustInOnlyMessageImg'/>");
                builder.append("<img src='" + request.getContextPath() + "/resources/img/monitoring/min-fault-narrow-consumer.png' title='fault message, transfert duration: " + this.getFaultTransfertTime() + " ms' id='faultRobustInOnlyMessageImg'/>");
                builder.append("<img src='" + request.getContextPath() + "/resources/img/monitoring/min-done-narrow-provider.png' title='done message, transfert duration: " + this.getDoneAckTransfertTime() + " ms' id='doneRobustInOnlyMessageImg'/>");
            } else if (this.hasOutSentMessage()) {
                builder.append("<img src='" + request.getContextPath() + "/resources/img/monitoring/min-out-narrow.png' title='out message, transfert duration: " + this.getOutTransfertTime() + " ms' id='outRobustInOnlyMessageImg'/>");
            }
            if (this.hasErrorMessage()) {
                builder.append("<img src='" + request.getContextPath() + "/resources/img/monitoring/min-error-narrow-provider.png' title='error message, transfert duration: " + this.getErrorAckTransfertTime() + " ms'  id='errorInOutMessageImg'/>");
            }
            builder.append("</div>");
        }
        try {
            if (this.componentImageAvailable("/resources/img/components/" + this.monitoredExchange.getProviderComponent() + ".png")) {
                builder.append("<img src='" + request.getContextPath() + "/resources/img/components/" + this.monitoredExchange.getProviderComponent() + ".png' title='Component provider: " + this.monitoredExchange.getProviderComponent() + " / Container provider: " + this.monitoredExchange.getProviderContainer() + "'  id='providerComponentImg'/>");
            } else {
                builder.append("<img src='" + request.getContextPath() + "/resources/img/components/" + PETALS_GENERIC_COMPONENT + ".png' title='Component provider: " + this.monitoredExchange.getProviderComponent() + " / Container provider: " + this.monitoredExchange.getProviderContainer() + "'  id='providerComponentImg'/>");
            }
        }
        catch (MalformedURLException e) {
            LOGGER.error((Object)"Error occurred during monitoring rendering", (Throwable)e);
            throw new NonLocalizedError(ManagementUIBean.MALFORMED_URL_ERROR, e.getLocalizedMessage(), (Throwable)e);
        }
        return builder.toString();
    }

    public long getInTransfertTime() {
        long result = 0L;
        if (this.monitoredExchange.getHistory().get("in-sent") != null && this.monitoredExchange.getHistory().get("in-received") != null) {
            result = (Long)this.monitoredExchange.getHistory().get("in-received") - (Long)this.monitoredExchange.getHistory().get("in-sent");
        }
        if (result > 0L) {
            return result;
        }
        return 0L;
    }

    public long getOutTransfertTime() {
        long result = 0L;
        if (this.monitoredExchange.getHistory().get("out-sent") != null && this.monitoredExchange.getHistory().get("out-received") != null) {
            result = (Long)this.monitoredExchange.getHistory().get("out-received") - (Long)this.monitoredExchange.getHistory().get("out-sent");
        }
        if (result > 0L) {
            return result;
        }
        return 0L;
    }

    public long getFaultTransfertTime() {
        long result = 0L;
        if (this.monitoredExchange.getHistory().get("fault-sent") != null && this.monitoredExchange.getHistory().get("fault-received") != null) {
            result = (Long)this.monitoredExchange.getHistory().get("fault-received") - (Long)this.monitoredExchange.getHistory().get("fault-sent");
        }
        if (result > 0L) {
            return result;
        }
        return 0L;
    }

    public long getErrorAckTransfertTime() {
        long result = 0L;
        if (this.monitoredExchange.getHistory().get("error-ack-sent") != null && this.monitoredExchange.getHistory().get("error-ack-received") != null) {
            result = (Long)this.monitoredExchange.getHistory().get("error-ack-received") - (Long)this.monitoredExchange.getHistory().get("error-ack-sent");
        }
        if (result > 0L) {
            return result;
        }
        return 0L;
    }

    public long getDoneAckTransfertTime() {
        long result = 0L;
        if (this.monitoredExchange.getHistory().get("done-ack-sent") != null && this.monitoredExchange.getHistory().get("done-ack-received") != null) {
            result = (Long)this.monitoredExchange.getHistory().get("done-ack-received") - (Long)this.monitoredExchange.getHistory().get("done-ack-sent");
        }
        if (result > 0L) {
            return result;
        }
        return 0L;
    }

    public boolean hasDoneSentMessage() {
        boolean result = false;
        if (this.monitoredExchange.isStored()) {
            for (MonitoredNormalizedMessageTO mnm : this.monitoredExchange.getNormalizedMessages()) {
                if (!mnm.getNormalizedMessageType().equals("done")) continue;
                result = true;
            }
        } else if (this.monitoredExchange.getHistory().get("done-ack-sent") != null || this.monitoredExchange.getHistory().get("error-ack-sent") != null) {
            result = true;
        }
        return result;
    }

    public MonitoredNormalizedMessageTO getInMNM() {
        for (MonitoredNormalizedMessageTO mnm : this.monitoredExchange.getNormalizedMessages()) {
            if (!mnm.getNormalizedMessageType().equals("in")) continue;
            return mnm;
        }
        return null;
    }

    public MonitoredNormalizedMessageTO getOutMNM() {
        for (MonitoredNormalizedMessageTO mnm : this.monitoredExchange.getNormalizedMessages()) {
            if (!mnm.getNormalizedMessageType().equals("out")) continue;
            return mnm;
        }
        return null;
    }

    public MonitoredNormalizedMessageTO getFaultMNM() {
        for (MonitoredNormalizedMessageTO mnm : this.monitoredExchange.getNormalizedMessages()) {
            if (!mnm.getNormalizedMessageType().equals("fault")) continue;
            return mnm;
        }
        return null;
    }

    public MonitoredNormalizedMessageTO getDoneMNM() {
        for (MonitoredNormalizedMessageTO mnm : this.monitoredExchange.getNormalizedMessages()) {
            if (!mnm.getNormalizedMessageType().equals("done")) continue;
            return mnm;
        }
        return null;
    }

    public boolean isInOnlyExchange() {
        return "InOnly".equals(this.monitoredExchange.getMep());
    }

    public boolean isInOutExchange() {
        return "InOut".equals(this.monitoredExchange.getMep());
    }

    public boolean isRobustInOnlyExchange() {
        return "RobustInOnly".equals(this.monitoredExchange.getMep());
    }

    public boolean isInOptionalOutExchange() {
        return "InOptionalOut".equals(this.monitoredExchange.getMep());
    }

    public String getNMContent(String nm) throws NonLocalizedError {
        StringBuilder builder = new StringBuilder();
        builder.append(BEGIN_XML_CONTENT_FORMAT_TAG);
        for (MonitoredNormalizedMessageTO mnm : this.monitoredExchange.getNormalizedMessages()) {
            if (!mnm.getNormalizedMessageType().equals(nm)) continue;
            builder.append(HtmlUtils.encode2HTML((String)StringHelper.prettyPrint((String)mnm.getContent())));
        }
        builder.append(ENDING_XML_CONTENT_FORMAT_TAG);
        return builder.toString();
    }

    public boolean notEmptyProperties(String nm) {
        for (MonitoredNormalizedMessageTO mnm : this.monitoredExchange.getNormalizedMessages()) {
            if (!mnm.getNormalizedMessageType().equals(nm) || mnm.getProperties() == null || mnm.getProperties().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean notEmptyMEXProperties() {
        return this.monitoredExchange.getProperties() != null && !this.monitoredExchange.getProperties().isEmpty();
    }

    public List<MonitoredPropertyTO> getMEXProperties() {
        ArrayList<MonitoredPropertyTO> propertieTOs = new ArrayList<MonitoredPropertyTO>();
        if (this.monitoredExchange.getProperties() != null && !this.monitoredExchange.getProperties().isEmpty()) {
            propertieTOs.addAll(this.monitoredExchange.getProperties());
        }
        return propertieTOs;
    }

    public List<MonitoredPropertyTO> getNMProperties(String nm) {
        ArrayList<MonitoredPropertyTO> propertieTOs = new ArrayList<MonitoredPropertyTO>();
        for (MonitoredNormalizedMessageTO mnm : this.monitoredExchange.getNormalizedMessages()) {
            if (!mnm.getNormalizedMessageType().equals(nm)) continue;
            propertieTOs.addAll(mnm.getProperties());
        }
        return propertieTOs;
    }

    public boolean notEmptyAttachments(String nm) {
        for (MonitoredNormalizedMessageTO mnm : this.monitoredExchange.getNormalizedMessages()) {
            if (!mnm.getNormalizedMessageType().equals(nm) || mnm.getAttachments() == null || mnm.getAttachments().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public List<String> getNMAttachments(String nm) {
        ArrayList<String> attachments = new ArrayList<String>();
        for (MonitoredNormalizedMessageTO mnm : this.monitoredExchange.getNormalizedMessages()) {
            if (!mnm.getNormalizedMessageType().equals(nm)) continue;
            attachments.addAll(mnm.getAttachments());
        }
        return attachments;
    }

    public String getMEP(String exchangeId) throws NonLocalizedError {
        try {
            return this.getBusinessBean().getMEPExchange(this.currentServer.getHost(), Integer.parseInt(this.currentServer.getPort()), this.currentServer.getLogin(), this.currentServer.getPassword(), exchangeId);
        }
        catch (NumberFormatException e) {
            LOGGER.error((Object)"Error occurred during the get of MEP exchange", (Throwable)e);
            NonLocalizedError error = new NonLocalizedError(ManagementUIBean.NUMBER_FORMAT_ERROR, "The port value: " + this.currentServer.getPort() + " is not properly formatted");
            error.setType((short)0);
            throw error;
        }
        catch (PetalsServiceTechnicalException e) {
            LOGGER.error((Object)"Error occurred during the get of MEP exchange", (Throwable)e);
            throw new NonLocalizedError(ManagementUIBean.PETALS_SERVICE_ERROR, e.getMessage(), (Throwable)e);
        }
    }

    public int getTotalExchangesForFilter(ExchangeFilterTO filter) throws NonLocalizedError {
        try {
            return this.getTotalExchanges(filter, 0L, System.currentTimeMillis());
        }
        catch (NumberFormatException e) {
            LOGGER.error((Object)("Error occurred during the get of total exchanges for filter: " + filter.getEISO()), (Throwable)e);
            NonLocalizedError error = new NonLocalizedError(ManagementUIBean.NUMBER_FORMAT_ERROR, "The port value: " + this.currentServer.getPort() + " is not properly formatted");
            error.setType((short)0);
            throw error;
        }
        catch (PetalsServiceTechnicalException e) {
            LOGGER.error((Object)("Error occurred during the get of total exchanges for filter: " + filter.getEISO()), (Throwable)e);
            throw new NonLocalizedError(ManagementUIBean.PETALS_SERVICE_ERROR, e.getMessage(), (Throwable)e);
        }
    }

    private int getTotalExchanges(ExchangeFilterTO filter, long start, long end) throws NumberFormatException, PetalsServiceTechnicalException {
        return this.getBusinessBean().getTotalExchangesForFilter(this.currentServer.getHost(), Integer.parseInt(this.currentServer.getPort()), this.currentServer.getLogin(), this.currentServer.getPassword(), filter, start, end);
    }

    public List<String> getSTATUS() {
        return STATUS;
    }

    public Integer getStatusValue(String itStatus) {
        int maxValue = 0;
        Collection stepStatusCollection = this.exchangeStatusSteps.values();
        Iterator i$ = stepStatusCollection.iterator();
        while (i$.hasNext()) {
            String[] stepStatus;
            for (String status : stepStatus = (String[])i$.next()) {
                if (!itStatus.equals(status)) continue;
                ++maxValue;
            }
        }
        return maxValue;
    }

    public void loadStatusChartValue(String filterUUID) throws NonLocalizedError {
        if (this.exchangeStatusSteps.size() == 0 && this.currentServer != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.add(14, -this.exchangeMaxTime);
            this.exchangeCountStartDate = calendar.getTime().getTime();
            this.exchangeCountEndDate = this.exchangeCountStartDate + (long)this.exchangeIntervalTime;
            for (ExchangeFilterTO filter : this.currentServer.getFilters()) {
                if (!filter.getUuid().toString().equals(filterUUID)) continue;
                for (int i = 0; i < this.exchangeCountSteps; ++i) {
                    this.exchangeStatusSteps.put(this.exchangeCountStartDate, this.recoverExchangeStatus(filter));
                    this.exchangeCountStartDate = this.exchangeCountEndDate;
                    this.exchangeCountEndDate += (long)this.exchangeIntervalTime;
                }
            }
        }
    }

    public List<String> getExchangesCountSeries() {
        return this.exchangesCountSeries;
    }

    public double[][] getExchangesCount(String filterUUID, String nameSerie) throws NonLocalizedError {
        ExchangeFilterTO currentFilter = this.currentServer.getExchangeFilter(filterUUID);
        double[][] values = new double[2][this.exchangeCountSteps];
        if (this.exchangeStatusForCurrentSlice == null) {
            this.exchangeStatusForCurrentSlice = this.recoverExchangeStatus(currentFilter);
            if (this.exchangeStatusSteps.size() >= this.exchangeCountSteps) {
                this.exchangeStatusSteps.remove(this.exchangeStatusSteps.firstKey());
            }
            this.exchangeStatusSteps.put(this.exchangeCountStartDate, this.exchangeStatusForCurrentSlice);
        }
        if (nameSerie.equals("error") && this.exchangeCountEndDate < System.currentTimeMillis()) {
            this.exchangeCountStartDate = this.exchangeCountEndDate;
            this.exchangeCountEndDate += (long)this.exchangeIntervalTime;
            this.exchangeStatusForCurrentSlice = null;
        }
        Set keys = this.exchangeStatusSteps.keySet();
        Long[] keysArray = keys.toArray(new Long[keys.size()]);
        Calendar calendar = Calendar.getInstance();
        for (int i = 0; i < keysArray.length; ++i) {
            Long key = keysArray[i];
            String[] stepStatus = (String[])this.exchangeStatusSteps.get(key);
            calendar.setTimeInMillis(key);
            values[0][i] = calendar.getTimeInMillis();
            int maxValue = 0;
            for (String status : stepStatus) {
                if (!nameSerie.equals(ALL_EXCHANGE_SERIE) && !nameSerie.equals(status)) continue;
                ++maxValue;
            }
            values[1][i] = maxValue;
        }
        return values;
    }

    public ExchangeFilterTO getFilterByUUID(String uuid) {
        return this.currentServer.getExchangeFilter(uuid);
    }

    public boolean isManually() {
        return this.manually;
    }

    public void setManually(boolean manually) {
        this.manually = manually;
    }

    private boolean componentImageAvailable(String component) throws MalformedURLException {
        File componentFile = null;
        if (OpenSuitSession.getCurrentRequest().getSession().getServletContext().getRealPath(component) == null) {
            componentFile = new File(OpenSuitSession.getCurrentRequest().getSession().getServletContext().getResource(component).toString());
            return componentFile != null;
        }
        componentFile = new File(OpenSuitSession.getCurrentRequest().getSession().getServletContext().getRealPath(component));
        return componentFile != null && componentFile.exists();
    }

    public void upload(IFileUploadPart file, HttpServletRequest request) throws NonLocalizedError {
        String contentType = file.getFileContentType();
        try {
            if (!("text/comma-separated-values".equals(contentType) || "application/csv".equals(contentType) || "text/csv".equals(contentType) || "text/x-csv".equals(contentType))) {
                LOGGER.warn((Object)"Error occurred during CSV file uploading, File content-type must be [text/comma-separated-values] [application/csv] [text/x-csv] [text/csv] ");
                throw new NonLocalizedError(ManagementUIBean.PETALS_SERVICE_ERROR, "File content-type must be [text/comma-separated-values] [application/csv] [text/x-csv] [text/csv] ");
            }
            this.importedCSVFile = this.getBusinessBean().storeCSVImport(file, request);
        }
        catch (IOException e) {
            LOGGER.error((Object)"Error occurred during CSV file uploading", (Throwable)e);
            throw new NonLocalizedError(ManagementUIBean.IOEXCEPTION_ERROR, e.getLocalizedMessage(), (Throwable)e);
        }
        catch (URISyntaxException e) {
            LOGGER.error((Object)"Error occurred during CSV file uploading", (Throwable)e);
            throw new NonLocalizedError(ManagementUIBean.URI_SYNTAX_ERROR, e.getLocalizedMessage(), (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String importFilters() throws NonLocalizedError {
        if (this.importedCSVFile != null) {
            List data = null;
            try {
                data = GeneralHelper.readCSVFile((URI)this.importedCSVFile.toURI());
            }
            catch (IOException e) {
                LOGGER.error((Object)"Error occurred during filter importation", (Throwable)e);
                throw new NonLocalizedError(ManagementUIBean.IOEXCEPTION_ERROR, e.getLocalizedMessage(), (Throwable)e);
            }
            if (data != null && data.size() > 0) {
                List occurredErrors = this.addImportedFitlers(data);
                if (occurredErrors.size() <= 0) return UIResult.SUCCESS.getValue();
                StringBuilder builder = new StringBuilder();
                builder.append("Occurred errors: \n");
                for (String error : occurredErrors) {
                    builder.append(error);
                    builder.append("\n");
                }
                throw new NonLocalizedError(ManagementUIBean.USER_ACTION_ERROR, builder.toString());
            }
            LOGGER.warn((Object)"Error occurred during CSV file uploading: no data available");
            NonLocalizedError error = new NonLocalizedError(ManagementUIBean.USER_ACTION_ERROR, "No data available");
            error.setType((short)0);
            throw error;
        }
        LOGGER.warn((Object)"Error occurred during CSV file uploading: no imported CSV file available");
        NonLocalizedError error = new NonLocalizedError(ManagementUIBean.USER_ACTION_ERROR, "No imported CSV file available");
        error.setType((short)0);
        throw error;
    }

    private List<String> addImportedFitlers(List<String[]> data) {
        ArrayList<String> occurredErrors = new ArrayList<String>();
        int i = 0;
        String[] firstRow = data.get(0);
        if (firstRow[0].equals("Endpoint") && firstRow[1].equals("Interface") && firstRow[2].equals("Operation") && firstRow[3].equals("Service")) {
            i = 1;
        }
        do {
            String[] dataFilters;
            if ((dataFilters = data.get(i)).length < 7) continue;
            ExchangeFilterTO exchangefilterTO = new ExchangeFilterTO();
            exchangefilterTO.setEndpointName(dataFilters[0]);
            exchangefilterTO.setInterfaceName(QName.valueOf(dataFilters[1]));
            exchangefilterTO.setOperationName(QName.valueOf(dataFilters[2]));
            exchangefilterTO.setServiceName(QName.valueOf(dataFilters[3]));
            if (!StringHelper.isNotNullAndNotEmpty((String)dataFilters[4])) {
                occurredErrors.add("Storage value must be a boolean type" + i);
                break;
            }
            exchangefilterTO.setStoreExchanges(Boolean.valueOf(dataFilters[4]).booleanValue());
            if (!StringHelper.isNotNullAndNotEmpty((String)dataFilters[5])) {
                occurredErrors.add("Server value must not be null or empty for row: " + i);
                break;
            }
            exchangefilterTO.setServerOwner(dataFilters[5]);
            if (StringHelper.isNotNullAndNotEmpty((String)dataFilters[6])) {
                if ("Disabled".equals(dataFilters[6])) {
                    exchangefilterTO.setActivateMonitoring(false);
                } else if ("Enabled".equals(dataFilters[6])) {
                    exchangefilterTO.setActivateMonitoring(true);
                } else {
                    occurredErrors.add("Monitoring must be either 'Disabled' or 'Enabled'");
                }
            } else {
                occurredErrors.add("Monitoring value must not be null or empty for row: " + i);
                break;
            }
            if (this.currentServer.filterAlreadyCreated(exchangefilterTO)) {
                this.currentServer.removeFilter(exchangefilterTO);
            }
            ExchangeFilterTO filterToDelete = null;
            for (ExchangeFilterTO filterTO : this.createdFilters) {
                if (!filterTO.getEndpointName().equals(exchangefilterTO.getEndpointName()) || !filterTO.getInterfaceName().equals(exchangefilterTO.getInterfaceName()) || !filterTO.getOperationName().equals(exchangefilterTO.getOperationName()) || !filterTO.getServiceName().equals(exchangefilterTO.getServiceName()) || filterTO.isStoreExchanges() != exchangefilterTO.isStoreExchanges()) continue;
                filterToDelete = filterTO;
            }
            if (filterToDelete != null) {
                this.createdFilters.remove(filterToDelete);
            }
            if (exchangefilterTO.getServerOwner().equals(this.currentServer.getName())) {
                if (exchangefilterTO.isActivateMonitoring()) {
                    try {
                        this.getBusinessBean().changeMonitoringStatus(true, this.currentServer.getHost(), Integer.valueOf(Integer.parseInt(this.currentServer.getPort())), this.currentServer.getLogin(), this.currentServer.getPassword(), exchangefilterTO);
                    }
                    catch (NumberFormatException e) {
                        LOGGER.warn((Object)("Error occurred during CSV file importation: " + e.getLocalizedMessage() + " for server: " + this.currentServer.getHost() + "/" + this.currentServer.getPort() + "(host/port)"));
                    }
                    catch (PetalsServiceTechnicalException e) {
                        LOGGER.warn((Object)("Error occurred during CSV file importation: " + e.getLocalizedMessage() + " for server: " + this.currentServer.getHost() + "/" + this.currentServer.getPort() + "(host/port)"));
                    }
                    this.currentServer.getFilters().add(exchangefilterTO);
                    continue;
                }
                try {
                    this.getBusinessBean().changeMonitoringStatus(false, this.currentServer.getHost(), Integer.valueOf(Integer.parseInt(this.currentServer.getPort())), this.currentServer.getLogin(), this.currentServer.getPassword(), exchangefilterTO);
                }
                catch (NumberFormatException e) {
                    LOGGER.warn((Object)("Error occurred during CSV file importation: " + e.getLocalizedMessage() + " for server: " + this.currentServer.getHost() + "/" + this.currentServer.getPort() + "(host/port)"));
                }
                catch (PetalsServiceTechnicalException e) {
                    LOGGER.warn((Object)("Error occurred during CSV file importation: " + e.getLocalizedMessage() + " for server: " + this.currentServer.getHost() + "/" + this.currentServer.getPort() + "(host/port)"));
                }
                this.createdFilters.add(exchangefilterTO);
                continue;
            }
            occurredErrors.add("Monitoring filter [" + exchangefilterTO.getEISO() + "] not imported because it can only be imported on Petals container '" + exchangefilterTO.getServerOwner() + "'");
            LOGGER.info((Object)("Monitoring filter [" + exchangefilterTO.getEISO() + "] not imported because it can only be imported on Petals container '" + exchangefilterTO.getServerOwner() + "'"));
        } while (++i < data.size() - 1);
        return occurredErrors;
    }

    public boolean isStoredExchange() {
        return this.monitoredExchange.isStored();
    }

    public List<ExchangeFilterTO> getAllFilters() {
        ArrayList<ExchangeFilterTO> allFilters = new ArrayList<ExchangeFilterTO>();
        allFilters.addAll(this.currentServer.getFilters());
        for (ExchangeFilterTO filterTO : this.createdFilters) {
            if (!filterTO.getServerOwner().equals(this.currentServer.getName())) continue;
            allFilters.add(filterTO);
        }
        return allFilters;
    }

    private boolean removeFilter(ExchangeFilterTO exchangeFilterTO) throws NonLocalizedError {
        boolean result = false;
        if (exchangeFilterTO.isActivateMonitoring()) {
            try {
                this.getBusinessBean().changeMonitoringStatus(false, this.currentServer.getHost(), Integer.valueOf(Integer.parseInt(this.currentServer.getPort())), this.currentServer.getLogin(), this.currentServer.getPassword(), exchangeFilterTO);
            }
            catch (NumberFormatException e) {
                LOGGER.error((Object)"Error occurred during filter removing", (Throwable)e);
                NonLocalizedError error = new NonLocalizedError(ManagementUIBean.NUMBER_FORMAT_ERROR, "The port value: " + this.currentServer.getPort() + " is not properly formatted");
                error.setType((short)0);
                throw error;
            }
            catch (PetalsServiceTechnicalException e) {
                LOGGER.error((Object)"Error occurred during filter removing", (Throwable)e);
                throw new NonLocalizedError(ManagementUIBean.PETALS_SERVICE_ERROR, e.getMessage(), (Throwable)e);
            }
            ExchangeFilterTO seekedFilter = null;
            for (ExchangeFilterTO serverFilterTO : this.currentServer.getFilters()) {
                if (!serverFilterTO.getEndpointName().equals(exchangeFilterTO.getEndpointName()) || !serverFilterTO.getInterfaceName().equals(exchangeFilterTO.getInterfaceName()) || !serverFilterTO.getOperationName().equals(exchangeFilterTO.getOperationName()) || !serverFilterTO.getServiceName().equals(exchangeFilterTO.getServiceName()) || !serverFilterTO.getServerOwner().equals(exchangeFilterTO.getServerOwner()) || serverFilterTO.isStoreExchanges() != exchangeFilterTO.isStoreExchanges()) continue;
                seekedFilter = serverFilterTO;
            }
            if (seekedFilter != null) {
                result = this.currentServer.getFilters().remove(seekedFilter);
            }
        } else {
            result = this.createdFilters.remove(exchangeFilterTO);
        }
        return result;
    }

    private boolean distributedMonitoredExchange(MonitoredExchangeTO monitoredExchangeTO) {
        return !monitoredExchangeTO.getConsumerContainer().equals(monitoredExchangeTO.getProviderContainer());
    }

    public Date getStartingDate() {
        return this.startingDate;
    }

    public void setStartingDate(Date startingDate) throws NonLocalizedError {
        if (startingDate == null) {
            NonLocalizedError error = new NonLocalizedError(ManagementUIBean.FORM_FIELD_ERROR, "Form starting date field must not be null");
            error.setType((short)0);
            throw error;
        }
        this.startingDate = startingDate;
    }

    public Date getEndingDate() {
        return this.endingDate;
    }

    public void setEndingDate(Date endingDate) throws NonLocalizedError {
        if (endingDate == null) {
            NonLocalizedError error = new NonLocalizedError(ManagementUIBean.FORM_FIELD_ERROR, "Form ending date field must not be null");
            error.setType((short)0);
            throw error;
        }
        this.endingDate = endingDate;
    }

    public String updateMonitoredSlice() {
        return UIResult.SUCCESS.getValue();
    }

    public boolean isEndpointFiltering() {
        return this.endpointFiltering;
    }

    public void setEndpointFiltering(boolean endpointFiltering) {
        this.endpointFiltering = endpointFiltering;
    }

    public boolean isInterfaceFiltering() {
        return this.interfaceFiltering;
    }

    public void setInterfaceFiltering(boolean interfaceFiltering) {
        this.interfaceFiltering = interfaceFiltering;
    }

    public boolean isServiceFiltering() {
        return this.serviceFiltering;
    }

    public void setServiceFiltering(boolean serviceFiltering) {
        this.serviceFiltering = serviceFiltering;
    }

    public boolean isOperationFiltering() {
        return this.operationFiltering;
    }

    public void setOperationFiltering(boolean operationFiltering) {
        this.operationFiltering = operationFiltering;
    }

    public int getExchangeMaxTimeForUser() {
        return this.exchangeMaxTime / 1000;
    }

    public void setExchangeMaxTimeForUser(int exchangeMaxTime) {
        this.exchangeMaxTime = exchangeMaxTime * 1000;
    }

    public int getExchangeIntervalTimeForUser() {
        return this.exchangeIntervalTime / 1000;
    }

    public void setExchangeIntervalTimeForUser(int exchangeIntervalTime) {
        this.exchangeIntervalTime = exchangeIntervalTime * 1000;
    }

    public int getExchangeMaxTime() {
        return this.exchangeMaxTime;
    }

    public void setExchangeMaxTime(int exchangeMaxTime) {
        this.exchangeMaxTime = exchangeMaxTime;
    }

    public int getExchangeIntervalTime() {
        return this.exchangeIntervalTime;
    }

    public void setExchangeIntervalTime(int exchangeIntervalTime) {
        this.exchangeIntervalTime = exchangeIntervalTime;
    }

    public long getExchangeCountStartDate() {
        return this.exchangeCountStartDate;
    }

    private String[] recoverExchangeStatus(ExchangeFilterTO currentFilter) throws NonLocalizedError {
        try {
            return this.getBusinessBean().getStatusValueForFilter(this.currentServer.getHost(), Integer.parseInt(this.currentServer.getPort()), this.currentServer.getLogin(), this.currentServer.getPassword(), currentFilter, this.exchangeCountStartDate, this.exchangeCountEndDate);
        }
        catch (NumberFormatException e) {
            LOGGER.error((Object)("Error occurred during exchange status recovery for filter: " + currentFilter.getEISO()), (Throwable)e);
            NonLocalizedError error = new NonLocalizedError(ManagementUIBean.NUMBER_FORMAT_ERROR, "The port value: " + this.currentServer.getPort() + " is not properly formatted");
            error.setType((short)0);
            throw error;
        }
        catch (PetalsServiceTechnicalException e) {
            LOGGER.error((Object)("Error occurred during exchange status recovery for filter: " + currentFilter.getEISO()), (Throwable)e);
            throw new NonLocalizedError(ManagementUIBean.PETALS_SERVICE_ERROR, e.getMessage(), (Throwable)e);
        }
    }

    public String updateDisplaying(String filterUUID) throws NonLocalizedError {
        this.exchangeCountSteps = this.exchangeMaxTime / this.exchangeIntervalTime;
        this.exchangeStatusSteps.clear();
        this.loadStatusChartValue(filterUUID);
        return UIResult.SUCCESS.getValue();
    }

    public boolean hasErrorMessage() {
        return this.monitoredExchange.isStored() && this.monitoredExchange.getException() != null;
    }

    public String getErrorMNM() {
        StringBuilder builder = new StringBuilder();
        builder.append(BEGIN_XML_CONTENT_FORMAT_TAG).append(HtmlUtils.encode2HTML((String)StringHelper.prettyPrint((String)this.monitoredExchange.getException()))).append(ENDING_XML_CONTENT_FORMAT_TAG);
        return builder.toString();
    }

    public long getProviderMessageProcessing() {
        long result = 0L;
        Map history = this.monitoredExchange.getHistory();
        if ("InOnly".equals(this.monitoredExchange.getMep())) {
            if (history.get("done-ack-sent") != null) {
                result = (Long)history.get("done-ack-sent") - (Long)history.get("in-received");
            } else if (history.get("error-ack-sent") != null) {
                result = (Long)history.get("error-ack-sent") - (Long)history.get("in-received");
            }
        } else if ("InOut".equals(this.monitoredExchange.getMep())) {
            if (history.get("fault-sent") != null) {
                result = (Long)history.get("fault-sent") - (Long)history.get("in-received");
            } else if (history.get("out-sent") != null) {
                result = (Long)history.get("out-sent") - (Long)history.get("in-received");
            }
        } else if ("InOptionalOut".equals(this.monitoredExchange.getMep())) {
            if (history.get("fault-sent") != null) {
                result = (Long)history.get("fault-sent") - (Long)history.get("in-received");
            } else if (history.get("out-sent") != null) {
                result = (Long)history.get("out-sent") - (Long)history.get("in-received");
            } else if (history.get("done-ack-sent") != null) {
                result = (Long)history.get("done-ack-sent") - (Long)history.get("in-received");
            } else if (history.get("error-ack-sent") != null) {
                result = (Long)history.get("error-ack-sent") - (Long)history.get("in-received");
            }
        } else if ("RobustInOnly".equals(this.monitoredExchange.getMep())) {
            if (history.get("fault-sent") != null) {
                result = (Long)history.get("fault-sent") - (Long)history.get("in-received");
            } else if (history.get("done-ack-sent") != null) {
                result = (Long)history.get("done-ack-sent") - (Long)history.get("in-received");
            } else if (history.get("error-ack-sent") != null) {
                result = (Long)history.get("error-ack-sent") - (Long)history.get("in-received");
            }
        }
        if (result > 0L) {
            return result;
        }
        return 0L;
    }

    public long getConsumerMessageProcessing() {
        long result = 0L;
        Map history = this.monitoredExchange.getHistory();
        if ("InOut".equals(this.monitoredExchange.getMep())) {
            if (history.get("done-ack-sent") != null) {
                if (history.get("fault-received") != null) {
                    result = (Long)history.get("fault-received") - (Long)history.get("done-ack-sent");
                } else if (history.get("out-received") != null) {
                    result = (Long)history.get("out-received") - (Long)history.get("done-ack-sent");
                }
            } else if (history.get("error-ack-sent") != null) {
                if (history.get("fault-received") != null) {
                    result = (Long)history.get("fault-received") - (Long)history.get("error-ack-sent");
                } else if (history.get("out-received") != null) {
                    result = (Long)history.get("out-received") - (Long)history.get("error-ack-sent");
                }
            }
        } else if ("InOptionalOut".equals(this.monitoredExchange.getMep())) {
            if (history.get("fault-received") != null) {
                if (history.get("done-ack-sent") != null) {
                    result = (Long)history.get("fault-received") - (Long)history.get("done-ack-sent");
                } else if (history.get("error-ack-sent") != null) {
                    result = (Long)history.get("fault-received") - (Long)history.get("error-ack-sent");
                }
            } else if (history.get("out-received") != null) {
                if (history.get("done-ack-sent") != null) {
                    result = (Long)history.get("out-received") - (Long)history.get("done-ack-sent");
                } else if (history.get("error-ack-sent") != null) {
                    result = (Long)history.get("out-received") - (Long)history.get("error-ack-sent");
                } else if (history.get("fault-sent") != null) {
                    result = (Long)history.get("out-received") - (Long)history.get("fault-sent");
                }
            }
        } else if ("RobustInOnly".equals(this.monitoredExchange.getMep()) && history.get("fault-received") != null) {
            if (history.get("done-ack-sent") != null) {
                result = (Long)history.get("fault-received") - (Long)history.get("done-ack-sent");
            } else if (history.get("error-ack-sent") != null) {
                result = (Long)history.get("fault-received") - (Long)history.get("error-ack-sent");
            }
        }
        if (result > 0L) {
            return result;
        }
        return 0L;
    }

    public Date getExchangeBeginDate() {
        Calendar calendar = Calendar.getInstance();
        if (this.monitoredExchange != null && this.monitoredExchange.getHistory() != null && this.monitoredExchange.getHistory().get("in-sent") != null) {
            calendar.setTimeInMillis((Long)this.monitoredExchange.getHistory().get("in-sent"));
        }
        return calendar.getTime();
    }

    protected MonitoringBBean getBusinessBean() {
        if (this.businessBean == null) {
            this.businessBean = new MonitoringBBean();
        }
        return this.businessBean;
    }

    public void updateCurrentEndpoint() throws NonLocalizedError {
        if (this.endpointFiltering && this.serviceFiltering) {
            this.currentEndpoint = this.findCurrentEndpoint(this.selectedEndpointName, this.selectedServiceName);
        } else if (this.endpointFiltering && !this.serviceFiltering) {
            this.currentEndpoint = this.findCurrentEndpoint(this.selectedEndpointName);
        } else if (!this.endpointFiltering && this.serviceFiltering) {
            this.currentEndpoint = this.findCurrentEndpointByService(this.selectedServiceName);
        }
        this.loadOperations();
        this.refreshFormFields();
    }

    private EndPointTO findCurrentEndpointByService(String serviceName) {
        this.loadEndpoints();
        EndPointTO edTO = null;
        for (EndPointTO endPointTO : this.currentServer.getEndpoints()) {
            if (serviceName != null && serviceName.equals(endPointTO.getService().toString())) {
                if (endPointTO.getOperations() == null) {
                    endPointTO.setOperations(new ArrayList());
                }
                if (endPointTO.getOperations().size() == 0) {
                    endPointTO.getOperations().add(QName.valueOf(NULL));
                }
                edTO = endPointTO;
                break;
            }
            if (serviceName != null) continue;
            if (endPointTO.getOperations() == null) {
                endPointTO.setOperations(new ArrayList());
            }
            if (endPointTO.getOperations().size() == 0) {
                endPointTO.getOperations().add(QName.valueOf(NULL));
            }
            edTO = endPointTO;
            break;
        }
        return edTO;
    }

    private void loadEndpoints() {
        ManagementBBean managementBusinessBean = new ManagementBBean();
        if (!this.currentServer.getEndpoints().isEmpty()) {
            this.currentServer.getEndpoints().clear();
        }
        for (ComponentTO componentTO : this.currentServer.getBindingComponents()) {
            try {
                if (!componentTO.getEndpoints().isEmpty()) {
                    componentTO.getEndpoints().clear();
                }
                componentTO.getEndpoints().addAll(managementBusinessBean.recoverEndpointsForComponent(componentTO.getName(), this.currentServer.getHost(), this.currentServer.getPort(), this.currentServer.getLogin(), this.currentServer.getPassword(), this.currentServer.getName()));
                this.currentServer.getEndpoints().addAll(componentTO.getEndpoints());
            }
            catch (PetalsServiceTechnicalException e) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Unable to recove endpoints for binding component: " + componentTO.getName() + " on server: " + this.currentServer.getName() + " because: " + e.getLocalizedMessage()), (Throwable)e);
                    continue;
                }
                LOGGER.info((Object)("Unable to recove endpoints for binding component: " + componentTO.getName() + " on server: " + this.currentServer.getName() + " because: " + e.getLocalizedMessage()));
            }
        }
        for (ComponentTO componentTO : this.currentServer.getServiceEngines()) {
            try {
                if (!componentTO.getEndpoints().isEmpty()) {
                    componentTO.getEndpoints().clear();
                }
                componentTO.getEndpoints().addAll(managementBusinessBean.recoverEndpointsForComponent(componentTO.getName(), this.currentServer.getHost(), this.currentServer.getPort(), this.currentServer.getLogin(), this.currentServer.getPassword(), this.currentServer.getName()));
                this.currentServer.getEndpoints().addAll(componentTO.getEndpoints());
            }
            catch (PetalsServiceTechnicalException e) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Unable to recove endpoints for service engine: " + componentTO.getName() + " on server: " + this.currentServer.getName() + " because: " + e.getLocalizedMessage()), (Throwable)e);
                    continue;
                }
                LOGGER.info((Object)("Unable to recove endpoints for service engine: " + componentTO.getName() + " on server: " + this.currentServer.getName() + " because: " + e.getLocalizedMessage()));
            }
        }
    }

    public void reload() throws NonLocalizedError {
        if (this.endpointFiltering) {
            this.loadEndpoints();
        }
        if (this.operationFiltering) {
            this.loadOperations();
        }
    }

    public void loadOperations() throws NonLocalizedError {
        if (this.currentEndpoint != null) {
            ManagementService service = null;
            if (this.currentEndpoint.getOperations() != null && !this.currentEndpoint.getOperations().isEmpty()) {
                this.currentEndpoint.getOperations().clear();
            }
            if (this.currentServer != null) {
                Document wsdlDocument = null;
                try {
                    service = (ManagementService)ManagementServiceFactory.getInstance().getService(this.currentServer.getHost(), Integer.valueOf(Integer.parseInt(this.currentServer.getPort())), this.currentServer.getLogin(), this.currentServer.getPassword());
                    wsdlDocument = service.getDocument(this.currentEndpoint.getService().toString(), this.currentEndpoint.getName());
                }
                catch (NumberFormatException e) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("Unable to recove operation for endpoint: " + this.currentEndpoint.getName() + " because: " + e.getMessage()), (Throwable)e);
                    } else {
                        LOGGER.debug((Object)("Unable to recove operation for endpoint: " + this.currentEndpoint.getName() + " because: " + e.getMessage()));
                    }
                }
                catch (PetalsServiceTechnicalException e) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("Unable to recove operation for endpoint: " + this.currentEndpoint.getName() + " because: " + e.getMessage()), (Throwable)e);
                    }
                    LOGGER.debug((Object)("Unable to recove operation for endpoint: " + this.currentEndpoint.getName() + " because: " + e.getMessage()));
                }
                Description description = null;
                if (wsdlDocument != null) {
                    try {
                        description = GeneralHelper.readWSDL((Document)wsdlDocument);
                        for (InterfaceType interfaze : description.getInterfaces()) {
                            for (Operation operation : interfaze.getOperations()) {
                                this.currentEndpoint.getOperations().add(operation.getQName());
                            }
                        }
                    }
                    catch (WSDLException e) {
                        if (!(e.getCause().getCause() instanceof WSDLImportException)) {
                            throw new NonLocalizedError(ManagementUIBean.WSDLEXCEPTION_ERROR, e.getLocalizedMessage(), (Throwable)e);
                        }
                    }
                    catch (MalformedURLException e) {
                        NonLocalizedError error = new NonLocalizedError(ManagementUIBean.MALFORMED_URL_ERROR, e.getLocalizedMessage());
                        error.setType((short)0);
                        throw error;
                    }
                    catch (URISyntaxException e) {
                        NonLocalizedError error = new NonLocalizedError(ManagementUIBean.URI_SYNTAX_ERROR, e.getLocalizedMessage());
                        error.setType((short)0);
                        throw error;
                    }
                }
            }
        }
    }

    public String[] getDisplayedEndpoints() {
        HashSet<String> toDisplay = new HashSet<String>();
        for (EndPointTO edpTO : this.currentServer.getEndpoints()) {
            toDisplay.add(edpTO.getName());
        }
        return toDisplay.toArray(new String[toDisplay.size()]);
    }

    public String[] getDisplayedInterfaces() {
        HashSet<String> toDisplay = new HashSet<String>();
        for (EndPointTO edpTO : this.currentServer.getEndpoints()) {
            toDisplay.add(edpTO.getInterfaceName().toString());
        }
        return toDisplay.toArray(new String[toDisplay.size()]);
    }

    public String[] getDisplayedServices() {
        HashSet<String> toDisplay = new HashSet<String>();
        for (EndPointTO edpTO : this.currentServer.getEndpoints()) {
            toDisplay.add(edpTO.getService().toString());
        }
        return toDisplay.toArray(new String[toDisplay.size()]);
    }

    public final boolean isBadCriteria() {
        return this.badCriteria;
    }

    static {
        DEFAULT_ENDPOINT = new EndPointTO(NULL, QName.valueOf(NULL), NULL, NULL, QName.valueOf(NULL));
        DEFAULT_ENDPOINT.getOperations().add(QName.valueOf(NULL));
        STATUS = new ArrayList();
        STATUS.add("error");
        STATUS.add("done");
        STATUS.add("active");
    }
}

