/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.tools.webconsole.uibeans;

import com.ebmwebsourcing.easycommons.stream.InputStreamForker;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.activation.DataHandler;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.easywsdl.schema.api.SchemaException;
import org.ow2.easywsdl.schema.api.absItf.AbsItfElement;
import org.ow2.easywsdl.tooling.xsd2xml.XSD2XML;
import org.ow2.easywsdl.wsdl.api.Description;
import org.ow2.easywsdl.wsdl.api.Input;
import org.ow2.easywsdl.wsdl.api.InterfaceType;
import org.ow2.easywsdl.wsdl.api.Operation;
import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.ow2.easywsdl.wsdl.api.WSDLImportException;
import org.ow2.opensuit.core.error.LocalizedError;
import org.ow2.opensuit.core.error.NonLocalizedError;
import org.ow2.opensuit.core.impl.multiparts.IFileUploadPart;
import org.ow2.opensuit.core.session.OpenSuitSession;
import org.ow2.opensuit.core.util.HtmlUtils;
import org.ow2.petals.jmx.exception.ComponentDoesNotExistException;
import org.ow2.petals.tools.webconsole.business.ManagementBBean;
import org.ow2.petals.tools.webconsole.business.RemoteInjectorBBean;
import org.ow2.petals.tools.webconsole.services.PetalsServiceTechnicalException;
import org.ow2.petals.tools.webconsole.services.management.ManagementService;
import org.ow2.petals.tools.webconsole.services.management.ManagementServiceFactory;
import org.ow2.petals.tools.webconsole.services.remoteinjector.models.Mep;
import org.ow2.petals.tools.webconsole.services.remoteinjector.models.Property;
import org.ow2.petals.tools.webconsole.to.ComponentTO;
import org.ow2.petals.tools.webconsole.to.DomainTO;
import org.ow2.petals.tools.webconsole.to.EndPointTO;
import org.ow2.petals.tools.webconsole.to.ServerTO;
import org.ow2.petals.tools.webconsole.uibeans.ManagementUIBean;
import org.ow2.petals.tools.webconsole.uibeans.utils.UIResult;
import org.ow2.petals.tools.webconsole.utils.ConfigHelper;
import org.ow2.petals.tools.webconsole.utils.GeneralHelper;
import org.ow2.petals.tools.webconsole.utils.RendererHelper;
import org.ow2.petals.tools.webconsole.utils.StringHelper;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class RemoteInjectorUIBean
implements Serializable {
    private static final long serialVersionUID = 2551476347458131871L;
    private static final Log LOGGER = LogFactory.getLog(RemoteInjectorUIBean.class);
    private static final String NO_OPERATION_STRING = "no operation selected";
    private static final String FAULT_RETURNED_CONTENT = "<tns:ioFault xmlns:tns=\"org.ow2.petals\"><tns:message></tns:message></tns:ioFault>";
    private static final String BEGIN_FORMAT_TAG = "\\html\\<pre class=xml>";
    private static final String ENDING_FORMAT_TAG = "</pre>";
    private static final String BEGIN_FORMAT_HISTORY_TAG = "\\html\\<pre class=xml-history>";
    private static final String ENDING_FORMAT_HISTORY_TAG = "</pre>";
    private List<EndPointTO> endpoints = new ArrayList();
    private List<String> operations = new ArrayList();
    private transient List<Object> wsdlOperations = new ArrayList();
    private String selectedOperation;
    private EndPointTO selectedEndpoint;
    private ServerTO currentServer;
    private String content;
    private String response;
    private List<String> meps;
    private List<Property> mEXProperties;
    private List<Property> normalizedProperties;
    private Property addedProperty;
    private List<String> selectedMEXProperties;
    private List<String> selectedNormalizedProperties;
    private List<File> attachments;
    private List<String> selectedAttachments = new ArrayList();
    private String selectedMep;
    private long timeout;
    private ServerTO remoteServer;
    private transient RemoteInjectorBBean businessBean;
    private List<String> selectedExchanges;
    private boolean remoteComponentAvailable;
    private boolean manually;
    private boolean performedSend;
    private String acknowledgmentType;
    private String[] acknowledgmentTypes;
    private String returnedContent;
    private MessageExchange sendedMEX;
    private boolean returnFromResponse;

    public RemoteInjectorUIBean() throws NonLocalizedError {
        this.meps = new ArrayList();
        this.mEXProperties = new ArrayList();
        this.normalizedProperties = new ArrayList();
        this.attachments = new ArrayList();
        this.selectedMEXProperties = new ArrayList();
        this.selectedNormalizedProperties = new ArrayList();
        this.init();
        this.timeout = 30000L;
        this.initmeps();
    }

    private void initmeps() {
        this.meps.add(Mep.IN_ONLY.value());
        this.meps.add(Mep.IN_OPTIONAL_OUT.value());
        this.meps.add(Mep.IN_OUT.value());
        this.meps.add(Mep.ROBUST_IN_ONLY.value());
    }

    public String load(HttpServletRequest request) throws NonLocalizedError {
        DomainTO domain;
        String serverName;
        if (!this.performedSend) {
            this.operations.clear();
            this.endpoints.clear();
            this.operations.add(NO_OPERATION_STRING);
            EndPointTO endpoint = new EndPointTO(null, QName.valueOf("no interface"), "no endpoint selected", null, QName.valueOf("no service"));
            this.endpoints.add(endpoint);
            this.selectedEndpoint = (EndPointTO)this.endpoints.get(0);
            this.selectedOperation = (String)this.operations.get(0);
        }
        this.performedSend = false;
        ManagementUIBean managementBean = (ManagementUIBean)request.getSession().getAttribute("managementUIBean");
        if (managementBean != null && (serverName = request.getParameter("serverName")) != null && !serverName.equals("") && (domain = managementBean.getDomain()) != null) {
            this.currentServer = domain.findServer(serverName);
            if (this.currentServer != null) {
                List serverEndpoints = this.currentServer.getEndpoints();
                ArrayList<String> endpointAlreadyPresent = new ArrayList<String>();
                for (EndPointTO edp : this.endpoints) {
                    endpointAlreadyPresent.add(edp.getName());
                }
                for (EndPointTO serverEndpoint : serverEndpoints) {
                    if (endpointAlreadyPresent.contains(serverEndpoint.getName())) continue;
                    this.endpoints.add(serverEndpoint);
                }
            }
        }
        this.init();
        if (!this.returnFromResponse) {
            this.loadEndpoints(request);
            if (this.endpoints != null && this.endpoints.size() > 0) {
                this.selectedEndpoint = (EndPointTO)this.endpoints.get(0);
                this.loadOperations(request);
                if (this.operations != null && this.operations.size() > 0) {
                    if (this.operations.size() > 1) {
                        this.operations.remove(NO_OPERATION_STRING);
                    }
                    this.selectedOperation = (String)this.operations.get(0);
                    this.loadContent();
                }
            }
            this.returnFromResponse = false;
        }
        return UIResult.SUCCESS.getValue();
    }

    public List<EndPointTO> getEndpoints() {
        if (this.endpoints.isEmpty()) {
            this.endpoints.add(new EndPointTO("no component", QName.valueOf("no interface"), "no endpoint", "no server", QName.valueOf("no service")));
        }
        return this.endpoints;
    }

    public void setEndpoints(List<EndPointTO> endpoints) {
        this.endpoints = endpoints;
    }

    public String getSelectedEndpoint() {
        if (!this.endpoints.isEmpty() && this.selectedEndpoint == null) {
            this.selectedEndpoint = (EndPointTO)this.endpoints.get(0);
        }
        return this.selectedEndpoint.getName();
    }

    public void setSelectedEndpoint(String nameEndpoint) {
        if (!this.manually) {
            this.selectedEndpoint = this.findEndpoint(nameEndpoint);
        } else {
            EndPointTO knowedEndpoint = this.findEndpoint(nameEndpoint);
            this.selectedEndpoint = new EndPointTO();
            this.selectedEndpoint.setName(nameEndpoint);
            if (knowedEndpoint != null) {
                this.selectedEndpoint.setService(knowedEndpoint.getService());
                this.selectedEndpoint.setInterfaceName(knowedEndpoint.getInterfaceName());
            }
        }
    }

    public void loadOperations(HttpServletRequest request) throws NonLocalizedError {
        this.operations.clear();
        this.operations.add(NO_OPERATION_STRING);
        if (this.selectedEndpoint != null && this.selectedEndpoint.getName() != null) {
            if (this.selectedEndpoint.getName().equals("no endpoint selected")) {
                return;
            }
        } else {
            LOGGER.warn((Object)"User try to send message without selected endpoint");
            NonLocalizedError error = new NonLocalizedError(ManagementUIBean.USER_ACTION_ERROR, "User try to send message without selected endpoint");
            error.setType((short)0);
            throw error;
        }
        ManagementService service = null;
        if (this.currentServer != null) {
            Document wsdlDocument = null;
            try {
                service = (ManagementService)ManagementServiceFactory.getInstance().getService(this.currentServer.getHost(), Integer.valueOf(Integer.parseInt(this.currentServer.getPort())), this.currentServer.getLogin(), this.currentServer.getPassword());
                this.remoteComponentAvailable = true;
                wsdlDocument = service.getDocument(this.selectedEndpoint.getService().toString(), this.selectedEndpoint.getName());
            }
            catch (NumberFormatException e) {
                LOGGER.error((Object)"Error occurred during management service recovery", (Throwable)e);
            }
            catch (PetalsServiceTechnicalException e) {
                this.remoteComponentAvailable = false;
                LOGGER.error((Object)"Error occurred during management service recovery", (Throwable)e);
            }
            Description description = null;
            if (wsdlDocument != null) {
                try {
                    description = GeneralHelper.readWSDL(wsdlDocument);
                    for (InterfaceType interfaze : description.getInterfaces()) {
                        for (Operation operation : interfaze.getOperations()) {
                            if (this.wsdlOperations == null) {
                                this.wsdlOperations = new ArrayList();
                            }
                            this.wsdlOperations.add(operation);
                            this.operations.add("{" + operation.getQName().getNamespaceURI() + "}" + operation.getQName().getLocalPart());
                        }
                    }
                }
                catch (WSDLException e) {
                    if (e.getCause().getCause() instanceof WSDLImportException) {
                        this.operations.add("WSDLImportException: " + e.getCause().getCause().getMessage());
                    }
                    LOGGER.error((Object)"Error occurred during WSDL reading", (Throwable)e);
                    throw new NonLocalizedError(ManagementUIBean.WSDLEXCEPTION_ERROR, e.getLocalizedMessage(), (Throwable)e);
                }
                catch (MalformedURLException e) {
                    LOGGER.error((Object)"Error occurred during WSDL reading", (Throwable)e);
                    throw new NonLocalizedError(ManagementUIBean.MALFORMED_URL_ERROR, e.getLocalizedMessage(), (Throwable)e);
                }
                catch (URISyntaxException e) {
                    LOGGER.error((Object)"Error occurred during WSDL reading", (Throwable)e);
                    throw new NonLocalizedError(ManagementUIBean.URI_SYNTAX_ERROR, e.getLocalizedMessage(), (Throwable)e);
                }
            }
        } else {
            this.load(request);
        }
    }

    public void loadContent() throws NonLocalizedError {
        if (this.selectedOperation != null) {
            int beginIndex = this.selectedOperation.indexOf("{") + 1;
            int endingIndex = this.selectedOperation.indexOf("}");
            String namespaceURI = null;
            String localPart = null;
            if (beginIndex > 0 && endingIndex > -1) {
                namespaceURI = this.selectedOperation.substring(beginIndex, endingIndex);
                localPart = this.selectedOperation.substring(this.selectedOperation.indexOf("}") + 1);
            }
            if (this.wsdlOperations != null) {
                for (Object obj : this.wsdlOperations) {
                    Operation operation = (Operation)obj;
                    if (!operation.getQName().getNamespaceURI().equals(namespaceURI) || !operation.getQName().getLocalPart().equals(localPart) || operation.getInput() == null || ((Input)operation.getInput()).getElement() == null) continue;
                    try {
                        this.content = XSD2XML.newInstance().printXml((AbsItfElement)((Input)operation.getInput()).getElement(), (Object)"?");
                    }
                    catch (SchemaException e) {
                        LOGGER.error((Object)"Error occurred during content loading", (Throwable)e);
                        throw new NonLocalizedError(ManagementUIBean.WSDLEXCEPTION_ERROR, e.getLocalizedMessage(), (Throwable)e);
                    }
                }
            }
        }
    }

    public List<String> getOperations() {
        if (this.operations.isEmpty()) {
            this.operations.add(NO_OPERATION_STRING);
        }
        return this.operations;
    }

    public void setOperations(List<String> operations) {
        this.operations = operations;
    }

    public String getSelectedOperation() {
        return this.selectedOperation;
    }

    public void setSelectedOperation(String selectedOperation) {
        this.selectedOperation = selectedOperation;
    }

    public ServerTO getCurrentServer() {
        return this.currentServer;
    }

    public void setCurrentServer(ServerTO currentServer) {
        this.currentServer = currentServer;
    }

    private EndPointTO findEndpoint(String ep) {
        for (EndPointTO endpoint : this.endpoints) {
            if (!endpoint.getName().equals(ep)) continue;
            return endpoint;
        }
        return null;
    }

    public List<String> getEndpointsNames() {
        ArrayList<String> endpointsNames = new ArrayList<String>();
        for (EndPointTO endpoint : this.endpoints) {
            endpointsNames.add(endpoint.getName());
        }
        return endpointsNames;
    }

    public String getFormatedContent() {
        return BEGIN_FORMAT_TAG + HtmlUtils.encode2HTML((String)this.content) + "</pre>";
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void send(HttpServletRequest request) throws NonLocalizedError {
        this.response = null;
        this.performedSend = true;
        if (this.remoteServer == null) {
            LOGGER.error((Object)"remote server unavailable: check if the petals-se-rmi is installed over a petals node or, check if declared petals-se-rmi is available , in webconsole configuration file");
            NonLocalizedError error = new NonLocalizedError(ManagementUIBean.REMOTE_SERVER_CONFIGURATION_ERROR, " remote server unavailable:\n - check if the petals-se-rmi is installed over a petals node \n - check if you have declared the available petals-se-rmi, in webconsole configuration file");
            error.setType((short)0);
            throw error;
        }
        if (this.selectedEndpoint != null && this.selectedEndpoint.getName() != null) {
            if (this.selectedEndpoint.getName().equals("no endpoint selected")) {
                LOGGER.warn((Object)"User try to send message with 'no endpoint selected' value");
                NonLocalizedError error = new NonLocalizedError(ManagementUIBean.USER_ACTION_ERROR, " you try to send a message to 'no endpoint selected' , remove this default value");
                error.setType((short)0);
                throw error;
            }
            try {
                QName qnOperation = null;
                QName qnService = null;
                String sEndpoint = null;
                if (StringHelper.isNotNullAndNotEmpty((String)this.selectedOperation)) {
                    qnOperation = QName.valueOf(this.selectedOperation);
                }
                if (StringHelper.isNotNullAndNotEmpty((String)this.selectedEndpoint.getService().toString())) {
                    qnService = this.selectedEndpoint.getService();
                }
                if (StringHelper.isNotNullAndNotEmpty((String)this.selectedEndpoint.getName())) {
                    sEndpoint = this.selectedEndpoint.getName();
                }
                this.sendedMEX = this.getBusinessBean().send(this.attachments, this.selectedMep, qnOperation, Long.valueOf(this.timeout), this.selectedEndpoint.getInterfaceName(), qnService, sEndpoint, this.mEXProperties, this.normalizedProperties, this.content);
            }
            catch (IllegalArgumentException e) {
                LOGGER.error((Object)"Error occurred during message sending", (Throwable)e);
                NonLocalizedError error = new NonLocalizedError(ManagementUIBean.ILLEGAL_ARGUMENT_ERROR, e.getLocalizedMessage());
                error.setType((short)0);
                throw error;
            }
            catch (PetalsServiceTechnicalException e) {
                LOGGER.error((Object)"Error occurred during message sending", (Throwable)e);
                throw new NonLocalizedError(ManagementUIBean.PETALS_SERVICE_ERROR, e.getLocalizedMessage(), (Throwable)e);
            }
        } else {
            LOGGER.warn((Object)"User try to send message without selected endpoint");
            NonLocalizedError error = new NonLocalizedError(ManagementUIBean.USER_ACTION_ERROR, "User try to send message without selected endpoint");
            error.setType((short)0);
            throw error;
        }
        if (this.sendedMEX != null) {
            InputStreamForker forker;
            if (this.sendedMEX.getError() != null) {
                String error = null;
                Exception e = this.sendedMEX.getError();
                try {
                    File tmpfile = File.createTempFile("tmp", "error");
                    PrintWriter writer = new PrintWriter(tmpfile);
                    e.printStackTrace(writer);
                    writer.flush();
                    writer.close();
                    BufferedReader reader = new BufferedReader(new FileReader(tmpfile));
                    StringWriter swriter = new StringWriter();
                    String line = null;
                    do {
                        if ((line = reader.readLine()) == null) continue;
                        swriter.write(line);
                    } while (line != null);
                    reader.close();
                    error = swriter.toString();
                    swriter.close();
                }
                catch (IOException ex) {
                    LOGGER.error((Object)"Occurred error during error reading of the current message exchange", (Throwable)ex);
                    throw new NonLocalizedError(ManagementUIBean.IOEXCEPTION_ERROR, ex.getLocalizedMessage(), (Throwable)ex);
                }
                this.response = e.getMessage() + "\n" + error;
                if (this.sendedMEX.getFault() != null) {
                    Fault f = this.sendedMEX.getFault();
                    try {
                        InputStreamForker forker2 = StringHelper.fork((Source)f.getContent());
                        f.setContent((Source)new StreamSource(forker2.fork()));
                    }
                    catch (TransformerFactoryConfigurationError ex) {
                        LOGGER.error((Object)"Occurred error during the pretty print of a message exchange fault", (Throwable)ex);
                        throw new NonLocalizedError(ManagementUIBean.TRANSFORMER_FACTORY_CONFIGURATION_ERROR, ex.getLocalizedMessage(), (Throwable)ex);
                    }
                    catch (IOException ex) {
                        LOGGER.error((Object)"Occurred error during the pretty print of a message exchange fault", (Throwable)ex);
                        throw new NonLocalizedError(ManagementUIBean.IOEXCEPTION_ERROR, ex.getLocalizedMessage(), (Throwable)ex);
                    }
                    catch (TransformerException ex) {
                        LOGGER.error((Object)"Occurred error during the pretty print of a message exchange fault", (Throwable)ex);
                        throw new NonLocalizedError(ManagementUIBean.TRANSFORMER_ERROR, ex.getLocalizedMessage(), (Throwable)ex);
                    }
                    catch (MessagingException ex) {
                        LOGGER.error((Object)"Occurred error during the pretty print of a message exchange fault", (Throwable)ex);
                        throw new NonLocalizedError(ManagementUIBean.MESSAGING_ERROR, ex.getLocalizedMessage(), (Throwable)ex);
                    }
                }
            } else if (this.sendedMEX.getFault() != null) {
                Fault f = this.sendedMEX.getFault();
                try {
                    forker = StringHelper.fork((Source)f.getContent());
                    this.response = StringHelper.prettyPrintWithSource((Source)new StreamSource(forker.fork()));
                    f.setContent((Source)new StreamSource(forker.fork()));
                }
                catch (TransformerFactoryConfigurationError e) {
                    LOGGER.error((Object)"Occurred error during the pretty print of a message exchange fault", (Throwable)e);
                    throw new NonLocalizedError(ManagementUIBean.TRANSFORMER_FACTORY_CONFIGURATION_ERROR, e.getLocalizedMessage(), (Throwable)e);
                }
                catch (IOException e) {
                    LOGGER.error((Object)"Occurred error during the pretty print of a message exchange fault", (Throwable)e);
                    throw new NonLocalizedError(ManagementUIBean.IOEXCEPTION_ERROR, e.getLocalizedMessage(), (Throwable)e);
                }
                catch (TransformerException e) {
                    LOGGER.error((Object)"Occurred error during the pretty print of a message exchange fault", (Throwable)e);
                    throw new NonLocalizedError(ManagementUIBean.TRANSFORMER_ERROR, e.getLocalizedMessage(), (Throwable)e);
                }
                catch (MessagingException e) {
                    LOGGER.error((Object)"Occurred error during the pretty print of a message exchange fault", (Throwable)e);
                    throw new NonLocalizedError(ManagementUIBean.MESSAGING_ERROR, e.getLocalizedMessage(), (Throwable)e);
                }
            } else if (this.sendedMEX.getMessage("OUT") != null) {
                NormalizedMessage nm = this.sendedMEX.getMessage("OUT");
                try {
                    forker = StringHelper.fork((Source)nm.getContent());
                    this.response = StringHelper.createString((Source)new StreamSource(forker.fork()));
                    nm.setContent((Source)new StreamSource(forker.fork()));
                }
                catch (TransformerFactoryConfigurationError e) {
                    LOGGER.error((Object)"Occurred error during the pretty print of a message exchange OUT", (Throwable)e);
                    throw new NonLocalizedError(ManagementUIBean.TRANSFORMER_FACTORY_CONFIGURATION_ERROR, e.getLocalizedMessage(), (Throwable)e);
                }
                catch (IOException e) {
                    LOGGER.error((Object)"Occurred error during the pretty print of a message exchange OUT", (Throwable)e);
                    throw new NonLocalizedError(ManagementUIBean.IOEXCEPTION_ERROR, e.getLocalizedMessage(), (Throwable)e);
                }
                catch (TransformerException e) {
                    LOGGER.error((Object)"Occurred error during the pretty print of a message exchange OUT", (Throwable)e);
                    throw new NonLocalizedError(ManagementUIBean.TRANSFORMER_ERROR, e.getLocalizedMessage(), (Throwable)e);
                }
                catch (MessagingException e) {
                    LOGGER.error((Object)"Occurred error during the pretty print of a message exchange OUT", (Throwable)e);
                    throw new NonLocalizedError(ManagementUIBean.MESSAGING_ERROR, e.getLocalizedMessage(), (Throwable)e);
                }
            } else if (this.selectedMep.equals(Mep.IN_ONLY.value())) {
                this.response = "Nothing content returned because " + Mep.IN_ONLY.value() + " pattern used";
            }
        }
    }

    public String getResponse() {
        return BEGIN_FORMAT_TAG + HtmlUtils.encode2HTML((String)this.response) + "</pre>";
    }

    public void setResponse(String response) {
        this.response = response;
    }

    public List<String> getMeps() {
        return this.meps;
    }

    public void setMeps(List<String> meps) {
        this.meps = meps;
    }

    public String getSelectedMep() {
        return this.selectedMep;
    }

    public void setSelectedMep(String selectedMep) {
        this.selectedMep = selectedMep;
    }

    public String getTimeout() {
        return Long.toString(this.timeout);
    }

    public void setTimeout(String timeout) {
        this.timeout = Long.parseLong(timeout);
    }

    public String getSelectedService() {
        EndPointTO knowedEndpoint;
        if (StringHelper.isNullOrEmpty((String)this.selectedEndpoint.getService().toString()) && (knowedEndpoint = this.findEndpoint(this.selectedEndpoint.getName())) != null) {
            this.selectedEndpoint.setService(knowedEndpoint.getService());
        }
        return this.selectedEndpoint.getService().toString();
    }

    public void setSelectedService(String service) {
        if (this.manually) {
            if (this.selectedEndpoint == null) {
                this.selectedEndpoint = new EndPointTO();
            }
            if (service != null) {
                this.selectedEndpoint.setService(QName.valueOf(service));
            }
        }
    }

    public void setSelectedInterface(String _interface) {
        if (this.manually) {
            if (this.selectedEndpoint == null) {
                this.selectedEndpoint = new EndPointTO();
            }
            if (_interface != null) {
                this.selectedEndpoint.setInterfaceName(QName.valueOf(_interface));
            }
        }
    }

    public String getSelectedInterface() {
        EndPointTO knowedEndpoint;
        if (StringHelper.isNullOrEmpty((String)this.selectedEndpoint.getInterfaceName().toString()) && (knowedEndpoint = this.findEndpoint(this.selectedEndpoint.getName())) != null) {
            this.selectedEndpoint.setInterfaceName(knowedEndpoint.getInterfaceName());
        }
        return this.selectedEndpoint.getInterfaceName().toString();
    }

    public void setSelectedProperties(String selectedProperties) {
        if (StringHelper.isNotNullAndNotEmpty((String)selectedProperties)) {
            String[] allProps;
            selectedProperties = selectedProperties.replaceAll("\r", "");
            for (String prop : allProps = selectedProperties.split("\n|;")) {
                Property property;
                String[] propParts = prop.split("=");
                if (propParts.length != 2) {
                    this.mEXProperties.clear();
                    property = new Property();
                    property.setName("Error: bad pattern for property ");
                    property.setValue(" Must be 'key=value' , and not 'key==value' or ';;' ...");
                    this.mEXProperties.add(property);
                    return;
                }
                property = new Property();
                property.setName(propParts[0]);
                property.setValue(propParts[1]);
                this.mEXProperties.add(property);
            }
        }
    }

    public String getSelectedProperties() {
        StringBuilder builder = new StringBuilder();
        for (Property prop : this.mEXProperties) {
            builder.append(prop.getName() + "=" + prop.getValue() + ";");
        }
        return builder.toString();
    }

    public void upload(IFileUploadPart file, HttpServletRequest request) throws NonLocalizedError {
        try {
            this.attachments.add(this.businessBean.storeAttachement(file, request));
        }
        catch (IOException e) {
            LOGGER.error((Object)"Occurred error during attachment uploading", (Throwable)e);
            throw new NonLocalizedError(ManagementUIBean.IOEXCEPTION_ERROR, e.getLocalizedMessage(), (Throwable)e);
        }
        catch (URISyntaxException e) {
            LOGGER.error((Object)"Occurred error during attachment uploading", (Throwable)e);
            throw new NonLocalizedError(ManagementUIBean.URI_SYNTAX_ERROR, e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public String attach(HttpServletRequest request) throws NonLocalizedError {
        File currentFile = (File)this.attachments.get(this.attachments.size() - 1);
        FileInputStream in = null;
        try {
            in = new FileInputStream(currentFile);
        }
        catch (FileNotFoundException e) {
            LOGGER.error((Object)"Occurred error during attachment", (Throwable)e);
            throw new NonLocalizedError(ManagementUIBean.FILE_NOT_FOUND_ERROR, e.getLocalizedMessage(), (Throwable)e);
        }
        try {
            byte[] data = new byte[in.available()];
            if (data != null) {
                LOGGER.debug((Object)(data.length + " bytes are written for " + currentFile.getAbsolutePath() + " attachment"));
            }
        }
        catch (OutOfMemoryError e) {
            LOGGER.error((Object)"Occurred error during attachment", (Throwable)e);
            this.attachments.remove(currentFile);
            this.response = "Error: Attachment " + currentFile.getName() + " too voluminous";
        }
        catch (IOException e) {
            LOGGER.error((Object)"Occurred error during attachment", (Throwable)e);
            throw new NonLocalizedError(ManagementUIBean.IOEXCEPTION_ERROR, e.getLocalizedMessage(), (Throwable)e);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                LOGGER.error((Object)"Occurred error during attachment", (Throwable)e);
                throw new NonLocalizedError(ManagementUIBean.IOEXCEPTION_ERROR, e.getLocalizedMessage(), (Throwable)e);
            }
        }
        this.saveForm(request);
        return UIResult.SUCCESS.getValue();
    }

    public List<File> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(List<File> attachments) {
        this.attachments = attachments;
    }

    public String deleteAttachements() {
        ArrayList<File> deletedAttachments = new ArrayList<File>();
        for (String fileName : this.selectedAttachments) {
            for (File attachement : this.attachments) {
                if (!attachement.getName().equals(fileName)) continue;
                deletedAttachments.add(attachement);
            }
        }
        this.attachments.removeAll(deletedAttachments);
        return UIResult.SUCCESS.getValue();
    }

    public List<MessageExchange> getExchanges() {
        if (this.businessBean != null) {
            return this.businessBean.getExchanges();
        }
        return new ArrayList<MessageExchange>();
    }

    public List<String> getSelectedExchanges() {
        return this.selectedExchanges;
    }

    public void setSelectedExchanges(List<String> selectedExchanges) {
        this.selectedExchanges = selectedExchanges;
    }

    public void deleteSelectedExchanges() throws NonLocalizedError {
        ArrayList<MessageExchange> deletedExchanges = new ArrayList<MessageExchange>();
        List businessExchanges = this.getBusinessBean().getExchanges();
        ArrayList<String> deletedAttachments = new ArrayList<String>();
        for (String exchangeId : this.selectedExchanges) {
            for (MessageExchange bExchange : businessExchanges) {
                Set set;
                if (!bExchange.getExchangeId().equals(exchangeId)) continue;
                NormalizedMessage nm = bExchange.getMessage("IN");
                if (nm != null) {
                    set = nm.getAttachmentNames();
                    for (String attachmentId : set) {
                        deletedAttachments.add(attachmentId);
                    }
                }
                nm = null;
                nm = bExchange.getMessage("OUT");
                if (nm != null) {
                    set = nm.getAttachmentNames();
                    for (String attachmentId : set) {
                        deletedAttachments.add(attachmentId);
                    }
                }
                nm = null;
                nm = bExchange.getFault();
                if (nm != null) {
                    set = nm.getAttachmentNames();
                    for (String attachmentId : set) {
                        deletedAttachments.add(attachmentId);
                    }
                }
                deletedExchanges.add(bExchange);
            }
        }
        businessExchanges.removeAll(deletedExchanges);
        ArrayList<File> removeAttachment = new ArrayList<File>();
        for (File attach : this.attachments) {
            if (!deletedAttachments.contains(attach.getName())) continue;
            removeAttachment.add(attach);
        }
        this.attachments.removeAll(removeAttachment);
        try {
            this.getBusinessBean().removeAttachments(deletedAttachments, OpenSuitSession.getCurrentRequest());
        }
        catch (IOException e) {
            LOGGER.error((Object)"Occurred error during attachment removing", (Throwable)e);
            throw new NonLocalizedError(ManagementUIBean.IOEXCEPTION_ERROR, e.getLocalizedMessage(), (Throwable)e);
        }
        catch (URISyntaxException e) {
            LOGGER.error((Object)"Occurred error during attachment removing", (Throwable)e);
            throw new NonLocalizedError(ManagementUIBean.URI_SYNTAX_ERROR, e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public String selectAllExchanges() {
        for (MessageExchange exchange : this.getBusinessBean().getExchanges()) {
            this.selectedExchanges.add(exchange.getExchangeId());
        }
        return UIResult.SUCCESS.getValue();
    }

    public boolean isReachableRemoteComponent() throws NonLocalizedError {
        return this.remoteComponentAvailable;
    }

    public boolean isDeclaredRemoteComponent() throws NonLocalizedError {
        return this.remoteServer != null;
    }

    public boolean isManually() {
        return this.manually;
    }

    public void setManually(boolean manually) {
        this.manually = manually;
    }

    public String deleteMessageExchangeProperties() {
        ArrayList<Property> deletedProperties = new ArrayList<Property>();
        for (String p : this.selectedMEXProperties) {
            for (Property prop : this.mEXProperties) {
                if (!prop.getName().equals(p)) continue;
                deletedProperties.add(prop);
            }
        }
        this.mEXProperties.removeAll(deletedProperties);
        return UIResult.SUCCESS.getValue();
    }

    public String deleteNormalizedProperties() {
        ArrayList<Property> deletedProperties = new ArrayList<Property>();
        for (String p : this.selectedNormalizedProperties) {
            for (Property prop : this.normalizedProperties) {
                if (!prop.getName().equals(p)) continue;
                deletedProperties.add(prop);
            }
        }
        this.normalizedProperties.removeAll(deletedProperties);
        return UIResult.SUCCESS.getValue();
    }

    public List<Property> getMEXProperties() {
        return this.mEXProperties;
    }

    public void setMEXProperties(List<Property> properties) {
        this.mEXProperties = properties;
    }

    public List<String> getSelectedMEXProperties() {
        return this.selectedMEXProperties;
    }

    public void setSelectedMEXProperties(List<String> selectedMEXProperties) {
        this.selectedMEXProperties = selectedMEXProperties;
    }

    public Property getAddedProperty() {
        return this.addedProperty;
    }

    public void setAddedProperty(Property addedProperty) {
        this.addedProperty = addedProperty;
    }

    public String addMEXProperty(HttpServletRequest request) {
        Property p = new Property();
        p.setName(this.addedProperty.getName());
        p.setValue(this.addedProperty.getValue());
        this.mEXProperties.add(p);
        this.addedProperty = null;
        this.saveForm(request);
        return UIResult.SUCCESS.getValue();
    }

    public String addNormalizedProperty(HttpServletRequest request) {
        Property p = new Property();
        p.setName(this.addedProperty.getName());
        p.setValue(this.addedProperty.getValue());
        this.normalizedProperties.add(p);
        this.addedProperty = null;
        this.saveForm(request);
        return UIResult.SUCCESS.getValue();
    }

    public void loadAddProperty() {
        this.addedProperty = new Property();
    }

    public List<Property> getNormalizedProperties() {
        return this.normalizedProperties;
    }

    public void setNormalizedProperties(List<Property> normalizedProperties) {
        this.normalizedProperties = normalizedProperties;
    }

    public List<String> getSelectedNormalizedProperties() {
        return this.selectedNormalizedProperties;
    }

    public void setSelectedNormalizedProperties(List<String> selectedNormalizedProperties) {
        this.selectedNormalizedProperties = selectedNormalizedProperties;
    }

    public List<String> getSelectedAttachments() {
        return this.selectedAttachments;
    }

    public void setSelectedAttachments(List<String> selectedAttachments) {
        this.selectedAttachments = selectedAttachments;
    }

    public String getNMContent(MessageExchange exchange, String message) throws NonLocalizedError {
        NormalizedMessage nm = exchange.getMessage(message);
        try {
            InputStreamForker forker = StringHelper.fork((Source)nm.getContent());
            String result = "\n" + StringHelper.prettyPrintWithSource((Source)new StreamSource(forker.fork()));
            nm.setContent((Source)new StreamSource(forker.fork()));
            return BEGIN_FORMAT_HISTORY_TAG + HtmlUtils.encode2HTML((String)result) + "</pre>";
        }
        catch (TransformerFactoryConfigurationError e) {
            LOGGER.error((Object)"Occurred error during the pretty print of normalized message content", (Throwable)e);
            throw new NonLocalizedError(ManagementUIBean.TRANSFORMER_FACTORY_CONFIGURATION_ERROR, e.getLocalizedMessage(), (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error((Object)"Occurred error during the pretty print of normalized message content", (Throwable)e);
            throw new NonLocalizedError(ManagementUIBean.IOEXCEPTION_ERROR, e.getLocalizedMessage(), (Throwable)e);
        }
        catch (TransformerException e) {
            LOGGER.error((Object)"Occurred error during the pretty print of normalized message content", (Throwable)e);
            throw new NonLocalizedError(ManagementUIBean.TRANSFORMER_ERROR, e.getLocalizedMessage(), (Throwable)e);
        }
        catch (MessagingException e) {
            LOGGER.error((Object)"Occurred error during the pretty print of normalized message content", (Throwable)e);
            throw new NonLocalizedError(ManagementUIBean.MESSAGING_ERROR, e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public String splitPattern(URI uri) {
        String[] splittedPattern = uri.toString().split("/");
        if (splittedPattern != null) {
            return splittedPattern[splittedPattern.length - 1];
        }
        return null;
    }

    public String getFaultContent(MessageExchange exchange) throws NonLocalizedError {
        Fault fault = exchange.getFault();
        try {
            InputStreamForker forker = StringHelper.fork((Source)fault.getContent());
            String result = "\n" + StringHelper.prettyPrintWithSource((Source)new StreamSource(forker.fork()));
            fault.setContent((Source)new StreamSource(forker.fork()));
            return BEGIN_FORMAT_HISTORY_TAG + HtmlUtils.encode2HTML((String)result) + "</pre>";
        }
        catch (TransformerFactoryConfigurationError e) {
            LOGGER.error((Object)"Occurred error during the pretty print of fault content", (Throwable)e);
            throw new NonLocalizedError(ManagementUIBean.TRANSFORMER_FACTORY_CONFIGURATION_ERROR, e.getLocalizedMessage(), (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error((Object)"Occurred error during the pretty print of fault content", (Throwable)e);
            throw new NonLocalizedError(ManagementUIBean.IOEXCEPTION_ERROR, e.getLocalizedMessage(), (Throwable)e);
        }
        catch (TransformerException e) {
            LOGGER.error((Object)"Occurred error during the pretty print of fault content", (Throwable)e);
            throw new NonLocalizedError(ManagementUIBean.TRANSFORMER_ERROR, e.getLocalizedMessage(), (Throwable)e);
        }
        catch (MessagingException e) {
            LOGGER.error((Object)"Occurred error during the pretty print of fault content", (Throwable)e);
            throw new NonLocalizedError(ManagementUIBean.MESSAGING_ERROR, e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public String getMessageError(MessageExchange exchange) {
        return exchange.getError() != null ? "\n" + exchange.getError().getMessage() : "";
    }

    public boolean isIN(MessageExchange exchange) {
        return exchange.getMessage("IN") != null;
    }

    public boolean isOUT(MessageExchange exchange) {
        return exchange.getMessage("OUT") != null;
    }

    public boolean isFault(MessageExchange exchange) {
        return exchange.getFault() != null;
    }

    public boolean isError(MessageExchange exchange) {
        return exchange.getError() != null;
    }

    public List<Property> getMEXProperties(MessageExchange exchange) {
        ArrayList<Property> properties = new ArrayList<Property>();
        Set set = exchange.getPropertyNames();
        for (String pName : set) {
            Property prop = new Property();
            prop.setName(pName);
            if (exchange.getProperty(pName) != null) {
                prop.setValue(exchange.getProperty(pName).toString());
            } else {
                prop.setValue("null");
            }
            properties.add(prop);
        }
        return properties;
    }

    public List<Property> getNMProperties(MessageExchange exchange, String message) {
        NormalizedMessage nm = exchange.getMessage(message);
        ArrayList<Property> properties = new ArrayList<Property>();
        Set set = nm.getPropertyNames();
        for (String pName : set) {
            Property prop = new Property();
            prop.setName(pName);
            if (nm.getProperty(pName) != null) {
                prop.setValue(nm.getProperty(pName).toString());
            } else {
                prop.setValue("null");
            }
            properties.add(prop);
        }
        return properties;
    }

    public List<Property> getNMProperties(NormalizedMessage nm) {
        ArrayList<Property> properties = new ArrayList<Property>();
        Set set = nm.getPropertyNames();
        for (String pName : set) {
            Property prop = new Property();
            prop.setName(pName);
            if (nm.getProperty(pName) != null) {
                prop.setValue(nm.getProperty(pName).toString());
            } else {
                prop.setValue("null");
            }
            properties.add(prop);
        }
        return properties;
    }

    public boolean notEmptyProperties(NormalizedMessage nm) {
        if (nm != null && nm.getPropertyNames() != null) {
            return !nm.getPropertyNames().isEmpty();
        }
        return false;
    }

    public boolean notEmptyProperties(MessageExchange exchange) {
        if (exchange != null && exchange.getPropertyNames() != null) {
            return !exchange.getPropertyNames().isEmpty();
        }
        return false;
    }

    public boolean notEmptyAttachments(NormalizedMessage nm) {
        if (nm != null && nm.getPropertyNames() != null) {
            return !nm.getAttachmentNames().isEmpty();
        }
        return false;
    }

    public List<String> getNMAttachments(MessageExchange exchange, String message) {
        NormalizedMessage nm = exchange.getMessage(message);
        ArrayList<String> attachments = new ArrayList<String>();
        Set set = nm.getAttachmentNames();
        for (String attachmentId : set) {
            attachments.add(nm.getAttachment(attachmentId).getName());
        }
        return attachments;
    }

    public void downloadAttachment(HttpServletRequest request, String message, HttpServletResponse response) throws NonLocalizedError, LocalizedError {
        String attachmentName = request.getParameter("attachmentName");
        String exchangeId = request.getParameter("exchangeId");
        List exchanges = this.getBusinessBean().getExchanges();
        NormalizedMessage nm = null;
        for (MessageExchange ex : exchanges) {
            if (!ex.getExchangeId().equals(exchangeId)) continue;
            nm = ex.getMessage(message);
        }
        if (nm == null) {
            throw new LocalizedError("DOWNLOAD_ATTACHMENT_ERROR", " attachment for message id: " + exchangeId + " not found");
        }
        Set set = nm.getAttachmentNames();
        for (String attachmentId : set) {
            DataHandler handler = nm.getAttachment(attachmentId);
            if (!handler.getName().equals(attachmentName)) continue;
            response.setContentType(handler.getContentType());
            ServletOutputStream out = null;
            InputStream in = null;
            try {
                int readedBytes;
                out = response.getOutputStream();
                in = handler.getInputStream();
                in.reset();
                byte[] data = new byte[1024];
                do {
                    if ((readedBytes = in.read(data)) == -1) continue;
                    out.write(data, 0, readedBytes);
                    out.flush();
                } while (readedBytes != -1);
            }
            catch (IOException e) {
                LOGGER.error((Object)"Occurred error during attachment downloading", (Throwable)e);
                throw new NonLocalizedError(ManagementUIBean.DOWNLOAD_ATTACHMENT_ERROR, e.getLocalizedMessage(), (Throwable)e);
            }
            finally {
                try {
                    out.close();
                    in.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)"Occurred error during attachment downloading", (Throwable)e);
                    throw new NonLocalizedError(ManagementUIBean.DOWNLOAD_ATTACHMENT_ERROR, e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
    }

    public void downloadFaultAttachment(NormalizedMessage nm, HttpServletRequest request, HttpServletResponse response) throws NonLocalizedError, LocalizedError {
        String attachmentName = request.getParameter("attachmentName");
        if (nm == null) {
            LOGGER.error((Object)"Occurred error during attachment downloading no normalized message selected");
            NonLocalizedError error = new NonLocalizedError("DOWNLOAD_ATTACHMENT_ERROR", "Occurred error during attachment downloading no normalized message selected");
            error.setType((short)0);
            throw error;
        }
        Set set = nm.getAttachmentNames();
        for (String attachmentId : set) {
            DataHandler handler = nm.getAttachment(attachmentId);
            if (!handler.getName().equals(attachmentName)) continue;
            response.setContentType(handler.getContentType());
            ServletOutputStream out = null;
            InputStream in = null;
            try {
                int readedBytes;
                out = response.getOutputStream();
                in = handler.getInputStream();
                in.reset();
                byte[] data = new byte[1024];
                do {
                    if ((readedBytes = in.read(data)) == -1) continue;
                    out.write(data, 0, readedBytes);
                    out.flush();
                } while (readedBytes != -1);
            }
            catch (IOException e) {
                LOGGER.error((Object)"Occurred error during attachment downloading", (Throwable)e);
                throw new NonLocalizedError(ManagementUIBean.IOEXCEPTION_ERROR, e.getLocalizedMessage(), (Throwable)e);
            }
            finally {
                try {
                    out.close();
                    in.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)"Occurred error during attachment downloading", (Throwable)e);
                    throw new NonLocalizedError(ManagementUIBean.IOEXCEPTION_ERROR, e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
    }

    public List<String> getFaultNMAttachments(MessageExchange exchange) {
        Fault nm = exchange.getFault();
        ArrayList<String> attachments = new ArrayList<String>();
        Set set = nm.getAttachmentNames();
        for (String attachmentId : set) {
            attachments.add(nm.getAttachment(attachmentId).getName());
        }
        return attachments;
    }

    public String getFreeMemory() {
        return ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().toString();
    }

    public boolean checkManually() {
        return this.manually;
    }

    public String getCurrentRemoteServerName() {
        if (this.remoteServer != null) {
            return this.remoteServer.getHost();
        }
        return null;
    }

    public String getCurrentServerPort() {
        if (this.remoteServer != null) {
            return this.remoteServer.getPort();
        }
        return null;
    }

    public String getCurrentRemoteServerPort() {
        if (this.remoteServer != null) {
            return String.valueOf(this.remoteServer.getRemotePort());
        }
        return null;
    }

    public void init() throws NonLocalizedError {
        block22: {
            HttpServletRequest request = OpenSuitSession.getCurrentRequest();
            if (request != null) {
                if (request.getSession().getAttribute("savedEndpoint") != null) {
                    this.selectedEndpoint = (EndPointTO)request.getSession().getAttribute("savedEndpoint");
                    request.getSession().removeAttribute("savedEndpoint");
                }
                if (request.getSession().getAttribute("savedContent") != null) {
                    this.content = (String)request.getSession().getAttribute("savedContent");
                    request.getSession().removeAttribute("savedContent");
                }
                if (request.getSession().getAttribute("savedMep") != null) {
                    this.selectedMep = (String)request.getSession().getAttribute("savedMep");
                    request.getSession().removeAttribute("savedMep");
                }
                if (request.getSession().getAttribute("savedTimeout") != null) {
                    this.timeout = (Long)request.getSession().getAttribute("savedTimeout");
                    request.getSession().removeAttribute("savedTimeout");
                }
                if (request.getSession().getAttribute("savedAcknowledgmentType") != null) {
                    this.acknowledgmentType = (String)request.getSession().getAttribute("savedAcknowledgmentType");
                    request.getSession().removeAttribute("savedAcknowledgmentType");
                }
                if (request.getSession().getAttribute("savedOperation") != null) {
                    this.selectedOperation = (String)request.getSession().getAttribute("savedOperation");
                    request.getSession().removeAttribute("savedOperation");
                }
                if (this.selectedEndpoint == null) {
                    this.operations.add(NO_OPERATION_STRING);
                    this.selectedEndpoint = new EndPointTO(null, QName.valueOf("no interface"), "no endpoint selected", null, QName.valueOf("no service"));
                } else if (this.selectedEndpoint.getOperations() != null && this.selectedEndpoint.getOperations().size() > 0) {
                    for (String operation : this.selectedEndpoint.getOperationStrings()) {
                        if (this.operations.contains(operation)) continue;
                        this.operations.add(operation);
                    }
                }
            }
            try {
                this.remoteServer = ConfigHelper.findRemoteServer((URL)ManagementUIBean.class.getClassLoader().getResource("webconsole.xml"));
                if (this.remoteServer != null) {
                    if (this.getBusinessBean() != null && this.getBusinessBean().getExchanges() != null && this.getBusinessBean().getExchanges().size() > 0) {
                        List storedExchanges = this.getBusinessBean().getExchanges();
                        this.businessBean = new RemoteInjectorBBean(this.remoteServer);
                        this.getBusinessBean().setExchanges(storedExchanges);
                    } else {
                        this.businessBean = new RemoteInjectorBBean(this.remoteServer);
                    }
                    this.remoteComponentAvailable = this.getBusinessBean().checkRemoteComponentAvailable(this.remoteServer);
                }
            }
            catch (MalformedURLException e) {
                LOGGER.error((Object)"Occurred error during remote injector initialization", (Throwable)e);
                throw new NonLocalizedError(ManagementUIBean.MALFORMED_URL_ERROR, e.getLocalizedMessage(), (Throwable)e);
            }
            catch (NumberFormatException e) {
                LOGGER.error((Object)"Occurred error during remote injector initialization", (Throwable)e);
                throw new NonLocalizedError(ManagementUIBean.NUMBER_FORMAT_ERROR, e.getLocalizedMessage(), (Throwable)e);
            }
            catch (IOException e) {
                LOGGER.error((Object)"Occurred error during remote injector initialization", (Throwable)e);
                throw new NonLocalizedError(ManagementUIBean.IOEXCEPTION_ERROR, e.getLocalizedMessage(), (Throwable)e);
            }
            catch (SAXException e) {
                LOGGER.error((Object)"Occurred error during remote injector initialization", (Throwable)e);
                throw new NonLocalizedError(ManagementUIBean.SAX_ERROR, e.getLocalizedMessage(), (Throwable)e);
            }
            catch (ParserConfigurationException e) {
                LOGGER.error((Object)"Occurred error during remote injector initialization", (Throwable)e);
                throw new NonLocalizedError(ManagementUIBean.PARSER_CONFIGURATION_ERROR, e.getLocalizedMessage(), (Throwable)e);
            }
            catch (FactoryConfigurationError e) {
                LOGGER.error((Object)"Occurred error during remote injector initialization", (Throwable)e);
                throw new NonLocalizedError(ManagementUIBean.FACTORY_CONFIGURATION_ERROR, e.getLocalizedMessage(), (Throwable)e);
            }
            catch (PetalsServiceTechnicalException e) {
                LOGGER.error((Object)"Occurred error during remote injector initialization", (Throwable)e);
                if (!e.getCause().getClass().equals(ComponentDoesNotExistException.class)) break block22;
                LOGGER.info((Object)("RemoteComponent (" + this.remoteServer.getRemotePort() + ":" + this.remoteServer.getRemoteContext() + ") not reachable on '" + this.remoteServer.getHost() + "' server with Port: " + this.remoteServer.getPort() + " associated"));
                this.remoteComponentAvailable = false;
            }
        }
    }

    public boolean getBadRemotePort() {
        if (this.getBusinessBean() != null) {
            return !this.getBusinessBean().isCorrectRemotePort();
        }
        return false;
    }

    public void updateModification() {
        if (this.acknowledgmentType != null && this.acknowledgmentType.equals("Fault")) {
            this.returnedContent = FAULT_RETURNED_CONTENT;
        }
    }

    public String saveForm(HttpServletRequest request) {
        request.getSession().setAttribute("savedEndpoint", (Object)this.selectedEndpoint);
        request.getSession().setAttribute("savedContent", (Object)this.content);
        request.getSession().setAttribute("savedOperation", (Object)this.selectedOperation);
        request.getSession().setAttribute("savedMep", (Object)this.selectedMep);
        request.getSession().setAttribute("savedTimeout", (Object)this.timeout);
        request.getSession().setAttribute("savedAcknowledgmentType", (Object)this.acknowledgmentType);
        return UIResult.SUCCESS.getValue();
    }

    protected RemoteInjectorBBean getBusinessBean() {
        if (this.businessBean == null) {
            try {
                this.businessBean = new RemoteInjectorBBean(this.remoteServer);
            }
            catch (PetalsServiceTechnicalException e) {
                LOGGER.warn((Object)("Business bean can't be recovered: " + e.getMessage()));
            }
        }
        return this.businessBean;
    }

    public String[] getAcknowledgmentTypes() {
        return this.acknowledgmentTypes;
    }

    public void recoverAckTypes(MessageExchange exchange) {
        this.acknowledgmentTypes = RendererHelper.acknowledgmentTypesCalculator((MessageExchange)exchange);
    }

    public String getAcknowledgmentType() {
        return this.acknowledgmentType;
    }

    public void setAcknowledgmentType(String acknowledgmentType) {
        this.acknowledgmentType = acknowledgmentType;
    }

    public String getReturnedContent() {
        return this.returnedContent;
    }

    public void setReturnedContent(String returnedContent) {
        this.returnedContent = returnedContent;
    }

    public boolean returnedContentAvailable() {
        return this.acknowledgmentType != null && (this.acknowledgmentType.equals("Fault") || this.acknowledgmentType.equals("Error"));
    }

    public String performAcknowledgment() throws NonLocalizedError {
        if (this.sendedMEX.getFault() != null && this.acknowledgmentType.equals("Fault")) {
            try {
                NormalizedMessage returnedFault = this.sendedMEX.createMessage();
                returnedFault.setContent(this.sendedMEX.getFault().getContent());
                this.sendedMEX.setMessage(returnedFault, "fault");
            }
            catch (MessagingException e) {
                LOGGER.error((Object)"Error occurred during perform acknowledgment", (Throwable)e);
                throw new NonLocalizedError(ManagementUIBean.MESSAGING_ERROR, e.getMessage(), (Throwable)e);
            }
        }
        try {
            this.sendedMEX = this.businessBean.performAcknowledgment(this.selectedMep, this.acknowledgmentType, this.sendedMEX, this.returnedContent);
        }
        catch (PetalsServiceTechnicalException e) {
            LOGGER.error((Object)"Error occurred during perform acknowledgment", (Throwable)e);
            throw new NonLocalizedError(ManagementUIBean.PETALS_SERVICE_ERROR, e.getMessage(), (Throwable)e);
        }
        this.returnFromResponse = true;
        return UIResult.SUCCESS.getValue();
    }

    public boolean returnedFault(MessageExchange exchange) {
        return exchange.getMessage("fault") != null;
    }

    public NormalizedMessage getReturnedFault(MessageExchange exchange) {
        return exchange.getMessage("fault");
    }

    public List<String> getReturnedFaultNMAttachments(MessageExchange exchange) {
        NormalizedMessage nm = exchange.getMessage("fault");
        ArrayList<String> attachments = new ArrayList<String>();
        Set set = nm.getAttachmentNames();
        for (String attachmentId : set) {
            attachments.add(nm.getAttachment(attachmentId).getName());
        }
        return attachments;
    }

    public MessageExchange getSendedMEX() {
        return this.sendedMEX;
    }

    public boolean acknowledgmentTypesAvailable() {
        return this.acknowledgmentTypes != null && this.acknowledgmentTypes.length > 0;
    }

    public boolean installationRemoteComponentAvailable() throws NonLocalizedError {
        try {
            return GeneralHelper.remoteComponentPackaged() != null;
        }
        catch (URISyntaxException e) {
            LOGGER.error((Object)"Error occurred during remote component available checking", (Throwable)e);
            throw new NonLocalizedError(ManagementUIBean.URI_SYNTAX_ERROR, e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error((Object)"Error occurred during remote component available checking", (Throwable)e);
            throw new NonLocalizedError(ManagementUIBean.IOEXCEPTION_ERROR, e.getMessage(), (Throwable)e);
        }
    }

    public String remoteComponentPath(HttpServletRequest request) throws NonLocalizedError {
        URL url;
        try {
            url = GeneralHelper.getFileRepositoryURL((String)"petals-se-rmi-1.2.0-SNAPSHOT.zip", (String)"components", (HttpServletRequest)request);
        }
        catch (MalformedURLException e) {
            LOGGER.error((Object)"Error occurred during remote component path recovering", (Throwable)e);
            throw new NonLocalizedError(ManagementUIBean.MALFORMED_URL_ERROR, e.getMessage(), (Throwable)e);
        }
        catch (UnknownHostException e) {
            LOGGER.error((Object)"Error occurred during remote component path recovering", (Throwable)e);
            throw new NonLocalizedError(ManagementUIBean.UNKNOW_HOST_ERROR, e.getMessage(), (Throwable)e);
        }
        if (url != null) {
            return url.toString();
        }
        return null;
    }

    public void loadEndpoints(HttpServletRequest request) throws NonLocalizedError {
        if (this.endpoints != null && !this.endpoints.isEmpty()) {
            this.endpoints.clear();
        }
        ManagementBBean managementBusinessBean = new ManagementBBean();
        for (ComponentTO componentTO : this.currentServer.getBindingComponents()) {
            try {
                this.endpoints.addAll(managementBusinessBean.recoverEndpointsForComponent(componentTO.getName(), this.currentServer.getHost(), this.currentServer.getPort(), this.currentServer.getLogin(), this.currentServer.getPassword(), this.currentServer.getName()));
            }
            catch (PetalsServiceTechnicalException e) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Unable to recove endpoints for binding component: " + componentTO.getName() + " on server: " + this.currentServer.getName() + " because: " + e.getLocalizedMessage()), (Throwable)e);
                    continue;
                }
                LOGGER.info((Object)("Unable to recove endpoints for binding component: " + componentTO.getName() + " on server: " + this.currentServer.getName() + " because: " + e.getLocalizedMessage()));
            }
        }
        for (ComponentTO componentTO : this.currentServer.getServiceEngines()) {
            try {
                this.endpoints.addAll(managementBusinessBean.recoverEndpointsForComponent(componentTO.getName(), this.currentServer.getHost(), this.currentServer.getPort(), this.currentServer.getLogin(), this.currentServer.getPassword(), this.currentServer.getName()));
            }
            catch (PetalsServiceTechnicalException e) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Unable to recove endpoints for service engine: " + componentTO.getName() + " on server: " + this.currentServer.getName() + " because: " + e.getLocalizedMessage()), (Throwable)e);
                    continue;
                }
                LOGGER.info((Object)("Unable to recove endpoints for service engine: " + componentTO.getName() + " on server: " + this.currentServer.getName() + " because: " + e.getLocalizedMessage()));
            }
        }
    }
}

