/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.tools.webconsole.uibeans;

import java.io.Serializable;
import java.security.Principal;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.opensuit.core.error.NonLocalizedError;
import org.ow2.petals.tools.webconsole.business.SecurityBBean;
import org.ow2.petals.tools.webconsole.services.PetalsServiceFunctionalException;
import org.ow2.petals.tools.webconsole.services.PetalsServiceTechnicalException;
import org.ow2.petals.tools.webconsole.uibeans.ManagementUIBean;
import org.ow2.petals.tools.webconsole.uibeans.utils.UIResult;

public class SecurityUIBean
implements Serializable {
    private static final long serialVersionUID = -4924694621958082946L;
    private static final Log LOGGER = LogFactory.getLog(SecurityUIBean.class);
    private transient SecurityBBean business = new SecurityBBean();
    private String confirmPassword;
    private String oldUser;
    private String modifiedUsername;
    private String oldPassword;
    private String modifiedPassword;
    private String confirmModifiedPassword;
    private Set<String> allUsers;
    private String[] selectedRoles;
    private String[] allRoles = new String[]{"administrator", "operator", "viewer"};
    private String loggedWithUsername;

    public SecurityUIBean() {
        this.allUsers = new HashSet();
    }

    public void resetLoginForm() {
        this.loggedWithUsername = null;
    }

    public String login(HttpServletRequest request) {
        Principal p = request.getUserPrincipal();
        if (p != null) {
            this.loggedWithUsername = p.getName();
            LOGGER.info((Object)("User authenticate as: " + p.getName()));
            return UIResult.SUCCESS.getValue();
        }
        LOGGER.info((Object)"User authentication failed");
        return UIResult.ERROR.getValue();
    }

    public void recoverAllUsers() throws NonLocalizedError {
        try {
            this.allUsers.clear();
            this.allUsers.addAll(this.getBusinessBean().getAllUsers());
        }
        catch (PetalsServiceTechnicalException e) {
            LOGGER.error((Object)"Technical error occurred during all users getting action", (Throwable)e);
            throw new NonLocalizedError(ManagementUIBean.PETALS_SERVICE_ERROR, e.getLocalizedMessage(), (Throwable)e);
        }
        catch (PetalsServiceFunctionalException e) {
            LOGGER.error((Object)"Functional error occurred during all users getting action", (Throwable)e);
            throw new NonLocalizedError(ManagementUIBean.PETALS_SERVICE_ERROR, e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public String deleteUser(HttpServletRequest request) throws NonLocalizedError {
        String username = request.getParameter("selectedName");
        if (username == null || username.trim().equals("")) {
            LOGGER.error((Object)("Functional error try to delete user '" + username + "' (certainly empty or null)"));
            throw new NonLocalizedError(ManagementUIBean.USER_ACTION_ERROR, "Functional error you try to delete empty user");
        }
        try {
            if (this.getBusinessBean().deleteUser(username)) {
                return UIResult.SUCCESS.getValue();
            }
            return UIResult.ERROR.getValue();
        }
        catch (PetalsServiceTechnicalException e) {
            LOGGER.error((Object)("Technical error occurred during delete action of user '" + username + "'"), (Throwable)e);
            throw new NonLocalizedError(ManagementUIBean.PETALS_SERVICE_ERROR, e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public String addUser() throws NonLocalizedError {
        try {
            if (this.modifiedPassword.equals(this.confirmPassword)) {
                if (this.getBusinessBean().addUser(this.modifiedUsername, this.modifiedPassword, this.selectedRoles)) {
                    this.resetForms();
                    return UIResult.SUCCESS.getValue();
                }
                return UIResult.ERROR.getValue();
            }
            this.modifiedPassword = null;
            this.confirmPassword = null;
            return UIResult.PARAMETERERROR.getValue();
        }
        catch (PetalsServiceTechnicalException e) {
            LOGGER.error((Object)("Technical error occurred during adding action of user '" + this.modifiedUsername + "'"), (Throwable)e);
            throw new NonLocalizedError(ManagementUIBean.PETALS_SERVICE_ERROR, e.getLocalizedMessage(), (Throwable)e);
        }
        catch (PetalsServiceFunctionalException e) {
            LOGGER.error((Object)("Functional error occurred during adding action of user '" + this.modifiedUsername + "'"), (Throwable)e);
            throw new NonLocalizedError(ManagementUIBean.PETALS_SERVICE_ERROR, e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public String loadUser(HttpServletRequest request) throws NonLocalizedError {
        String username = request.getParameter("selectedName");
        if (username == null || username.trim().equals("")) {
            LOGGER.error((Object)("Functional error try to edit user '" + username + "' (certainly empty or null)"));
            throw new NonLocalizedError(ManagementUIBean.USER_ACTION_ERROR, "Functional error you try to edit empty user");
        }
        this.oldUser = username;
        this.modifiedUsername = username;
        try {
            this.selectedRoles = this.getBusinessBean().getUserRoles(username);
        }
        catch (PetalsServiceTechnicalException e) {
            LOGGER.error((Object)("Technical error occurred during loading action of user '" + this.modifiedUsername + "'"), (Throwable)e);
            throw new NonLocalizedError(ManagementUIBean.PETALS_SERVICE_ERROR, e.getLocalizedMessage(), (Throwable)e);
        }
        catch (PetalsServiceFunctionalException e) {
            LOGGER.error((Object)("Functional error occurred during loading action of user '" + this.modifiedUsername + "'"), (Throwable)e);
            throw new NonLocalizedError(ManagementUIBean.PETALS_SERVICE_ERROR, e.getLocalizedMessage());
        }
        return UIResult.SUCCESS.getValue();
    }

    public final String getOldUser() {
        return this.oldUser;
    }

    public final void setOldUser(String oldUser) {
        this.oldUser = oldUser;
    }

    public final String getModifiedUsername() {
        return this.modifiedUsername;
    }

    public final void setModifiedUsername(String modifiedUsername) {
        this.modifiedUsername = modifiedUsername;
    }

    public final String getModifiedPassword() {
        return this.modifiedPassword;
    }

    public final void setModifiedPassword(String modifiedPassword) throws NonLocalizedError {
        try {
            this.modifiedPassword = this.getBusinessBean().encrypt(modifiedPassword);
        }
        catch (PetalsServiceTechnicalException e) {
            LOGGER.error((Object)"Technical error occurred during the encryption of the modified password parameter", (Throwable)e);
            throw new NonLocalizedError(ManagementUIBean.PETALS_SERVICE_ERROR, e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public final String getConfirmPassword() {
        return this.confirmPassword;
    }

    public final void setConfirmPassword(String confirmPassword) throws NonLocalizedError {
        try {
            this.confirmPassword = this.getBusinessBean().encrypt(confirmPassword);
        }
        catch (PetalsServiceTechnicalException e) {
            LOGGER.error((Object)"Technical error occurred during the encryption of the confirm password parameter", (Throwable)e);
            throw new NonLocalizedError(ManagementUIBean.PETALS_SERVICE_ERROR, e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public final String getOldPassword() {
        return this.oldPassword;
    }

    public final void setOldPassword(String oldPassword) throws NonLocalizedError {
        try {
            this.oldPassword = this.getBusinessBean().encrypt(oldPassword);
        }
        catch (PetalsServiceTechnicalException e) {
            LOGGER.error((Object)"Technical error occurred during the encryption of the old password parameter", (Throwable)e);
            throw new NonLocalizedError(ManagementUIBean.PETALS_SERVICE_ERROR, e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public final String getConfirmModifiedPassword() {
        return this.confirmModifiedPassword;
    }

    public final void setConfirmModifiedPassword(String confirmModifiedPassword) throws NonLocalizedError {
        try {
            this.confirmModifiedPassword = this.getBusinessBean().encrypt(confirmModifiedPassword);
        }
        catch (PetalsServiceTechnicalException e) {
            LOGGER.error((Object)"Technical error occurred during the encryption of the confirm modified password parameter", (Throwable)e);
            throw new NonLocalizedError(ManagementUIBean.PETALS_SERVICE_ERROR, e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public final Set<String> getAllUsers() {
        return this.allUsers;
    }

    public final void setAllUsers(Set<String> allUsers) {
        this.allUsers = allUsers;
    }

    public final String[] getSelectedRoles() {
        return this.selectedRoles;
    }

    public final void setSelectedRoles(String[] selectedRoles) {
        this.selectedRoles = selectedRoles;
    }

    public final String[] getAllRoles() {
        return this.allRoles;
    }

    public String modifyUser() throws NonLocalizedError {
        try {
            if (this.modifiedPassword.equals(this.confirmModifiedPassword)) {
                if (this.getBusinessBean().modifyUser(this.oldUser, this.modifiedUsername, this.oldPassword, this.modifiedPassword, this.confirmModifiedPassword, this.selectedRoles)) {
                    this.resetForms();
                    return UIResult.SUCCESS.getValue();
                }
                this.oldPassword = null;
                this.modifiedPassword = null;
                this.confirmModifiedPassword = null;
                return UIResult.ERROR.getValue();
            }
            this.oldPassword = null;
            this.modifiedPassword = null;
            this.confirmModifiedPassword = null;
            return UIResult.PARAMETERERROR.getValue();
        }
        catch (PetalsServiceTechnicalException e) {
            LOGGER.error((Object)("Technical error occurred during the modification of user '" + this.modifiedUsername + "'"), (Throwable)e);
            throw new NonLocalizedError(ManagementUIBean.PETALS_SERVICE_ERROR, e.getLocalizedMessage(), (Throwable)e);
        }
        catch (PetalsServiceFunctionalException e) {
            LOGGER.error((Object)("Functional error occurred during the modification of user '" + this.modifiedUsername + "'"), (Throwable)e);
            throw new NonLocalizedError(ManagementUIBean.PETALS_SERVICE_ERROR, e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public final String resetForms() {
        this.confirmPassword = null;
        this.oldUser = null;
        this.modifiedUsername = null;
        this.oldPassword = null;
        this.modifiedPassword = null;
        this.confirmModifiedPassword = null;
        this.selectedRoles = null;
        return UIResult.SUCCESS.getValue();
    }

    public final String getLoggedWithUsername() {
        return this.loggedWithUsername;
    }

    public final boolean isLogged(HttpServletRequest request) {
        Principal principal = request.getUserPrincipal();
        if (principal != null) {
            this.loggedWithUsername = principal.getName();
            return true;
        }
        return false;
    }

    public final String logout(HttpServletRequest request) {
        request.getSession().invalidate();
        return UIResult.SUCCESS.getValue();
    }

    private SecurityBBean getBusinessBean() {
        if (this.business == null) {
            this.business = new SecurityBBean();
        }
        return this.business;
    }
}

