/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.tools.webconsole.uibeans;

import java.io.IOException;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.opensuit.core.error.NonLocalizedError;
import org.ow2.petals.tools.webconsole.business.ServerFeatureBBean;
import org.ow2.petals.tools.webconsole.uibeans.ManagementUIBean;
import org.ow2.petals.tools.webconsole.uibeans.RemoteInjectorUIBean;
import org.ow2.petals.tools.webconsole.uibeans.utils.UIResult;
import org.ow2.petals.tools.webconsole.utils.PetalsConsoleException;
import org.ow2.petals.tools.webconsole.xmlbeans.Server;

public class ServerFeatureUIBean
implements Serializable {
    private static final long serialVersionUID = -5485531976807601301L;
    private static final Log LOGGER = LogFactory.getLog(ServerFeatureUIBean.class);
    private String host = "localhost";
    private String port = "7700";
    private String login = "petals";
    private String password = "petals";
    private transient ServerFeatureBBean businessBean = new ServerFeatureBBean();
    private String modifiedName = "localhost";
    private String modifiedDomain;
    private String remoteContext;
    private String remotePort;
    private boolean installedRemoteComponent;

    public void load(HttpServletRequest request) throws NonLocalizedError {
        if (request.getParameter("selectedName") == null || request.getParameter("selectedName").equals("")) {
            LOGGER.error((Object)"Error occurred during ServerFeatureUIBean loading 'selectedName' parameter cannot be null or empty");
            NonLocalizedError error = new NonLocalizedError(ManagementUIBean.PETALS_CONSOLE_ERROR, "Name parameter unavailable for selected server");
            error.setType((short)0);
            throw error;
        }
        if (request.getParameter("selectedDomain") == null || request.getParameter("selectedDomain").equals("")) {
            LOGGER.error((Object)"Error occurred during ServerFeatureUIBean loading 'selectedDomain' parameter cannot be null or empty");
            NonLocalizedError error = new NonLocalizedError(ManagementUIBean.PETALS_CONSOLE_ERROR, "Domain parameter unavailable for selected server");
            error.setType((short)0);
            throw error;
        }
        String selectedName = request.getParameter("selectedName");
        String selectedDomain = request.getParameter("selectedDomain");
        List servers = ServerFeatureBBean.getConfiguredServers();
        for (Server server : servers) {
            if (!server.getName().equals(selectedName) || !server.getDomain().equals(selectedDomain)) continue;
            this.host = server.getHost();
            this.port = server.getPort();
            this.login = server.getLogin();
            this.password = server.getPassword();
            this.modifiedName = server.getName();
            this.modifiedDomain = server.getDomain();
            this.installedRemoteComponent = server.isInstalledRemoteComponent();
            this.remoteContext = server.getRemoteContext();
            this.remotePort = Integer.toString(server.getRemotePort());
        }
    }

    public void saveServer(Server server) throws NonLocalizedError {
        try {
            this.getBusinessBean().addServer(server);
        }
        catch (URISyntaxException e) {
            LOGGER.error((Object)"Error occurred during saving server", (Throwable)e);
            throw new NonLocalizedError(ManagementUIBean.URI_SYNTAX_ERROR, e.getLocalizedMessage(), (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            LOGGER.error((Object)"Error occurred during saving server", (Throwable)e);
            throw new NonLocalizedError(ManagementUIBean.PARSER_CONFIGURATION_ERROR, e.getLocalizedMessage(), (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error((Object)"Error occurred during saving server", (Throwable)e);
            throw new NonLocalizedError(ManagementUIBean.IOEXCEPTION_ERROR, e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void saveServers(List<Server> servers) throws NonLocalizedError, PetalsConsoleException {
        for (Server server : servers) {
            try {
                this.getBusinessBean().addServer(server);
            }
            catch (IllegalArgumentException e) {
                LOGGER.info((Object)("Server: " + server.getDomain() + ":" + server.getName() + " is already present in configuration file, it cannot added again"));
            }
            catch (URISyntaxException e) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.error((Object)"Error occurred during saving servers", (Throwable)e);
                } else {
                    LOGGER.error((Object)("Error occurred during saving servers: " + e.getLocalizedMessage()));
                }
                NonLocalizedError error = new NonLocalizedError(ManagementUIBean.URI_SYNTAX_ERROR, e.getLocalizedMessage());
                error.setType((short)0);
                throw error;
            }
            catch (ParserConfigurationException e) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.error((Object)"Error occurred during saving servers", (Throwable)e);
                } else {
                    LOGGER.error((Object)("Error occurred during saving servers: " + e.getLocalizedMessage()));
                }
                NonLocalizedError error = new NonLocalizedError(ManagementUIBean.PARSER_CONFIGURATION_ERROR, e.getLocalizedMessage());
                error.setType((short)0);
                throw error;
            }
            catch (IOException e) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.error((Object)"Error occurred during saving servers", (Throwable)e);
                } else {
                    LOGGER.error((Object)("Error occurred during saving servers: " + e.getLocalizedMessage()));
                }
                NonLocalizedError error = new NonLocalizedError(ManagementUIBean.IOEXCEPTION_ERROR, e.getLocalizedMessage());
                error.setType((short)0);
                throw error;
            }
        }
    }

    public String performServerForm(HttpServletRequest request) throws NonLocalizedError {
        RemoteInjectorUIBean remoteInjectorUIBean;
        try {
            this.getBusinessBean().modifyServer(this.host, this.port, this.login, this.password, this.modifiedName, this.modifiedDomain, this.installedRemoteComponent, Integer.valueOf(this.remotePort).intValue(), this.remoteContext);
        }
        catch (NumberFormatException e) {
            LOGGER.error((Object)("Error occurred during establish connection action, remote port value: " + this.remotePort + " isn't correct"));
            NonLocalizedError error = new NonLocalizedError(ManagementUIBean.NUMBER_FORMAT_ERROR, "The port value: " + this.remotePort + " is not properly formatted");
            error.setType((short)0);
            throw error;
        }
        catch (URISyntaxException e) {
            LOGGER.error((Object)"Error occurred during server form performing", (Throwable)e);
            throw new NonLocalizedError(ManagementUIBean.URI_SYNTAX_ERROR, e.getLocalizedMessage(), (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            LOGGER.error((Object)"Error occurred during server form performing", (Throwable)e);
            throw new NonLocalizedError(ManagementUIBean.PARSER_CONFIGURATION_ERROR, e.getLocalizedMessage(), (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error((Object)"Error occurred during server form performing", (Throwable)e);
            throw new NonLocalizedError(ManagementUIBean.IOEXCEPTION_ERROR, e.getLocalizedMessage(), (Throwable)e);
        }
        ManagementUIBean managementUIBean = (ManagementUIBean)request.getSession().getAttribute("managementUIBean");
        if (managementUIBean != null) {
            managementUIBean.setHost(this.host);
            managementUIBean.setPort(this.port);
            managementUIBean.setLogin(this.login);
            managementUIBean.setPassword(this.password);
            managementUIBean.updateDomain(this.modifiedDomain);
            managementUIBean.setDomainDisplaying(true);
        }
        if ((remoteInjectorUIBean = (RemoteInjectorUIBean)request.getSession().getAttribute("remoteInjectorUIBean")) != null) {
            remoteInjectorUIBean.init();
        }
        return UIResult.SUCCESS.getValue();
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public List<Server> getConfiguredServers() throws NonLocalizedError {
        return ServerFeatureBBean.getConfiguredServers();
    }

    public void deleteServer(HttpServletRequest request) throws NonLocalizedError {
        String host = request.getParameter("host");
        String port = request.getParameter("port");
        String login = request.getParameter("login");
        String password = request.getParameter("password");
        try {
            this.getBusinessBean().deleteServer(host, port, login, password);
        }
        catch (URISyntaxException e) {
            LOGGER.error((Object)"Error occurred during server deleting", (Throwable)e);
            throw new NonLocalizedError(ManagementUIBean.URI_SYNTAX_ERROR, e.getLocalizedMessage(), (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            LOGGER.error((Object)"Error occurred during server deleting", (Throwable)e);
            throw new NonLocalizedError(ManagementUIBean.PARSER_CONFIGURATION_ERROR, e.getLocalizedMessage(), (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error((Object)"Error occurred during server deleting", (Throwable)e);
            throw new NonLocalizedError(ManagementUIBean.IOEXCEPTION_ERROR, e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public String getRemoteContext() {
        return this.remoteContext;
    }

    public void setRemoteContext(String remoteContext) {
        this.remoteContext = remoteContext;
    }

    public String getRemotePort() {
        return this.remotePort;
    }

    public void setRemotePort(String remotePort) throws NonLocalizedError {
        if (remotePort.trim().isEmpty()) {
            NonLocalizedError error = new NonLocalizedError(ManagementUIBean.USER_ACTION_ERROR, "Port must not be null or empty value");
            error.setType((short)0);
            throw error;
        }
        this.remotePort = remotePort;
    }

    public boolean isInstalledRemoteComponent() {
        return this.installedRemoteComponent;
    }

    public void setInstalledRemoteComponent(boolean installedRemoteComponent) {
        this.installedRemoteComponent = installedRemoteComponent;
    }

    protected ServerFeatureBBean getBusinessBean() {
        if (this.businessBean == null) {
            this.businessBean = new ServerFeatureBBean();
        }
        return this.businessBean;
    }

    public void onChangeProcess() {
    }
}

