/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.tools.webconsole.uibeans;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.opensuit.core.error.NonLocalizedError;
import org.ow2.petals.tools.webconsole.business.ManagementBBean;
import org.ow2.petals.tools.webconsole.business.ServerBBean;
import org.ow2.petals.tools.webconsole.services.PetalsServiceFunctionalException;
import org.ow2.petals.tools.webconsole.services.PetalsServiceTechnicalException;
import org.ow2.petals.tools.webconsole.services.management.ManagementService;
import org.ow2.petals.tools.webconsole.services.management.ManagementServiceFactory;
import org.ow2.petals.tools.webconsole.to.ComponentTO;
import org.ow2.petals.tools.webconsole.to.DomainTO;
import org.ow2.petals.tools.webconsole.to.EndPointTO;
import org.ow2.petals.tools.webconsole.to.ServerTO;
import org.ow2.petals.tools.webconsole.to.ServiceAssemblyTO;
import org.ow2.petals.tools.webconsole.uibeans.ManagementUIBean;
import org.ow2.petals.tools.webconsole.uibeans.RemoteInjectorUIBean;
import org.ow2.petals.tools.webconsole.uibeans.utils.UIResult;
import org.ow2.petals.tools.webconsole.utils.StringHelper;

public class ServerUIBean
implements Serializable {
    private static final long serialVersionUID = -6076684869394428340L;
    private static final Log LOGGER = LogFactory.getLog(ServerUIBean.class);
    private String serverName;
    private String host;
    private String port;
    private String login;
    private String password;
    private boolean monitoringStarted;
    private String[] selectedComponents;
    private String[] selectedSharedLibraries;
    private String[] selectedServiceAssemblies;
    private List<ComponentTO> bindingcomponents;
    private List<ComponentTO> serviceEngines;
    private List<String> sharedLibraries;
    private List<ServiceAssemblyTO> serviceAssemblies;
    private List<EndPointTO> endpointsList;
    private List<String> selectedEndpointsList;
    private ManagementUIBean managementBean;
    private transient ServerBBean businessBean;
    private List<String> uninstalledComponents;
    private List<String> unloadedInstallers;
    private List<String> uninstalledSharedLibraries;
    private List<String> uninstalledServiceAssemblies;
    private List<String> loadedComponentInstallers;
    private List<String> selectedInstallers;
    private String unloadedInstaller;
    private transient ManagementBBean managementBusinessBean;
    private static final String RECOVERY_SERVICE_ERROR = "Recovery service error";
    private static final String DOWNLOAD_WSDL_ERROR = "Download wsdl error";
    private static final String START_COMPONENT_ACTION_ERROR = "Problem occurred during start component action";
    private static final String STOP_COMPONENT_ACTION_ERROR = "Problem occurred during stop component action";
    private static final String SHUTDOWN_COMPONENT_ACTION_ERROR = "Problem occurred during shutdown component action";
    private static final String UNINSTALL_COMPONENT_ACTION_ERROR = "Problem occurred during uninstall component action";
    private static final String START_SA_ACTION_ERROR = "Problem occurred during start service assembly action";
    private static final String STOP_SA_ACTION_ERROR = "Problem occurred during stop service assembly action";
    private static final String SHUTDOWN_SA_ACTION_ERROR = "Problem occurred during shutdown service assembly action";
    private static final String UNINSTALL_SA_ACTION_ERROR = "Problem occurred during uninstall service assembly action";
    private static final String UNINSTALL_SL_ACTION_ERROR = "Problem occurred during uninstall shared library action";
    private static final String FORCE_UNLOAD_COMPONENT_ERROR = "Problem occurred during force unload component action";
    private static final String FORCE_UNDEPLOY_SERVICE_ASSEMBLY_ERROR = "Problem occurred during force undeploy service assembly action";

    public void load(HttpServletRequest iRequest) throws NonLocalizedError {
        this.serverName = iRequest.getParameter("serverName");
        this.businessBean = new ServerBBean();
        this.managementBean = (ManagementUIBean)iRequest.getSession().getAttribute("managementUIBean");
        this.managementBusinessBean = new ManagementBBean();
        this.managementBean = (ManagementUIBean)iRequest.getSession().getAttribute("managementUIBean");
        this.uninstalledComponents = new ArrayList();
        this.unloadedInstallers = new ArrayList();
        this.uninstalledSharedLibraries = new ArrayList();
        this.uninstalledServiceAssemblies = new ArrayList();
        this.setLoadedComponentInstallers(new ArrayList());
        this.setSelectedInstallers(new ArrayList());
        if (this.managementBean != null) {
            this.managementBean.connect();
            if (this.managementBean.getDomain() != null) {
                for (ServerTO server : this.managementBean.getDomain().getServers()) {
                    if (!server.getName().equals(this.serverName)) continue;
                    this.bindingcomponents = server.getBindingComponents();
                    this.serviceEngines = server.getServiceEngines();
                    this.serviceAssemblies = server.getServiceAssemblies();
                    this.sharedLibraries = server.getSharedLibraries();
                    this.serverName = server.getName();
                    this.host = server.getHost();
                    this.port = server.getPort();
                    this.login = server.getLogin();
                    this.password = server.getPassword();
                    this.loadEndpoints();
                }
            }
        } else if (iRequest.getSession().getAttribute("connectedServer") != null) {
            ServerTO server = (ServerTO)iRequest.getSession().getAttribute("connectedServer");
            this.serverName = server.getName();
        }
        if (this.bindingcomponents == null) {
            this.bindingcomponents = new ArrayList();
        }
        if (this.serviceEngines == null) {
            this.serviceEngines = new ArrayList();
        }
        if (this.serviceAssemblies == null) {
            this.serviceAssemblies = new ArrayList();
        }
    }

    public void startSelectedComponent(HttpServletRequest request) throws NonLocalizedError {
        String componentName = request.getParameter("componentName");
        ManagementService service = null;
        service = this.serviceRecovery(request);
        try {
            service.startComponent(componentName);
        }
        catch (PetalsServiceTechnicalException e) {
            LOGGER.error((Object)("Error occurred during the starting of " + componentName + " component"), (Throwable)e);
            throw new NonLocalizedError(START_COMPONENT_ACTION_ERROR, e.getLocalizedMessage(), (Throwable)e);
        }
        catch (PetalsServiceFunctionalException e) {
            LOGGER.error((Object)("Functional error occurred during the starting of " + componentName + " component"), (Throwable)e);
            NonLocalizedError error = new NonLocalizedError(START_COMPONENT_ACTION_ERROR, e.getLocalizedMessage());
            error.setType((short)0);
            throw error;
        }
        this.managementBean.reconnect(request);
        this.updateModification();
        this.updateRemoteInjectorUIBean(request);
    }

    public String startSelectedComponents(HttpServletRequest request) throws NonLocalizedError {
        ManagementService service = this.serviceRecovery(request);
        ArrayList<PetalsServiceTechnicalException> exceptions = new ArrayList<PetalsServiceTechnicalException>();
        ArrayList<PetalsServiceFunctionalException> functionalExceptions = new ArrayList<PetalsServiceFunctionalException>();
        if (this.selectedComponents != null) {
            for (String componentName : this.selectedComponents) {
                try {
                    service.startComponent(componentName);
                }
                catch (PetalsServiceTechnicalException e) {
                    exceptions.add(e);
                }
                catch (PetalsServiceFunctionalException e) {
                    functionalExceptions.add(e);
                }
            }
        }
        this.managementBean.reconnect(request);
        this.updateModification();
        this.updateRemoteInjectorUIBean(request);
        this.selectedComponents = null;
        if (exceptions.isEmpty() && functionalExceptions.isEmpty()) {
            return UIResult.SUCCESS.getValue();
        }
        StringBuilder builder = new StringBuilder();
        for (PetalsServiceTechnicalException exception : exceptions) {
            builder.append("Technical error: " + exception.getMessage() + "\n\n");
            LOGGER.error((Object)"Error occurred during starting of several component", (Throwable)exception);
        }
        for (PetalsServiceFunctionalException fException : functionalExceptions) {
            builder.append(fException.getMessage() + "\n\n");
            LOGGER.error((Object)"Functional error occurred during starting of several component", (Throwable)fException);
        }
        NonLocalizedError error = new NonLocalizedError(START_COMPONENT_ACTION_ERROR, builder.toString());
        error.setType((short)0);
        throw error;
    }

    public void shutdownSelectedComponent(HttpServletRequest request) throws NonLocalizedError {
        String componentName = request.getParameter("componentName");
        ManagementService service = null;
        service = this.serviceRecovery(request);
        try {
            service.shutdownComponent(componentName);
        }
        catch (PetalsServiceTechnicalException e) {
            LOGGER.error((Object)("Error occurred during the shutdown of " + componentName + " component"), (Throwable)e);
            NonLocalizedError error = new NonLocalizedError(SHUTDOWN_COMPONENT_ACTION_ERROR, e.getLocalizedMessage(), (Throwable)e);
            error.setType((short)1);
            throw error;
        }
        catch (PetalsServiceFunctionalException e) {
            LOGGER.error((Object)("Functional error occurred during the shutdown of " + componentName + " component"), (Throwable)e);
            NonLocalizedError error = new NonLocalizedError(START_COMPONENT_ACTION_ERROR, e.getLocalizedMessage());
            error.setType((short)0);
            throw error;
        }
        this.managementBean.reconnect(request);
        this.updateModification();
        this.updateRemoteInjectorUIBean(request);
    }

    public String shutdownSelectedComponents(HttpServletRequest request) throws NonLocalizedError {
        ManagementService service = null;
        service = this.serviceRecovery(request);
        ArrayList<PetalsServiceTechnicalException> exceptions = new ArrayList<PetalsServiceTechnicalException>();
        ArrayList<PetalsServiceFunctionalException> functionalExceptions = new ArrayList<PetalsServiceFunctionalException>();
        if (this.selectedComponents != null) {
            for (String componentName : this.selectedComponents) {
                try {
                    service.shutdownComponent(componentName);
                }
                catch (PetalsServiceTechnicalException e) {
                    exceptions.add(e);
                }
                catch (PetalsServiceFunctionalException e) {
                    functionalExceptions.add(e);
                }
            }
        }
        this.managementBean.reconnect(request);
        this.updateModification();
        this.updateRemoteInjectorUIBean(request);
        this.selectedComponents = null;
        if (exceptions.isEmpty() && functionalExceptions.isEmpty()) {
            return UIResult.SUCCESS.getValue();
        }
        StringBuilder builder = new StringBuilder();
        for (PetalsServiceTechnicalException exception : exceptions) {
            builder.append("Technical error: " + exception.getMessage() + "\n\n");
            LOGGER.error((Object)"Error occurred during the shutdown of several component", (Throwable)exception);
        }
        for (PetalsServiceFunctionalException fException : functionalExceptions) {
            builder.append(fException.getMessage() + "\n\n");
            LOGGER.error((Object)"Functional error occurred during the shutdown of several component", (Throwable)fException);
        }
        NonLocalizedError error = new NonLocalizedError(SHUTDOWN_COMPONENT_ACTION_ERROR, builder.toString());
        error.setType((short)0);
        throw error;
    }

    public void stopSelectedComponent(HttpServletRequest request) throws NonLocalizedError {
        String componentName = request.getParameter("componentName");
        ManagementService service = null;
        service = this.serviceRecovery(request);
        try {
            service.stopComponent(componentName);
        }
        catch (PetalsServiceTechnicalException e) {
            LOGGER.error((Object)("Error occurred during the stop of " + componentName + " component"), (Throwable)e);
            NonLocalizedError error = new NonLocalizedError(STOP_COMPONENT_ACTION_ERROR, e.getLocalizedMessage(), (Throwable)e);
            error.setType((short)1);
            throw error;
        }
        catch (PetalsServiceFunctionalException e) {
            LOGGER.error((Object)("Functional error occurred during the stop of " + componentName + " component"), (Throwable)e);
            NonLocalizedError error = new NonLocalizedError(START_COMPONENT_ACTION_ERROR, e.getLocalizedMessage());
            error.setType((short)0);
            throw error;
        }
        this.managementBean.reconnect(request);
        this.updateModification();
        this.updateRemoteInjectorUIBean(request);
    }

    public String stopSelectedComponents(HttpServletRequest request) throws NonLocalizedError {
        ManagementService service = null;
        service = this.serviceRecovery(request);
        ArrayList<PetalsServiceTechnicalException> exceptions = new ArrayList<PetalsServiceTechnicalException>();
        ArrayList<PetalsServiceFunctionalException> functionalExceptions = new ArrayList<PetalsServiceFunctionalException>();
        if (this.selectedComponents != null) {
            for (String componentName : this.selectedComponents) {
                try {
                    service.stopComponent(componentName);
                }
                catch (PetalsServiceTechnicalException e) {
                    exceptions.add(e);
                }
                catch (PetalsServiceFunctionalException e) {
                    functionalExceptions.add(e);
                }
            }
        }
        this.managementBean.reconnect(request);
        this.updateModification();
        this.updateRemoteInjectorUIBean(request);
        this.selectedComponents = null;
        if (exceptions.isEmpty() && functionalExceptions.isEmpty()) {
            return UIResult.SUCCESS.getValue();
        }
        StringBuilder builder = new StringBuilder();
        for (PetalsServiceTechnicalException exception : exceptions) {
            builder.append("Technical error: " + exception.getMessage() + "\n\n");
            LOGGER.error((Object)"Error occurred during the stop of several component", (Throwable)exception);
        }
        for (PetalsServiceFunctionalException fException : functionalExceptions) {
            builder.append(fException.getMessage() + "\n\n");
            LOGGER.error((Object)"Functional error occurred during the stop of several component", (Throwable)fException);
        }
        NonLocalizedError error = new NonLocalizedError(STOP_COMPONENT_ACTION_ERROR, builder.toString());
        error.setType((short)0);
        throw error;
    }

    public void uninstallSelectedComponent(HttpServletRequest request) throws NonLocalizedError {
        String componentName = request.getParameter("componentName");
        ManagementService service = null;
        service = this.serviceRecovery(request);
        try {
            service.uninstallComponent(componentName);
        }
        catch (PetalsServiceTechnicalException e) {
            LOGGER.error((Object)("Error occurred during uninstallation of " + componentName + " component"), (Throwable)e);
            NonLocalizedError error = new NonLocalizedError(UNINSTALL_COMPONENT_ACTION_ERROR, e.getLocalizedMessage(), (Throwable)e);
            error.setType((short)1);
            throw error;
        }
        this.managementBean.reconnect(request);
        this.updateModification();
        this.updateRemoteInjectorUIBean(request);
    }

    public String uninstallSelectedComponents(HttpServletRequest request) throws NonLocalizedError {
        ManagementService service = null;
        service = this.serviceRecovery(request);
        ArrayList<PetalsServiceTechnicalException> exceptions = new ArrayList<PetalsServiceTechnicalException>();
        if (this.selectedComponents != null) {
            for (String componentName : this.selectedComponents) {
                try {
                    service.uninstallComponent(componentName);
                }
                catch (PetalsServiceTechnicalException e) {
                    exceptions.add(e);
                }
            }
        }
        this.managementBean.reconnect(request);
        this.updateModification();
        this.updateRemoteInjectorUIBean(request);
        if (exceptions.isEmpty()) {
            return UIResult.SUCCESS.getValue();
        }
        StringBuilder builder = new StringBuilder();
        for (PetalsServiceTechnicalException exception : exceptions) {
            builder.append(exception.getMessage() + "\n\n");
            LOGGER.error((Object)"Technical error occurred during uninstallation of several component", (Throwable)exception);
        }
        NonLocalizedError error = new NonLocalizedError(UNINSTALL_COMPONENT_ACTION_ERROR, builder.toString());
        error.setType((short)0);
        throw error;
    }

    public void uninstallSelectedLibrary(HttpServletRequest request) throws NonLocalizedError {
        String libraryName = request.getParameter("libraryName");
        ManagementService service = null;
        service = this.serviceRecovery(request);
        try {
            service.uninstallSharedLibrary(libraryName);
        }
        catch (PetalsServiceTechnicalException e) {
            LOGGER.error((Object)("Error occurred during the uninstallation of " + libraryName + " shared library"));
            NonLocalizedError error = new NonLocalizedError(UNINSTALL_SL_ACTION_ERROR, e.getLocalizedMessage(), (Throwable)e);
            error.setType((short)1);
            throw error;
        }
        this.resetServerUIBean();
        this.managementBean.reconnect(request);
        this.updateModification();
    }

    public String uninstallSelectedLibraries(HttpServletRequest request) throws NonLocalizedError {
        ManagementService service = null;
        service = this.serviceRecovery(request);
        ArrayList<PetalsServiceTechnicalException> exceptions = new ArrayList<PetalsServiceTechnicalException>();
        if (this.selectedSharedLibraries != null) {
            for (String slName : this.selectedSharedLibraries) {
                try {
                    service.uninstallSharedLibrary(slName);
                }
                catch (PetalsServiceTechnicalException e) {
                    exceptions.add(e);
                }
            }
        }
        this.resetServerUIBean();
        this.managementBean.reconnect(request);
        this.updateModification();
        this.selectedSharedLibraries = null;
        if (exceptions.isEmpty()) {
            return UIResult.SUCCESS.getValue();
        }
        StringBuilder builder = new StringBuilder();
        for (PetalsServiceTechnicalException exception : exceptions) {
            builder.append(exception.getMessage() + "\n\n");
            LOGGER.error((Object)"Error occurred during the uninstallation of several shared libraries", (Throwable)exception);
        }
        NonLocalizedError error = new NonLocalizedError(UNINSTALL_SL_ACTION_ERROR, builder.toString());
        error.setType((short)0);
        throw error;
    }

    public void startSelectedServiceAssembly(HttpServletRequest request) throws NonLocalizedError {
        String saName = request.getParameter("saName");
        ManagementService service = null;
        service = this.serviceRecovery(request);
        try {
            service.startServiceAssembly(saName);
        }
        catch (PetalsServiceTechnicalException e) {
            LOGGER.error((Object)("Error occurred during the start of " + saName + " service assembly"), (Throwable)e);
            NonLocalizedError error = new NonLocalizedError(START_SA_ACTION_ERROR, e.getLocalizedMessage(), (Throwable)e);
            error.setType((short)1);
            throw error;
        }
        catch (PetalsServiceFunctionalException e) {
            LOGGER.error((Object)("Functional error occurred during the start of " + saName + " service assembly"), (Throwable)e);
            NonLocalizedError error = new NonLocalizedError(START_COMPONENT_ACTION_ERROR, e.getLocalizedMessage());
            error.setType((short)0);
            throw error;
        }
        this.resetServerUIBean();
        this.managementBean.reconnect(request);
        this.updateModification();
        this.updateRemoteInjectorUIBean(request);
    }

    public String startSelectedServiceAssemblies(HttpServletRequest request) throws NonLocalizedError {
        ManagementService service = null;
        service = this.serviceRecovery(request);
        ArrayList<PetalsServiceTechnicalException> exceptions = new ArrayList<PetalsServiceTechnicalException>();
        ArrayList<PetalsServiceFunctionalException> functionalExceptions = new ArrayList<PetalsServiceFunctionalException>();
        if (this.selectedServiceAssemblies != null) {
            for (String saName : this.selectedServiceAssemblies) {
                try {
                    service.startServiceAssembly(saName);
                }
                catch (PetalsServiceTechnicalException e) {
                    exceptions.add(e);
                }
                catch (PetalsServiceFunctionalException e) {
                    functionalExceptions.add(e);
                }
            }
        }
        this.resetServerUIBean();
        this.managementBean.reconnect(request);
        this.updateModification();
        this.updateRemoteInjectorUIBean(request);
        this.selectedServiceAssemblies = null;
        if (exceptions.isEmpty() && functionalExceptions.isEmpty()) {
            return UIResult.SUCCESS.getValue();
        }
        StringBuilder builder = new StringBuilder();
        for (PetalsServiceTechnicalException exception : exceptions) {
            builder.append("Technical error: " + exception.getMessage() + "\n\n");
            LOGGER.error((Object)"Error occurred during the starting of several service assemblies", (Throwable)exception);
        }
        for (PetalsServiceFunctionalException fException : functionalExceptions) {
            builder.append(fException.getMessage() + "\n\n");
            LOGGER.error((Object)"Functional error occurred during the starting of several service assemblies", (Throwable)fException);
        }
        NonLocalizedError error = new NonLocalizedError(START_SA_ACTION_ERROR, builder.toString());
        error.setType((short)0);
        throw error;
    }

    private void updateRemoteInjectorUIBean(HttpServletRequest request) {
        RemoteInjectorUIBean remoteInjectorUIBean = (RemoteInjectorUIBean)request.getSession().getAttribute("remoteInjectorUIBean");
        if (remoteInjectorUIBean != null) {
            remoteInjectorUIBean.getOperations().clear();
            remoteInjectorUIBean.getEndpoints().clear();
            remoteInjectorUIBean.getEndpointsNames().clear();
            for (EndPointTO endpoint : this.endpointsList) {
                remoteInjectorUIBean.getEndpoints().add(endpoint);
                remoteInjectorUIBean.getEndpointsNames().add(endpoint.getName());
            }
        } else {
            LOGGER.warn((Object)"Unable to update Remote Injector");
        }
    }

    public void stopSelectedServiceAssembly(HttpServletRequest request) throws NonLocalizedError {
        String saName = request.getParameter("saName");
        ManagementService service = null;
        service = this.serviceRecovery(request);
        try {
            service.stopServiceAssembly(saName);
        }
        catch (PetalsServiceTechnicalException e) {
            LOGGER.error((Object)("Error occurred during the stop of " + saName + " service assembly"), (Throwable)e);
            NonLocalizedError error = new NonLocalizedError(STOP_SA_ACTION_ERROR, e.getLocalizedMessage(), (Throwable)e);
            error.setType((short)1);
            throw error;
        }
        catch (PetalsServiceFunctionalException e) {
            LOGGER.error((Object)("Functional error occurred during the stop of " + saName + " service assembly"), (Throwable)e);
            NonLocalizedError error = new NonLocalizedError(START_COMPONENT_ACTION_ERROR, e.getLocalizedMessage());
            error.setType((short)0);
            throw error;
        }
        this.resetServerUIBean();
        this.managementBean.reconnect(request);
        this.updateModification();
        this.updateRemoteInjectorUIBean(request);
    }

    public String stopSelectedServiceAssemblies(HttpServletRequest request) throws NonLocalizedError {
        ManagementService service = null;
        service = this.serviceRecovery(request);
        ArrayList<PetalsServiceTechnicalException> exceptions = new ArrayList<PetalsServiceTechnicalException>();
        ArrayList<PetalsServiceFunctionalException> functionalExceptions = new ArrayList<PetalsServiceFunctionalException>();
        if (this.selectedServiceAssemblies != null) {
            for (String saName : this.selectedServiceAssemblies) {
                try {
                    service.stopServiceAssembly(saName);
                }
                catch (PetalsServiceTechnicalException e) {
                    exceptions.add(e);
                }
                catch (PetalsServiceFunctionalException e) {
                    functionalExceptions.add(e);
                }
            }
        }
        this.resetServerUIBean();
        this.managementBean.reconnect(request);
        this.updateModification();
        this.updateRemoteInjectorUIBean(request);
        this.selectedServiceAssemblies = null;
        if (exceptions.isEmpty() && functionalExceptions.isEmpty()) {
            return UIResult.SUCCESS.getValue();
        }
        StringBuilder builder = new StringBuilder();
        for (PetalsServiceTechnicalException exception : exceptions) {
            builder.append("Technical error: " + exception.getMessage() + "\n\n");
            LOGGER.error((Object)"Error occurred during the stop of several service assemblies", (Throwable)exception);
        }
        for (PetalsServiceFunctionalException fException : functionalExceptions) {
            builder.append(fException.getMessage() + "\n\n");
            LOGGER.error((Object)"Functional error occurred during the stop of several service assemblies", (Throwable)fException);
        }
        NonLocalizedError error = new NonLocalizedError(STOP_SA_ACTION_ERROR, builder.toString());
        error.setType((short)0);
        throw error;
    }

    public String uninstallSelectedServiceAssemblies(HttpServletRequest request) throws NonLocalizedError {
        ManagementService service = null;
        service = this.serviceRecovery(request);
        ArrayList<PetalsServiceTechnicalException> exceptions = new ArrayList<PetalsServiceTechnicalException>();
        if (this.selectedServiceAssemblies != null) {
            for (String saName : this.selectedServiceAssemblies) {
                try {
                    service.uninstallServiceAssembly(saName);
                }
                catch (PetalsServiceTechnicalException e) {
                    exceptions.add(e);
                }
            }
        }
        this.resetServerUIBean();
        this.managementBean.reconnect(request);
        this.updateModification();
        this.updateRemoteInjectorUIBean(request);
        if (exceptions.isEmpty()) {
            return UIResult.SUCCESS.getValue();
        }
        StringBuilder builder = new StringBuilder();
        for (PetalsServiceTechnicalException exception : exceptions) {
            builder.append(exception.getMessage() + "\n\n");
            LOGGER.error((Object)"Error occurred during the uninstallation of several service assemblies", (Throwable)exception);
        }
        NonLocalizedError error = new NonLocalizedError(UNINSTALL_SA_ACTION_ERROR, builder.toString());
        error.setType((short)0);
        throw error;
    }

    public void uninstallSelectedServiceAssembly(HttpServletRequest request) throws NonLocalizedError {
        String saName = request.getParameter("saName");
        ManagementService service = null;
        service = this.serviceRecovery(request);
        try {
            service.uninstallServiceAssembly(saName);
        }
        catch (PetalsServiceTechnicalException e) {
            LOGGER.error((Object)("Error occurred during the uninstallation of " + saName + " service assembly"), (Throwable)e);
            NonLocalizedError error = new NonLocalizedError(UNINSTALL_SA_ACTION_ERROR, e.getLocalizedMessage(), (Throwable)e);
            error.setType((short)1);
            throw error;
        }
        this.resetServerUIBean();
        this.managementBean.reconnect(request);
        this.updateModification();
        this.updateRemoteInjectorUIBean(request);
        this.selectedServiceAssemblies = null;
    }

    public void shutdownSelectedServiceAssembly(HttpServletRequest request) throws NonLocalizedError {
        String saName = request.getParameter("saName");
        ManagementService service = null;
        service = this.serviceRecovery(request);
        try {
            service.shutdownServiceAssembly(saName);
        }
        catch (PetalsServiceTechnicalException e) {
            LOGGER.error((Object)("Error occurred during the shutdown of " + saName + " service assembly"), (Throwable)e);
            NonLocalizedError error = new NonLocalizedError(SHUTDOWN_SA_ACTION_ERROR, e.getLocalizedMessage(), (Throwable)e);
            error.setType((short)1);
            throw error;
        }
        catch (PetalsServiceFunctionalException e) {
            LOGGER.error((Object)("Functional error occurred during the shutdown of " + saName + " service assembly"), (Throwable)e);
            NonLocalizedError error = new NonLocalizedError(START_COMPONENT_ACTION_ERROR, e.getLocalizedMessage());
            error.setType((short)0);
            throw error;
        }
        this.resetServerUIBean();
        this.managementBean.reconnect(request);
        this.updateModification();
        this.updateRemoteInjectorUIBean(request);
    }

    public String shutdownSelectedServiceAssemblies(HttpServletRequest request) throws NonLocalizedError {
        ManagementService service = null;
        service = this.serviceRecovery(request);
        ArrayList<PetalsServiceTechnicalException> exceptions = new ArrayList<PetalsServiceTechnicalException>();
        ArrayList<PetalsServiceFunctionalException> functionalExceptions = new ArrayList<PetalsServiceFunctionalException>();
        if (this.selectedServiceAssemblies != null) {
            for (String saName : this.selectedServiceAssemblies) {
                try {
                    service.shutdownServiceAssembly(saName);
                }
                catch (PetalsServiceTechnicalException e) {
                    exceptions.add(e);
                }
                catch (PetalsServiceFunctionalException e) {
                    functionalExceptions.add(e);
                }
            }
        }
        this.resetServerUIBean();
        this.managementBean.reconnect(request);
        this.updateModification();
        this.updateRemoteInjectorUIBean(request);
        this.selectedServiceAssemblies = null;
        if (exceptions.isEmpty() && functionalExceptions.isEmpty()) {
            return UIResult.SUCCESS.getValue();
        }
        StringBuilder builder = new StringBuilder();
        for (PetalsServiceTechnicalException exception : exceptions) {
            builder.append("Technical error: " + exception.getMessage() + "\n\n");
            LOGGER.error((Object)"Error occurred during the shutdown of several service assemblies", (Throwable)exception);
        }
        for (PetalsServiceFunctionalException fException : functionalExceptions) {
            builder.append(fException.getMessage() + "\n\n");
            LOGGER.error((Object)"Functional error occurred during the shutdown of several service assemblies", (Throwable)fException);
        }
        NonLocalizedError error = new NonLocalizedError(UNINSTALL_SA_ACTION_ERROR, builder.toString());
        error.setType((short)0);
        throw error;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public boolean isMonitoringStarted() {
        return this.monitoringStarted;
    }

    public void setMonitoringStarted(boolean monitoringStarted) {
        this.monitoringStarted = monitoringStarted;
    }

    public String[] getSelectedComponents() {
        return this.selectedComponents;
    }

    public void setSelectedComponents(String[] selectedComponents) {
        this.selectedComponents = selectedComponents;
    }

    public String[] getSelectedSharedLibraries() {
        return this.selectedSharedLibraries;
    }

    public void setSelectedSharedLibraries(String[] selectedSharedLibraries) {
        this.selectedSharedLibraries = selectedSharedLibraries;
    }

    public String[] getSelectedServiceAssemblies() {
        return this.selectedServiceAssemblies;
    }

    public void setSelectedServiceAssemblies(String[] selectedServiceAssemblies) {
        this.selectedServiceAssemblies = selectedServiceAssemblies;
    }

    public List<ComponentTO> getBindingcomponents() {
        return this.bindingcomponents;
    }

    public void setBindingcomponents(List<ComponentTO> bindingcomponents) {
        this.bindingcomponents = bindingcomponents;
    }

    public List<ComponentTO> getServiceEngines() {
        return this.serviceEngines;
    }

    public void setServiceEngines(List<ComponentTO> serviceEngines) {
        this.serviceEngines = serviceEngines;
    }

    public List<String> getSharedLibraries() {
        return this.sharedLibraries;
    }

    public void setSharedLibraries(List<String> sharedLibraries) {
        this.sharedLibraries = sharedLibraries;
    }

    public List<ServiceAssemblyTO> getServiceAssemblies() {
        return this.serviceAssemblies;
    }

    public void setServiceAssemblies(List<ServiceAssemblyTO> serviceAssemblies) {
        this.serviceAssemblies = serviceAssemblies;
    }

    public List<ComponentTO> getComponents() {
        ArrayList<ComponentTO> allComponents = new ArrayList<ComponentTO>();
        if (this.bindingcomponents != null && this.bindingcomponents.size() > 0) {
            allComponents.addAll(this.bindingcomponents);
        }
        if (this.serviceEngines != null && this.serviceEngines.size() > 0) {
            allComponents.addAll(this.serviceEngines);
        }
        return allComponents;
    }

    public List<EndPointTO> getEndpointsList() {
        this.endpointsList = new ArrayList();
        for (ComponentTO componentTO : this.bindingcomponents) {
            for (EndPointTO endpointTO : componentTO.getEndpoints()) {
                this.endpointsList.add(endpointTO);
            }
        }
        for (ComponentTO componentTO : this.serviceEngines) {
            for (EndPointTO endpointTO : componentTO.getEndpoints()) {
                this.endpointsList.add(endpointTO);
            }
        }
        return this.endpointsList;
    }

    public List<String> getSelectedEndpointsList() {
        return this.selectedEndpointsList;
    }

    public void setSelectedEndpointsList(List<String> selectedEndpointsList) {
        this.selectedEndpointsList = selectedEndpointsList;
    }

    public void setEndpointsList(List<EndPointTO> endpointsList) {
        this.endpointsList = endpointsList;
    }

    private ManagementService serviceRecovery(HttpServletRequest request) throws NonLocalizedError {
        if (StringHelper.isNullOrEmpty((String)this.serverName)) {
            this.serverName = request.getParameter("serverName");
        }
        this.managementBean = (ManagementUIBean)request.getSession().getAttribute("managementUIBean");
        if (this.managementBean != null) {
            if (this.managementBean.getDomain() != null) {
                ServerTO server = this.managementBean.getDomain().findServer(this.serverName);
                if (server != null) {
                    this.managementBean.setHost(server.getHost());
                    this.managementBean.setLogin(server.getLogin());
                    this.managementBean.setPassword(server.getPassword());
                    this.managementBean.setPort(server.getPort());
                }
                ManagementService service = null;
                try {
                    service = (ManagementService)ManagementServiceFactory.getInstance().getService(this.managementBean.getHost(), Integer.valueOf(Integer.parseInt(this.managementBean.getPort())), this.managementBean.getLogin(), this.managementBean.getPassword());
                }
                catch (NumberFormatException e) {
                    LOGGER.error((Object)"Error occurred during service recovering", (Throwable)e);
                    throw new NonLocalizedError(RECOVERY_SERVICE_ERROR, e.getLocalizedMessage(), (Throwable)e);
                }
                catch (PetalsServiceTechnicalException e) {
                    LOGGER.error((Object)"Error occurred during service recovering", (Throwable)e);
                    throw new NonLocalizedError(RECOVERY_SERVICE_ERROR, e.getLocalizedMessage(), (Throwable)e);
                }
                return service;
            }
            LOGGER.error((Object)("Error occurred during service recovering: domain unavailable for server: " + this.serverName + ", the connection may be lost"));
            throw new NonLocalizedError("Error management connection", "Domain unavailable for server: " + this.serverName + ", the connection may be lost.");
        }
        LOGGER.warn((Object)("Error occurred during service recovering: Management connection lost for the server '" + this.serverName + "'"));
        throw new NonLocalizedError("Error management connection", "Management connection lost for the server: " + this.serverName);
    }

    private void updateModification() throws NonLocalizedError {
        for (ServerTO server : this.managementBean.getDomain().getServers()) {
            if (!server.getName().equals(this.serverName)) continue;
            this.bindingcomponents = server.getBindingComponents();
            this.serviceEngines = server.getServiceEngines();
            this.serviceAssemblies = server.getServiceAssemblies();
            this.endpointsList = server.getEndpoints();
            this.sharedLibraries = server.getSharedLibraries();
            this.serverName = server.getName();
        }
    }

    private void resetServerUIBean() {
        if (this.bindingcomponents != null) {
            this.bindingcomponents.clear();
        } else {
            this.bindingcomponents = new ArrayList();
        }
        if (this.serviceEngines != null) {
            this.serviceEngines.clear();
        } else {
            this.serviceEngines = new ArrayList();
        }
        if (this.serviceAssemblies != null) {
            this.serviceAssemblies.clear();
        } else {
            this.serviceAssemblies = new ArrayList();
        }
        if (this.endpointsList != null) {
            this.endpointsList.clear();
        } else {
            this.endpointsList = new ArrayList();
        }
        if (this.sharedLibraries != null) {
            this.sharedLibraries.clear();
        } else {
            this.sharedLibraries = new ArrayList();
        }
    }

    public void downloadWsdl(HttpServletRequest request, HttpServletResponse response) throws NonLocalizedError {
        String endpointName = request.getParameter("endpointName");
        String serviceName = request.getParameter("serviceName");
        String prettyWsdl = null;
        try {
            prettyWsdl = this.getBusinessBean().loadWsdlEndpoint(serviceName, endpointName, this.host, Integer.valueOf(Integer.parseInt(this.port)), this.login, this.password);
        }
        catch (NumberFormatException e) {
            LOGGER.error((Object)"Error occurred during the wsdl downloading", (Throwable)e);
            throw new NonLocalizedError(DOWNLOAD_WSDL_ERROR, e.getLocalizedMessage(), (Throwable)e);
        }
        catch (PetalsServiceTechnicalException e) {
            LOGGER.error((Object)"Error occurred during the wsdl downloading", (Throwable)e);
            throw new NonLocalizedError(DOWNLOAD_WSDL_ERROR, e.getLocalizedMessage(), (Throwable)e);
        }
        response.setContentType("text/xml");
        ServletOutputStream out = null;
        try {
            out = response.getOutputStream();
            out.write(prettyWsdl.getBytes());
            out.flush();
        }
        catch (IOException e) {
            LOGGER.error((Object)"Error occurred during the wsdl downloading", (Throwable)e);
            throw new NonLocalizedError(DOWNLOAD_WSDL_ERROR, e.getLocalizedMessage(), (Throwable)e);
        }
        finally {
            prettyWsdl = null;
            this.businessBean = null;
            try {
                out.close();
            }
            catch (IOException e) {
                LOGGER.error((Object)"Error occurred during the wsdl downloading", (Throwable)e);
                throw new NonLocalizedError(DOWNLOAD_WSDL_ERROR, e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    public void updateServer(DomainTO domain) {
        ServerTO currentServer;
        if (domain != null && (currentServer = domain.findServer(this.serverName)) != null) {
            this.bindingcomponents = currentServer.getBindingComponents();
            this.serviceAssemblies = currentServer.getServiceAssemblies();
            this.sharedLibraries = currentServer.getSharedLibraries();
            this.serviceEngines = currentServer.getServiceEngines();
            this.endpointsList = currentServer.getEndpoints();
        }
    }

    public String forceUnloadSelectedComponents(HttpServletRequest request) throws NonLocalizedError {
        ManagementBBean businessBean = new ManagementBBean();
        ManagementService service = null;
        service = this.serviceRecovery(request);
        ArrayList<PetalsServiceTechnicalException> exceptions = new ArrayList<PetalsServiceTechnicalException>();
        for (String component : this.selectedComponents) {
            try {
                businessBean.forceUnload(component, service);
            }
            catch (PetalsServiceTechnicalException e) {
                exceptions.add(e);
            }
        }
        this.resetServerUIBean();
        this.managementBean.reconnect(request);
        this.updateModification();
        this.updateRemoteInjectorUIBean(request);
        this.selectedComponents = null;
        if (exceptions.isEmpty()) {
            return UIResult.SUCCESS.getValue();
        }
        StringBuilder builder = new StringBuilder();
        for (PetalsServiceTechnicalException exception : exceptions) {
            builder.append(exception.getMessage() + "\n\n");
            LOGGER.error((Object)"Error occurred during the force unload of several component", (Throwable)exception);
        }
        NonLocalizedError error = new NonLocalizedError(FORCE_UNLOAD_COMPONENT_ERROR, builder.toString());
        error.setType((short)0);
        throw error;
    }

    public String forceUnDeploySelectedServiceAssemblies(HttpServletRequest request) throws NonLocalizedError {
        ManagementBBean businessBean = new ManagementBBean();
        ManagementService service = null;
        service = this.serviceRecovery(request);
        ArrayList<PetalsServiceTechnicalException> exceptions = new ArrayList<PetalsServiceTechnicalException>();
        for (String sa : this.selectedServiceAssemblies) {
            try {
                businessBean.forceUnDeploy(sa, service);
            }
            catch (PetalsServiceTechnicalException e) {
                exceptions.add(e);
            }
        }
        this.resetServerUIBean();
        this.managementBean.reconnect(request);
        this.updateModification();
        this.updateRemoteInjectorUIBean(request);
        this.selectedServiceAssemblies = null;
        if (exceptions.isEmpty()) {
            return UIResult.SUCCESS.getValue();
        }
        StringBuilder builder = new StringBuilder();
        for (PetalsServiceTechnicalException exception : exceptions) {
            builder.append(exception.getMessage() + "\n\n");
            LOGGER.error((Object)"Error occurred during force undeploy of several service assemblies", (Throwable)exception);
        }
        NonLocalizedError error = new NonLocalizedError(FORCE_UNDEPLOY_SERVICE_ASSEMBLY_ERROR, builder.toString());
        error.setType((short)0);
        throw error;
    }

    public String forceUnloadSelectedComponent(HttpServletRequest request) throws NonLocalizedError {
        ManagementBBean businessBean = new ManagementBBean();
        ManagementService service = null;
        service = this.serviceRecovery(request);
        String componentName = request.getParameter("componentName");
        try {
            businessBean.forceUnload(componentName, service);
        }
        catch (PetalsServiceTechnicalException e) {
            LOGGER.error((Object)("Error occurred during the force unload of " + componentName + " component"), (Throwable)e);
            NonLocalizedError error = new NonLocalizedError(FORCE_UNLOAD_COMPONENT_ERROR, e.getLocalizedMessage(), (Throwable)e);
            error.setType((short)1);
            throw error;
        }
        this.resetServerUIBean();
        this.managementBean.reconnect(request);
        this.updateModification();
        this.updateRemoteInjectorUIBean(request);
        return UIResult.SUCCESS.getValue();
    }

    public String forceUnDeploySelectedServiceAssembly(HttpServletRequest request) throws NonLocalizedError {
        ManagementBBean businessBean = new ManagementBBean();
        ManagementService service = null;
        service = this.serviceRecovery(request);
        String saName = request.getParameter("saName");
        try {
            businessBean.forceUnDeploy(saName, service);
        }
        catch (PetalsServiceTechnicalException e) {
            LOGGER.error((Object)("Error occurred during the force undeploy of " + saName + " service assembly"), (Throwable)e);
            NonLocalizedError error = new NonLocalizedError(FORCE_UNDEPLOY_SERVICE_ASSEMBLY_ERROR, e.getLocalizedMessage(), (Throwable)e);
            error.setType((short)1);
            throw error;
        }
        this.resetServerUIBean();
        this.managementBean.reconnect(request);
        this.updateModification();
        this.updateRemoteInjectorUIBean(request);
        return UIResult.SUCCESS.getValue();
    }

    public String clearSharedLibraries(HttpServletRequest request) throws NonLocalizedError {
        ManagementService managementService = this.serviceRecovery(request);
        if (managementService != null) {
            try {
                this.uninstalledSharedLibraries = managementService.uninstallAllSharedLibraries();
            }
            catch (PetalsServiceTechnicalException e) {
                LOGGER.error((Object)"Error occurred during the clear shared libraries action", (Throwable)e);
                NonLocalizedError error = new NonLocalizedError(ManagementUIBean.PETALS_SERVICE_ERROR, e.getLocalizedMessage(), (Throwable)e);
                error.setType((short)1);
                throw error;
            }
        }
        this.resetServerUIBean();
        this.managementBean.reconnect(request);
        this.updateModification();
        this.updateRemoteInjectorUIBean(request);
        return UIResult.SUCCESS.getValue();
    }

    public String clearComponents(HttpServletRequest request) throws NonLocalizedError {
        ManagementService managementService = this.serviceRecovery(request);
        if (managementService != null) {
            try {
                this.uninstalledComponents = managementService.uninstallAllComponents();
                this.unloadedInstallers = managementService.unloadAllInstallers();
            }
            catch (PetalsServiceTechnicalException e) {
                LOGGER.error((Object)"Error occurred during component cleaning", (Throwable)e);
                NonLocalizedError error = new NonLocalizedError(ManagementUIBean.PETALS_SERVICE_ERROR, e.getLocalizedMessage(), (Throwable)e);
                error.setType((short)1);
                throw error;
            }
        }
        this.resetServerUIBean();
        this.managementBean.reconnect(request);
        this.updateModification();
        this.updateRemoteInjectorUIBean(request);
        return UIResult.SUCCESS.getValue();
    }

    public String clearServiceAssemblies(HttpServletRequest request) throws NonLocalizedError {
        ManagementService managementService = this.serviceRecovery(request);
        if (managementService != null) {
            try {
                this.uninstalledServiceAssemblies = managementService.uninstallAllServiceAssemblies();
            }
            catch (PetalsServiceTechnicalException e) {
                LOGGER.error((Object)"Error occurred during service assemblies cleaning", (Throwable)e);
                NonLocalizedError error = new NonLocalizedError(ManagementUIBean.PETALS_SERVICE_ERROR, e.getLocalizedMessage(), (Throwable)e);
                error.setType((short)1);
                throw error;
            }
        }
        this.resetServerUIBean();
        this.managementBean.reconnect(request);
        this.updateModification();
        this.updateRemoteInjectorUIBean(request);
        return UIResult.SUCCESS.getValue();
    }

    public List<String> getUninstalledComponents() {
        return this.uninstalledComponents;
    }

    public List<String> getUnloadedInstallers() {
        return this.unloadedInstallers;
    }

    public List<String> getUninstalledSharedLibraries() {
        return this.uninstalledSharedLibraries;
    }

    public List<String> getUninstalledServiceAssemblies() {
        return this.uninstalledServiceAssemblies;
    }

    public String unloadInstaller(HttpServletRequest request) throws NonLocalizedError {
        ManagementService managementService = this.serviceRecovery(request);
        if (managementService != null) {
            try {
                managementService.forceUnloadInstaller(this.unloadedInstaller);
            }
            catch (PetalsServiceTechnicalException e) {
                LOGGER.error((Object)("Error occurred during installer unloading: " + this.unloadedInstaller), (Throwable)e);
                NonLocalizedError error = new NonLocalizedError(ManagementUIBean.PETALS_SERVICE_ERROR, e.getLocalizedMessage(), (Throwable)e);
                error.setType((short)1);
                throw error;
            }
        }
        return UIResult.SUCCESS.getValue();
    }

    public String getUnloadedInstaller() {
        return this.unloadedInstaller;
    }

    public void setUnloadedInstaller(String unloadedInstaller) {
        this.unloadedInstaller = unloadedInstaller;
    }

    protected ServerBBean getBusinessBean() {
        if (this.businessBean == null) {
            this.businessBean = new ServerBBean();
        }
        return this.businessBean;
    }

    public void setLoadedComponentInstallers(List<String> loadedComponentInstallers) {
        this.loadedComponentInstallers = loadedComponentInstallers;
    }

    public List<String> getLoadedComponentInstallers() {
        return this.loadedComponentInstallers;
    }

    public void setSelectedInstallers(List<String> selectedInstallers) {
        this.selectedInstallers = selectedInstallers;
    }

    public List<String> getSelectedInstallers() {
        return this.selectedInstallers;
    }

    public String unloadInstallers() throws NonLocalizedError {
        try {
            this.businessBean.unloadInstallers(this.selectedInstallers, this.managementBean.getHost(), Integer.valueOf(Integer.parseInt(this.managementBean.getPort())), this.managementBean.getLogin(), this.managementBean.getPassword());
        }
        catch (NumberFormatException e) {
            LOGGER.error((Object)"Error occurred during component installers unloading", (Throwable)e);
            throw new NonLocalizedError(ManagementUIBean.NUMBER_FORMAT_ERROR, e.getLocalizedMessage(), (Throwable)e);
        }
        catch (PetalsServiceTechnicalException e) {
            LOGGER.error((Object)"Error occurred during component installers unloading", (Throwable)e);
            throw new NonLocalizedError(ManagementUIBean.PETALS_SERVICE_ERROR, e.getLocalizedMessage(), (Throwable)e);
        }
        return UIResult.SUCCESS.getValue();
    }

    public void loadedInstallersRecovering() throws NonLocalizedError {
        try {
            this.loadedComponentInstallers = this.businessBean.getLoadedComponentInstallers(this.managementBean.getHost(), Integer.valueOf(Integer.parseInt(this.managementBean.getPort())), this.managementBean.getLogin(), this.managementBean.getPassword());
        }
        catch (NumberFormatException e) {
            LOGGER.error((Object)"Error occurred during loaded component installers recovering", (Throwable)e);
            throw new NonLocalizedError(ManagementUIBean.NUMBER_FORMAT_ERROR, e.getLocalizedMessage(), (Throwable)e);
        }
        catch (PetalsServiceTechnicalException e) {
            LOGGER.error((Object)"Error occurred during loaded component installers recovering", (Throwable)e);
            throw new NonLocalizedError(ManagementUIBean.PETALS_SERVICE_ERROR, e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public final String getHost() {
        return this.host;
    }

    public final void setHost(String host) {
        this.host = host;
    }

    private void loadEndpoints() {
        for (ComponentTO componentTO : this.bindingcomponents) {
            try {
                componentTO.getEndpoints().clear();
                componentTO.getEndpoints().addAll(this.managementBusinessBean.recoverEndpointsForComponent(componentTO.getName(), this.host, this.port, this.login, this.password, this.serverName));
            }
            catch (PetalsServiceTechnicalException e) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Unable to recove endpoints for binding component: " + componentTO.getName() + " on server: " + this.serverName + " because: " + e.getLocalizedMessage()), (Throwable)e);
                    continue;
                }
                LOGGER.info((Object)("Unable to recove endpoints for binding component: " + componentTO.getName() + " on server: " + this.serverName + " because: " + e.getLocalizedMessage()));
            }
            catch (NumberFormatException e) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Unable to recove endpoints for binding component: " + componentTO.getName() + " on server: " + this.serverName + " because: " + e.getLocalizedMessage()), (Throwable)e);
                    continue;
                }
                LOGGER.info((Object)("Unable to recove endpoints for binding component: " + componentTO.getName() + " on server: " + this.serverName + " because: " + e.getLocalizedMessage()));
            }
        }
        for (ComponentTO componentTO : this.serviceEngines) {
            try {
                componentTO.getEndpoints().clear();
                componentTO.getEndpoints().addAll(this.managementBusinessBean.recoverEndpointsForComponent(componentTO.getName(), this.host, this.port, this.login, this.password, this.serverName));
            }
            catch (PetalsServiceTechnicalException e) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Unable to recove endpoints for service engine: " + componentTO.getName() + " on server: " + this.serverName + " because: " + e.getLocalizedMessage()), (Throwable)e);
                    continue;
                }
                LOGGER.info((Object)("Unable to recove endpoints for service engine: " + componentTO.getName() + " on server: " + this.serverName + " because: " + e.getLocalizedMessage()));
            }
            catch (NumberFormatException e) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Unable to recove endpoints for binding component: " + componentTO.getName() + " on server: " + this.serverName + " because: " + e.getLocalizedMessage()), (Throwable)e);
                    continue;
                }
                LOGGER.info((Object)("Unable to recove endpoints for binding component: " + componentTO.getName() + " on server: " + this.serverName + " because: " + e.getLocalizedMessage()));
            }
        }
    }
}

